/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.RollbackSegmentPropertyDialogOracle;

public class RollbackSegmentOracle
extends AbstractStorageObjectOracle {
    private String initialSizeUnit = "";
    private String nextSizeUnit = "";
    private int scInitialExtent = 0;
    private int scNextExtent = 0;
    private int scMinExtents = 1;
    private String scMaxExtents = "UNLIMITED";
    private String tablespaces = "";
    private InlineList tablespaceSet = null;
    private String pub = "NO";
    private String scOptimal = "";
    public static final String TYPE_NAME = "RSeg";
    public static final String OLD_TYPE_NAME = "RollbackSegment";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RollbackSegmentPropertyDialogOracle dialog = new RollbackSegmentPropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "RollbackSeg";
    }

    public static String[] getSizeUnitChoices() {
        return ConstantsOracle.UNITS_CHOICES;
    }

    public String getInitialSizeUnit() {
        return this.initialSizeUnit;
    }

    public void setInitialSizeUnit(String unit) {
        if (ConstantsOracle.checkUnit(unit)) {
            this.initialSizeUnit = unit;
        }
    }

    public String getNextSizeUnit() {
        return this.nextSizeUnit;
    }

    public void setNextSizeUnit(String unit) {
        if (ConstantsOracle.checkUnit(unit)) {
            this.nextSizeUnit = unit;
        }
    }

    public int getSCInitialExtent() {
        return this.scInitialExtent;
    }

    public void setSCInitialExtent(int scInitialExtent) {
        this.scInitialExtent = scInitialExtent;
    }

    public int getSCNextExtent() {
        return this.scNextExtent;
    }

    public void setSCNextExtent(int scNextExtent) {
        this.scNextExtent = scNextExtent;
    }

    public int getSCMinExtents() {
        return this.scMinExtents;
    }

    public void setSCMinExtents(int scMinExtents) {
        if (scMinExtents >= 1) {
            this.scMinExtents = scMinExtents;
        }
    }

    public String getSCMaxExtents() {
        return this.scMaxExtents;
    }

    public void setSCMaxExtents(String scMaxExtents) {
        try {
            this.scMaxExtents = Integer.parseInt(scMaxExtents) > 0 ? scMaxExtents : "UNLIMITED";
        }
        catch (NumberFormatException E) {
            this.scMaxExtents = "UNLIMITED";
        }
    }

    public String convertTSNamesToIDs(String names) {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(names, ",");
        while (st.hasMoreTokens()) {
            String name = st.nextToken().trim();
            TableSpaceOracle ts = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getByName(name);
            if (ts == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(ts.getObjectID());
        }
        return result.toString();
    }

    private void addTablespace(String tablespaceObjectID) {
        if (!this.getTablespaceSet().contains(tablespaceObjectID)) {
            this.getTablespaceSet().add(tablespaceObjectID);
        }
    }

    public void recreateTablespaceSet(String tablespaces) {
        this.getTablespaceSet().clear();
        StringTokenizer st = new StringTokenizer(tablespaces, ",");
        while (st.hasMoreTokens()) {
            this.getTablespaceSet().add(st.nextToken().trim());
        }
    }

    public void setTablespaces(String tablespaces) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateTablespaceSet(tablespaces);
        } else {
            this.addTablespace(tablespaces);
        }
        this.tablespaces = this.getTablespaceSet().toString();
        this.fireDataFieldChange();
    }

    public String getTablespaces() {
        return this.tablespaces;
    }

    public InlineList getTablespaceSet() {
        if (this.tablespaceSet == null) {
            this.tablespaceSet = new InlineList();
        }
        return this.tablespaceSet;
    }

    public void clear() {
        this.getTablespaceSet().removeAllElements();
        this.tablespaces = "";
    }

    public String getPub() {
        return this.pub;
    }

    public void setPub(String pub) {
        if (ConstantsOracle.checkYesNo(pub)) {
            this.pub = pub;
            this.fireDataFieldChange();
        }
    }

    public String getScOptimal() {
        return this.scOptimal;
    }

    public void setScOptimal(String scOptimal) {
        this.scOptimal = scOptimal;
        this.fireDataFieldChange();
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SEGMENT_ICON", 16);
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

