/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxySetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.PKPropertyDialogOraclev9i;

public class PKProxyOraclev9i
extends PKProxyOracle {
    private String createIndexStatement = "";
    public static final String NO = "NO";
    public static final String SORTED = "SORTED";
    public static final String REVERSE = "REVERSE";
    public static final String LOCAL_PARTITIONED = "LOCAL PARTITIONED";
    public static final String GLOBAL_PARTITIONED = "GLOBAL PARTITIONED";
    public static final String BY_INDEX_NAME = "BY INDEX NAME";
    public static final String BY_CREATE_INDEX_STATEMENT = "BY CREATE INDEX STATEMENT";
    private static final String[] INDEX_SORT = new String[]{"NO", "SORTED", "REVERSE"};
    private static Set indexSortSet = null;
    private String indexSort = "SORTED";
    private String computeStatistics = "NO";
    private static final String[] USING_INDEX = new String[]{"NO", "LOCAL PARTITIONED", "GLOBAL PARTITIONED", "BY INDEX NAME", "BY CREATE INDEX STATEMENT"};
    private static Set usingIndexSet = null;
    private String usingIndex = "NO";

    public PKProxyOraclev9i(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public PKProxyOraclev9i(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            PKPropertyDialogOraclev9i dialog = new PKPropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void setIndexGlobalPL(IndexGlobalPartitionsListOracle indexGlobalPartitionList) {
        if (this.indexGlobalPartitionList != null && this.indexGlobalPartitionList != indexGlobalPartitionList) {
            this.partitions.removeAll();
            this.partitions.setForbiddenCreateElement(true);
        }
        this.indexGlobalPartitionList = indexGlobalPartitionList;
        if (this.indexGlobalPartitionList != null) {
            this.indexGlobalPartitionList.setIndex(this);
            this.partitions.setLogicalParent(indexGlobalPartitionList);
            if (((PKProxyOracle)indexGlobalPartitionList.getIndex()).getUsingIndex().equalsIgnoreCase(GLOBAL_PARTITIONED)) {
                this.addIGPFromDesign(((StorageDesignOracle)this.getStorageDesign()).getIndexGlobalPartitionSet());
                this.partitions.setForbiddenCreateElement(false);
            } else {
                this.partitions.removeAll();
                this.partitions.setForbiddenCreateElement(true);
            }
        }
        this.fireDataFieldChange();
    }

    public static String[] getIndexSortChoices() {
        return INDEX_SORT;
    }

    private boolean checkIndexSort(String value) {
        if (indexSortSet == null) {
            indexSortSet = new HashSet();
            indexSortSet.addAll(Arrays.asList(PKProxyOraclev9i.getIndexSortChoices()));
        }
        return indexSortSet.contains(value);
    }

    @Override
    public void setIndexSort(String using) {
        if (this.checkIndexSort(using)) {
            this.indexSort = using;
            this.fireDataFieldChange();
        }
    }

    @Override
    public String getIndexSort() {
        return this.indexSort;
    }

    public String getCreateIndexStatement() {
        return this.createIndexStatement;
    }

    public void setCreateIndexStatement(String createIndexStatement) {
        this.createIndexStatement = createIndexStatement;
        this.fireDataFieldChange();
    }

    @Override
    public String getComputeStatistics() {
        return this.computeStatistics;
    }

    @Override
    public void setComputeStatistics(String computeStatistics) {
        if (ConstantsOracle.checkYesNo(computeStatistics)) {
            this.computeStatistics = computeStatistics;
            this.fireDataFieldChange();
        }
    }

    public static String[] getUsingIndexChoices() {
        return USING_INDEX;
    }

    private boolean checkUsingIndex(String value) {
        if (usingIndexSet == null) {
            usingIndexSet = new HashSet();
            usingIndexSet.addAll(Arrays.asList(PKProxyOraclev9i.getUsingIndexChoices()));
        }
        return usingIndexSet.contains(value);
    }

    @Override
    public void setUsingIndex(String using) {
        if (this.checkUsingIndex(using)) {
            this.usingIndex = using;
            if (this.usingIndex.equalsIgnoreCase(GLOBAL_PARTITIONED)) {
                this.partitions.setForbiddenCreateElement(false);
            } else {
                this.partitions.setForbiddenCreateElement(true);
                this.partitions.removeAll();
            }
            this.fireDataFieldChange();
        }
    }

    @Override
    public String getUsingIndex() {
        return this.usingIndex;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Index indexPK = (Index)targetDesign.getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getObject().getName());
        PKProxyOraclev9i pkProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignOraclev9i)targetDesign).getPKProxySet().getProxy(indexPK.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            pkProxy = (PKProxyOraclev9i)storageObject;
        }
        if (pkProxy != null) {
            pkProxy.setName(this.getName());
            pkProxy.setDeferrable(this.getDeferrable());
            pkProxy.setInitially(this.getInitially());
            pkProxy.setEnable(this.getEnable());
            pkProxy.setValidate(this.getValidate());
            pkProxy.setRely(this.getRely());
            pkProxy.setUsingIndex(this.getUsingIndex());
            if (this.getExceptionsTable() != null) {
                TableProxyOraclev9i table = (TableProxyOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableProxySet().getProxy(this.getExceptionsTable().getObjectID());
                if (table == null) {
                    TableProxyOraclev9i newTable = (TableProxyOraclev9i)((TableProxySetOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableProxySet()).createProxy(this.getExceptionsTable().getObject());
                    newTable.setName(this.getName());
                    newTable.setRawObject(true);
                    pkProxy.setExceptionsTable(newTable);
                } else {
                    pkProxy.setExceptionsTable(table);
                }
            }
            if (this.getIndexGlobalPL() != null) {
                IndexGlobalPartitionsListOraclev9i list = (IndexGlobalPartitionsListOraclev9i)((StorageDesignOraclev9i)targetDesign).getIndexGlobalPartitionsListSet().getByName(this.getIndexGlobalPL().getName());
                if (list == null) {
                    IndexGlobalPartitionsListOraclev9i newList = (IndexGlobalPartitionsListOraclev9i)((StorageDesignOraclev9i)targetDesign).getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                    newList.setName(this.getName());
                    newList.setRawObject(true);
                    newList.setIndex(pkProxy);
                    pkProxy.setIndexGlobalPL(newList);
                } else {
                    list.setIndex(pkProxy);
                    pkProxy.setIndexGlobalPL(list);
                }
            }
            if (this.getIndexSegment() != null) {
                SegmentOraclev9i segment = (SegmentOraclev9i)((StorageDesignOraclev9i)targetDesign).getSegmentSet().getByName(this.getIndexSegment().getName());
                if (segment == null) {
                    SegmentOraclev9i newSegment = (SegmentOraclev9i)((StorageDesignOraclev9i)targetDesign).getSegmentSet().createSegment();
                    newSegment.setName(this.getIndexSegment().getName());
                    newSegment.setRawObject(true);
                    pkProxy.setIndexSegment(newSegment);
                } else {
                    pkProxy.setIndexSegment(segment);
                }
            }
            pkProxy.setIndexSort(this.getIndexSort());
            if (this.getTableSpace() != null) {
                TableSpaceOraclev9i tablespace = (TableSpaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tablespace == null) {
                    TableSpaceOraclev9i newTablespace = (TableSpaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().createTableSpace();
                    newTablespace.setName(this.getTableSpace().getName());
                    newTablespace.setRawObject(true);
                    pkProxy.setTableSpace(newTablespace);
                } else {
                    pkProxy.setTableSpace(tablespace);
                }
            }
            pkProxy.setLogging(this.getLogging());
            pkProxy.setComment(this.getComment());
            pkProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            pkProxy.setRawObject(false);
        }
    }
}

