/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.lang.invoke.CallSite;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DistinctTypeProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.UsedUDDTPropertyDialog;

public class UsedUserDefinedData
extends AbstractStorageObjectSqlServer
implements RelationalObjectProxySetListener {
    protected SchemaSqlServer schema;
    protected DistinctTypeProxySqlServer distinctTypeProxy;
    protected DefaultSqlServer defaultObject;
    protected RuleSqlServer ruleObject;
    protected String comments;
    protected String commentsInRDBMS;
    protected UserDefinedTypeSqlServer userDefinedType;
    protected DataBaseSqlServer database;
    private String props = "";
    private InlineList extPropsSet = null;
    public static final String TYPE_NAME = "UUDD";
    public static final String OLD_TYPE_NAME = "UsedUserDefinedData";

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getCommentsInRDBMS() {
        return this.commentsInRDBMS;
    }

    public void setCommentsInRDBMS(String commentsInRDBMS) {
        this.commentsInRDBMS = commentsInRDBMS;
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.database;
    }

    public void setDatabase(DataBaseSqlServer database) {
        this.database = database;
        this.setPAC_Element(database);
    }

    public DefaultSqlServer getDefaultObject() {
        return this.defaultObject;
    }

    public void setDefaultObject(DefaultSqlServer defaultObject) {
        this.defaultObject = defaultObject;
    }

    public DistinctTypeProxySqlServer getDistinctTypeProxy() {
        return this.distinctTypeProxy;
    }

    public void setDistinctTypeProxy(DistinctTypeProxySqlServer distinctType) {
        if (distinctType != null) {
            this.distinctTypeProxy = distinctType;
            this.userDefinedType = null;
            this.fireDataFieldChange();
        }
    }

    public RuleSqlServer getRuleObject() {
        return this.ruleObject;
    }

    public void setRuleObject(RuleSqlServer ruleObject) {
        this.ruleObject = ruleObject;
    }

    public SchemaSqlServer getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaSqlServer schema) {
        this.schema = schema;
    }

    @Override
    public void showPropertyDialog() {
        UsedUDDTPropertyDialog dialog = new UsedUDDTPropertyDialog(this.getDesign().getAppView(), this.getStorageDesign(), this);
        dialog.show();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "UDDT";
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
    }

    public UserDefinedTypeSqlServer getUserDefinedType() {
        return this.userDefinedType;
    }

    public void setUserDefinedType(UserDefinedTypeSqlServer userDefinedType) {
        if (userDefinedType != null) {
            this.userDefinedType = userDefinedType;
            this.distinctTypeProxy = null;
            this.fireDataFieldChange();
        }
    }

    public boolean isBaseOnDistinctType() {
        return this.getDistinctTypeProxy() != null;
    }

    public InlineList getExtPropsSet() {
        if (this.extPropsSet == null) {
            this.extPropsSet = new InlineList();
        }
        return this.extPropsSet;
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String prop) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateExtPropertiesSet(prop);
        } else {
            this.addExtProperty(prop);
        }
        this.props = this.getExtPropsSet().toString();
        this.fireDataFieldChange();
    }

    private void addExtProperty(String props2) {
        this.getExtPropsSet().add(props2);
    }

    public void recreateExtPropertiesSet(String props1) {
        this.getExtPropsSet().clear();
        StringTokenizer st = new StringTokenizer(props1, ",");
        this.extPropsSet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getExtPropsSet().add(st.nextToken().trim());
        }
    }

    public void clear() {
        this.getExtPropsSet().removeAllElements();
        this.props = "";
    }

    public String getDataType() {
        try {
            if (this.distinctTypeProxy != null) {
                return this.distinctTypeProxy.getDistinctType().getLogicalDataType().toString();
            }
            return this.userDefinedType.getDataType().getName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getDataTypeString() {
        String result = "";
        MDDataType dtype = null;
        if (this.distinctTypeProxy != null) {
            DistinctType dt = this.distinctTypeProxy.getDistinctType();
            LogicalDatatype type = dt.getLogicalDataType();
            if (type != null) {
                TreeMap<String, CallSite> map = new TreeMap<String, CallSite>();
                map.put("size", (CallSite)((Object)dt.getSize()));
                map.put("precision", (CallSite)((Object)("" + dt.getPrecision())));
                map.put("scale", (CallSite)((Object)("" + dt.getScale())));
                dtype = type.createDataType(this.getRDBMSType().toString(), map);
                result = dtype.toString();
            }
        } else {
            dtype = this.userDefinedType.getDataType();
            result = dtype.toString();
        }
        return result;
    }

    public String getNullType() {
        if (this.isBaseOnDistinctType()) {
            return this.getDistinctTypeProxy().getNullType();
        }
        return this.getUserDefinedType().getNullType();
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return this.getSchema().getName() + "." + this.getName();
        }
        return super.getLongName();
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

