/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k5;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.datatype.sqlserver.MDXMLTypeSqlServer;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SecondaryXmlIndexSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SecondaryXmlIndexSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.XMLIndexCollection;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.IndexPropertyDialogSqlServerv2k5;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxySqlServerv2k5
extends IndexProxySqlServer
implements ModelObjectSetListener,
StorageObjectListener,
RelationalObjectProxySetListener {
    public static final String[] ON_OFF_CHOICES = new String[]{"ON", "OFF"};
    private String allowRowLocks = "ON";
    private String allowPageLocks = "ON";
    private String onlineChoise = "OFF";
    private int maxdop = 0;
    private PartitionSchemeSqlServer partitionScheme = null;
    private StorageObjectCollection secondaryXmlIndex = null;
    public static final String REGULAR = "Regular";
    public static final String PRIMARY_XML = "Primary XML";
    public static final String SECONDARY_XML = "Secondary XML";
    private ColumnProxy partitioningColumn = null;
    private IncludeColumns includeColumnsSet = null;
    private String includeColumns = "";
    private String dropExisting = "OFF";
    private String recomputeStatistics = "ON";
    protected List propertyWrapperList = null;

    public IndexProxySqlServerv2k5(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public IndexProxySqlServerv2k5(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
        this.secondaryXmlIndex = new XMLIndexCollection(((StorageDesignSqlServerv2k5)storageDesign).getSecondaryXmlIndexSetv2k5());
        this.secondaryXmlIndex.setParent(this);
        this.secondaryXmlIndex.setName(Messages.getString("IndexProxySqlServerv2k5.SecondaryXmlIndex"));
        this.secondaryXmlIndex.setClassForParent(IndexProxySqlServer.class);
        this.secondaryXmlIndex.setSetMethod("setPrimaryXmlIndex");
        this.secondaryXmlIndex.setForbiddenCreateElement(!this.isPrimaryXmlIndex());
        ((StorageDesignSqlServerv2k5)storageDesign).getSecondaryXmlIndexSetv2k5().addSetListener(this);
        ((StorageDesignSqlServerv2k5)storageDesign).getColumnProxySet().addSetListener(this);
        index.getContainerObject().addObjectListener(this);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogSqlServerv2k5 dialog = new IndexPropertyDialogSqlServerv2k5(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public String getAllowPageLocks() {
        return this.allowPageLocks;
    }

    public void setAllowPageLocks(String allowPageLocks) {
        this.allowPageLocks = allowPageLocks;
    }

    public String getAllowRowLocks() {
        return this.allowRowLocks;
    }

    public void setAllowRowLocks(String allowRowLocks) {
        this.allowRowLocks = allowRowLocks;
    }

    public int getMaxdop() {
        return this.maxdop;
    }

    public void setMaxdop(int maxdop) {
        if (maxdop >= 0 && maxdop <= 64) {
            this.maxdop = maxdop;
        }
    }

    public String getOnlineChoise() {
        return this.onlineChoise;
    }

    public void setOnlineChoise(String online) {
        this.onlineChoise = online;
    }

    public PartitionSchemeSqlServer getPartitionScheme() {
        return this.partitionScheme;
    }

    public void setPartitionScheme(PartitionSchemeSqlServer partitionScheme) {
        this.partitionScheme = partitionScheme;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.secondaryXmlIndex) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.secondaryXmlIndex) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.secondaryXmlIndex;
            }
        }
        return null;
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof SecondaryXmlIndexSqlServer) {
            SecondaryXmlIndexSqlServer sXmlIndex = (SecondaryXmlIndexSqlServer)event.getAffected();
            this.secondaryXmlIndex.setForbiddenCreateElement(!this.isPrimaryXmlIndex());
            if (sXmlIndex.getPrimaryXmlIndex() != null && sXmlIndex.getPrimaryXmlIndex() == this) {
                sXmlIndex.setParent(this.partitionScheme);
                this.secondaryXmlIndex.add(sXmlIndex);
            } else {
                this.secondaryXmlIndex.remove(sXmlIndex);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof SecondaryXmlIndexSqlServer) {
                SecondaryXmlIndexSqlServer sXmlIndex = (SecondaryXmlIndexSqlServer)event.getAffected();
                sXmlIndex.addObjectListener(this);
                if (sXmlIndex.getPrimaryXmlIndex() != null && sXmlIndex.getPrimaryXmlIndex() == this) {
                    sXmlIndex.setParent(this.partitionScheme);
                    this.secondaryXmlIndex.add(sXmlIndex);
                } else {
                    this.secondaryXmlIndex.remove(sXmlIndex);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof SecondaryXmlIndexSqlServer) {
            SecondaryXmlIndexSqlServer sXmlIndex = (SecondaryXmlIndexSqlServer)event.getAffected();
            this.secondaryXmlIndex.remove(sXmlIndex);
            sXmlIndex.removeObjectListener(this);
        }
    }

    @Override
    public void clearChildren() {
        this.secondaryXmlIndex.removeAll();
    }

    public boolean isPrimaryXmlIndex() {
        if (this.getColumnProxies().length == 1) {
            ColumnProxySqlServerv2k5 columnProxy = (ColumnProxySqlServerv2k5)this.getColumnProxies()[0];
            return columnProxy != null && columnProxy.getDataType() instanceof MDXMLTypeSqlServer && !columnProxy.getComputed();
        }
        return false;
    }

    public boolean isSecondaryXmlIndex() {
        if (this.isPrimaryXmlIndex()) {
            return this.secondaryXmlIndex.size() > 0;
        }
        return false;
    }

    public boolean isRegularIndex() {
        return !this.isPrimaryXmlIndex() && !this.isSecondaryXmlIndex();
    }

    public String getIndexType() {
        if (this.isPrimaryXmlIndex()) {
            if (this.isSecondaryXmlIndex()) {
                return SECONDARY_XML;
            }
            return PRIMARY_XML;
        }
        return REGULAR;
    }

    public ColumnProxy getPartitioningColumn() {
        return this.partitioningColumn;
    }

    public void setPartitioningColumn(ColumnProxy partitionColumn) {
        this.partitioningColumn = partitionColumn;
    }

    public String getIncludeColumns() {
        return this.includeColumns;
    }

    public void setIncludeColumns(String value) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateIncludeColumnsSet(value);
        } else {
            this.addIncludeColumnsValue(value);
        }
        this.includeColumns = this.getIncludeColumnsSet().toString();
        this.fireDataFieldChange();
    }

    private void addIncludeColumnsValue(String value) {
        this.getIncludeColumnsSet().add(value);
    }

    protected void recreateIncludeColumnsSet(String value) {
        this.getIncludeColumnsSet().clear();
        StringTokenizer st = new StringTokenizer(value, ",");
        this.includeColumnsSet = new IncludeColumns();
        while (st.hasMoreTokens()) {
            this.getIncludeColumnsSet().add(st.nextToken().trim());
        }
    }

    public IncludeColumns getIncludeColumnsSet() {
        if (this.includeColumnsSet == null) {
            this.includeColumnsSet = new IncludeColumns();
        }
        return this.includeColumnsSet;
    }

    @Override
    public void clear() {
        if (this.includeColumnsSet != null) {
            this.includeColumnsSet.removeAllElements();
            this.includeColumns = "";
        }
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        if (event.isType(0) && event.getAffected() instanceof ColumnProxySqlServerv2k5) {
            ColumnProxySqlServerv2k5 col = (ColumnProxySqlServerv2k5)event.getAffected();
            if (this.getIncludeColumnsSet().contains(col.getObjectID())) {
                this.getIncludeColumnsSet().remove(col.getObjectID());
                this.includeColumns = this.getIncludeColumnsSet().toString();
            }
            if (this.getPartitioningColumn() == col) {
                this.setPartitioningColumn(null);
            }
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (this.getObject() == object && event.isType(ObjectChangeEvent.NAME_CHANGED) && !this.isNameChanged()) {
            this.setName(object.getName());
        }
        if (event.getAffected() instanceof Table) {
            Table table = (Table)event.getAffected();
            if (this.getTable() == table) {
                if (!this.isPrimaryXmlIndex()) {
                    this.secondaryXmlIndex.removeAll();
                    this.secondaryXmlIndex.setForbiddenCreateElement(true);
                } else {
                    this.secondaryXmlIndex.setForbiddenCreateElement(false);
                }
            }
        }
        if (event.isType(ObjectChangeEvent.KEY_CHANGED_TO_PK)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignSqlServer)this.getStorageDesign()).getPKProxySet().add(object);
            this.fireChangeNoDirty(event);
        } else if (event.isType(ObjectChangeEvent.ADD_FK)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignSqlServer)this.getStorageDesign()).getFKProxySet().add(object);
            this.fireChangeNoDirty(event);
        } else if (event.isType(ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignSqlServer)this.getStorageDesign()).getUniqueProxySet().add(object);
            this.fireChangeNoDirty(event);
        }
    }

    public void changed(ContainerObject container, ContainerObjectEvent event) {
        if (container == this.getObject()) {
            if (!this.isPrimaryXmlIndex()) {
                this.secondaryXmlIndex.removeAll();
                this.secondaryXmlIndex.setForbiddenCreateElement(true);
            } else {
                this.secondaryXmlIndex.setForbiddenCreateElement(false);
            }
        }
    }

    public StorageObjectCollection getSecondaryXMLIndexs() {
        return this.secondaryXmlIndex;
    }

    public SecondaryXmlIndexSqlServer createSecondaryXMLIndex() {
        if (this.secondaryXmlIndex.getStorageObjectSet() != null) {
            return (SecondaryXmlIndexSqlServer)this.secondaryXmlIndex.createElement(null);
        }
        return null;
    }

    public String getDropExisting() {
        return this.dropExisting;
    }

    public void setDropExisting(String dropExisting) {
        this.dropExisting = dropExisting;
    }

    @Override
    public String getRecomputeStatistics() {
        return this.recomputeStatistics;
    }

    @Override
    public void setRecomputeStatistics(String recomputeStatistics) {
        this.recomputeStatistics = recomputeStatistics;
        this.fireDataFieldChange();
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Clustered", this, "isClustered", "setClustered", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Filegroup", this, "getFilegroup", "setFilegroup", FileGroupSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partition Scheme", this, "getPartitionScheme", "setPartitionScheme", PartitionSchemeSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partitioning Column", this, "getPartitioningColumn", "setPartitioningColumn", ColumnProxy.class));
            this.propertyWrapperList.add(new PropertyWrapper("Pad Index", this, "getPadIndex", "setPadIndex", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Fill Factor[0,100]", this, "getFillFactor", "setFillFactor", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Recompute Stat", this, "getRecomputeStatistics", "setRecomputeStatistics", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Sort in temp DB", this, "getSortInTempDB", "setSortInTempDB", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Allow Row Locks", this, "getAllowRowLocks", "setAllowRowLocks", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Allow Page Locks", this, "getAllowPageLocks", "setAllowPageLocks", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("MaxDop[0,64]", this, "getMaxdop", "setMaxdop", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Online", this, "getOnlineChoise", "setOnlineChoise", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Index index = (Index)targetDesign.getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getObject().getName());
        IndexProxySqlServerv2k5 indexProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignSqlServerv2k5)targetDesign).getIndexProxySet().getProxy(index.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            indexProxy = (IndexProxySqlServerv2k5)storageObject;
        }
        if (indexProxy != null) {
            indexProxy.setName(this.getName());
            for (SecondaryXmlIndexSqlServerv2k5 secIndex : this.getSecondaryXMLIndexs()) {
                SecondaryXmlIndexSqlServerv2k5 targetSecIndex = (SecondaryXmlIndexSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getSecondaryXmlIndexSetv2k5().getByName(secIndex.getName());
                if (targetSecIndex == null) {
                    SecondaryXmlIndexSqlServerv2k5 newSecIndex = (SecondaryXmlIndexSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getSecondaryXmlIndexSetv2k5().createXmlIndex();
                    newSecIndex.setName(secIndex.getName());
                    newSecIndex.setRawObject(true);
                    indexProxy.getSecondaryXMLIndexs().add(newSecIndex);
                    continue;
                }
                indexProxy.getSecondaryXMLIndexs().add(targetSecIndex);
            }
            indexProxy.setClustered(this.isClustered());
            if (this.getFilegroup() != null) {
                FileGroupSqlServerv2k5 fileGroup = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getFileGroupSet().getByName(this.getFilegroup().getName());
                if (fileGroup == null) {
                    FileGroupSqlServerv2k5 newFileGroup = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getFileGroupSet().createFileGroup();
                    newFileGroup.setName(this.getFilegroup().getName());
                    newFileGroup.setRawObject(true);
                    indexProxy.setFilegroup(newFileGroup);
                } else {
                    indexProxy.setFilegroup(fileGroup);
                }
            }
            if (this.getPartitionScheme() != null) {
                PartitionSchemeSqlServerv2k5 partScheme = (PartitionSchemeSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getPartitionSchemeSet().getByName(this.getPartitionScheme().getName());
                if (partScheme == null) {
                    PartitionSchemeSqlServerv2k5 newPartScheme = (PartitionSchemeSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getPartitionSchemeSet().createPartitionScheme();
                    newPartScheme.setName(this.getPartitionScheme().getName());
                    newPartScheme.setRawObject(true);
                    indexProxy.setPartitionScheme(newPartScheme);
                } else {
                    indexProxy.setPartitionScheme(partScheme);
                }
            }
            if (this.getPartitioningColumn() != null) {
                ColumnProxySqlServerv2k5 column = (ColumnProxySqlServerv2k5)((ColumnProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getColumnProxySet()).getByName(this.getPartitioningColumn().getName());
                if (column == null) {
                    ColumnProxySqlServerv2k5 newColumn = (ColumnProxySqlServerv2k5)((ColumnProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getColumnProxySet()).createProxy(this.getPartitioningColumn().getObject());
                    newColumn.setName(this.getPartitioningColumn().getName());
                    newColumn.setRawObject(true);
                    indexProxy.setPartitioningColumn(newColumn);
                } else {
                    indexProxy.setPartitioningColumn(column);
                }
            }
            indexProxy.setPadIndex(this.getPadIndex());
            indexProxy.setFillFactor(this.getFillFactor());
            indexProxy.setRecomputeStatistics(this.getRecomputeStatistics());
            indexProxy.setSortInTempDB(this.getSortInTempDB());
            indexProxy.setIgnoreDupKey(this.getIgnoreDupKey());
            indexProxy.setAllowRowLocks(this.getAllowRowLocks());
            indexProxy.setAllowPageLocks(this.getAllowPageLocks());
            indexProxy.setMaxdop(this.getMaxdop());
            indexProxy.setOnlineChoise(this.getOnlineChoise());
            indexProxy.setDropExisting(this.getDropExisting());
            indexProxy.recreateExtPropertiesSet(this.getExtPropsSet().toString());
            indexProxy.recreateIncludeColumnsSet(this.getIncludeColumnsSet().toString());
            indexProxy.setComment(this.getComment());
            indexProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            indexProxy.setRawObject(false);
        }
    }

    @Override
    public void clearMergableStructure(Map reverseMap) {
        if (reverseMap != null) {
            ArrayList list = new ArrayList();
            this.secondaryXmlIndex.addAllElementsTo(list);
            for (StorageObject st : list) {
                if (reverseMap.get(st.getObjectID()) != null) continue;
                st.remove(true);
            }
        }
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    public void resetSecXMLIndexStatus() {
        this.secondaryXmlIndex.setForbiddenCreateElement(!this.isPrimaryXmlIndex());
    }

    public class IncludeColumns
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

