/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsUDB;
import oracle.dbtools.crest.model.design.storage.udb.PrivilegesUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.swingui.editor.storage.udb.OwnerPropertyDialogUDB;

public class OwnerUDB
extends Owner {
    @Override
    public String getIDPrefix() {
        return "Owner";
    }

    @Override
    public String getObjectTypeName() {
        return "Owner";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            OwnerPropertyDialogUDB dialog = new OwnerPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        OwnerUDB owner = null;
        StorageObject stObject = (StorageObject)((StorageDesignUDBv71)targetDesign).getOwnerSetUDB().getByName(this.getName());
        if (stObject != null) {
            if (this.isRawObject()) {
                owner = (OwnerUDB)stObject;
            }
        } else {
            owner = (OwnerUDB)((StorageDesignUDBv71)targetDesign).getOwnerSetUDB().createElement(null);
        }
        if (owner != null) {
            owner.setName(this.getName());
            owner.setComment(this.getComment());
            owner.setRawObject(false);
        }
    }

    private List getPermissions() {
        ArrayList<PermissionsUDB> list = new ArrayList<PermissionsUDB>();
        for (PermissionsUDB perm : ((StorageDesignUDB)this.getStorageDesign()).getPermissionsSet()) {
            if (perm.getUser() != this) continue;
            list.add(perm);
        }
        return list;
    }

    @Override
    public List getSortedByIDPermisions() {
        List list = this.getPermissions();
        Collections.sort(list, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
        return list;
    }

    private List getDBPrivileges() {
        ArrayList<PrivilegesUDB> list = new ArrayList<PrivilegesUDB>();
        for (PrivilegesUDB priv : ((StorageDesignUDB)this.getStorageDesign()).getPrivilegesSet()) {
            if (priv.getUser() != this) continue;
            list.add(priv);
        }
        return list;
    }

    @Override
    public List getSortedByID_DBPrivileges() {
        List list = this.getDBPrivileges();
        Collections.sort(list, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
        return list;
    }

    public PermissionsUDB createPermissionUDB() {
        PermissionsUDB perm = ((StorageDesignUDB)this.getStorageDesign()).getPermissionsSet().createPermissions();
        perm.setUser(this);
        return perm;
    }

    public PrivilegesUDB createDBPrivilegeUDB() {
        PrivilegesUDB priv = ((StorageDesignUDB)this.getStorageDesign()).getPrivilegesSet().createPriv();
        priv.setUser(this);
        return priv;
    }
}

