/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageObjectConstantsUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.ColumnPropertyDialogUDBv81;

public class ColumnProxyUDBv81
extends ColumnProxyUDB {
    protected String compressSystemDefault = "NO";
    protected String maxValue = "";
    protected String minValue = "";
    protected String cycle = "NO";
    protected String order = "NO";
    protected static final String[] WRITE_PERMISSION = new String[]{"FS", "BLOCKED", "ADMIN REQUIRING TOKEN FOR UPDATE", "ADMIN NOT REQUIRING TOKEN FOR UPDATE"};
    protected static List writePermissionList = Arrays.asList(WRITE_PERMISSION);
    protected static Set writePermissionSet = null;
    private String validation = "ENFORCED";
    private String queryOptimization = "ENABLE";
    public static final String ENFORCED = "ENFORCED";
    public static final String NOT_ENFORCED = "NOT ENFORCED";
    public static final String ENABLE = "ENABLE";
    public static final String DISABLE = "DISABLE";
    public static String[] validationChoices = new String[]{"ENFORCED", "NOT ENFORCED"};
    private static Set validationSet = null;
    public static String[] queryOptimizationChoices = new String[]{"ENABLE", "DISABLE"};
    private static Set queryOptimizationSet = null;
    private boolean orderChanged;

    public ColumnProxyUDBv81(Column column, StorageDesign storageDesign) {
        super(column, storageDesign);
    }

    public ColumnProxyUDBv81(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public String getCompressSystemDefault() {
        return this.compressSystemDefault;
    }

    public void setCompressSystemDefault(String compressSystemDefault) {
        if (StorageObjectConstantsUDB.checkYesNo(compressSystemDefault)) {
            this.compressSystemDefault = compressSystemDefault;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnPropertyDialogUDBv81 dialog = new ColumnPropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public String getCycle() {
        if (!this.isCycleChanged()) {
            boolean autoIncCycle = this.getColumn().isAutoIncrementCycle();
            return autoIncCycle ? "YES" : "NO";
        }
        return this.cycle;
    }

    public void setCycle(String cycle) {
        if (StorageObjectConstantsUDB.checkYesNo(cycle)) {
            this.cycle = cycle;
            this.fireDataFieldChange();
        }
    }

    public String getMaxValue() {
        if (!this.isMaxValueChanged()) {
            String colMaxValue = this.getColumn().getAutoIncrementMaxValue();
            return colMaxValue == null ? "" : colMaxValue;
        }
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
        this.fireDataFieldChange();
    }

    public String getMinValue() {
        if (!this.isMinValueChanged()) {
            String colMinValue = this.getColumn().getAutoIncrementMinValue();
            return colMinValue == null ? "" : colMinValue;
        }
        return this.minValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
        this.fireDataFieldChange();
    }

    public String getOrder() {
        if (!this.orderChanged) {
            boolean autoIncOrder = this.getColumn().isAutoIncrementOrder();
            return autoIncOrder ? "YES" : "NO";
        }
        return this.order;
    }

    public void setOrder(String order) {
        if (StorageObjectConstantsUDB.checkYesNo(order)) {
            this.order = order;
            this.fireDataFieldChange();
        }
    }

    public static String[] getWritePermissionChoices() {
        return WRITE_PERMISSION;
    }

    @Override
    protected boolean checkWritePermission(String value) {
        if (writePermissionSet == null) {
            writePermissionSet = new HashSet();
            writePermissionSet.addAll(Arrays.asList(ColumnProxyUDBv81.getWritePermissionChoices()));
        }
        return writePermissionSet.contains(value);
    }

    protected boolean checkValidation(String value) {
        if (validationSet == null) {
            validationSet = new HashSet();
            validationSet.addAll(Arrays.asList(validationChoices));
        }
        return validationSet.contains(value);
    }

    protected boolean checkQueryOptimization(String value) {
        if (queryOptimizationSet == null) {
            queryOptimizationSet = new HashSet();
            queryOptimizationSet.addAll(Arrays.asList(queryOptimizationChoices));
        }
        return queryOptimizationSet.contains(value);
    }

    public String getQueryOptimization() {
        return this.queryOptimization;
    }

    public void setQueryOptimization(String queryOptimization) {
        if (this.checkQueryOptimization(queryOptimization)) {
            this.queryOptimization = queryOptimization;
            this.fireDataFieldChange();
        }
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String validation) {
        if (this.checkValidation(validation)) {
            this.validation = validation;
            this.fireDataFieldChange();
        }
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Column column = (Column)targetDesign.getPhysicalDesign().getColumnSet().getByName(this.getObject().getName());
        ColumnProxyUDBv81 columnProxy = null;
        RelationalObjectProxy storageObject = targetDesign.getColumnProxySet().getProxy(column.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            columnProxy = (ColumnProxyUDBv81)storageObject;
        }
        if (columnProxy != null) {
            columnProxy.setName(this.getName());
            columnProxy.setDefault(this.getDefault());
            columnProxy.setDefaultValue(this.getDefaultValue());
            columnProxy.setDefaultValueConstant(this.getDefaultValueConstant());
            columnProxy.setForBitData(this.isForBitData());
            columnProxy.setCompressSystemDefault(this.getCompressSystemDefault());
            columnProxy.setLinkControl(this.getLinkControl());
            columnProxy.setReadPermission(this.getReadPermission());
            columnProxy.setWritePermission(this.getWritePermission());
            columnProxy.setRecovery(this.getRecovery());
            columnProxy.setOnUnlink(this.getOnUnlink());
            columnProxy.setLogging(this.getLogging());
            columnProxy.setCompact(this.getCompact());
            columnProxy.setUseIdentity(this.getUseIdentity());
            columnProxy.setUseIdentityChanged(this.isUseIdentityChanged());
            columnProxy.setGenerate(this.getGenerate());
            columnProxy.setStartWith(this.getStartWith());
            columnProxy.setIncrementBy(this.getIncrementBy());
            columnProxy.setMaxValue(this.getMaxValue());
            columnProxy.setMinValue(this.getMinValue());
            columnProxy.setCycle(this.getCycle());
            columnProxy.setCache(this.getCache());
            columnProxy.setOrder(this.getOrder());
            columnProxy.setGenerationExpression(this.getGenerationExpression());
            columnProxy.setGenerationExpressionChanged(this.isGenerationExpressionChanged());
            columnProxy.setComment(this.getComment());
            columnProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            columnProxy.setRawObject(false);
            columnProxy.setAutoIncrementDDL(this.getAutoIncrementDDL());
        }
    }

    public boolean isOrderChanged() {
        return this.orderChanged;
    }

    public void setOrderChanged(boolean orderChanged) {
        this.orderChanged = orderChanged;
    }
}

