/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class DP_UndoManager
extends UndoManager {
    private boolean inUndoRedoMode = false;
    private boolean locked = false;
    private int UNDO_REDO_LIST_SIZE = 20;

    @Override
    public synchronized void redo() throws CannotRedoException {
        try {
            if (this.canRedo()) {
                this.inUndoRedoMode = true;
                super.redo();
            }
        }
        finally {
            this.inUndoRedoMode = false;
        }
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        try {
            if (this.canUndo()) {
                this.inUndoRedoMode = true;
                super.undo();
            }
        }
        finally {
            this.inUndoRedoMode = false;
        }
    }

    public boolean isInUndoRedoMode() {
        return this.inUndoRedoMode;
    }

    public UndoableEdit getLastEdit() {
        int last = this.edits.size();
        if (last > 0) {
            return (UndoableEdit)this.edits.elementAt(last - 1);
        }
        return null;
    }

    public boolean removeEdit(UndoableEdit edit) {
        return this.edits.removeElement(edit);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit anEdit) {
        if (this.isLocked()) {
            return false;
        }
        if (!this.edits.contains(anEdit)) {
            return super.addEdit(anEdit);
        }
        return true;
    }

    public List<UndoableEdit> getEdits() {
        ArrayList<UndoableEdit> list = new ArrayList<UndoableEdit>();
        Enumeration en = this.edits.elements();
        while (en.hasMoreElements()) {
            list.add((UndoableEdit)en.nextElement());
        }
        return list;
    }

    public List<UndoableEdit> getUndoList() {
        List<UndoableEdit> list = this.getEdits();
        ArrayList<UndoableEdit> res = new ArrayList<UndoableEdit>();
        UndoableEdit edit = this.editToBeUndone();
        if (edit != null) {
            int ind;
            for (int i = ind = list.indexOf(edit); i >= 0 && res.size() < this.UNDO_REDO_LIST_SIZE; --i) {
                UndoableEdit ed = list.get(i);
                if (!ed.isSignificant()) continue;
                res.add(ed);
            }
        }
        return res;
    }

    public List<UndoableEdit> getRedoList() {
        List<UndoableEdit> list = this.getEdits();
        ArrayList<UndoableEdit> res = new ArrayList<UndoableEdit>();
        UndoableEdit edit = this.editToBeRedone();
        if (edit != null) {
            int ind;
            for (int i = ind = list.indexOf(edit); i < list.size() && res.size() < this.UNDO_REDO_LIST_SIZE; ++i) {
                UndoableEdit ed = list.get(i);
                if (!ed.isSignificant()) continue;
                res.add(ed);
            }
        }
        return res;
    }

    public void undoToEdit(UndoableEdit edit) {
        try {
            if (this.canUndo()) {
                this.inUndoRedoMode = true;
                this.undoTo(edit);
            }
        }
        finally {
            this.inUndoRedoMode = false;
        }
    }

    public void redoToEdit(UndoableEdit edit) {
        UndoableEdit redit = this.editToBeRedone();
        while (redit != null) {
            this.redo();
            if (redit == edit) {
                return;
            }
            redit = this.editToBeRedone();
        }
    }
}

