/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.undo.relational.FKColumnPreserver;

public class ColumnViewPreserver
extends FKColumnPreserver {
    private FKElement column;
    private FKElement backup;
    private String id;
    private TableView table;
    private int position;
    private int[][] occurences;
    private KeyObject[] keys;
    private RelationalDesign phdes;
    private List fk_col_preservers = new ArrayList();

    public ColumnViewPreserver(FKElement oldColumn) {
        this.phdes = (RelationalDesign)oldColumn.getDesignPart();
        this.preserve(oldColumn);
    }

    @Override
    public void preserve(FKElement oldColumn) {
        this.column = oldColumn;
        this.backup = new ColumnView(this.phdes);
        this.column.copy(this.backup);
        this.id = this.column.getObjectID();
        this.backup.setObjectID(this.id);
        this.position = this.column.getIndex();
        this.table = (TableView)this.column.getContainerWithKeyObject();
        this.keys = this.table.getKeys();
        this.occurences = this.occursInCandidateKeys(this.keys, this.column);
        this.saveMappings(this.column, this.mappings);
        ColumnViewPreserver.saveFKandDelegates(oldColumn, this.delegates);
        List pu_keys = this.getUK_PKFor(oldColumn);
        if (pu_keys.size() > 0) {
            List fkeys = this.phdes.getFKIndexAssociationSet().getFKeysToListOfKeys(pu_keys);
            for (FKIndexAssociation fk : fkeys) {
                FKElement fk_colum = fk.getColumnForDelegate(oldColumn);
                if (fk_colum == null) continue;
                FKColumnPreserver fpres = new FKColumnPreserver();
                fpres.preserve(fk_colum);
                this.fk_col_preservers.add(fpres);
            }
        }
    }

    @Override
    public void restore(FKElement newColumn) {
        this.backup.copy(newColumn);
        newColumn.setObjectID(this.id);
        this.table.moveToIndex(newColumn, this.position);
        if (this.occurences != null) {
            this.insertInCandidateKeys(this.keys, newColumn, this.occurences);
        }
        this.restoreMappings(this.mappings);
        ColumnViewPreserver.restoreFKandDelegates(newColumn, this.delegates);
        for (FKColumnPreserver fpres : this.fk_col_preservers) {
            fpres.restore(newColumn);
        }
    }

    @Override
    public void restore() {
        FKElement newColumn = (FKElement)this.table.getElementByID(this.id);
        if (newColumn == null) {
            newColumn = this.column;
            this.column.setObjectID(this.id);
            this.table.add(newColumn);
        }
        this.backup.copy(newColumn);
        this.table.moveToIndex(newColumn, this.position);
        if (this.occurences != null) {
            this.insertInCandidateKeys(this.keys, newColumn, this.occurences);
        }
        this.restoreMappings(this.mappings);
        ColumnViewPreserver.restoreFKandDelegates(newColumn, this.delegates);
        for (FKColumnPreserver fpres : this.fk_col_preservers) {
            fpres.restore();
        }
    }

    private List getUK_PKFor(FKElement column) {
        TableView table = (TableView)column.getContainerWithKeyObject();
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        KeyObject[] keys = table.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].isPK() && !keys[i].isUnique()) continue;
            list.add(keys[i]);
        }
        return list;
    }
}

