/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.relational.ViewIndexSet;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.design.undo.UpdateDO_Edit;
import oracle.dbtools.crest.model.design.undo.relational.ColumnViewPreserver;
import oracle.dbtools.crest.model.design.undo.relational.ColumnViewRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKCreateEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKUpdateEdit;
import oracle.dbtools.crest.model.design.undo.relational.ViewIndexRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.memento.ViewIndexMemento;

public class TableViewUpdateEdit
extends UpdateDO_Edit {
    private TableView oldTableBackup;
    private TableView oldTable;
    private TableView newTable;
    private List removedColumnsEdit = new ArrayList();
    private List removedKeysEdit = new ArrayList();
    private List newColumns = new ArrayList();
    private List newIndexes = new ArrayList();
    private List newIndOrder = new ArrayList();
    private List oldIndOrder = new ArrayList();
    private List columnPreservers = new ArrayList();
    private boolean createEdits = true;
    private List<ViewIndex> indexesForUpdate;
    private List<FKIndexAssociation.FKMemento> fkMementosForUpdate;
    private List<FKIndexAssociation.FKMemento> fkMementosForCreate;
    private List<FKIndexAssociation.FKMemento> fkMementosForRemove;
    private List<DesignObjectEdit> fkEdits = new ArrayList<DesignObjectEdit>();
    List todelete = new ArrayList();
    List updatedIndexes = new ArrayList();
    List updatedColumns = new ArrayList();

    public TableViewUpdateEdit(TableView oldTable, TableView newTable, List<ViewIndex> indexesForUpdate, List<FKIndexAssociation.FKMemento> fkMementosForUpdate, List<FKIndexAssociation.FKMemento> fkMementosForCreate, List<FKIndexAssociation.FKMemento> fkMementosForRemove) {
        super(oldTable);
        this.oldTableBackup = new TableView(oldTable.getDesignPart());
        this.oldTable = oldTable;
        this.newTable = newTable;
        oldTable.backupTo(this.oldTableBackup);
        this.indexesForUpdate = indexesForUpdate;
        this.fkMementosForCreate = fkMementosForCreate;
        this.fkMementosForUpdate = fkMementosForUpdate;
        this.fkMementosForRemove = fkMementosForRemove;
    }

    @Override
    public void applyUpdates() {
        this.newTable.applyChangesTo(this.oldTable);
        this.changeStructure(this.createEdits);
        this.createEdits = false;
    }

    @Override
    protected void restoreObject() {
        this.oldTableBackup.applyChangesTo(this.oldTable);
        this.restoreStructure();
        for (int i = this.fkEdits.size() - 1; i > -1; --i) {
            this.fkEdits.get(i).undo();
        }
    }

    private void changeStructure(boolean createEdits) {
        this.changeColumns(createEdits);
        this.changeIndexes(createEdits);
        this.changeForeignKeys(createEdits);
    }

    private void saveIndexOrder(List oldixs, List newixs) {
        for (ViewIndex index : oldixs) {
            this.oldIndOrder.add(index.getObjectID());
        }
        for (ViewIndex index : newixs) {
            this.newIndOrder.add(index.getObjectID());
        }
    }

    private void setIndexOrder(TableView table, List index_IDs) {
        ArrayList<ViewIndex> list = new ArrayList<ViewIndex>();
        for (String id : index_IDs) {
            ViewIndex index = (ViewIndex)table.getKeySet().getObjectByID(id);
            if (index == null) continue;
            list.add(index);
        }
        ((ViewIndexSet)table.getKeySet()).addAndApplyOrderFromList(list);
    }

    private void changeIndexes(boolean createEdits) {
        if (createEdits) {
            IndWr wr;
            for (ViewIndex index : this.indexesForUpdate) {
                if (index.isPK()) continue;
                index.restoreFromMemento((ViewIndexMemento)index.getIndexMemento());
            }
            List oldixs = this.oldTable.getAllInds_PK_UK_NoFKeys();
            List newixs = this.newTable.getAllInds_PK_UK_NoFKeys();
            this.saveIndexOrder(oldixs, newixs);
            this.todelete.clear();
            for (ViewIndex ind : oldixs) {
                ViewIndex indcopy;
                if (ind.isFK() || (indcopy = (ViewIndex)this.getObjectByID(newixs, ind.getObjectID())) == null && this.oldTable.isBST() && ind.isOidKey() && (indcopy = (ViewIndex)this.newTable.getOidKey()) == null && this.newTable.isBST()) continue;
                if (indcopy == null) {
                    this.todelete.add(ind);
                    continue;
                }
                wr = new IndWr();
                wr.old = ind;
                wr.omem = (ViewIndexMemento)ind.getIndexMemento();
                wr.nmem = (ViewIndexMemento)indcopy.getIndexMemento();
                if (!this.oldTable.getAppView().getXMLTransformationManager().equal(ind, indcopy, false)) {
                    wr.old.restoreFromMemento(wr.nmem);
                }
                wr.old.setMarkedGenerate(wr.nmem.generate_in_DDL);
                this.updatedIndexes.add(wr);
            }
            for (ViewIndex index : this.todelete) {
                ViewIndexRemoveEdit ie = new ViewIndexRemoveEdit(index);
                ie.end();
                this.removedKeysEdit.add(ie);
                index.remove();
            }
            for (ViewIndex newind : newixs) {
                ViewIndex oldind = (ViewIndex)this.getObjectByID(oldixs, newind.getObjectID());
                if (oldind == null && this.oldTable.isBST() && newind.isOidKey()) {
                    oldind = (ViewIndex)this.oldTable.getOidKey();
                }
                if (oldind == null) {
                    wr = new IndWr();
                    wr.old = this.oldTable.createIndex(newind.getObjectID());
                    wr.nmem = (ViewIndexMemento)newind.getIndexMemento();
                    wr.old.restoreFromMemento(wr.nmem);
                    this.newIndexes.add(wr);
                }
                if (!newind.isFK()) continue;
            }
        } else {
            for (IndWr wr : this.newIndexes) {
                wr.old.setContainerObject(this.oldTable);
                wr.old.restoreFromMemento(wr.nmem);
                this.oldTable.add(wr.old);
            }
            for (IndWr wr : this.updatedIndexes) {
                wr.old.restoreFromMemento(wr.nmem);
            }
            for (int i = 0; i < this.removedKeysEdit.size(); ++i) {
                UndoableEdit edit = (UndoableEdit)this.removedKeysEdit.get(i);
                edit.redo();
            }
        }
        this.setIndexOrder(this.oldTable, this.newIndOrder);
    }

    private void changeColumns(boolean createEdits) {
        ContainedObject[] cols_old = this.oldTable.getElements();
        Object[] cols_new = this.newTable.getElements();
        if (createEdits) {
            this.todelete.clear();
            for (int i = 0; i < cols_old.length; ++i) {
                FKElement col = (FKElement)cols_old[i];
                FKElement colcopy = (FKElement)this.getObjectByID(cols_new, col.getObjectID());
                if (colcopy == null) {
                    this.todelete.add(col);
                    continue;
                }
                ColWr wr = new ColWr();
                wr.old = col;
                wr.upd = colcopy;
                wr.bckup = (FKElement)this.oldTableBackup.getElementByID(col.getObjectID());
                wr.upd.copy(wr.old);
                wr.newpos = colcopy.getIndex();
                wr.oldpos = col.getIndex();
                this.updatedColumns.add(wr);
            }
            for (FKElement col : this.todelete) {
                ColumnViewRemoveEdit ce = new ColumnViewRemoveEdit(col);
                ce.end();
                this.removedColumnsEdit.add(ce);
                col.remove();
            }
            for (int i = 0; i < cols_new.length; ++i) {
                FKElement newcol = (FKElement)cols_new[i];
                ContainedObject col = null;
                String newColID = newcol.getObjectID();
                int oldColPosition = -1;
                for (int j = 0; j < cols_old.length; ++j) {
                    if (!cols_old[j].getObjectID().equals(newColID)) continue;
                    oldColPosition = j;
                    col = (FKElement)cols_old[j];
                    break;
                }
                if (col == null && this.oldTable.isBST()) {
                    if (newcol.isOid()) {
                        col = (FKElement)this.oldTable.getOidElement();
                    } else {
                        String id = newcol.getStructAttributeID();
                        if (id != null && !"".equals(id)) {
                            col = (FKElement)this.oldTable.getElementByStructAttributeID(id);
                        }
                    }
                }
                if (col == null) {
                    ColumnView column = this.oldTable.createColumn(newcol.getName(), newcol.getObjectID());
                    newcol.copy(column);
                    this.newColumns.add(column);
                    column.moveToIndex(i);
                    continue;
                }
                if (oldColPosition <= i) continue;
                col.moveToIndex(i);
            }
            for (ColWr wr : this.updatedColumns) {
                wr.old.moveToIndex(wr.newpos);
            }
            for (FKElement column : this.newColumns) {
                ColumnViewPreserver cp = new ColumnViewPreserver(column);
                this.columnPreservers.add(cp);
            }
        } else {
            for (ColWr wr : this.updatedColumns) {
                wr.upd.copy(wr.old);
                wr.old.moveToIndex(wr.newpos);
            }
            for (int i = 0; i < this.removedColumnsEdit.size(); ++i) {
                UndoableEdit edit = (UndoableEdit)this.removedColumnsEdit.get(i);
                edit.redo();
            }
            for (ColumnViewPreserver cp : this.columnPreservers) {
                cp.restore();
            }
        }
    }

    private void changeForeignKeys(boolean createEdits) {
        if (createEdits) {
            this.createForeignKeyEdits();
        } else {
            for (DesignObjectEdit fkEdit : this.fkEdits) {
                fkEdit.redo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createForeignKeyEdits() {
        FKIndexAssociation fk;
        if (!this.fkMementosForCreate.isEmpty()) {
            boolean propagatePKChahges = this.oldTable.getDesign().isPropagatePKChahges();
            try {
                this.oldTable.getDesign().setPropagatePKChahges(false);
                for (FKIndexAssociation.FKMemento fkMemento : this.fkMementosForCreate) {
                    fk = fkMemento.fk;
                    fk.resetFromMemento(fkMemento);
                    this.oldTable.getKeySet().remove(fk.getLocalFKIndex());
                    KeyObject ind = fkMemento.remoteTable.getKeyObject(fkMemento.remoteKeyID);
                    FKIndexAssociation nfk = this.oldTable.addFK(ind);
                    nfk.setObjectID(fk.getObjectID());
                    fk.restoreToCandidateOrigFK(nfk, fkMemento.dpv);
                    nfk.resetEdgeParams();
                    this.addFKCreateEdit(nfk);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.oldTable.getDesign().setPropagatePKChahges(propagatePKChahges);
                this.fkMementosForCreate.clear();
            }
        }
        if (!this.fkMementosForUpdate.isEmpty()) {
            Object[] fkeys = this.oldTable.getFKAssociations();
            for (FKIndexAssociation.FKMemento fkMemento : this.fkMementosForUpdate) {
                fk = (FKIndexAssociation)this.getObjectByID(fkeys, fkMemento.fk.getObjectID());
                if (fk != null) {
                    FKIndexAssociation fKIndexAssociation = fk;
                    Objects.requireNonNull(fKIndexAssociation);
                    FKIndexAssociation.FKMemento newmem = fKIndexAssociation.new FKIndexAssociation.FKMemento(fk);
                    String oldStatus = fk.getAppView().getXMLTransformationManager().getFilteredXMLString(fk);
                    fkMemento.copyTo(newmem);
                    FKUpdateEdit edit = new FKUpdateEdit(fk, newmem);
                    edit.end();
                    edit.applyUpdates();
                    String newStatus = fk.getAppView().getXMLTransformationManager().getFilteredXMLString(fk);
                    if (!oldStatus.equals(newStatus)) {
                        fk.setDirty(true);
                    }
                    this.fkEdits.add(edit);
                    continue;
                }
                FKUpdateEdit edit = this.addFKUpdateEdit(fkMemento);
                edit.applyUpdates();
            }
            this.fkMementosForUpdate.clear();
        }
        try {
            for (FKIndexAssociation.FKMemento fkMemento : this.fkMementosForRemove) {
                FKIndexAssociation originatingFK = fkMemento.fk.getOriginatingFK();
                this.addFKRemoveEdit(originatingFK);
                originatingFK.getLocalFKIndex().remove();
            }
        }
        finally {
            this.fkMementosForRemove.clear();
        }
    }

    private Object getObjectByID(Object[] objects, String id) {
        for (int i = 0; i < objects.length; ++i) {
            if (!(objects[i] instanceof ModelIDObject) || !((ModelIDObject)objects[i]).getObjectID().equals(id)) continue;
            return objects[i];
        }
        return null;
    }

    private Object getObjectByID(List objects, String id) {
        for (Object object : objects) {
            if (!(object instanceof ModelIDObject) || !((ModelIDObject)object).getObjectID().equals(id)) continue;
            return object;
        }
        return null;
    }

    private void restoreStructure() {
        UndoableEdit edit;
        for (FKElement column : this.newColumns) {
            column.remove();
        }
        for (int i = this.removedColumnsEdit.size() - 1; i > -1; --i) {
            edit = (UndoableEdit)this.removedColumnsEdit.get(i);
            edit.undo();
        }
        for (ColWr wr : this.updatedColumns) {
            wr.bckup.copy(wr.old);
            wr.old.moveToIndex(wr.oldpos);
        }
        for (IndWr wr : this.newIndexes) {
            wr.old.remove();
        }
        for (IndWr wr : this.updatedIndexes) {
            wr.old.restoreFromMemento(wr.omem);
            wr.old.setIndexState(wr.bckstate);
        }
        for (int i = this.removedKeysEdit.size() - 1; i > -1; --i) {
            edit = (UndoableEdit)this.removedKeysEdit.get(i);
            edit.undo();
        }
        this.setIndexOrder(this.oldTable, this.oldIndOrder);
    }

    public FKUpdateEdit addFKUpdateEdit(FKIndexAssociation.FKMemento fkMemento) {
        FKUpdateEdit edit = new FKUpdateEdit(fkMemento.fk, fkMemento);
        edit.end();
        this.fkEdits.add(edit);
        return edit;
    }

    public FKCreateEdit addFKCreateEdit(FKIndexAssociation fk) {
        FKCreateEdit edit = new FKCreateEdit(fk);
        edit.end();
        this.fkEdits.add(edit);
        return edit;
    }

    public FKRemoveEdit addFKRemoveEdit(FKIndexAssociation fk) {
        FKRemoveEdit edit = new FKRemoveEdit(fk);
        edit.end();
        this.fkEdits.add(edit);
        return edit;
    }

    class ColWr {
        FKElement old;
        FKElement upd;
        FKElement bckup;
        int newpos;
        int oldpos;

        ColWr() {
        }
    }

    class IndWr {
        ViewIndex old;
        ViewIndex upd;
        ViewIndex bckup;
        ViewIndexMemento omem;
        ViewIndexMemento nmem;
        String bckstate;

        IndWr() {
        }
    }
}

