/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRTableNoColumns
extends DesignRule {
    private final String RULE_ID = "1EEDFDAB-94A8-DB88-927F-D0B22DC6E295";

    public DRTableNoColumns() {
        this.setName(Messages.getString("DRTableNoColumns.IdentifyTablesWithoutColumns"));
        this.setDescription(Messages.getString("DRTableNoColumns.TablesWithoutColumnsAreNotAllowed"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Table table = (Table)object;
        if (table.size() > 0) {
            return CheckResult.createOk(object, this, Messages.getString("DRTableNoColumns.TableHasColumns"));
        }
        return CheckResult.createFailed(object, this, this.getDescription());
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "1EEDFDAB-94A8-DB88-927F-D0B22DC6E295";
    }
}

