/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRTableUndefinedColumnSecurity
extends DesignRule {
    private final String RULE_ID = "D4527A56-F58D-5D79-3CFF-D1368A8517C1";

    public DRTableUndefinedColumnSecurity() {
        this.setName(Messages.getString("DRTableUndefinedColumnSecurity.IdentifyTablesWithUndefinedColumnSecurity"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Table table = (Table)object;
        for (Column column : (Column[])table.getElements()) {
            if (column.isContainsPII() != null && column.isContainsSensitiveInformation() != null) continue;
            return CheckResult.createWarning(object, this, Messages.getString("DRTableUndefinedColumnSecurity.TableHasUndefinedColumnSecurity"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRTableUndefinedColumnSecurity.TableHasNotUndefinedColumnSecurity"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "D4527A56-F58D-5D79-3CFF-D1368A8517C1";
    }
}

