/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2.v80;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyEmptyMaterializedQuery
extends AbstractDRStorageDesign {
    private final String RULE_ID = "6E1EBECE-14E7-F523-264C-D7E01FE8AC77";

    public DRTableProxyEmptyMaterializedQuery(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyEmptyMaterializedQuery.CheckEmptyMaterializedQueryDefinition"));
        this.setDescription(Messages.getString("DRTableProxyEmptyMaterializedQuery.ThisRuleCheckForEmptyMaterializedQueryDefinition"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxyDB2v80 proxy = (TableProxyDB2v80)object;
        if (proxy.getMaterializedQuery().equalsIgnoreCase(TableProxyDB2v80.YES_NO_STATES[0]) && "".equalsIgnoreCase(proxy.getMqQueryDefinition())) {
            return CheckResult.createWarning(object, this, Messages.getString("DRTableProxyEmptyMaterializedQuery.MaterializedQueryDefinitionEmpty"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRTableProxyEmptyMaterializedQuery.TableHasNotMaterializedQuery"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "6E1EBECE-14E7-F523-264C-D7E01FE8AC77";
    }
}

