/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.udb;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.DataBaseUDB;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRDataBaseOnPathLength
extends AbstractDRStorageDesign {
    private final String RULE_ID = "A0751B35-9373-EF10-6090-F738F77E8287";
    public static final int MAX_ON_PATH_LENGTH = 205;

    public DRDataBaseOnPathLength(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(MessageFormat.format(Messages.getString("DRDataBaseOnPathLength.CheckDatabaseOnPath"), "ON path"));
        this.setDescription(MessageFormat.format(Messages.getString("DRDataBaseOnPathLength.TheOnPathValueMayNotExceedMoreThan205characters"), "ON path"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        DataBaseUDB database = (DataBaseUDB)object;
        if (database.getOnPath() != null && database.getOnPath().length() > 205) {
            return CheckResult.createFailed(database, this, MessageFormat.format(Messages.getString("DRDataBaseOnPathLength.OnPathContainsMoreThan205characters"), "ON path"));
        }
        return CheckResult.createOk(database, this, MessageFormat.format(Messages.getString("DRDataBaseOnPathLength.OnPathcontainsNotMoreThan205Characters"), "ON path"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "A0751B35-9373-EF10-6090-F738F77E8287";
    }
}

