/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db.oracle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.InflaterInputStream;
import oracle.dbtools.crest.model.design.AbstractLevelDomains;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.ObjectTypes;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.db.oracle.OracleRepositoryManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLHandler;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.RXMLSubview;
import oracle.dbtools.crest.model.persistence.xml.storage.AbstractRXMLStorageDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.TimeLog;
import oracle.sql.BLOB;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReadManager {
    private OracleRepositoryManager repositoryManager;
    private String[] dpOrder = new String[]{"Business Information", "Data Types", "LogicalDesign", "RelationalModel", "Process Model", "TransformationPackage", "Data Flow Diagram"};
    int count = 0;

    public ReadManager(OracleRepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public OracleRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDesignPartObjects(DesignPart dp, String oid, String ovid) throws SQLException {
        List co_list = new ArrayList<String>();
        Connection conn = this.getRepositoryManager().getConnection();
        Statement stmt = null;
        ResultSet rset = null;
        try {
            String query = "select distinct m.type from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m where parent_OVID = '" + ovid + "'";
            stmt = conn.createStatement();
            rset = stmt.executeQuery(query);
            while (rset.next()) {
                String type = rset.getString(1);
                co_list.add(type);
            }
        }
        finally {
            if (rset != null) {
                rset.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        co_list = dp.getOrderedTypes(co_list);
        for (String type : co_list) {
            this.readDesignPartObjects(dp, oid, ovid, type);
        }
    }

    public void readChangerequests(Design design) throws SQLException {
        String oid = design.getRepositoryOID();
        String ovid = design.getRepositoryOVID();
        if (oid != null && ovid != null) {
            this.readDesignPartObjects(null, oid, ovid, "ChangeRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDesignPartObjects(DesignPart dp, String oid, String ovid, String objectType) throws SQLException {
        AbstractXMLReader reader = this.getRepositoryManager().getXMReader(objectType);
        int count = 0;
        if (reader != null) {
            String user = this.getRepositoryManager().getUser();
            String tableName = this.getRepositoryManager().getTableName(objectType);
            Connection conn = this.getRepositoryManager().getConnection();
            Statement stmt = null;
            ResultSet rset = null;
            try {
                String query = "select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + tableName + " d where m.type = '" + objectType + "' and m.parent_OVID = '" + ovid + "'  and m.oid = r.oid and r.last_version = d.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
                query = query + " union all select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + tableName + " d where m.type = '" + objectType + "' and  m.parent_OVID = '" + ovid + "'  and m.oid = r.oid and r.check_out_version = d.ovid and r.check_out_version is not null and r.checkout_by = user";
                stmt = conn.createStatement();
                rset = stmt.executeQuery(query);
                while (rset.next()) {
                    String type = rset.getString(1);
                    String ob_oid = rset.getString(2);
                    String ob_ovid = rset.getString(3);
                    String checkOut_v = rset.getString(4);
                    String checkOut_by = rset.getString(5);
                    BLOB blob = (BLOB)rset.getBlob(6);
                    String xmldata = null;
                    ++count;
                    try {
                        if (blob != null) {
                            xmldata = ReadManager.getString(blob);
                        }
                        Object object = null;
                        if (xmldata != null) {
                            if ("TransformationPackage".equalsIgnoreCase(objectType)) {
                                object = this.readTransformationPackage(dp.getDesign(), ob_oid, ob_ovid, xmldata);
                            } else {
                                Document doc = OracleRepositoryManager.getDocument(xmldata);
                                if (dp != null && objectType.equalsIgnoreCase("Note")) {
                                    String id = this.getAttributeForObject(doc, "id");
                                    dp.recreateNote(id);
                                }
                                object = reader instanceof RXMLSubview && (objectType.equalsIgnoreCase(ObjectTypes.SUBVIEW) || objectType.equalsIgnoreCase(ObjectTypes.MAINVIEW)) ? ((RXMLSubview)reader).recreateObject(doc, dp, false) : reader.recreateObject(doc, this.getRepositoryManager().getDesign(), false);
                            }
                        }
                        if (object != null && object instanceof RepositoryObject) {
                            RepositoryObject ro = (RepositoryObject)object;
                            ro.setRepositoryOID(ob_oid);
                            ro.setRepositoryOVID(ob_ovid);
                            if (checkOut_v != null) {
                                ro.setCheckedOut(true);
                            } else {
                                ro.setCheckedOut(false);
                            }
                            if (checkOut_by == null) {
                                checkOut_by = "";
                            }
                            ro.setCheckedOutBy(checkOut_by);
                            if (ro.isCheckedOut() && user != null && user.equalsIgnoreCase(checkOut_by)) {
                                ro.setCheckedOutByMe(true);
                            } else {
                                ro.setCheckedOutByMe(false);
                            }
                            ro.setDirty(false);
                        }
                        if (!(object instanceof DesignPartView)) continue;
                        DesignPartView dpv = (DesignPartView)object;
                        dpv.setCheckedOutByMe(dpv.isCheckedOutByMe());
                        ((DesignPartView)object).getPlaceHolder().setDirty(false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTransformationTasks(TransformationPackage trp, Design design, String oid, String ovid) throws SQLException {
        String objectType = "TransformationTask";
        AbstractXMLReader reader = design.getAppView().getPersistenceManager().getTransformationTaskReader();
        int count = 0;
        if (reader != null) {
            String user = this.getRepositoryManager().getUser();
            String tableName = OracleRepositoryManager.T_PACKAGES;
            Connection conn = this.getRepositoryManager().getConnection();
            Statement stmt = null;
            ResultSet rset = null;
            try {
                String query = "select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + tableName + " d where m.type = '" + objectType + "' and m.parent_OVID = '" + ovid + "'  and m.oid = r.oid and r.last_version = d.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
                query = query + " union all select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + tableName + " d where m.type = '" + objectType + "' and  m.parent_OVID = '" + ovid + "'  and m.oid = r.oid and r.check_out_version = d.ovid and r.check_out_version is not null and r.checkout_by = user";
                stmt = conn.createStatement();
                rset = stmt.executeQuery(query);
                while (rset.next()) {
                    String type = rset.getString(1);
                    String ob_oid = rset.getString(2);
                    String ob_ovid = rset.getString(3);
                    String checkOut_v = rset.getString(4);
                    String checkOut_by = rset.getString(5);
                    BLOB blob = (BLOB)rset.getBlob(6);
                    String xmldata = null;
                    ++count;
                    if (blob != null) {
                        try {
                            xmldata = ReadManager.getString(blob);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    Document doc = OracleRepositoryManager.getDocument(xmldata);
                    String id = this.getAttributeForDesign(doc, "id");
                    TransformationTask object = trp.createTransformationTask(id);
                    this.readDesignPartObjects(object, ob_oid, ob_ovid);
                    if ((object = (TransformationTask)reader.recreateDesign(doc, (DesignPart)object, false)) == null || !(object instanceof RepositoryObject)) continue;
                    TransformationTask ro = object;
                    ro.setRepositoryOID(ob_oid);
                    ro.setRepositoryOVID(ob_ovid);
                    if (checkOut_v != null) {
                        ro.setCheckedOut(true);
                    } else {
                        ro.setCheckedOut(false);
                    }
                    if (checkOut_by == null) {
                        checkOut_by = "";
                    }
                    ro.setCheckedOutBy(checkOut_by);
                    if (ro.isCheckedOut() && user != null && user.equalsIgnoreCase(checkOut_by)) {
                        ro.setCheckedOutByMe(true);
                    } else {
                        ro.setCheckedOutByMe(false);
                    }
                    ro.setDirty(false);
                    object.getMainView().setDirty(false);
                }
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readRepSet(RepositoryObject rp) throws SQLException {
        String objectType = rp.getName();
        AbstractXMLReader reader = this.getRepositoryManager().getXMReader(objectType);
        int count = 0;
        if (reader != null) {
            String user = this.getRepositoryManager().getUser();
            Connection conn = this.getRepositoryManager().getConnection();
            Statement stmt = null;
            ResultSet rset = null;
            try {
                String query = "select m.type, m.oid, m.ovid, r.check_out_version, r.checkout_by, m.xml_content from " + OracleRepositoryManager.T_PACKAGES + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r where m.type = '" + objectType + "' and m.oid = r.oid and r.last_version = m.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
                query = query + " union all select m.type, m.oid, m.ovid, r.check_out_version, r.checkout_by, m.xml_content from " + OracleRepositoryManager.T_PACKAGES + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r where m.type = '" + objectType + "' and m.oid = r.oid and r.check_out_version = m.ovid and r.check_out_version is not null and r.checkout_by = user";
                stmt = conn.createStatement();
                rset = stmt.executeQuery(query);
                while (rset.next()) {
                    String ob_oid = rset.getString(2);
                    String ob_ovid = rset.getString(3);
                    String checkOut_v = rset.getString(4);
                    String checkOut_by = rset.getString(5);
                    BLOB blob = (BLOB)rset.getBlob(6);
                    String xmldata = null;
                    ++count;
                    if (blob != null) {
                        try {
                            xmldata = ReadManager.getString(blob);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    Document doc = OracleRepositoryManager.getDocument(xmldata);
                    Object object = null;
                    object = reader.recreateObject(doc, this.getRepositoryManager().getDesign(), false);
                    if (object != null && object instanceof RepositoryObject) {
                        RepositoryObject ro = (RepositoryObject)object;
                        ro.setRepositoryOID(ob_oid);
                        ro.setRepositoryOVID(ob_ovid);
                        if (checkOut_v != null) {
                            ro.setCheckedOut(true);
                        } else {
                            ro.setCheckedOut(false);
                        }
                        if (checkOut_by == null) {
                            checkOut_by = "";
                        }
                        ro.setCheckedOutBy(checkOut_by);
                        if (ro.isCheckedOut() && user != null && user.equalsIgnoreCase(checkOut_by)) {
                            ro.setCheckedOutByMe(true);
                        } else {
                            ro.setCheckedOutByMe(false);
                        }
                    }
                    if (object == null || !(object instanceof RepositoryObject)) continue;
                    ((RepositoryObject)object).setDirty(false);
                }
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStorageObjects(StorageDesign stoDes, String ovid, String objectType) throws SQLException {
        AbstractXMLReader reader = stoDes.getAppView().getPersistenceManager().getReaderFor(stoDes);
        if (reader != null && reader instanceof AbstractRXMLStorageDesign) {
            String user = this.getRepositoryManager().getUser();
            String tableName = OracleRepositoryManager.T_PHYSICAL_OBJECTS;
            Connection conn = this.getRepositoryManager().getConnection();
            Statement stmt = null;
            ResultSet rset = null;
            try {
                String query = "select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PHYSMODELS_MEMBERS + " m, " + OracleRepositoryManager.T_PM_OBJECT_REGISTER + " r, " + tableName + " d where m.type ='" + objectType + "' and m.parent_OVID = '" + ovid + "'  and m.oid = r.oid and r.last_version = d.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
                query = query + " union all select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PHYSMODELS_MEMBERS + " m, " + OracleRepositoryManager.T_PM_OBJECT_REGISTER + " r, " + tableName + " d where m.type ='" + objectType + "' and m.parent_OVID = '" + ovid + "'  and m.oid = r.oid and r.check_out_version = d.ovid and r.check_out_version is not null and r.checkout_by = user";
                stmt = conn.createStatement();
                rset = stmt.executeQuery(query);
                while (rset.next()) {
                    String type = rset.getString(1);
                    String ob_oid = rset.getString(2);
                    String ob_ovid = rset.getString(3);
                    String checkOut_v = rset.getString(4);
                    String checkOut_by = rset.getString(5);
                    BLOB blob = (BLOB)rset.getBlob(6);
                    String xmldata = null;
                    if (blob != null) {
                        try {
                            xmldata = ReadManager.getString(blob);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    Document doc = OracleRepositoryManager.getDocument(xmldata);
                    StorageObject object = null;
                    object = ((AbstractRXMLStorageDesign)reader).recreateStorageObject(doc, type, stoDes, true);
                    ++this.count;
                    if (object == null || !(object instanceof RepositoryObject)) continue;
                    RepositoryObject ro = object;
                    ro.setRepositoryOID(ob_oid);
                    ro.setRepositoryOVID(ob_ovid);
                    if (checkOut_v != null) {
                        ro.setCheckedOut(true);
                    } else {
                        ro.setCheckedOut(false);
                    }
                    if (checkOut_by == null) {
                        checkOut_by = "";
                    }
                    ro.setCheckedOutBy(checkOut_by);
                    if (ro.isCheckedOut() && user != null && user.equalsIgnoreCase(checkOut_by)) {
                        ro.setCheckedOutByMe(true);
                    } else {
                        ro.setCheckedOutByMe(false);
                    }
                    ro.setDirty(false);
                }
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDomains(Design design, AbstractLevelDomains alDomains) throws SQLException {
        ArrayList<ObjectDescr> domains = new ArrayList<ObjectDescr>();
        String tableName = OracleRepositoryManager.T_DOMAINS;
        Connection conn = this.getRepositoryManager().getConnection();
        Statement stmt = null;
        ResultSet rset = null;
        String ovid = alDomains.getRepositoryOVID();
        String objectType = "Domain";
        try {
            String user = this.getRepositoryManager().getUser();
            String query = "select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + tableName + " d where m.type = '" + objectType + "' and m.parent_OVID = '" + ovid + "'  and m.oid = r.oid and r.last_version = d.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
            query = query + " union all select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + tableName + " d where m.type = '" + objectType + "' and  m.parent_OVID = '" + ovid + "'  and m.oid = r.oid and r.check_out_version = d.ovid and r.check_out_version is not null and r.checkout_by = user";
            stmt = conn.createStatement();
            rset = stmt.executeQuery(query);
            while (rset.next()) {
                ObjectDescr descr = new ObjectDescr();
                domains.add(descr);
                descr.type = rset.getString(1);
                descr.oid = rset.getString(2);
                descr.ovid = rset.getString(3);
                String check_out_v = rset.getString(4);
                descr.checkOutBy = rset.getString(5);
                BLOB blob = (BLOB)rset.getBlob(6);
                if (descr.checkOutBy == null) {
                    descr.checkOutBy = "";
                }
                descr.checkedOut = check_out_v != null;
                if (blob == null) continue;
                try {
                    descr.xmldata = ReadManager.getString(blob);
                }
                catch (IOException iOException) {}
            }
            alDomains.clearDomains();
            for (ObjectDescr descr : domains) {
                Domain domain = this.createDomain(design, alDomains, descr.type, descr.oid, descr.ovid, descr.xmldata);
                if (domain == null) continue;
                domain.setCheckedOut(descr.checkedOut);
                domain.setCheckedOutBy(descr.checkOutBy);
                if (domain.isCheckedOut() && user != null && user.equalsIgnoreCase(descr.checkOutBy)) {
                    domain.setCheckedOutByMe(true);
                } else {
                    domain.setCheckedOutByMe(false);
                }
                domain.setDirty(false);
            }
            design.getDomainSet().sort();
        }
        finally {
            if (rset != null) {
                rset.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXMapObjects(String oid, String ovid) throws SQLException {
        String objectType = ObjectTypes.XMAPPING;
        AbstractXMLReader reader = this.getRepositoryManager().getXMReader(objectType);
        int count = 0;
        boolean a = false;
        if (reader != null) {
            String user = this.getRepositoryManager().getUser();
            String tableName = this.getRepositoryManager().getTableName(objectType);
            Connection conn = this.getRepositoryManager().getConnection();
            Statement stmt = null;
            ResultSet rset = null;
            try {
                String query = "select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + tableName + " d where m.type = '" + objectType + "' and m.parent_OVID = '" + ovid + "'  and m.oid = r.oid and r.last_version = d.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
                query = query + " union all select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + tableName + " d where m.type = '" + objectType + "' and  m.parent_OVID = '" + ovid + "'  and m.oid = r.oid and r.check_out_version = d.ovid and r.check_out_version is not null and r.checkout_by = user";
                stmt = conn.createStatement();
                rset = stmt.executeQuery(query);
                while (rset.next()) {
                    Document doc;
                    Object object;
                    String type = rset.getString(1);
                    String ob_oid = rset.getString(2);
                    String ob_ovid = rset.getString(3);
                    String checkOut_v = rset.getString(4);
                    String checkOut_by = rset.getString(5);
                    BLOB blob = (BLOB)rset.getBlob(6);
                    String xmldata = null;
                    ++count;
                    if (blob != null) {
                        try {
                            xmldata = ReadManager.getString(blob);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if ((object = reader.recreateObject(doc = OracleRepositoryManager.getDocument(xmldata), this.getRepositoryManager().getDesign(), false)) != null && object instanceof RepositoryObject) {
                        RepositoryObject ro = (RepositoryObject)object;
                        ro.setRepositoryOID(ob_oid);
                        ro.setRepositoryOVID(ob_ovid);
                        if (checkOut_v != null) {
                            ro.setCheckedOut(true);
                        } else {
                            ro.setCheckedOut(false);
                        }
                        if (checkOut_by == null) {
                            checkOut_by = "";
                        }
                        ro.setCheckedOutBy(checkOut_by);
                        if (ro.isCheckedOut() && user != null && user.equalsIgnoreCase(checkOut_by)) {
                            ro.setCheckedOutByMe(true);
                        } else {
                            ro.setCheckedOutByMe(false);
                        }
                    }
                    if (object == null || !(object instanceof RepositoryObject)) continue;
                    ((RepositoryObject)object).setDirty(false);
                }
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDesignParts(Design design, String parentoid, String parentovid, ProgressDialog monitor) throws SQLException {
        List<ObjectDescr> dparts = new ArrayList();
        ArrayList<ObjectDescr> dataFlowDesigns = new ArrayList<ObjectDescr>();
        String tableName = OracleRepositoryManager.T_PACKAGE_MEMBERS;
        Connection conn = this.getRepositoryManager().getConnection();
        Statement stmt = null;
        ResultSet rset = null;
        ObjectDescr xmapdesc = null;
        try {
            String user = this.getRepositoryManager().getUser();
            String dldType = design.getDLDomains().getType();
            String query = "select m.type,p.name,m.oid,p.ovid,r.check_out_version,r.checkout_by,p.xml_content from " + tableName + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + OracleRepositoryManager.T_PACKAGES + " p where m.type != '" + dldType + "' and parent_OVID = '" + parentovid + "'  and m.oid = r.oid and p.ovid = r.last_version and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
            query = query + " union all select m.type,p.name,m.oid,p.ovid,r.check_out_version,r.checkout_by,p.xml_content from " + tableName + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + OracleRepositoryManager.T_PACKAGES + " p where parent_OVID = '" + parentovid + "'  and m.oid = r.oid and p.ovid = r.check_out_version and r.check_out_version is not null and r.checkout_by = user";
            stmt = conn.createStatement();
            rset = stmt.executeQuery(query);
            int progress = 10;
            while (rset.next()) {
                String dp_type = rset.getString(1);
                ObjectDescr descr = new ObjectDescr();
                if ("ExtendedMap".equalsIgnoreCase(dp_type)) {
                    xmapdesc = descr;
                } else if ("Data Flow Diagram".equalsIgnoreCase(dp_type)) {
                    dataFlowDesigns.add(descr);
                } else {
                    dparts.add(descr);
                }
                descr.type = dp_type;
                descr.name = rset.getString(2);
                descr.oid = rset.getString(3);
                descr.ovid = rset.getString(4);
                String check_out_v = rset.getString(5);
                descr.checkOutBy = rset.getString(6);
                if (descr.checkOutBy == null) {
                    descr.checkOutBy = "";
                }
                BLOB blob = (BLOB)rset.getBlob(7);
                if (check_out_v != null) {
                    descr.checkedOut = true;
                }
                if (blob == null) continue;
                try {
                    descr.xmldata = ReadManager.getString(blob);
                }
                catch (IOException iOException) {}
            }
            dparts = this.reorderDP_Descriptors(dparts);
            for (ObjectDescr descr : dparts) {
                monitor.setNote("Reading Model: " + descr.name);
                monitor.setProgress(progress);
                if (!"TransformationPackage".equalsIgnoreCase(descr.type)) {
                    DesignPart dp = this.createDesignPart(design, descr.name, descr.type, descr.oid, descr.ovid, descr.xmldata, dataFlowDesigns);
                    if (dp != null) {
                        if (descr.checkedOut) {
                            dp.setCheckedOut(true);
                        }
                        dp.setDirty(false);
                        dp.setLoaded(true);
                        dp.setCheckedOutBy(descr.checkOutBy);
                        if (dp.isCheckedOut() && user != null && user.equalsIgnoreCase(descr.checkOutBy)) {
                            dp.setCheckedOutByMe(true);
                        }
                        dp.sortCollections();
                        if (dp.getMainView() != null) {
                            dp.getMainView().setDirty(false);
                        }
                    }
                    if ("LogicalDesign".equalsIgnoreCase(descr.type)) {
                        RelationalDesign pdes = design.getRelationalDesign();
                        pdes.setIsDeleting(true);
                        design.removeRelationalDesign(pdes);
                    }
                }
                progress += 10;
            }
            if (xmapdesc != null) {
                this.readXMapObjects(xmapdesc.oid, xmapdesc.ovid);
            }
        }
        finally {
            if (rset != null) {
                rset.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private TransformationPackage readTransformationPackage(Design design, String oid, String ovid, String xmldata) throws SQLException {
        Document doc = OracleRepositoryManager.getDocument(xmldata);
        String id = this.getAttributeForObject(doc, "id");
        TransformationPackage trp = design.getProcessModel().createTransformationPackage(id);
        design.getProcessModel().setTransformationPackage(trp);
        trp.setRepositoryOID(oid);
        trp.setRepositoryOVID(ovid);
        this.readTransformationTasks(trp, design, oid, ovid);
        AbstractXMLReader reader = this.getRepositoryManager().getXMReader("TransformationPackage");
        if (reader != null) {
            trp = (TransformationPackage)reader.recreateObject(doc, this.getRepositoryManager().getDesign(), false);
            trp.setDirty(false);
        }
        return trp;
    }

    public static String getString(BLOB compressedBLOB) throws SQLException, IOException {
        int cnt;
        int size = compressedBLOB.getBufferSize();
        ByteArrayOutputStream out = new ByteArrayOutputStream(size);
        InflaterInputStream z = new InflaterInputStream(compressedBLOB.getBinaryStream());
        byte[] buffer = new byte[size];
        int all_cnt = 0;
        while ((cnt = z.read(buffer)) != -1) {
            out.write(buffer, 0, cnt);
            all_cnt += cnt;
        }
        byte[] result = out.toByteArray();
        z.close();
        out.close();
        String xml = new String(result, 0, all_cnt, "UTF-8");
        return xml;
    }

    private DesignPart createDesignPart(Design design, String name, String type, String oid, String ovid, String xmldata, List dataFlowDesignDescrs) {
        Document doc = OracleRepositoryManager.getDocument(xmldata);
        DesignPart dp = this.createDesignPart(type, name, design, doc, dataFlowDesignDescrs);
        if (dp != null) {
            if (dp instanceof ProcessModel) {
                this.createDataFlowDesigns(design, dataFlowDesignDescrs);
            }
            dp.setRepositoryOID(oid);
            dp.setRepositoryOVID(ovid);
            try {
                this.readDesignPartObjects(dp, oid, ovid);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            AbstractXMLReader reader = this.getRepositoryManager().getDesign().getAppView().getPersistenceManager().getDesignPartReader(dp);
            if (reader != null) {
                reader.recreateDesign(doc, dp, false);
            }
            dp.checkAndSetIDGenerator();
            dp.createRepositoryMap();
            dp.setLoaded(true);
            dp.setDirty(false);
            if (dp instanceof ProcessModel) {
                ProcessModel pm = (ProcessModel)dp;
                for (ObjectDescr descr : dataFlowDesignDescrs) {
                    try {
                        DataFlowDesign dfd = descr.dfd;
                        pm.setDataFlowDesign(dfd);
                        this.readDesignPartObjects(dfd, descr.oid, descr.ovid);
                        AbstractXMLReader readerd = this.getRepositoryManager().getDesign().getAppView().getPersistenceManager().getDesignPartReader(dfd);
                        if (readerd != null) {
                            Document docd = OracleRepositoryManager.getDocument(descr.xmldata);
                            readerd.recreateDesign(docd, (DesignPart)dfd, false);
                        }
                        dfd.checkAndSetIDGenerator();
                        dfd.createRepositoryMap();
                        dfd.setLoaded(true);
                        dfd.setDirty(false);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return dp;
    }

    private void createDataFlowDesigns(Design design, List descriptors) {
        for (ObjectDescr descr : descriptors) {
            Document doc = OracleRepositoryManager.getDocument(descr.xmldata);
            String name = descr.name;
            String topLevelDFD = this.getAttributeForDesign(doc, "top_level_dfd_design");
            DataFlowDesign dfDesign = "true".equalsIgnoreCase(topLevelDFD) ? design.getProcessModel().addDataFlowDesign(name) : design.getProcessModel().addDataFlowDesign(name, false);
            descr.dfd = dfDesign;
            design.getProcessModel().setDataFlowDesign(dfDesign);
            String id = this.getAttributeForDesign(doc, "id");
            dfDesign.setObjectID(id);
            design.getProcessModel().setHasOpenedDFDesigns(true);
            dfDesign.setRepositoryOID(descr.oid);
            dfDesign.setRepositoryOVID(descr.ovid);
            dfDesign.setDirty(false);
            if (dfDesign.getMainView() == null) continue;
            dfDesign.getMainView().setDirty(false);
        }
    }

    private boolean createLogicalDatatypes(Design design, String type, String oid, String ovid, String xmldata) {
        Document doc;
        AbstractXMLReader reader;
        if (xmldata != null && (reader = this.getRepositoryManager().getXMReader(type)) != null && (doc = OracleRepositoryManager.getDocument(xmldata)) != null) {
            reader.recreateObject(doc, design, false);
            return true;
        }
        return false;
    }

    private boolean createRDBMSSites(Design design, String type, String oid, String ovid, String xmldata) {
        Document doc;
        AbstractXMLReader reader;
        if (xmldata != null && (reader = this.getRepositoryManager().getXMReader(type)) != null && (doc = OracleRepositoryManager.getDocument(xmldata)) != null) {
            reader.recreateObject(doc, design, false);
            return true;
        }
        return false;
    }

    private Domain createDomain(Design design, AbstractLevelDomains alDomains, String type, String oid, String ovid, String xmldata) {
        Domain domain;
        Document doc;
        AbstractXMLReader reader;
        if (xmldata != null && (reader = this.getRepositoryManager().getXMReader(type)) != null && (doc = OracleRepositoryManager.getDocument(xmldata)) != null && (domain = (Domain)reader.recreateObject(doc, design, false)) != null) {
            domain.setRepositoryOID(oid);
            domain.setRepositoryOVID(ovid);
            alDomains.createRepositoryMap();
            return domain;
        }
        return null;
    }

    private DesignPart createDesignPart(String type, String name, Design design, Document doc, List dataFlowDesignDescrs) {
        if ("RelationalModel".equalsIgnoreCase(type)) {
            RelationalDesign rd = design.addRelationalDesign(name);
            design.setRelationalDesign(rd);
            return rd;
        }
        if ("LogicalDesign".equalsIgnoreCase(type)) {
            return design.getLogicalDesign();
        }
        if ("Data Types".equalsIgnoreCase(type)) {
            return design.getDataTypesDesign();
        }
        if ("Dimensional Model".equalsIgnoreCase(type)) {
            MultidimensionalDesign md = design.addMultidimensionalDesign(name);
            design.setMultidimensionalDesign(md);
            return md;
        }
        if ("Process Model".equalsIgnoreCase(type)) {
            return design.getProcessModel();
        }
        if ("Data Flow Diagram".equalsIgnoreCase(type)) {
            String topLevelDFD = this.getAttributeForDesign(doc, "top_level_dfd_design");
            DataFlowDesign dfDesign = "true".equalsIgnoreCase(topLevelDFD) ? design.getProcessModel().addDataFlowDesign(name) : design.getProcessModel().addDataFlowDesign(name, false);
            design.getProcessModel().setDataFlowDesign(dfDesign);
            String id = this.getAttributeForDesign(doc, "id");
            dfDesign.setObjectID(id);
            design.getProcessModel().setHasOpenedDFDesigns(true);
            return dfDesign;
        }
        if ("Business Information".equalsIgnoreCase(type)) {
            return design.getBusinessInfoDesign();
        }
        return null;
    }

    private String getAttributeForDesign(Document doc, String attrName) {
        Element root = doc.getDocumentElement();
        String attr = root.getAttribute(attrName);
        return attr;
    }

    private String getAttributeForObject(Document doc, String attrName) {
        Element root = doc.getDocumentElement();
        Element objInfo = AbstractXMLHandler.getFirstChildByTagName(root, "object");
        String attr = objInfo.getAttribute(attrName);
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDesigns(boolean lastVersionsOnly) {
        ArrayList<AbstractRepositoryManager.DesignDescriptor> list = new ArrayList<AbstractRepositoryManager.DesignDescriptor>();
        Connection conn = this.getRepositoryManager().getConnection();
        Statement stmt = null;
        ResultSet rset = null;
        Object query = "";
        String tableName = OracleRepositoryManager.T_PACKAGES;
        String registerTable = OracleRepositoryManager.T_OBJECT_REGISTER;
        if (lastVersionsOnly) {
            // empty if block
        }
        query = "select name,p.oid,ovid,to_char(date_created, 'DD.MM.YYYY HH24:MI') cdate_created,created_by,to_char(date_changed, 'DD.MM.YYYY HH24:MI'),changed_by, short_description, v_sequence, r.check_out_version, r.checkout_by,date_created  from " + tableName + " p, " + registerTable + " r  where type = 'Design' and p.oid = r.oid  and r.last_version = p.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)  union all select name,p.oid,ovid,to_char(date_created, 'DD.MM.YYYY HH24:MI') cdate_created,created_by,to_char(date_changed, 'DD.MM.YYYY HH24:MI') date_changed,changed_by, short_description, v_sequence, r.check_out_version, r.checkout_by,date_created  from " + tableName + " p, " + registerTable + " r  where type = 'Design' and p.oid = r.oid  and r.check_out_version = p.ovid and r.check_out_version is not null and r.checkout_by = user  order by name asc, date_created desc ";
        try {
            stmt = conn.createStatement();
            rset = stmt.executeQuery((String)query);
            while (rset.next()) {
                AbstractRepositoryManager.DesignDescriptor descr = this.getRepositoryManager().new AbstractRepositoryManager.DesignDescriptor();
                list.add(descr);
                descr.name = rset.getString(1);
                descr.oid = rset.getString(2);
                descr.ovid = rset.getString(3);
                descr.date_created = rset.getString(4);
                descr.created_by = rset.getString(5);
                descr.date_changed = rset.getString(6);
                descr.changed_by = rset.getString(7);
                String desc = rset.getString(8);
                if (desc == null) {
                    desc = "";
                }
                descr.short_description = desc;
                descr.v_sequence = rset.getInt(9);
                descr.checkout_version = rset.getString(10);
                descr.checkout_by = rset.getString(11);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readUserRights(Design design) {
        if (ApplicationView.IS_VIEWER) {
            design.setReadOnly(true);
            return;
        }
        Connection conn = this.getRepositoryManager().getConnection();
        Statement stmt = null;
        ResultSet rset = null;
        try {
            String query = "select Viewer_Mode,Logical_Only from " + OracleRepositoryManager.T_USERS + " where name = user";
            stmt = conn.createStatement();
            rset = stmt.executeQuery(query);
            if (rset.next()) {
                String viewr = rset.getString(1);
                String logonly = rset.getString(2);
                if (viewr != null && viewr.equalsIgnoreCase("Y")) {
                    ApplicationView.LOGICAL_MODEL_ONLY = false;
                    ApplicationView.IS_VIEWER = true;
                    design.setReadOnly(true);
                    design.getAppView().getController().updateMenus();
                    design.getAppView().getController().updateToolbar();
                    design.getAppView().updateActions();
                } else if (logonly != null && logonly.equalsIgnoreCase("Y")) {
                    ApplicationView.IS_VIEWER = false;
                    ApplicationView.LOGICAL_MODEL_ONLY = true;
                    design.getAppView().getController().updateMenus();
                    design.getAppView().getController().updateToolbar();
                    design.getAppView().updateActions();
                } else if (!ApplicationView.LOGICAL_MODEL_ONLY) {
                    ApplicationView.IS_VIEWER = false;
                    ApplicationView.LOGICAL_MODEL_ONLY = false;
                    design.setReadOnly(false);
                    design.getAppView().getController().updateMenus();
                    design.getAppView().getController().updateToolbar();
                    design.getAppView().updateActions();
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private List reorderDP_Descriptors(List descriptors) {
        ArrayList<ObjectDescr> list = new ArrayList<ObjectDescr>();
        ArrayList temp = new ArrayList(descriptors);
        for (int i = 0; i < this.dpOrder.length; ++i) {
            String type = this.dpOrder[i];
            for (ObjectDescr descr : descriptors) {
                if (!type.equalsIgnoreCase(descr.type)) continue;
                list.add(descr);
                temp.remove(descr);
            }
        }
        list.addAll(temp);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPhysicalModel(StorageDesign stoDes) throws SQLException {
        block15: {
            RelationalDesign rd = stoDes.getPhysicalDesign();
            String parentoid = rd.getRepositoryOID();
            String parentovid = rd.getRepositoryOVID();
            String siteID = stoDes.getRDBMSSite().getObjectID();
            ArrayList<ObjectDescr> dparts = new ArrayList<ObjectDescr>();
            String tableName = OracleRepositoryManager.T_PACKAGE_MEMBERS;
            Connection conn = this.getRepositoryManager().getConnection();
            Statement stmt = null;
            ResultSet rset = null;
            try {
                TimeLog.log();
                System.out.println("Load from DB start " + System.currentTimeMillis());
                String user = this.getRepositoryManager().getUser();
                String query = "select m.type,p.name,m.oid,p.ovid,r.check_out_version,r.checkout_by,p.xml_content from " + tableName + " m, " + OracleRepositoryManager.T_PM_OBJECT_REGISTER + " r, " + OracleRepositoryManager.T_PHYSMODELS + " p where parent_OVID = '" + parentovid + "' and DB_SITE = '" + siteID + "' and m.oid = r.oid and p.ovid = r.last_version and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
                query = query + " union all select m.type,p.name,m.oid,p.ovid,r.check_out_version,r.checkout_by,p.xml_content from " + tableName + " m, " + OracleRepositoryManager.T_PM_OBJECT_REGISTER + " r, " + OracleRepositoryManager.T_PHYSMODELS + " p where parent_OVID = '" + parentovid + "'  and DB_SITE = '" + siteID + "' and m.oid = r.oid and p.ovid = r.check_out_version and r.check_out_version is not null and r.checkout_by = user";
                stmt = conn.createStatement();
                rset = stmt.executeQuery(query);
                ObjectDescr descr = null;
                stoDes.setLoading(true);
                if (!rset.next()) break block15;
                String dp_type = rset.getString(1);
                descr = new ObjectDescr();
                dparts.add(descr);
                descr.type = dp_type;
                descr.name = rset.getString(2);
                descr.oid = rset.getString(3);
                descr.ovid = rset.getString(4);
                String check_out_v = rset.getString(5);
                descr.checkOutBy = rset.getString(6);
                if (descr.checkOutBy == null) {
                    descr.checkOutBy = "";
                }
                BLOB blob = (BLOB)rset.getBlob(7);
                if (check_out_v != null) {
                    descr.checkedOut = true;
                }
                if (blob != null) {
                    try {
                        descr.xmldata = ReadManager.getString(blob);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Document doc = OracleRepositoryManager.getDocument(descr.xmldata);
                String sd_version = this.getAttributeForDesign(doc, "stdes_version");
                float version = 2.1f;
                if (sd_version != null && !"".equals(sd_version)) {
                    try {
                        version = Float.valueOf(sd_version).floatValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                stoDes.setLoadedVersion(version);
                List<String> co_list = new ArrayList();
                rset.close();
                stmt.close();
                stmt = null;
                rset = null;
                query = "select distinct m.type from " + OracleRepositoryManager.T_PHYSMODELS_MEMBERS + " m where parent_OVID = '" + descr.ovid + "'";
                stmt = conn.createStatement();
                rset = stmt.executeQuery(query);
                while (rset.next()) {
                    String type = rset.getString(1);
                    co_list.add(type);
                }
                co_list = stoDes.getOrderedTypes(co_list);
                this.count = 0;
                for (String type : co_list) {
                    this.readStorageObjects(stoDes, descr.ovid, type);
                }
                stoDes.setRepositoryOID(descr.oid);
                stoDes.setRepositoryOVID(descr.ovid);
                stoDes.createRepositoryMap();
            }
            finally {
                System.out.println("Load from DB end " + System.currentTimeMillis());
                TimeLog.log();
                System.out.println("phys objects " + this.count);
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                stoDes.setLoading(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDesignDoc(String ovid) throws SQLException {
        Document doc;
        block7: {
            String tableName = OracleRepositoryManager.T_PACKAGES;
            Connection conn = this.getRepositoryManager().getConnection();
            Statement stmt = null;
            ResultSet rset = null;
            String xmldata = null;
            doc = null;
            try {
                BLOB blob;
                String query = "select xml_content from " + tableName + " where ovid = '" + ovid + "'";
                stmt = conn.createStatement();
                rset = stmt.executeQuery(query);
                if (!rset.next() || (blob = (BLOB)rset.getBlob(1)) == null) break block7;
                try {
                    xmldata = ReadManager.getString(blob);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                doc = OracleRepositoryManager.getDocument(xmldata);
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readDLSettings(Design design) throws SQLException {
        boolean result = false;
        String design_ovid = design.getRepositoryOVID();
        if (design_ovid != null) {
            Connection conn = this.getRepositoryManager().getConnection();
            Statement stmt = null;
            ResultSet rset = null;
            try {
                BLOB blob;
                String tableName = OracleRepositoryManager.T_DL_SETTINGS;
                String query = "select xml_content from " + tableName + " where Design_ovid = '" + design_ovid + "'";
                stmt = conn.createStatement();
                rset = stmt.executeQuery(query);
                if (rset.next() && (blob = (BLOB)rset.getBlob(1)) != null) {
                    try {
                        String settings = ReadManager.getString(blob);
                        result = true;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        return result;
    }

    class ObjectDescr {
        String type;
        String name;
        String oid;
        String ovid;
        String xmldata;
        String checkOutBy;
        boolean checkedOut = false;
        DataFlowDesign dfd;
        BLOB blob;

        ObjectDescr() {
        }
    }
}

