/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.AbstractLevelDomains;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.ObjectTypes;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.RepDeleteDescr;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.db.oracle.AbstractDBWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.DB_COntainerObjWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.DB_ConnectorObjWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.DB_DomainObjWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.DB_LogicalTypesObjWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.DB_PhysObjWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.DB_RDBMSSitesObjWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.DB_XMappingWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.OracleRepositoryManager;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.TimeLog;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.BLOB;

public class WriteManager {
    private OracleRepositoryManager repositoryManager;
    private Map writers = new TreeMap();
    private DB_COntainerObjWriter coWriter;
    private DB_ConnectorObjWriter connectorWriter;
    private DB_DomainObjWriter dmWriter;
    private DB_LogicalTypesObjWriter ldtWriter;
    private DB_RDBMSSitesObjWriter rdbmsWriter;
    private List rollbackList = new ArrayList();
    private List dirtyList = new ArrayList();
    private DB_XMappingWriter xmappingWriter;
    private DB_PhysObjWriter physObjWriter;

    public WriteManager(OracleRepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
        this.initWriters();
    }

    private void initWriters() {
        this.coWriter = new DB_COntainerObjWriter(this.repositoryManager);
        this.connectorWriter = new DB_ConnectorObjWriter(this.repositoryManager);
        this.dmWriter = new DB_DomainObjWriter(this.repositoryManager);
        this.ldtWriter = new DB_LogicalTypesObjWriter(this.repositoryManager);
        this.xmappingWriter = new DB_XMappingWriter(this.repositoryManager);
        this.physObjWriter = new DB_PhysObjWriter(this.repositoryManager);
        this.rdbmsWriter = new DB_RDBMSSitesObjWriter(this.repositoryManager);
    }

    public OracleRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void writeDesignPart(DesignPart designPart) {
        boolean error = false;
        try {
            boolean newdp = false;
            if (designPart.getRepositoryOID() == null) {
                this.writePackageRecord(designPart.getObjectTypeName(), designPart);
                newdp = true;
            }
            List list = (List)designPart.getStorableDesignObjects();
            list = this.getObjectsToStore(list, newdp);
            List newObjects = this.getNewObjects(list);
            if (list.size() > 0) {
                this.writeObjects(list, designPart);
                this.writePackageMembers(designPart.getRepositoryOID(), designPart.getRepositoryOVID(), newObjects);
            }
            this.writeSubviews(designPart, newdp);
            if (!newdp && designPart.isCheckedOutByMe() && designPart.isDirty()) {
                this.updatePackageRecord(designPart.getObjectTypeName(), designPart);
            }
            if (designPart.isCheckedOutByMe()) {
                this.removeDeleted(designPart.getObjectsToDeleteFromRepository(), designPart.getRepositoryOVID(), false);
            }
            designPart.createRepositoryMap();
            if (designPart instanceof RelationalDesign) {
                this.writePhysicalModels((RelationalDesign)designPart);
            }
        }
        catch (SQLException e) {
            error = true;
        }
        catch (RuntimeException r) {
            error = true;
        }
        if (!error) {
            designPart.setDirty(false);
        }
    }

    public void writePhysicalModels(RelationalDesign rd) throws SQLException {
        StorageDesign[] stdes = rd.getStorageDesignFactory().getOpenStorageDesigns();
        ArrayList<StorageDesign> list = new ArrayList<StorageDesign>();
        for (int i = 0; i < stdes.length; ++i) {
            if (!stdes[i].isOpen()) continue;
            this.writePhysicalModel(stdes[i]);
            list.add(stdes[i]);
        }
        if (list.size() > 0) {
            this.writePackageMembers(rd.getRepositoryOID(), rd.getRepositoryOVID(), list);
        }
    }

    public void writePhysicalModel(StorageDesign stoDesign) {
        TimeLog.log();
        System.out.println("Save SD to DB start " + System.currentTimeMillis());
        boolean error = false;
        try {
            boolean newdp = false;
            if (stoDesign.getRepositoryOID() == null) {
                this.writePhysModelRecord(stoDesign);
                newdp = true;
            }
            List list = stoDesign.getStorableObjects();
            list = this.getObjectsToStore(list, newdp);
            List newObjects = this.getNewObjects(list);
            if (list.size() > 0) {
                this.writeObjects(list, "");
                this.writePackageMembers(stoDesign.getRepositoryOID(), stoDesign.getRepositoryOVID(), newObjects);
            }
            if (!newdp && stoDesign.isCheckedOutByMe() && stoDesign.isDirty()) {
                this.updatePackageRecord(stoDesign.getObjectTypeName(), stoDesign);
            }
            this.removeDeleted(stoDesign.getObjectsToDeleteFromRepository(), stoDesign.getRepositoryOVID(), true);
            stoDesign.createRepositoryMap();
        }
        catch (SQLException e) {
            error = true;
        }
        catch (RuntimeException r) {
            error = true;
        }
        if (!error) {
            stoDesign.setDirty(false);
        }
        TimeLog.log();
        System.out.println("Save SD to DB end " + System.currentTimeMillis());
    }

    public void writeDomains(AbstractLevelDomains alDomains) {
        boolean error = false;
        try {
            List list = alDomains.getDomains();
            list = this.getPackageMembersToStore(list);
            List newObjects = this.getNewObjects(list);
            if (list.size() > 0) {
                this.writeObjects(list, "");
                this.writePackageMembers(alDomains.getRepositoryOID(), alDomains.getRepositoryOVID(), newObjects);
            }
            this.removeDeleted(alDomains.getObjectsToDeleteFromRepository(), alDomains.getRepositoryOVID(), false);
            alDomains.createRepositoryMap();
        }
        catch (SQLException e) {
            error = true;
        }
        catch (RuntimeException r) {
            error = true;
        }
        if (!error) {
            alDomains.setDirty(false);
        }
    }

    private List getObjectsToStore(List list, boolean newParent) {
        ArrayList<RepositoryObject> result = new ArrayList<RepositoryObject>();
        for (RepositoryObject object : list) {
            if (AbstractRepositoryManager.INITIAL_WRITE_TODB || newParent) {
                result.add(object);
                continue;
            }
            if (object.getRepositoryOID() == null) {
                if (object instanceof DesignObject) {
                    if (!((DesignObject)object).getDesignPart().isCheckedOutByMe()) continue;
                    result.add(object);
                    continue;
                }
                if (!(object instanceof StorageObject)) continue;
                result.add(object);
                continue;
            }
            if (!object.isDirty() || !object.isCheckedOutByMe()) continue;
            result.add(object);
        }
        return result;
    }

    private List getPackageMembersToStore(List list) {
        ArrayList<ModelIDObject> result = new ArrayList<ModelIDObject>();
        for (ModelIDObject object : list) {
            if (AbstractRepositoryManager.INITIAL_WRITE_TODB) {
                result.add(object);
                continue;
            }
            if (object.getRepositoryOID() == null) {
                result.add(object);
                continue;
            }
            if (!object.isDirty() || !object.isCheckedOutByMe()) continue;
            result.add(object);
        }
        return result;
    }

    private List getNewObjects(List list) {
        ArrayList<RepositoryObject> result = new ArrayList<RepositoryObject>();
        for (RepositoryObject object : list) {
            if (object.getRepositoryOID() != null) continue;
            result.add(object);
        }
        return result;
    }

    public void writeXMap(ExtendedMap xmap) {
        boolean error = false;
        try {
            boolean newdp = false;
            if (xmap.getRepositoryOID() == null) {
                this.writeXMapPackageRecord(xmap);
                newdp = true;
            }
            List list = xmap.getAllMappings();
            list = this.getObjectsToStore(list, newdp);
            List newObjects = this.getNewObjects(list);
            if (list.size() > 0) {
                this.writeObjects(list, ObjectTypes.XMAPPING);
                this.writePackageMembers(xmap.getRepositoryOID(), xmap.getRepositoryOVID(), newObjects);
            }
        }
        catch (SQLException e) {
            error = true;
        }
        catch (RuntimeException r) {
            error = true;
        }
        if (!error) {
            // empty if block
        }
    }

    public void writeObject(RepositoryObject object) {
        if (object instanceof Design) {
            if (object.getRepositoryOID() == null) {
                throw new RuntimeException("Design should be saved using writeDesign(Design design) of OracleRepositoryManager");
            }
            this.getRepositoryManager().writeDesign((Design)object);
            object.setDirty(false);
            return;
        }
        if (object instanceof DesignPartView || object instanceof DesignPart) {
            String type = this.getRepositoryManager().getObjectType(object);
            if (object.getRepositoryOID() == null) {
                DesignPart dp;
                if (object instanceof DesignPartView) {
                    if (((DesignPartView)object).getDesignPart().isCheckedOutByMe()) {
                        try {
                            this.writePackageRecord(type, object);
                            object.setDirty(false);
                        }
                        catch (SQLException sQLException) {}
                    }
                } else if (object instanceof DesignPart && (dp = (DesignPart)object).getDesign().isCheckedOutByMe()) {
                    this.writeDesignPart(dp);
                }
            } else if (object instanceof DesignPart) {
                DesignPart dp = (DesignPart)object;
                this.writeDesignPart(dp);
            } else if (object.isCheckedOutByMe() && object.isDirty()) {
                try {
                    this.updatePackageRecord(type, object);
                    object.setDirty(false);
                }
                catch (SQLException sQLException) {}
            }
        } else if (object instanceof RDBMSSiteSet || object instanceof LogicalDatatypeSet) {
            String type = this.getRepositoryManager().getObjectType(object);
            if (object.getRepositoryOID() == null) {
                if (object.isCheckedOutByMe()) {
                    try {
                        this.writePackageRecord(type, object);
                        object.setDirty(false);
                    }
                    catch (SQLException sQLException) {}
                }
            } else if (object.isCheckedOutByMe() && object.isDirty()) {
                try {
                    this.updatePackageRecord(type, object);
                    object.setDirty(false);
                }
                catch (SQLException sQLException) {}
            }
        } else if (object instanceof StorageDesign) {
            this.writePhysicalModel((StorageDesign)object);
        } else {
            AbstractDBWriter wr = this.getWriterFor(object);
            if (wr != null) {
                wr.writeObject(object);
            }
        }
    }

    private void writeTransformationPackage(TransformationPackage object) throws SQLException {
        boolean newdp = false;
        if (object.getRepositoryOID() == null) {
            this.writePackageRecord(object.getObjectTypeName(), object);
            newdp = true;
        }
        Iterator it = object.getTransformationTaskSet().iterator();
        ArrayList<DesignPart> newObjects = new ArrayList<DesignPart>();
        while (it.hasNext()) {
            DesignPart dp = (DesignPart)it.next();
            if (dp.getRepositoryOID() == null) {
                newObjects.add(dp);
            }
            this.writeDesignPart(dp);
        }
        if (newObjects.size() > 0) {
            this.writePackageMembers(object.getRepositoryOID(), object.getRepositoryOVID(), newObjects);
        }
        if (!newdp && object.isCheckedOutByMe() && object.isDirty()) {
            this.updatePackageRecord(object.getObjectTypeName(), object);
        }
    }

    public void writeObjects(List objects, String type) throws SQLException {
        if (objects.size() > 0) {
            Object object = objects.get(0);
            if (object instanceof TransformationPackage) {
                this.writeTransformationPackage((TransformationPackage)object);
            } else {
                AbstractDBWriter wr = this.getWriterFor(object);
                if (wr != null) {
                    wr.writeObjects(objects);
                }
            }
        }
    }

    public void writeObjects(List objects, DesignPart dp) throws SQLException {
        List list;
        String type;
        TreeMap<String, ArrayList<ModelIDObject>> map = new TreeMap<String, ArrayList<ModelIDObject>>();
        for (ModelIDObject object : objects) {
            String type2 = this.getRepositoryManager().getObjectType(object);
            ArrayList<ModelIDObject> list2 = (ArrayList<ModelIDObject>)map.get(type2);
            if (list2 == null) {
                list2 = new ArrayList<ModelIDObject>();
                map.put(type2, list2);
            }
            list2.add(object);
        }
        Iterator it = dp.getTypeOrder().iterator();
        while (it.hasNext()) {
            type = (String)it.next();
            list = (List)map.get(type);
            if (list == null || list.size() <= 0) continue;
            this.writeObjects(list, type);
            map.remove(type);
        }
        while (it.hasNext()) {
            type = (String)it.next();
            list = (List)map.get(type);
            if (list == null || list.size() <= 0) continue;
            this.writeObjects(list, type);
            map.remove(type);
        }
    }

    private AbstractDBWriter getWriterFor(Object object) {
        DB_COntainerObjWriter writer;
        String type = ObjectTypes.getObjectType(object);
        if (!ObjectTypes.UNKNOWN.equals(type) && (writer = (DB_COntainerObjWriter)this.writers.get(type)) == null) {
            if (object instanceof ContainerObject || object instanceof StructuredType || object instanceof CollectionType || object instanceof DistinctType || object instanceof FactEntitiesJoin || (object instanceof AbstractMDObject || object instanceof AbstractProcessObject) && !(object instanceof ConnectionInterface) || object instanceof BIEmail || object instanceof BILocation || object instanceof BIPhone || object instanceof BIResourceLocator || object instanceof BIContact || object instanceof BIResponsibleParty || object instanceof BIDocument || object instanceof Note || object instanceof ChangeRequest) {
                return this.coWriter;
            }
            if (object instanceof LogicalDatatypeSet) {
                return this.ldtWriter;
            }
            if (object instanceof RDBMSSiteSet) {
                return this.rdbmsWriter;
            }
            if (object instanceof Domain) {
                return this.dmWriter;
            }
            if (object instanceof ConnectionInterface) {
                return this.connectorWriter;
            }
            if (object instanceof XtdMapping) {
                return this.xmappingWriter;
            }
            if (object instanceof StorageObject) {
                return this.physObjWriter;
            }
        }
        return null;
    }

    public void writePackageRecord(String type, RepositoryObject object) throws SQLException {
        String xmlData = this.getRepositoryManager().getXML(object);
        String name = "null";
        try (OraclePreparedStatement stmt = null;){
            String query;
            String ovid;
            boolean newobj = false;
            name = object.getName();
            Connection conn = this.getRepositoryManager().getConnection();
            String tableName = OracleRepositoryManager.T_PACKAGES;
            String oid = object.getRepositoryOID();
            if (oid == null) {
                oid = new GUID().toString();
                newobj = true;
            }
            if ((ovid = object.getRepositoryOVID()) == null) {
                ovid = new GUID().toString();
            }
            if (object instanceof Design) {
                String desc = ((Design)object).getComment();
                query = "insert into " + tableName + " ( name,type, OID, OVID, created_by,date_created,short_description,v_sequence,xml_content) values ('" + name + "' ,'" + type + "','" + oid + "', '" + ovid + "', user, sysdate,'" + desc + "',1,? )";
            } else {
                query = "insert into " + tableName + " ( name,type, OID, OVID, created_by,date_created,v_sequence,xml_content) values ('" + name + "' ,'" + type + "','" + oid + "', '" + ovid + "', user, sysdate,1,? )";
            }
            stmt = (OraclePreparedStatement)conn.prepareStatement(query);
            BLOB blob = AbstractDBWriter.getBLOB(xmlData, conn);
            stmt.setObject(1, (Object)blob);
            int res = stmt.executeUpdate();
            if (res == 1) {
                this.assignRepositoryIDs(object, oid, ovid);
                boolean physical = object instanceof StorageObject;
                WriteManager.registerObject(oid, ovid, conn, physical);
                if (newobj && object instanceof DesignPartView) {
                    object.setCheckedOut(false);
                    object.setCheckedOutByMe(false);
                }
                this.clearDirtyFlag(object);
            }
        }
    }

    public void writePhysModelRecord(StorageDesign object) throws SQLException {
        String xmlData = this.getRepositoryManager().getXML(object);
        String name = "null";
        try (OraclePreparedStatement stmt = null;){
            String ovid;
            boolean newobj = false;
            name = object.getName();
            Connection conn = this.getRepositoryManager().getConnection();
            String tableName = OracleRepositoryManager.T_PHYSMODELS;
            String oid = object.getRepositoryOID();
            if (oid == null) {
                oid = new GUID().toString();
                newobj = true;
            }
            if ((ovid = object.getRepositoryOVID()) == null) {
                ovid = new GUID().toString();
            }
            String relID = object.getPhysicalDesign().getRepositoryOID();
            String siteID = object.getRDBMSSite().getObjectID();
            String dbType = String.valueOf(object.getRDBMSSite().getType().getType());
            String query = "insert into " + tableName + " ( name, Reational_Model, DB_Site, DB_Type, OID, OVID, created_by,date_created,v_sequence,xml_content) values ('" + name + "' ,'" + relID + "','" + siteID + "','" + dbType + "','" + oid + "', '" + ovid + "', user, sysdate,1,? )";
            stmt = (OraclePreparedStatement)conn.prepareStatement(query);
            BLOB blob = AbstractDBWriter.getBLOB(xmlData, conn);
            stmt.setObject(1, (Object)blob);
            int res = stmt.executeUpdate();
            if (res == 1) {
                this.assignRepositoryIDs(object, oid, ovid);
                WriteManager.registerObject(oid, ovid, conn, true);
                this.clearDirtyFlag(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeXMapPackageRecord(ExtendedMap xmap) throws SQLException {
        Object xmlData = null;
        String name = "ExtendedMap";
        try (OraclePreparedStatement stmt = null;){
            String ovid;
            boolean newobj = false;
            Connection conn = this.getRepositoryManager().getConnection();
            String tableName = OracleRepositoryManager.T_PACKAGES;
            String oid = xmap.getRepositoryOID();
            if (oid == null) {
                oid = new GUID().toString();
                newobj = true;
            }
            if ((ovid = xmap.getRepositoryOVID()) == null) {
                ovid = new GUID().toString();
            }
            String query = "insert into " + tableName + " ( name,type, OID, OVID, created_by,date_created,v_sequence,xml_content) values ('" + name + "' ,'" + xmap.getName() + "','" + oid + "', '" + ovid + "', user, sysdate,1,? )";
            stmt = (OraclePreparedStatement)conn.prepareStatement(query);
            Object blob = null;
            stmt.setObject(1, blob);
            int res = stmt.executeUpdate();
            if (res == 1) {
                if (xmap.getRepositoryOID() == null) {
                    xmap.setRepositoryOID(oid);
                    xmap.setRepositoryOVID(ovid);
                }
                WriteManager.registerObject(oid, ovid, conn, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePackageRecord(String type, RepositoryObject object) throws SQLException {
        String xmlData = this.getRepositoryManager().getXML(object);
        String name = "null";
        try (OraclePreparedStatement stmt = null;){
            String ovid;
            String oid;
            name = object.getName();
            Connection conn = this.getRepositoryManager().getConnection();
            String tableName = OracleRepositoryManager.T_PACKAGES;
            if (object instanceof StorageDesign) {
                tableName = OracleRepositoryManager.T_PHYSMODELS;
            }
            if ((oid = object.getRepositoryOID()) == null) {
                oid = new GUID().toString();
            }
            if ((ovid = object.getRepositoryOVID()) == null) {
                ovid = new GUID().toString();
            }
            String query = "update " + tableName + " set name = ?, changed_by = user, date_changed = sysdate, xml_content = ?  where ovid = ?";
            stmt = (OraclePreparedStatement)conn.prepareStatement(query);
            BLOB blob = AbstractDBWriter.getBLOB(xmlData, conn);
            stmt.setString(1, name);
            stmt.setObject(2, (Object)blob);
            stmt.setString(3, ovid);
            int res = stmt.executeUpdate();
            if (res > 0) {
                object.setDirty(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePackageRecords(String type, List objects) throws SQLException {
        String name = "null";
        try (Statement stmt = null;){
            for (RepositoryObject object : objects) {
                String ovid;
                String xmlData = this.getRepositoryManager().getXML(object);
                name = object.getName();
                Connection conn = this.getRepositoryManager().getConnection();
                String tableName = OracleRepositoryManager.T_PACKAGES;
                String oid = object.getRepositoryOID();
                if (oid == null) {
                    oid = new GUID().toString();
                }
                if ((ovid = object.getRepositoryOVID()) == null) {
                    ovid = new GUID().toString();
                }
                if (stmt == null) {
                    String query = "update " + tableName + " set name = ?, changed_by = user, date_changed = sysdate, xml_content = ?  where ovid = ?";
                    stmt = conn.prepareStatement(query);
                }
                BLOB blob = AbstractDBWriter.getBLOB(xmlData, conn);
                stmt.setString(1, name);
                stmt.setObject(2, blob);
                stmt.setString(3, ovid);
                int res = stmt.executeUpdate();
                if (res <= 0) continue;
                object.setDirty(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePackageRecords(String type, List objects) throws SQLException {
        String name = "null";
        try (Statement stmt = null;){
            for (RepositoryObject object : objects) {
                String ovid;
                String xmlData = this.getRepositoryManager().getXML(object);
                name = object.getName();
                Connection conn = this.getRepositoryManager().getConnection();
                String tableName = OracleRepositoryManager.T_PACKAGES;
                String oid = object.getRepositoryOID();
                if (oid == null) {
                    oid = new GUID().toString();
                }
                if ((ovid = object.getRepositoryOVID()) == null) {
                    ovid = new GUID().toString();
                }
                if (stmt == null) {
                    String query = "insert into " + tableName + " ( name,type, OID, OVID, created_by,date_created,v_sequence,xml_content) values (? ,'" + type + "',?, ?, user, sysdate,1,? )";
                    stmt = conn.prepareStatement(query);
                }
                BLOB blob = AbstractDBWriter.getBLOB(xmlData, conn);
                stmt.setString(1, name);
                stmt.setString(2, oid);
                stmt.setString(3, ovid);
                stmt.setObject(4, blob);
                int res = stmt.executeUpdate();
                if (res != 1) continue;
                this.assignRepositoryIDs(object, oid, ovid);
                WriteManager.registerObject(oid, ovid, conn, false);
                this.clearDirtyFlag(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePackageMembers(String parentOID, String parentOVID, List objects) throws SQLException {
        if (objects.size() > 0) {
            Connection conn = this.getRepositoryManager().getConnection();
            try (Statement stmt = null;){
                Object object = objects.get(0);
                String tableName = OracleRepositoryManager.T_PACKAGE_MEMBERS;
                if (object instanceof StorageObject) {
                    tableName = OracleRepositoryManager.T_PHYSMODELS_MEMBERS;
                }
                String query = "insert into " + tableName + " ( type, OID, created_by,date_created,OWNERSHIP_FLAG,parent_oid,parent_ovid) values (?,?,user, sysdate,'Y','" + parentOID + "','" + parentOVID + "' )";
                stmt = (OraclePreparedStatement)conn.prepareStatement(query);
                for (RepositoryObject cob : objects) {
                    String oid = cob.getRepositoryOID();
                    String ovid = cob.getRepositoryOVID();
                    if (oid == null || ovid == null) {
                        throw new RuntimeException("Object " + cob.getName() + "should be saved before added to package");
                    }
                    stmt.setString(1, this.getRepositoryManager().getObjectType(cob));
                    stmt.setString(2, oid);
                    int res = stmt.executeUpdate();
                    if (res != 1) continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerObject(String oid, String ovid, Connection conn, boolean physical) throws SQLException {
        Statement regstmt = null;
        String registerName = OracleRepositoryManager.T_OBJECT_REGISTER;
        if (physical) {
            registerName = OracleRepositoryManager.T_PM_OBJECT_REGISTER;
        }
        try {
            String query = "insert into " + registerName + " (oid,last_version) values('" + oid + "','" + ovid + "')";
            regstmt = conn.createStatement();
            regstmt.executeUpdate(query);
        }
        finally {
            if (regstmt != null) {
                regstmt.close();
            }
        }
    }

    public static void registerObject(String oid, String ovid, PreparedStatement regstmt) throws SQLException {
        regstmt.setString(1, oid);
        regstmt.setString(2, ovid);
        regstmt.executeUpdate();
    }

    public static PreparedStatement prepareRegisterStatement(Connection conn, boolean physical) throws SQLException {
        PreparedStatement regstmt = null;
        String registerName = OracleRepositoryManager.T_OBJECT_REGISTER;
        if (physical) {
            registerName = OracleRepositoryManager.T_PM_OBJECT_REGISTER;
        }
        String query = "insert into " + registerName + " (oid,last_version) values(?,?)";
        regstmt = conn.prepareStatement(query);
        return regstmt;
    }

    private void writeSubviews(DesignPart dp, boolean newDP) {
        ArrayList<DesignPartView> newObjects = new ArrayList<DesignPartView>();
        ArrayList<DesignPartView> updObjects = new ArrayList<DesignPartView>();
        DesignPartView dpv = dp.getMainView();
        String oid = null;
        if (dpv != null) {
            oid = dpv.getRepositoryOID();
        }
        try {
            if (dpv != null && dpv.isStorable() && (oid == null || AbstractRepositoryManager.INITIAL_WRITE_TODB)) {
                if (dp.isCheckedOutByMe() || AbstractRepositoryManager.INITIAL_WRITE_TODB || newDP) {
                    this.writePackageRecord("MainView", dpv);
                    newObjects.add(dpv);
                    this.writePackageMembers(dp.getRepositoryOID(), dp.getRepositoryOVID(), newObjects);
                    newObjects.clear();
                }
            } else if (dpv != null && dpv.isStorable() && dpv.isCheckedOutByMe() && dpv.isDirty()) {
                this.updatePackageRecord("MainView", dpv);
            }
            Iterator it = dp.getDesignSubviews().iterator();
            while (it.hasNext()) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
                dpv = ph.getDesignPartView();
                if (!dpv.isStorable()) continue;
                oid = dpv.getRepositoryOID();
                if (oid == null || AbstractRepositoryManager.INITIAL_WRITE_TODB) {
                    if (!dp.isCheckedOutByMe() && !AbstractRepositoryManager.INITIAL_WRITE_TODB && !newDP) continue;
                    newObjects.add(dpv);
                    continue;
                }
                if (!dpv.isCheckedOutByMe() || !ph.isDirty()) continue;
                updObjects.add(dpv);
            }
            if (newObjects.size() > 0) {
                this.writePackageRecords("SubView", newObjects);
                this.writePackageMembers(dp.getRepositoryOID(), dp.getRepositoryOVID(), newObjects);
            }
            if (updObjects.size() > 0) {
                this.updatePackageRecords("SubView", updObjects);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void writeRepSet(RepositoryObject rp) {
        String oid = rp.getRepositoryOID();
        try {
            if (oid == null || AbstractRepositoryManager.INITIAL_WRITE_TODB) {
                if (rp.isCheckedOutByMe() || AbstractRepositoryManager.INITIAL_WRITE_TODB) {
                    this.writePackageRecord(rp.getName(), rp);
                }
            } else if (rp.isCheckedOutByMe() && rp.isDirty()) {
                this.updatePackageRecord(rp.getName(), rp);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDeleted(List list, String parentOVID, boolean storageObjects) throws SQLException {
        int res = 0;
        if (list.size() > 0 && parentOVID != null) {
            try (Statement stmt = null;){
                Connection conn = this.getRepositoryManager().getConnection();
                String tableName = OracleRepositoryManager.T_PACKAGE_MEMBERS;
                if (storageObjects) {
                    tableName = OracleRepositoryManager.T_PHYSMODELS_MEMBERS;
                }
                Object inlist = "(";
                boolean first = true;
                for (RepDeleteDescr descr : list) {
                    if (first) {
                        first = false;
                        inlist = (String)inlist + "'" + descr.repOID + "'";
                        continue;
                    }
                    inlist = (String)inlist + ",'" + descr.repOID + "'";
                }
                inlist = (String)inlist + ")";
                String query = "delete from " + tableName + " where parent_ovid = '" + parentOVID + "' and oid in " + (String)inlist;
                stmt = conn.createStatement();
                res = stmt.executeUpdate(query);
            }
        }
    }

    public void assignRepositoryIDs(RepositoryObject object, String oid, String ovid) {
        if (object.getRepositoryOID() == null) {
            object.setRepositoryOID(oid);
            object.setRepositoryOVID(ovid);
            this.rollbackList.add(object);
        }
    }

    public void rollbackIDs() {
        for (RepositoryObject object : this.rollbackList) {
            object.setRepositoryOID(null);
            object.setRepositoryOVID(null);
        }
        this.rollbackList.clear();
    }

    public void clearDirtyFlag(RepositoryObject object) {
        if (object.isDirty()) {
            object.setDirty(false);
            this.dirtyList.add(object);
        }
    }

    public void rollbackDirtyFlag() {
        for (RepositoryObject object : this.dirtyList) {
            object.setDirty(true);
        }
        this.dirtyList.clear();
    }

    public List writeChangeRequests(Design design) throws SQLException {
        List newObjects = new ArrayList();
        List list = new ArrayList();
        design.getChangeRequestSet().addAllElementsTo(list);
        list = this.getObjectsToStore(list, false);
        newObjects = this.getNewObjects(list);
        this.writeObjects(list, "ChangeRequest");
        return newObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDLSettingsRecord(Design object, String settings) throws SQLException {
        String xmlData = settings;
        try (OraclePreparedStatement stmt = null;){
            Connection conn = this.getRepositoryManager().getConnection();
            String tableName = OracleRepositoryManager.T_DL_SETTINGS;
            String oid = object.getRepositoryOID();
            if (oid != null) {
                String ovid = object.getRepositoryOVID();
                String query = "update " + tableName + " set changed_by = user, date_changed = sysdate, xml_content = ?  where Design_ovid = ?";
                stmt = (OraclePreparedStatement)conn.prepareStatement(query);
                BLOB blob = AbstractDBWriter.getBLOB(xmlData, conn);
                stmt.setObject(1, (Object)blob);
                stmt.setString(2, ovid);
                int res = stmt.executeUpdate();
                if (res > 0) {
                    // empty if block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createDLSettingsRecord(Design object, String settings) throws SQLException {
        String xmlData = settings;
        try (OraclePreparedStatement stmt = null;){
            Connection conn = this.getRepositoryManager().getConnection();
            String tableName = OracleRepositoryManager.T_DL_SETTINGS;
            String oid = object.getRepositoryOID();
            if (oid != null) {
                String ovid = object.getRepositoryOVID();
                String query = "insert into " + tableName + " (type, Design_OID, Design_OVID,created_by,date_created,v_sequence,xml_content)  values('Design','" + oid + "', '" + ovid + "', user, sysdate,1,? )";
                stmt = (OraclePreparedStatement)conn.prepareStatement(query);
                BLOB blob = AbstractDBWriter.getBLOB(xmlData, conn);
                stmt.setObject(1, (Object)blob);
                int res = stmt.executeUpdate();
                if (res > 0) {
                    // empty if block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsDLSettings(String design_ovid) throws SQLException {
        Connection conn = this.getRepositoryManager().getConnection();
        Statement stmt = null;
        ResultSet rset = null;
        boolean result = false;
        try {
            String tableName = OracleRepositoryManager.T_DL_SETTINGS;
            String query = "select 1 from " + tableName + " where Design_ovid = '" + design_ovid + "'";
            stmt = conn.createStatement();
            rset = stmt.executeQuery(query);
            if (rset.next()) {
                rset.getString(1);
                result = true;
            }
        }
        finally {
            if (rset != null) {
                rset.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return result;
    }

    public void writeDLSettings(Design design, String settings) {
        String ovid = design.getRepositoryOVID();
        try {
            if (ovid != null) {
                if (this.existsDLSettings(ovid)) {
                    this.updateDLSettingsRecord(design, settings);
                } else {
                    this.createDLSettingsRecord(design, settings);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

