/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLEntity
extends AbstractWXMLDesignObject {
    private Entity entity = null;

    public WXMLEntity(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof Entity;
        if (result) {
            this.entity = (Entity)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.entity != null) {
            String designName = this.entity.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("logical").append('/');
        }
        buffer.append(this.getConfiguration().get("entityPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof Entity) {
            String source;
            String owner;
            String dsynonym;
            String shortName;
            String abbr;
            Entity ent = (Entity)object;
            objectInfoNode.setAttribute("entitytype", ent.getTypeID());
            String scope = ent.getScope();
            if (scope != null && !"".equalsIgnoreCase(scope)) {
                objectInfoNode.setAttribute("scope", StringUtilities.encodeAttributeValue(scope));
            }
            if (ent.getBasedOnStructuredType() != null) {
                objectInfoNode.setAttribute("structuredType", StringUtilities.encodeAttributeValue(ent.getBasedOnStructuredType().getObjectID()));
            }
            if ((abbr = ent.getPreferredAbbreviation()) != null && !"".equalsIgnoreCase(abbr)) {
                objectInfoNode.setAttribute("pref_abbreviation", StringUtilities.encodeAttributeValue(abbr));
            }
            if ((shortName = ent.getShortName()) != null && !"".equalsIgnoreCase(shortName)) {
                objectInfoNode.setAttribute("short_name", StringUtilities.encodeAttributeValue(shortName));
            }
            objectInfoNode.setAttribute("allow_type_substitution", String.valueOf(ent.isAllowTypeSubstitution()));
            objectInfoNode.setAttribute("strategy", ent.getFwdEngineeringStrategyName());
            String synonym = ent.getSynonym();
            if (synonym != null && !"".equalsIgnoreCase(synonym)) {
                objectInfoNode.setAttribute("synonym", StringUtilities.encodeAttributeValue(synonym));
            }
            if ((dsynonym = ent.getSynonymToDisplay()) != null && !"".equalsIgnoreCase(dsynonym)) {
                objectInfoNode.setAttribute("synonym_to_display", StringUtilities.encodeAttributeValue(dsynonym));
            }
            if ((owner = ent.getOwner()) != null && !"".equalsIgnoreCase(owner)) {
                objectInfoNode.setAttribute("owner", StringUtilities.encodeAttributeValue(owner));
            }
            if ((source = ent.getSource()) != null && !"".equalsIgnoreCase(source)) {
                objectInfoNode.setAttribute("entsource", StringUtilities.encodeAttributeValue(source));
            }
            Element hierarchyElm = this.createElement(objectInfoNode, "parent");
            objectInfoNode.appendChild(hierarchyElm);
            if (ent.hasHierarchicalParent()) {
                hierarchyElm.setAttribute("inherits", VALUE_TRUE);
                hierarchyElm.setAttribute("id", StringUtilities.encodeAttributeValue(ent.getHierarchicalParent().getObjectID()));
            } else {
                hierarchyElm.setAttribute("inherits", VALUE_FALSE);
            }
            objectInfoNode.setAttribute("minVolumes", new Integer(ent.getMinVolumes()).toString());
            objectInfoNode.setAttribute("expectedVolumes", new Integer(ent.getExpectedVolumes()).toString());
            objectInfoNode.setAttribute("maxVolumes", new Integer(ent.getMaxVolumes()).toString());
            objectInfoNode.setAttribute("growthPercent", new Integer(ent.getGrowthPercent()).toString());
            objectInfoNode.setAttribute("growthType", ent.getGrowthType());
            objectInfoNode.setAttribute("normalForm", ent.getNormalForm());
            objectInfoNode.setAttribute("adequatelyNormalized", ent.getAdequatelyNormalized());
        }
    }

    @Override
    protected void appendContainedObjectInfo(Element parentNode, ContainedObject object) {
        Attribute attribute = (Attribute)object;
        this.appendDataTypeInfo(parentNode, attribute);
        this.appendReferenceInfo(parentNode, attribute.isReference());
        this.appendLogicalTypeInfo(parentNode, attribute.getLogicalDatatype());
        this.appendUseDomainInfo(parentNode, attribute.getUse());
        this.appendSourceTypeInfo(parentNode, attribute.getSourceType());
        this.appendFormulaDescInfo(parentNode, attribute.getFormulaDesc());
        this.appendSubtypeSubstitutionInfo(parentNode, attribute.isAllowSubtypeSubstitution());
        this.appendRestrictedSubstitutionInfo(parentNode, attribute);
        this.appendScopeInfo(parentNode, attribute);
        this.appendPreferredAbbreviationInfo(parentNode, attribute.getPreferredAbbreviation());
        this.appendSource(parentNode, attribute.getSource());
    }

    protected void appendLogicalTypeInfo(Element parentNode, LogicalDatatype type) {
        if (type != null) {
            Element elm = parentNode.getOwnerDocument().createElement("logicaltype");
            elm.setAttribute("dttype", StringUtilities.encodeAttributeValue(type.getName()));
            elm.setAttribute("oid", StringUtilities.encodeAttributeValue(type.getObjectID()));
            parentNode.appendChild(elm);
        }
    }

    protected void appendUseDomainInfo(Element parentNode, short use) {
        Element elm = parentNode.getOwnerDocument().createElement("use");
        if (use == 0) {
            elm.setAttribute("value", "domain");
        } else if (use == 1) {
            elm.setAttribute("value", "logical type");
        } else if (use == 2) {
            elm.setAttribute("value", "distinct type");
        } else if (use == 3) {
            elm.setAttribute("value", "structured type");
        } else if (use == 4) {
            elm.setAttribute("value", "collection type");
        }
        parentNode.appendChild(elm);
    }

    private void appendSourceTypeInfo(Element parentNode, String sourceType) {
        Element elm = parentNode.getOwnerDocument().createElement("sourcetype");
        elm.setAttribute("sort", sourceType);
        parentNode.appendChild(elm);
    }

    private void appendFormulaDescInfo(Element parentNode, String formulaDesc) {
        Element elm = parentNode.getOwnerDocument().createElement("formula");
        elm.setAttribute("desc", StringUtilities.encodeAttributeValue(formulaDesc));
        parentNode.appendChild(elm);
    }

    private void appendPreferredAbbreviationInfo(Element parentNode, String abbreviation) {
        if (abbreviation != null && !"".equalsIgnoreCase(abbreviation)) {
            Element elm = parentNode.getOwnerDocument().createElement("pref_abbreviation");
            elm.setAttribute("abbreviation", StringUtilities.encodeAttributeValue(abbreviation));
            parentNode.appendChild(elm);
        }
    }

    private void appendSource(Element parentNode, String formulaDesc) {
        Element elm = parentNode.getOwnerDocument().createElement("source");
        elm.setAttribute("value", StringUtilities.encodeAttributeValue(formulaDesc));
        parentNode.appendChild(elm);
    }
}

