/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLSubview
extends AbstractXMLWriter {
    public WXMLSubview(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof DesignPartView;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append("subviews");
        }
        return buffer.toString();
    }

    @Override
    public String getRelativePath(Object object) {
        if (object instanceof DesignPartView) {
            DesignPartView dpv = (DesignPartView)object;
            DesignPart dp = dpv.getDesignPart();
            StringBuffer buffer = new StringBuffer();
            if (this.getPersistenceManager().getAppView() != null) {
                String designName = this.getPersistenceManager().getAppView().getDesignName();
                String dpid = dp.getObjectID();
                String dpPath = "";
                if (dp instanceof RelationalDesign) {
                    dpPath = "rel";
                    dpid = dp.getPathIDString();
                } else if (dp instanceof LogicalDesign) {
                    dpPath = "logical";
                } else if (dp instanceof DataTypesDesign) {
                    dpPath = "datatypes";
                }
                buffer.append(designName).append('/').append(dpPath);
                if (dp instanceof RelationalDesign) {
                    buffer.append('/').append(StringUtilities.encodeAttributeValue(dpid));
                }
                buffer.append('/').append("subviews");
            }
            return buffer.toString();
        }
        return this.getRelativePath();
    }

    @Override
    public String getFilenameFor(Object object) {
        if (object instanceof DesignPartView) {
            return ((DesignPartView)object).getDPVId();
        }
        return null;
    }

    @Override
    public Document writeDocument(Object object) {
        Document doc = this.createDocument();
        if (object instanceof DesignPartView) {
            DesignPartView dpv = (DesignPartView)object;
            Element docElement = doc.getDocumentElement();
            DesignPartViewPlaceHolder dpvPH = (DesignPartViewPlaceHolder)dpv.getPlaceHolder();
            this.appendSubView(docElement, dpvPH, dpv);
        }
        return doc;
    }

    public void appendExtSubViews(Element parentNode, DesignPart designPart) {
        Document doc = parentNode.getOwnerDocument();
        Element subviews = doc.createElement("ext_sub_views_collection");
        DesignPartViewPlaceHolder dph = designPart.getMainDPVPlaceHolder();
        if (!this.getPersistenceManager().isXML_FromDataBase() && dph != null) {
            boolean check = this.getPersistenceManager().isCheckDirty() ? dph.isDirty() : true;
            if (check) {
                DesignPartView dpv = dph.getDesignPartView();
                this.write(dpv);
                StringBuffer buffer = new StringBuffer();
                if (this.getPersistenceManager().getAppView() != null) {
                    buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
                }
                buffer.append(this.getRelativePath(dpv)).append('/').append(dpv.getDPVId()).append(".dmd");
                dph.setFilePath(buffer.toString());
                dph.setDirty(false);
                dpv.setDirty(false);
            }
        }
        this.appendSubViewElement(subviews, dph);
        Iterator it = designPart.getDesignSubviews().iterator();
        while (it.hasNext()) {
            dph = (DesignPartViewPlaceHolder)it.next();
            if (!this.getPersistenceManager().isXML_FromDataBase() && dph != null) {
                boolean check = this.getPersistenceManager().isCheckDirty() ? dph.isDirty() : true;
                if (check) {
                    DesignPartView dpv = dph.getDesignPartView();
                    this.write(dpv);
                    StringBuffer buffer = new StringBuffer();
                    if (this.getPersistenceManager().getAppView() != null) {
                        buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
                    }
                    buffer.append(this.getRelativePath(dpv)).append('/').append(dpv.getDPVId()).append(".dmd");
                    dph.setFilePath(buffer.toString());
                    dph.setDirty(false);
                    dpv.setDirty(false);
                }
            }
            this.appendSubViewElement(subviews, dph);
        }
        parentNode.appendChild(subviews);
    }

    protected Element appendObjectInfo(Document doc, Element parentNode, ModelIDObject object, String objectTypeName) {
        String notes;
        object.setPersisted(true);
        Element objInfo = doc.createElement("object");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(objectTypeName));
        objInfo.setAttribute("id", StringUtilities.encodeAttributeValue(object.getObjectID()));
        if (!object.hasOwnerDesignName() && object.isWriteable()) {
            object.setOwnerDesign();
        }
        Element child = doc.createElement("name");
        Text content = doc.createTextNode(StringUtilities.encodeAttributeValue(object.getName()));
        child.appendChild(content);
        objInfo.appendChild(child);
        String comment = object.getComment();
        if (comment != null) {
            child = doc.createElement("comment");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(comment));
            child.appendChild(content);
            objInfo.appendChild(child);
        }
        if ((notes = object.getNotes()) != null) {
            child = doc.createElement("notes");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(notes));
            child.appendChild(content);
            objInfo.appendChild(child);
        }
        this.appendChange(objInfo, object.getCreation(), "created");
        this.appendChange(objInfo, object.getChange(), "changed");
        String generatorID = object.getGeneratorID();
        if (!"User generated".equalsIgnoreCase(generatorID)) {
            child = doc.createElement("generator");
            content = doc.createTextNode(generatorID);
            child.appendChild(content);
            objInfo.appendChild(child);
        }
        parentNode.appendChild(objInfo);
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.encodeAttributeValue(object.getObjectID())).append(".dmd");
        object.setFilePath(buffer.toString());
        return objInfo;
    }

    protected void appendSubViewElement(Element parentNode, DesignPartViewPlaceHolder dpvPH) {
        DesignPartView dpv = dpvPH.getDesignPartView();
        String sv_type = "sub_view";
        if (dpv == dpv.getDesignPart().getMainView()) {
            sv_type = "main_view";
        }
        Document doc = parentNode.getOwnerDocument();
        Element subView = doc.createElement("sub_view");
        subView.setAttribute("subview_name", StringUtilities.encodeAttributeValue(dpv.getName()));
        subView.setAttribute("id", dpv.getDPVId());
        subView.setAttribute("sv_type", sv_type);
        subView.setAttribute("visible", dpvPH.getVisible() ? "true" : "false");
        subView.setAttribute("rep_oid", dpv.getRepositoryOID());
        subView.setAttribute("rep_ovid", dpv.getRepositoryOVID());
        subView.setAttribute("is_checkedout", String.valueOf(dpv.isCheckedOut()));
        subView.setAttribute("checkedout_by", dpv.getCheckedOutBy());
        parentNode.appendChild(subView);
    }
}

