/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.TreeMap;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLUrl
extends AbstractWXMLDesignObject
implements BIConstants {
    private BIResourceLocator url = null;

    public WXMLUrl(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof BIResourceLocator;
        if (result) {
            this.url = (BIResourceLocator)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.url != null) {
            String designName = this.url.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("businessinfo").append('/');
        }
        buffer.append(this.getConfiguration().get("urlPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof BIResourceLocator) {
            BIResourceLocator url = (BIResourceLocator)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("url", StringUtilities.encodeAttributeValue(String.valueOf(url.getUrl())));
            this.appendProperties(objectInfoNode, "attributes", map);
        }
    }
}

