/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteria;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLSelectionCriteria
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLSelectionCriteria(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getMultidimensionalDesign().getSelectionCriteriaSet().createSC(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        String funcID;
        Entity entity;
        SelectionCriteria sc = (SelectionCriteria)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        sc.setSelectionCriteria((String)map.get("selectioncriteria"));
        sc.setDescription((String)map.get("description"));
        String entityID = (String)map.get("entity");
        if (!"null".equalsIgnoreCase(entityID) && (entity = (Entity)sc.getDesign().getLogicalDesign().getEntitySet().getObjectByID(entityID)) != null) {
            sc.setEntity(entity);
        }
        sc.setPartition((String)map.get("partition"));
        String measID = (String)map.get("measure_id");
        if (!"null".equalsIgnoreCase(measID)) {
            sc.setMeasureID(measID);
        }
        if (!"null".equalsIgnoreCase(funcID = (String)map.get("aggr_function_id"))) {
            sc.setFuncID(funcID);
        }
        sc.setPartition((String)map.get("partition"));
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(sc.getObjectID())).append(".dmd");
        sc.setFilePath(buffer.toString());
        return sc;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            String dfDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(dfDesName).append('/');
        }
        buffer.append(this.getConfiguration().get("selcriteriaPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == SelectionCriteria.class;
    }
}

