/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLDimension
extends AbstractWXMLDesignObject
implements MDConstants {
    private Dimension dimension = null;

    public WXMLDimension(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof Dimension;
        if (result) {
            this.dimension = (Dimension)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.dimension != null) {
            String designName = this.dimension.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.dimension.getDesignPart().getObjectID())).append('/');
        }
        buffer.append(this.getConfiguration().get("dimensionPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof Dimension) {
            Dimension dimension = (Dimension)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("description", String.valueOf(dimension.getDescription()));
            map.put("timedimension", String.valueOf(dimension.isTimeDimension()));
            map.put("use_natural_keys", String.valueOf(dimension.isUseNaturalKeys()));
            this.appendProperties(objectInfoNode, "attributes", map);
            this.appendClacMembers(objectInfoNode, dimension);
        }
    }

    private void appendClacMembers(Element parent, Dimension dim) {
        Element propertiesList = parent.getOwnerDocument().createElement("calculated_members");
        for (Dimension.PermanentCalcMember func : dim.getPermanentCalcMembers()) {
            Element felem = parent.getOwnerDocument().createElement("calculated_member");
            if (func.getName() != null && !"".equalsIgnoreCase(func.getName())) {
                felem.setAttribute("name", StringUtilities.encodeAttributeValue(func.getName()));
            }
            if (func.getExpression() != null && !"".equalsIgnoreCase(func.getExpression())) {
                felem.setAttribute("expression", StringUtilities.encodeAttributeValue(func.getExpression()));
            }
            propertiesList.appendChild(felem);
        }
        parent.appendChild(propertiesList);
    }
}

