/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.Role;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLRole
extends AbstractWXMLDesignObject
implements DFConstants {
    private Role role = null;

    public WXMLRole(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof Role;
        if (result) {
            this.role = (Role)object;
        }
        return result;
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof Role) {
            Role role = (Role)object;
            if (role.getSynonym() != null && !role.getSynonym().equalsIgnoreCase("")) {
                objectInfoNode.setAttribute("synonym", StringUtilities.encodeAttributeValue(role.getSynonym()));
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("description", role.getDescription());
            this.appendProperties(objectInfoNode, "attributes", map);
            this.appendObjects(objectInfoNode, role.getProcesses().toArray(), "processes");
        }
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.role != null) {
            String designName = this.role.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("pm").append('/');
        }
        buffer.append(this.getConfiguration().get("rolePath"));
        return buffer.toString();
    }
}

