/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Iterator;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLStore
extends AbstractWXMLDesignObject
implements DFConstants {
    private InfoStore store = null;

    public WXMLStore(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof InfoStore;
        if (result) {
            this.store = (InfoStore)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.store != null) {
            String designName = this.store.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("pm").append('/');
        }
        buffer.append(this.getConfiguration().get("storePath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof InfoStore) {
            InfoStore store = (InfoStore)object;
            if (store.getSynonym() != null && !"".equalsIgnoreCase(store.getSynonym())) {
                objectInfoNode.setAttribute("synonym", StringUtilities.encodeAttributeValue(store.getSynonym()));
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("systemobjective", store.getSystemObjective());
            map.put("type", StringUtilities.encodeAttributeValue(store.getType()));
            map.put("rdbmstype", StringUtilities.encodeAttributeValue(store.getRdbmsSite()));
            map.put("owner", StringUtilities.encodeAttributeValue(store.getOwner()));
            map.put("source", StringUtilities.encodeAttributeValue(store.getSource()));
            map.put("filename", StringUtilities.encodeAttributeValue(store.getFileName()));
            map.put("location", StringUtilities.encodeAttributeValue(store.getLocation()));
            map.put("filetype", StringUtilities.encodeAttributeValue(store.getFileType()));
            map.put("fieldseparator", StringUtilities.encodeAttributeValue(store.getFieldSeparator()));
            map.put("transfertype", StringUtilities.encodeAttributeValue(store.getTransferType()));
            map.put("scope", StringUtilities.encodeAttributeValue(store.getScope()));
            map.put("objectType", StringUtilities.encodeAttributeValue(store.getObjectType()));
            map.put("implementationName", StringUtilities.encodeAttributeValue(store.getImplementationName()));
            map.put("selfDescribing", new Boolean(store.isSelfDescribing()).toString());
            map.put("skipRecords", new Integer(store.getSkipRecords()).toString());
            map.put("textDelimiter", StringUtilities.encodeAttributeValue(store.getTextDelimiter()));
            this.appendProperties(objectInfoNode, "attributes", map);
            Iterator it = store.getEntityImplementations().keySet().iterator();
            TreeMap<String, String> objMap = new TreeMap<String, String>();
            while (it.hasNext()) {
                DesignObject entity = (DesignObject)it.next();
                DesignObject impl = (DesignObject)store.getEntityImplementations().get(entity);
                if (impl == null) continue;
                objMap.put(StringUtilities.encodeAttributeValue(entity.getObjectID()), StringUtilities.encodeAttributeValue(impl.getObjectID()));
            }
            this.appendProperties(objectInfoNode, "entityimpl", objMap);
            this.appendObjects(objectInfoNode, store.getDatas().toArray(), "storedatas");
        }
    }
}

