/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.swingui.PointsEnteredCallback;

public class GlassComponent
extends JComponent {
    private static final Point[] POINT_ARRAY_PROTO = new Point[0];
    private MultiplePointsAdapter multiPointListener = new MultiplePointsAdapter();
    private SinglePointAdapter singlePointListener = new SinglePointAdapter();
    private RectangleDragAdapter rectangleListener = new RectangleDragAdapter();
    private PredeterminedMultiplePointsAdapter predeterminedListener = new PredeterminedMultiplePointsAdapter();
    private StatusBarOwner statusBar = null;
    private List activeListeners = new ArrayList();

    public GlassComponent() {
        this.setVisible(false);
    }

    public void setStatusBarOwner(StatusBarOwner statusBarOwner) {
        this.statusBar = statusBarOwner;
    }

    public void getSinglePoint(PointsEnteredCallback callback) {
        this.singlePointListener.start(callback);
    }

    public void getPointsUntilDoubleClick(PointsEnteredCallback callback) {
        this.multiPointListener.start(callback);
    }

    public void getPoints(PointsEnteredCallback callback, int requestedNumber) {
        this.predeterminedListener.setRequestedNumber(requestedNumber);
        this.predeterminedListener.start(callback);
    }

    public void getRectangle(PointsEnteredCallback callback) {
        this.rectangleListener.start(callback);
    }

    protected void clearStatusMessage() {
        if (this.statusBar != null) {
            this.statusBar.clearStatusMessage();
        }
    }

    public void stopAll() {
        while (!this.activeListeners.isEmpty()) {
            GPMouseInputAdapter listener = (GPMouseInputAdapter)this.activeListeners.remove(0);
            listener.doStop();
        }
        this.setVisible(false);
    }

    class PredeterminedMultiplePointsAdapter
    extends MultiplePointsAdapter {
        Point sPoint;
        Point ePoint;
        boolean drawing;
        private int requestedNumber;

        PredeterminedMultiplePointsAdapter() {
            this.sPoint = new Point(-1, -1);
            this.ePoint = new Point(-1, -1);
            this.drawing = false;
            this.requestedNumber = 2;
        }

        public void setRequestedNumber(int requestedNumber) {
            this.requestedNumber = requestedNumber;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            boolean bl = this.drawing = !this.drawing;
            if (this.drawing) {
                this.sPoint.setLocation(e.getX(), e.getY());
                this.ePoint.setLocation(e.getX(), e.getY());
            } else {
                Graphics g = GlassComponent.this.getGraphics();
                g.setXORMode(GlassComponent.this.getBackground());
                g.drawLine(this.sPoint.x, this.sPoint.y, this.ePoint.x, this.ePoint.y);
                g.dispose();
                GlassComponent.this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.drawing) {
                Graphics g = GlassComponent.this.getGraphics();
                g.setXORMode(GlassComponent.this.getBackground());
                g.drawLine(this.sPoint.x, this.sPoint.y, this.ePoint.x, this.ePoint.y);
                this.ePoint.setLocation(e.getX(), e.getY());
                g.drawLine(this.sPoint.x, this.sPoint.y, this.ePoint.x, this.ePoint.y);
                g.dispose();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.drawing && !this.sPoint.equals(this.ePoint)) {
                GlassComponent.this.repaint();
            }
            this.getPointsCollection().add(e.getPoint());
            if (this.getPointsCollection().size() >= this.requestedNumber) {
                this.sPoint = new Point(-1, -1);
                this.ePoint = new Point(-1, -1);
                this.drawing = false;
                this.sendPoints();
            }
        }
    }

    class SinglePointAdapter
    extends GPMouseInputAdapter {
        private PointsEnteredCallback callback;

        SinglePointAdapter() {
            this.callback = null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.callback.pointSelected(SwingUtilities.convertPoint(GlassComponent.this, e.getPoint(), this.callback.getTargetCoordinateSpace()));
            this.stop();
        }

        @Override
        protected void doStart(PointsEnteredCallback callback) {
            this.callback = callback;
            GlassComponent.this.addMouseListener(this);
        }

        @Override
        protected void doStop() {
            GlassComponent.this.removeMouseListener(this);
        }
    }

    class MultiplePointsAdapter
    extends GPMouseInputAdapter {
        private PointsEnteredCallback callback;
        private List points;

        MultiplePointsAdapter() {
            this.callback = null;
            this.points = new ArrayList();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.getPointsCollection().add(e.getPoint());
            if (e.getClickCount() >= 2) {
                this.sendPoints();
            }
        }

        protected Collection getPointsCollection() {
            return this.points;
        }

        @Override
        protected void doStart(PointsEnteredCallback callback) {
            this.callback = callback;
            this.getPointsCollection().clear();
            GlassComponent.this.addMouseListener(this);
            GlassComponent.this.addMouseMotionListener(this);
        }

        protected void sendPoints() {
            this.stop();
            for (int i = 0; i < this.points.size(); ++i) {
                Point p = (Point)this.points.remove(i);
                p = SwingUtilities.convertPoint(GlassComponent.this, p, this.callback.getTargetCoordinateSpace());
                this.points.add(i, p);
            }
            if (this.points.size() == 1) {
                this.callback.pointSelected((Point)this.points.get(0));
            } else {
                this.callback.pointsSelected(this.points.toArray(POINT_ARRAY_PROTO));
            }
        }

        @Override
        protected void doStop() {
            GlassComponent.this.removeMouseListener(this);
            GlassComponent.this.removeMouseMotionListener(this);
        }
    }

    class RectangleDragAdapter
    extends GPMouseInputAdapter {
        private Point dragStart;
        private Point lastDragPoint;
        private PointsEnteredCallback callback;
        private List points;

        RectangleDragAdapter() {
            this.dragStart = null;
            this.lastDragPoint = null;
            this.callback = null;
            this.points = new ArrayList();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.dragStart == null) {
                this.dragStart = e.getPoint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.lastDragPoint = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.points.add(this.dragStart);
            if (this.lastDragPoint != null) {
                this.points.add(this.lastDragPoint);
                this.sendRectangle();
                this.stop();
            }
        }

        @Override
        protected void doStart(PointsEnteredCallback callback) {
            this.callback = callback;
            this.points.clear();
            GlassComponent.this.addMouseListener(this);
            GlassComponent.this.addMouseMotionListener(this);
        }

        private void sendRectangle() {
            Rectangle rect = new Rectangle((Point)this.points.get(0));
            rect.add((Point)this.points.get(1));
            this.callback.rectangleSelected(SwingUtilities.convertRectangle(GlassComponent.this, rect, this.callback.getTargetCoordinateSpace()));
            GlassComponent.this.setVisible(false);
        }

        @Override
        protected void doStop() {
            GlassComponent.this.removeMouseListener(this);
            GlassComponent.this.removeMouseMotionListener(this);
            this.dragStart = null;
            this.lastDragPoint = null;
            this.callback = null;
        }
    }

    abstract class GPMouseInputAdapter
    extends MouseInputAdapter {
        GPMouseInputAdapter() {
        }

        protected final void start(PointsEnteredCallback callback) {
            GlassComponent.this.activeListeners.add(this);
            GlassComponent.this.setVisible(true);
            this.doStart(callback);
        }

        protected abstract void doStart(PointsEnteredCallback var1);

        protected abstract void doStop();

        protected final void stop() {
            GlassComponent.this.activeListeners.remove(this);
            this.doStop();
            GlassComponent.this.stopAll();
        }
    }
}

