/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class MenuPath {
    public static final Object[] MENUPATH_ARRAY = new MenuPath[0];
    private String name;
    private int level;
    private Map children = new TreeMap();
    private MenuPath parent;
    private int mnemonic;

    private MenuPath(String name, int level, MenuPath parent) {
        int index;
        this.name = name;
        this.level = level;
        this.parent = parent;
        if (name != null && (index = name.indexOf(38)) > -1) {
            StringBuffer sb = new StringBuffer(name);
            sb.deleteCharAt(index);
            this.mnemonic = sb.toString().charAt(index);
        }
    }

    protected void addChild(String[] path) {
        String childname = path[this.level + 1];
        this.children.put(childname, new MenuPath(childname, this.level + 1, this));
    }

    protected boolean isInPath(String[] path) {
        return path[this.level].equals(this.name);
    }

    protected MenuPath getOrCreateChild(String[] path) {
        if (!this.children.containsKey(path[this.level + 1])) {
            this.addChild(path);
        }
        return (MenuPath)this.children.get(path[this.level + 1]);
    }

    public MenuPath[] getChildren() {
        return (MenuPath[])this.children.values().toArray(MENUPATH_ARRAY);
    }

    protected Iterator childIterator() {
        return this.children.values().iterator();
    }

    public String getLastNodeName() {
        int index = this.name.indexOf(38);
        if (index > -1) {
            StringBuffer sb = new StringBuffer(this.name);
            sb.deleteCharAt(index);
            return sb.toString();
        }
        return this.name;
    }

    public MenuPath getLastNodeIn(String[] path) {
        if (this.isInPath(path)) {
            if (path.length - 1 == this.level) {
                return this;
            }
            return this.getOrCreateChild(path).getLastNodeIn(path);
        }
        throw new RuntimeException("wrong path");
    }

    public MenuPath getFirstNodeIn(String[] path) {
        return (MenuPath)this.children.get(path[0]);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.appendTo(buf);
        return buf.toString();
    }

    public MenuPath getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean isRoot() {
        return false;
    }

    public void appendTo(StringBuffer buf) {
        Iterator it = this.children.values().iterator();
        buf.append('[');
        buf.append(this.name);
        buf.append(':');
        while (it.hasNext()) {
            ((MenuPath)it.next()).appendTo(buf);
        }
        buf.append(']');
    }

    public static MenuPath createRoot() {
        return new RootNode();
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    protected static class RootNode
    extends MenuPath {
        private RootNode() {
            super(null, -1, null);
        }

        protected boolean isInPath() {
            return true;
        }

        @Override
        public MenuPath getLastNodeIn(String[] path) {
            return super.getOrCreateChild(path).getLastNodeIn(path);
        }

        @Override
        public void appendTo(StringBuffer buf) {
            Iterator it = this.childIterator();
            while (it.hasNext()) {
                ((MenuPath)it.next()).appendTo(buf);
            }
        }

        @Override
        public boolean isRoot() {
            return true;
        }
    }
}

