/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectedObjectChangeListener;
import oracle.dbtools.crest.swingui.SelectionSource;

public class SelectionSourceImpl
implements SelectionSource {
    private SelectableObject currentSelection = null;
    private Set selectionChangeListeners = new HashSet();

    @Override
    public void setCurrentSelection(SelectableObject selected) {
        this.currentSelection = selected;
        this.fireSelectionChanged();
    }

    @Override
    public SelectableObject getCurrentSelection() {
        return this.currentSelection;
    }

    @Override
    public void addSelectedObjectChangeListener(SelectedObjectChangeListener listener) {
        this.selectionChangeListeners.add(listener);
    }

    @Override
    public void removeSelectedObjectChangeListener(SelectedObjectChangeListener listener) {
        this.selectionChangeListeners.remove(listener);
    }

    @Override
    public void fireSelectionChanged() {
        this.fireSelectionChanged(this.getCurrentSelection());
    }

    @Override
    public void fireSelectionChanged(SelectableObject selObject) {
        Iterator it = this.selectionChangeListeners.iterator();
        while (it.hasNext()) {
            ((SelectedObjectChangeListener)it.next()).selectionChanged(selObject);
        }
    }
}

