/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.GroupRemoveEdit;
import oracle.dbtools.crest.model.design.undo.RemoveDO_Edit;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVLabel;
import oracle.dbtools.crest.swingui.TVLegend;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.ShowHideElementsDialog;
import oracle.dbtools.crest.util.TopViewColorDialog;
import oracle.ide.Ide;

public class DefaultDiagramCell
extends DefaultMutableTreeNode
implements DiagramCell,
Cloneable {
    public static final String FORMAT = Messages.getString("DefaultDiagramCell.Format");
    public static final String SHOW_HIDE_ELEMENTS = Messages.getString("DefaultDiagramCell.SHElements");
    public static final String PROPERTIES = Messages.getString("DefaultDiagramCell.Properties");
    public static final String CUT = Messages.getString("DefaultDiagramCell.Cut");
    public static final String COPY = Messages.getString("DefaultDiagramCell.Copy");
    public static final String PASTE = Messages.getString("DefaultDiagramCell.Paste");
    public static final String DELETE = Messages.getString("DefaultDiagramCell.Delete");
    public static final String HIDE = Messages.getString("DefaultDiagramCell.Hide");
    public static final String HIDE_LINES = Messages.getString("DefaultDiagramCell.HideLines");
    public static final String DELETE_FROM_DFD = Messages.getString("DefaultDiagramCell.DeleteFromDFD");
    public static final String DELETE_OBJECT = Messages.getString("DefaultDiagramCell.DeleteObject");
    public static final String DELETE_OBJECTS = Messages.getString("DefaultDiagramCell.DeleteObjects");
    public static final String DELETE_VIEW = Messages.getString("DefaultDiagramCell.DeleteView");
    public static final String DELETE_VIEWS = Messages.getString("DefaultDiagramCell.DeleteViews");
    public static final String CREATE_SYNONYM = Messages.getString("DefaultDiagramCell.CreateSynonym");
    public static final String DDL_PREVIEW = Messages.getString("DefaultDiagramCell.DDLPreview");
    public static final String HIVE_DDL = "Hive DDL";
    public static final String BOX_IN_BOX = Messages.getString("DefaultDiagramCell.BoxInBoxPresentation");
    public static final String CREATE_SUBVIEW_FROM_SELECTED = Messages.getString("DefaultDiagramCell.CreateSubViewFromSelected");
    public static final String CREATE_SUBVIEW_WITH_RELATED_OBJECTS = Messages.getString("DefaultDiagramCell.CreateSubViewWithRelatedObjects");
    public static final String SELECT_NEIGHBORS = Messages.getString("DefaultDiagramCell.SelectNeighbors");
    public static final String SEND_TO_BACK = Messages.getString("DefaultDiagramCell.SendToBack");
    public static final String STRAIGHT_LINE = Messages.getString("DefaultDiagramCell.StraightenLines");
    public static final String ADD_BREAKPOINT = Messages.getString("DefaultDiagramCell.AddElbow");
    public static final String REMOVE_BREAKPOINT = Messages.getString("DefaultDiagramCell.RemoveElbow");
    public static final String CHECK_OUT = Messages.getString("DefaultDiagramCell.CheckOut");
    public static final String CHECK_IN = Messages.getString("DefaultDiagramCell.CheckIn");
    public static final String RESIZE_TO_VISIBLE = Messages.getString("DefaultDiagramCell.ResizeToVisible");
    public static final String VERSIONING = Messages.getString("DefaultDiagramCell.Versioning");
    public static final String VALIDATE_SELECTED_VIEWS = Messages.getString("DefaultDiagramCell.ValidateSelectedViews");
    public static final String VALIDATE_SELECTED_TABLES = Messages.getString("DefaultDiagramCell.ValidateSelectedTables");
    public static final String PARSE_SELECTED_OLDER_STYLE_VIEWs = Messages.getString("DefaultDiagramCell.ParseSelectedOldStyleViews");
    public static final String SORT_ATTRIBUTES_FOR_SELECTED_ENTITIES = Messages.getString("DefaultDiagramCell.SortAttributes");
    public static final String SORT_ATTRIBUTES_FOR_SELECTED_ENTITIES_ASC = Messages.getString("DefaultDiagramCell.SortASC");
    public static final String SORT_ATTRIBUTES_FOR_SELECTED_ENTITIES_DESC = Messages.getString("DefaultDiagramCell.SortDESC");
    public static final String SHOW_PARENT_CHILD_TABLES = Messages.getString("DefaultDiagramCell.ShowParentChildTables");
    public static final String DESIGN_RULES = Messages.getString("DefaultDiagramCell.DesignRules");
    public static final String IMPLIED_FOREIGN_KEYS = Messages.getString("DefaultDiagramCell.ImpliedForeignKeys");
    public static final String RESET_LABEL_SIZE = Messages.getString("DefaultDiagramCell.ResetLabelSize");
    public static final String TARGET_LABEL_ABOVE = Messages.getString("DefaultDiagramCell.TargetLabelAboveLine");
    public static final String SOURCE_LABEL_BELOW = Messages.getString("DefaultDiagramCell.SourceLabelBelowLine");
    protected Object[] selectedObjects;
    public static final Rectangle defaultBounds = new Rectangle(20, 20, 200, 120);
    private AbstractCellView cellView;
    private TopView topView;
    protected Map attributes = DiagramConstants.createMap();

    public DefaultDiagramCell() {
        this(null);
    }

    public void showPopupMenu(Point pt) {
    }

    public void doubleClick() {
    }

    protected boolean isEditable() {
        return this.isEditable(false);
    }

    protected boolean isEditable(boolean checkNewDesign) {
        if (ApplicationView.IS_VIEWER) {
            if (checkNewDesign && this.topView != null) {
                return this.topView.getDesignPartView().getDesign().isNewDesign();
            }
            return false;
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY && this.topView != null) {
            return this.topView.getDesignPartView() instanceof DPVLogical;
        }
        return true;
    }

    protected void setEnabled(JComponent component, boolean enabled) {
        if (component != null) {
            component.setEnabled(enabled);
        }
    }

    public DefaultDiagramCell(Object userObject) {
        this(userObject, null);
    }

    public DefaultDiagramCell(Object userObject, MutableTreeNode[] children) {
        super(userObject, true);
        this.setUserObject(userObject);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.add(children[i]);
            }
        }
        DiagramConstants.setBounds(this.attributes, defaultBounds);
    }

    public DefaultDiagramCell(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    @Override
    public void setUserObject(Object obj) {
        if (this.userObject instanceof ValueChangeHandler) {
            ((ValueChangeHandler)this.userObject).valueChanged(obj);
        } else {
            super.setUserObject(obj);
        }
        obj = this.getUserObject();
        if (obj == null) {
            DiagramConstants.setValue(this.attributes, "");
        } else {
            DiagramConstants.setValue(this.attributes, obj);
        }
    }

    public List getChildren() {
        if (this.children == null) {
            return Collections.EMPTY_LIST;
        }
        return this.children;
    }

    @Override
    public Map getAttributes() {
        return this.attributes;
    }

    @Override
    public Map changeAttributes(Map change) {
        Map undo = DiagramConstants.applyMap(change, this.attributes);
        Object newValue = DiagramConstants.getValue(this.attributes);
        if (this.userObject != null && newValue == null) {
            DiagramConstants.setValue(this.attributes, this.userObject);
        } else if (this.userObject instanceof ValueChangeHandler) {
            Object oldValue = ((ValueChangeHandler)this.userObject).valueChanged(newValue);
            if (oldValue == null || !newValue.toString().equals(oldValue.toString())) {
                DiagramConstants.setValue(undo, oldValue);
            }
            DiagramConstants.setValue(this.attributes, this.userObject);
        } else {
            this.setUserObject(newValue);
        }
        Rectangle2D bounds = DiagramConstants.getBounds(this.attributes);
        if (bounds == null) {
            DiagramConstants.setBounds(this.attributes, defaultBounds);
        }
        return undo;
    }

    @Override
    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    @Override
    public Object clone() {
        DefaultDiagramCell c = (DefaultDiagramCell)super.clone();
        c.attributes = DiagramConstants.createMap();
        c.attributes.putAll(this.attributes);
        c.userObject = this.cloneUserObject();
        return c;
    }

    protected Object cloneUserObject() {
        if (this.userObject instanceof ValueChangeHandler) {
            return ((ValueChangeHandler)this.userObject).clone();
        }
        return this.userObject;
    }

    public AbstractCellView getCellView() {
        return this.cellView;
    }

    public void setCellView(AbstractCellView cellView) {
        this.cellView = cellView;
    }

    public Diagram getDiagram() {
        if (this.cellView != null) {
            return (Diagram)this.cellView.getDiagram();
        }
        return null;
    }

    public TopView getTopView() {
        return this.topView;
    }

    public void format() {
        if (this.topView != null) {
            if (this.topView instanceof TVConnector) {
                new TopViewColorDialog(this.topView.getDesignPartView().getSelectedTVConnectors()).setVisible(true);
            } else if (this.topView instanceof TVNote) {
                new TopViewColorDialog(this.topView.getDesignPartView().getSelectedNoteViews().toArray()).setVisible(true);
            } else if (this.topView instanceof TVLegend) {
                new TopViewColorDialog(this.topView.getDesignPartView().getSelectedLegendViews().toArray(), true).setVisible(true);
                this.topView.getDesignPartView().updateLegendSize();
            } else if (this.topView instanceof TVLabel) {
                new TopViewColorDialog(this.topView.getDesignPartView().getSelectedLabelViews().toArray(), true).setVisible(true);
                this.topView.getDesignPartView().updateLegendSize();
            } else {
                new TopViewColorDialog(this.topView.getDesignPartView().getSelectedContainerViews().toArray()).setVisible(true);
            }
            this.getCellView().getDiagram().repaint();
        }
    }

    protected void showDesignRulesDialog() {
        List<ContainerView> selectedTVItems = this.topView.getDesignPartView().getSelectedContainerViews();
        DesignPart model = selectedTVItems.get(0).getModel().getDesignPart();
        if (model instanceof DataFlowDesign) {
            model = ((DataFlowDesign)model).getProcessModel();
        }
        this.getApplicationView().setDesignRuleViewVisible(true, model, this.getSelectecDesignObjects(selectedTVItems));
    }

    public List getSelectecDesignObjects(List selectedTVItems) {
        ArrayList<DesignObject> designObjList = new ArrayList<DesignObject>();
        Iterator it = selectedTVItems.iterator();
        while (it.hasNext()) {
            DesignObject obj = ((ContainerView)it.next()).getModel();
            designObjList.add(obj);
        }
        return designObjList;
    }

    public void showHideElements() {
        if (this.topView != null) {
            new ShowHideElementsDialog(this.getApplicationView(), this.topView);
        }
    }

    private ApplicationView getApplicationView() {
        return this.topView.getApplicationView();
    }

    public boolean checkOut() {
        DesignObject object = this.topView.getModel();
        AbstractRepositoryManager rman = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        boolean res = false;
        if (rman.isConnected()) {
            String ch_user = null;
            try {
                ch_user = rman.getCheckoutByUser(object);
            }
            catch (SQLException e) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("DefaultDiagramCell.ErrorInCheckout"), e.getMessage()}, Messages.getString("DefaultDiagramCell.CheckoutError"), 0);
                return false;
            }
            if (ch_user != null) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("DefaultDiagramCell.CheckedOut"), object.getName(), ch_user), Messages.getString("DefaultDiagramCell.CheckoutError"), 0);
                object.setCheckedOut(true);
                object.setCheckedOutByMe(false);
                return false;
            }
            res = rman.checkOutObject(object);
            if (res) {
                object.setCheckedOutByMe(true);
                this.getApplicationView().getBrowserPanel().getJTree().updateUI();
            }
        }
        return res;
    }

    public boolean checkIn() {
        DesignObject object = this.topView.getModel();
        AbstractRepositoryManager rman = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        boolean res = false;
        if (rman.isConnected()) {
            if (object.isDirty()) {
                rman.writeObject(object);
                object.setDirty(false);
            }
            if (res = rman.checkInObject(object)) {
                object.setCheckedOut(false);
                object.setCheckedOutByMe(false);
                this.getApplicationView().getBrowserPanel().getJTree().updateUI();
            }
        }
        return res;
    }

    public boolean canShowCheckOutFor() {
        DesignObject object = this.topView.getModel();
        AbstractRepositoryManager rman = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        boolean res = false;
        if (this.isCheckInOutObject() && !object.isCheckedOut() && rman.isConnected() && this.getApplicationView().getCurrentDesign().isLoadFromDB()) {
            res = object.getRepositoryOID() != null;
        }
        return res;
    }

    public boolean canShowCheckInFor() {
        DesignObject object = this.topView.getModel();
        AbstractRepositoryManager rman = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        boolean res = false;
        if (this.isCheckInOutObject() && object.isCheckedOut() && rman.isConnected() && this.getApplicationView().getCurrentDesign().isLoadFromDB() && object.isCheckedOutByMe()) {
            res = object.getRepositoryOID() != null;
        }
        return res;
    }

    public boolean isCheckInOutObject() {
        DesignObject object = this.topView.getModel();
        return object instanceof ContainerObject || object instanceof ConnectionInterface || object instanceof Domain || object instanceof AbstractDTObject || object instanceof AbstractMDObject || object instanceof AbstractProcessObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteObjects(Object[] selectedObjects, ApplicationView applicationView) {
        int res = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("DefaultDiagramCell.DeleteSelected"), String.valueOf(selectedObjects.length)), Messages.getString("DefaultDiagramCell.SelectedWillBeDeleted"), 0, 3, null, new String[]{Messages.getString("DefaultDiagramCell.RemoveObjects"), Messages.getString("DefaultDiagramCell.Cancel")}, Messages.getString("DefaultDiagramCell.RemoveObjects"));
        if (res == 0 && selectedObjects.length > 0) {
            GroupRemoveEdit groupEdit = new GroupRemoveEdit((DesignObject)selectedObjects[0]);
            ArrayList<DesignObject> connectors = new ArrayList<DesignObject>();
            ArrayList<DesignObject> others = new ArrayList<DesignObject>();
            ArrayList<DesignObject> arcs = new ArrayList<DesignObject>();
            for (int i = 0; i < selectedObjects.length; ++i) {
                if (!(selectedObjects[i] instanceof DesignObject)) continue;
                DesignObject dobj = (DesignObject)selectedObjects[i];
                if (dobj.getTopView() instanceof TVConnector) {
                    connectors.add(dobj);
                    continue;
                }
                if (dobj instanceof FKArc || dobj instanceof Arc) {
                    arcs.add(dobj);
                    continue;
                }
                others.add(dobj);
            }
            for (DesignObject dobj : arcs) {
                RemoveDO_Edit.addUndoableRemoveEditForObject(groupEdit, dobj);
                dobj.remove();
            }
            for (DesignObject dobj : connectors) {
                RemoveDO_Edit.addUndoableRemoveEditForObject(groupEdit, dobj);
                if (dobj instanceof FKIndexAssociation) {
                    FKIndexAssociation fk = (FKIndexAssociation)dobj;
                    if (others.contains(fk.getTable())) {
                        fk.setSilentRemove(true);
                        try {
                            fk.remove();
                            continue;
                        }
                        finally {
                            fk.setSilentRemove(false);
                            continue;
                        }
                    }
                    if (fk.getTable().isRemoteObject()) continue;
                    fk.remove();
                    continue;
                }
                dobj.remove();
            }
            for (DesignObject dobj : others) {
                if (dobj instanceof Entity) {
                    if (((Entity)dobj).getRelationConnections().length <= 0) {
                        RemoveDO_Edit.addUndoableRemoveEditForObject(groupEdit, dobj);
                        ((Entity)dobj).remove(true);
                        continue;
                    }
                    MessageDialogs.showWarningMessage(Messages.getString("DefaultDiagramCell.DeleteOrRemoveRelationsBeforeDeletingEntity") + dobj.getName() + "'.");
                    continue;
                }
                if (dobj instanceof Table) {
                    Table tab = (Table)dobj;
                    List list = tab.getRelationalModel().getFKIndexAssociationSet().getFKeysEndingTo(tab);
                    for (FKIndexAssociation fk : list) {
                        if (tab == fk.getTable() || others.contains(fk.getTable())) {
                            fk.setSilentRemove(true);
                        }
                        if (tab == fk.getTable()) continue;
                        RemoveDO_Edit.addUndoableRemoveEditForObject(groupEdit, fk);
                        fk.remove();
                    }
                }
                RemoveDO_Edit.addUndoableRemoveEditForObject(groupEdit, dobj);
                dobj.remove();
            }
            groupEdit.end();
            if (groupEdit.getNumberOfEdits() > 0) {
                ((DesignObject)selectedObjects[0]).getDesignPart().postUndoableEdit(groupEdit);
            }
        }
    }

    public void setTopView(TopView topView) {
        this.topView = topView;
    }

    public void deleteSelected() {
    }

    public boolean canDeleteModelObject() {
        DesignObject dobj;
        TopView tv = this.getTopView();
        if (tv != null && (dobj = tv.getModel()) != null) {
            return dobj.canBedeleted();
        }
        return false;
    }

    public static interface ValueChangeHandler {
        public Object valueChanged(Object var1);

        public Object clone();
    }
}

