/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.DiagramViewPanel;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewView;

public class DiagramViewRenderer
extends JPanel
implements CellViewRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(159, 155, 251);
    public static final Color DEFAULT_BORDER_COLOR = Color.BLACK;
    protected transient Color bordercolor;
    protected transient Color defaultForeground = DEFAULT_FOREGROUND;
    protected transient Color defaultBackground = DEFAULT_BACKGROUND;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient AbstractDiagram diagram;
    protected transient int borderWidth;
    protected transient DiagramView diagramView;
    protected transient DiagramViewPanel overviewPanel = null;

    public DiagramViewRenderer() {
        this.bordercolor = DEFAULT_BORDER_COLOR;
        this.setLayout(new BorderLayout());
    }

    @Override
    public Component getRendererComponent(AbstractDiagram diagram, CellView view, boolean sel, boolean focus, boolean preview) {
        if (view instanceof DiagramViewView) {
            DiagramViewDiagramCell cell = (DiagramViewDiagramCell)view.getCell();
            this.diagramView = cell.getDiagramView();
            this.diagram = diagram;
            this.hasFocus = focus;
            this.selected = sel;
            this.preview = preview;
            this.setComponentOrientation(diagram.getComponentOrientation());
            if (this.diagramView.isCompositeView() && this.overviewPanel == null && this.diagramView.getDesignPartView() != null) {
                this.overviewPanel = new DiagramViewPanel(this.diagramView.getDesignPartView().getWorkSpace(), this.diagramView.getDesignPartView().getWorkSpace().getScrollPane().getViewport());
                this.add(this.overviewPanel);
            }
            cell.setRenderer(this);
            this.diagramView.setRenderer(this);
        }
        this.installAttributes(view);
        return this;
    }

    public void resetOverviewPanel() {
        if (this.overviewPanel != null) {
            this.remove(this.overviewPanel);
        }
        this.overviewPanel = null;
        if (this.diagramView.isCompositeView() && this.overviewPanel == null && this.diagramView.getDesignPartView() != null) {
            this.overviewPanel = new DiagramViewPanel(this.diagramView.getDesignPartView().getWorkSpace(), this.diagramView.getDesignPartView().getWorkSpace().getScrollPane().getViewport());
            this.add(this.overviewPanel);
            this.repaint();
        }
    }

    protected void installAttributes(CellView view) {
        Map map = view.getAllAttributes();
        this.borderWidth = Math.max(1, Math.round(DiagramConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground(this.getForegroundColor());
        Color background = DiagramConstants.getBackground(map);
        this.setBackground(background != null ? background : this.getBackgroundColor());
        this.setFont(this.diagram.getFont());
    }

    public Color getBackgroundColor() {
        if (this.diagramView.getTopView().useDefaultColor() || this.diagramView.getTopView().getBackgroundColor() == null) {
            return this.defaultBackground;
        }
        return this.diagramView.getTopView().getBackgroundColor();
    }

    public Color getForegroundColor() {
        if (this.diagramView.getTopView().useDefaultColor() || this.diagramView.getTopView().getForegroundColor() == null) {
            return this.bordercolor;
        }
        return this.diagramView.getTopView().getForegroundColor();
    }

    public Color getBorderColor() {
        if (this.diagramView.getTopView().useDefaultColor() || this.diagramView.getTopView().getForegroundColor() == null) {
            return this.bordercolor;
        }
        return this.diagramView.getTopView().getForegroundColor();
    }

    @Override
    public Color getBGColor() {
        return this.getBackgroundColor();
    }

    @Override
    public Color getFGColor() {
        return this.getForegroundColor();
    }

    @Override
    public void paintChildren(Graphics g) {
        this.overviewPanel.componentResized(null);
        super.paintChildren(g);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.diagramView.isCompositeView() || this.diagramView.getDesignPartView() == null) {
            Graphics2D g2 = (Graphics2D)g;
            Dimension dim = this.getSize();
            int w = dim.width;
            int h = dim.height;
            g2.setPaint(this.getBackgroundColor());
            int m = w / 3;
            int r = w / 15;
            int[] xx = new int[]{0, w - m, w - m + r, w - r, w - 1, w - 1, 0, 0};
            int[] yy = new int[]{r, r, 0, 0, r, h - 1, h - 1, r};
            Polygon p = new Polygon(xx, yy, 8);
            g.fillPolygon(p);
            g.setColor(this.getBorderColor());
            g.drawPolygon(p);
            FontMetrics fm = g.getFontMetrics();
            Font normalFont = this.diagram.getFont();
            Font titleFont = normalFont.deriveFont(1);
            Object title = "";
            int yCursor = (h - titleFont.getSize() + 15) / 2;
            BasicStroke textStroke = new BasicStroke(1.0f);
            DesignPartView dpv = this.diagramView.getDesignPartView();
            if (this.diagramView.getDesignPartView() == null || !this.diagramView.getDesignPartView().getDesignPart().isLoaded()) {
                title = "(NOT OPENED)";
                int xCursor = (w - fm.stringWidth((String)title)) / 2;
                g.drawString((String)title, xCursor, yCursor);
            } else {
                title = dpv.canCreateDisplays() ? (dpv.isMasterDPV() ? (dpv.getSubordinateViews().size() > 0 ? dpv.getName() + " ( main )" : dpv.getName()) : dpv.getMasterDPV().getName() + " ( " + dpv.getName() + " )") : dpv.getName();
                int xCursor = (w - fm.stringWidth((String)title)) / 2;
                g2.setStroke(textStroke);
                g.setColor(this.getBorderColor());
                g.setFont(titleFont);
                g.drawString((String)title, xCursor, yCursor);
            }
        } else if (this.diagramView.getDesignPartView() != null) {
            Graphics2D g2 = (Graphics2D)g;
            Dimension dim = this.getSize();
            int w = dim.width;
            int h = dim.height;
            int m = w / 3;
            int r = w / 15;
            int[] xx = new int[]{0, w - m, w - m + r, w - r, w - 1, w - 1, 0, 0};
            int[] yy = new int[]{r, r, 0, 0, r, h - 1, h - 1, r};
            g2.setPaint(this.getBackgroundColor());
            Polygon p = new Polygon(xx, yy, 8);
            g.fillPolygon(p);
            this.overviewPanel.hIndex = r;
            g.translate(0, r);
            super.paint(g);
            g.translate(0, -r);
            g.setColor(this.getBorderColor());
            g.drawPolygon(p);
            Font normalFont = this.diagram.getFont();
            int fs = r;
            Font titleFont = normalFont.deriveFont((float)fs - 2.0f);
            Object title = "";
            DesignPartView dpv = this.diagramView.getDesignPartView();
            title = dpv.canCreateDisplays() ? (dpv.isMasterDPV() ? (dpv.getSubordinateViews().size() > 0 ? dpv.getName() + " ( main )" : dpv.getName()) : dpv.getMasterDPV().getName() + " ( " + dpv.getName() + " )") : dpv.getName();
            BasicStroke textStroke = new BasicStroke(1.0f);
            g2.setStroke(textStroke);
            g.setColor(this.getBorderColor());
            g.setFont(titleFont);
            g.drawString((String)title, 10, r - r / 4);
        }
    }

    public Point2D getPerimeterPoint(DiagramViewView view, Point2D source, Point2D p, boolean simple) {
        Rectangle2D bounds = view.getBounds();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double t = Math.atan2(height, width);
        if (alpha < -pi + t || alpha > pi - t) {
            xout = x;
            yout = yCenter;
        } else if (alpha < -t) {
            yout = y;
            xout = xCenter;
        } else if (alpha < t) {
            xout = x + width;
            yout = yCenter;
        } else {
            yout = y + height;
            xout = xCenter;
        }
        return DiagramConstants.createPoint(xout, yout);
    }
}

