/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.AttributeMap;
import oracle.dbtools.crest.swingui.diagram.graph.CellHandle;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramContext;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.Port;
import oracle.dbtools.crest.swingui.diagram.graph.PortRenderer;

public class PortView
extends AbstractCellView {
    protected static int size = 3;
    public static PortRenderer renderer = new PortRenderer();
    protected transient CellView lastParent;
    public Point2D point = null;
    public Point2D ip = new Point2D.Double(0.0, 0.0);

    public PortView(Object cell, AbstractDiagram diagram, CellMapper mapper) {
        super(cell, diagram, mapper);
    }

    @Override
    public CellView getParentView() {
        CellView parent = super.getParentView();
        if (parent == null) {
            parent = this.lastParent;
        } else {
            this.lastParent = parent;
        }
        return parent;
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D bounds;
        if (this.point != null) {
            Rectangle2D r = this.getParentView().getBounds();
            this.point.setLocation(r.getX() + this.ip.getX(), r.getY() + this.ip.getY());
            bounds = DiagramConstants.createRect(this.point);
        } else {
            bounds = DiagramConstants.createRect(this.getLocation(null));
        }
        bounds.setFrame(bounds.getX() - (double)size, bounds.getY() - (double)size, bounds.getWidth() + (double)size, bounds.getHeight() + (double)size);
        return bounds;
    }

    @Override
    public CellViewRenderer getRenderer() {
        return renderer;
    }

    @Override
    public CellHandle getHandle(DiagramContext context) {
        return null;
    }

    public PortView getOtherPortAt(Point2D p) {
        CellView parent = this.getParentView();
        DiagramModel model = this.getModel();
        for (int i = 0; i < model.getChildCount(parent.getCell()); ++i) {
            PortView pv;
            CellView cv;
            Object child = model.getChild(parent.getCell(), i);
            if (!this.diagram.getDiagramLayoutCache().isVisible(child) || (cv = this.mapper.getMapping(child, false)) == null || !model.isPort(child) || !(cv instanceof PortView) || (pv = (PortView)cv) == null || pv == this || !(p.distance(pv.getPoint()) < 10.0)) continue;
            return pv;
        }
        return null;
    }

    public Point2D getLocation(EdgeView edge) {
        CellView parent;
        if (this.isAutoRoute()) {
            CellView parent2;
            if (this.point != null && (parent2 = this.getParentView()) != null) {
                Rectangle2D r = EdgeView.getBounds(parent2);
                this.point.setLocation(r.getX() + this.ip.getX(), r.getY() + this.ip.getY());
                this.fixPoint();
                this.setPoint(this.point);
            }
            return this.getAutoLocation(edge);
        }
        if (edge != null && edge.getPointCount() <= 2) {
            CellView parent3;
            if (this.point != null && (parent3 = this.getParentView()) != null) {
                Rectangle2D r = this.getParentView().getBounds();
                this.point.setLocation(r.getX() + this.ip.getX(), r.getY() + this.ip.getY());
                this.fixPoint();
                this.setPoint(this.point);
                return this.point;
            }
        } else if (this.point != null && (parent = this.getParentView()) != null) {
            Rectangle2D r = parent.getBounds();
            this.point.setLocation(r.getX() + this.ip.getX(), r.getY() + this.ip.getY());
            this.fixPoint();
            this.setPoint(this.point);
        }
        return this.getSimpleLocation(edge);
    }

    public boolean isAutoRoute() {
        return ((Diagram)this.diagram).getDesignPartView().isAutoRoute();
    }

    public Point2D getPoint() {
        return this.getPoint(null);
    }

    public Point2D getPoint(EdgeView edge) {
        if (this.point == null) {
            this.getSimpleLocation(edge);
        }
        return this.point;
    }

    public void setPoint(Point2D point) {
        if (point != null) {
            if (this.point == null) {
                this.point = point;
            } else {
                this.point.setLocation(point);
            }
            CellView parent = this.getParentView();
            if (parent != null) {
                Rectangle2D r = parent.getBounds();
                this.ip.setLocation(point.getX() - r.getX(), point.getY() - r.getY());
            }
        }
    }

    public void fixPoint() {
        Rectangle2D r = this.getParentView().getBounds();
        double x = this.point.getX();
        double y = this.point.getY();
        if (x < r.getX()) {
            x = r.getX();
        } else if (x > r.getMaxX()) {
            x = r.getMaxX();
        }
        if (y < r.getY()) {
            y = r.getY();
        } else if (y > r.getMaxY()) {
            y = r.getMaxY();
        }
        if (x > r.getX() && x <= r.getCenterX() && y > r.getY() && y <= r.getCenterY()) {
            if (x - r.getX() < y - r.getY()) {
                x = r.getX();
            } else {
                y = r.getY();
            }
        } else if (x > r.getX() && x <= r.getCenterX() && y < r.getMaxY() && y > r.getCenterY()) {
            if (x - r.getX() < r.getMaxY() - y) {
                x = r.getX();
            } else {
                y = r.getMaxY();
            }
        } else if (x < r.getMaxX() && x > r.getCenterX() && y > r.getY() && y <= r.getCenterY()) {
            if (r.getMaxX() - x < y - r.getY()) {
                x = r.getMaxX();
            } else {
                y = r.getY();
            }
        } else if (x < r.getMaxX() && x > r.getCenterX() && y < r.getMaxY() && y > r.getCenterY()) {
            if (r.getMaxX() - x < r.getMaxY() - y) {
                x = r.getMaxX();
            } else {
                y = r.getMaxY();
            }
        }
        this.point.setLocation(x, y);
    }

    public Point2D getFixedPoint(Point2D point, CellView pview) {
        Rectangle2D r = pview.getBounds();
        double x = point.getX();
        double y = point.getY();
        if (x < r.getX()) {
            x = r.getX();
        } else if (x > r.getMaxX()) {
            x = r.getMaxX();
        }
        if (y < r.getY()) {
            y = r.getY();
        } else if (y > r.getMaxY()) {
            y = r.getMaxY();
        }
        if (x > r.getX() && x <= r.getCenterX() && y > r.getY() && y <= r.getCenterY()) {
            if (x - r.getX() < y - r.getY()) {
                x = r.getX();
            } else {
                y = r.getY();
            }
        } else if (x > r.getX() && x <= r.getCenterX() && y < r.getMaxY() && y > r.getCenterY()) {
            if (x - r.getX() < r.getMaxY() - y) {
                x = r.getX();
            } else {
                y = r.getMaxY();
            }
        } else if (x < r.getMaxX() && x > r.getCenterX() && y > r.getY() && y <= r.getCenterY()) {
            if (r.getMaxX() - x < y - r.getY()) {
                x = r.getMaxX();
            } else {
                y = r.getY();
            }
        } else if (x < r.getMaxX() && x > r.getCenterX() && y < r.getMaxY() && y > r.getCenterY()) {
            if (r.getMaxX() - x < r.getMaxY() - y) {
                x = r.getMaxX();
            } else {
                y = r.getMaxY();
            }
        }
        point.setLocation(x, y);
        return point;
    }

    public Point2D getSimpleLocation(EdgeView edge) {
        Port modelAnchor = null;
        if (this.cell instanceof Port) {
            modelAnchor = ((Port)this.cell).getAnchor();
        }
        PortView anchor = (PortView)this.mapper.getMapping(modelAnchor, false);
        Point2D pos = null;
        boolean isAbsolute = DiagramConstants.isAbsolute(this.allAttributes);
        Point2D offset = DiagramConstants.getOffset(this.allAttributes);
        AbstractCellView vertex = (AbstractCellView)this.getParentView();
        if (vertex != null) {
            if (edge == null && offset == null) {
                pos = vertex.getCenterPoint();
            }
            if (offset != null) {
                double x = offset.getX();
                double y = offset.getY();
                Rectangle2D r = vertex.getBounds();
                if (!isAbsolute) {
                    x = x * (r.getWidth() - 1.0) / 1000.0;
                    y = y * (r.getHeight() - 1.0) / 1000.0;
                }
                pos = anchor != null ? anchor.getLocation(edge) : DiagramConstants.createPoint(r.getX(), r.getY());
                pos = DiagramConstants.createPoint(pos.getX() + x, pos.getY() + y);
            } else if (edge != null) {
                Point2D p1 = this.getNextPoint(edge);
                if (p1 == null) {
                    return vertex.getCenterPoint();
                }
                pos = vertex.getPerimeterPoint(vertex, pos, p1, edge.getPointCount() <= 2, false);
                if (edge.getPointCount() > 2 && DiagramConstants.getRouting(edge.getAllAttributes()) == null && p1 != null) {
                    Rectangle2D r = this.getParentView().getBounds();
                    if (p1.getX() >= r.getX() && p1.getX() <= r.getX() + r.getWidth()) {
                        pos.setLocation(p1.getX(), pos.getY());
                    } else if (p1.getY() >= r.getY() && p1.getY() <= r.getY() + r.getHeight()) {
                        pos.setLocation(pos.getX(), p1.getY());
                    }
                    if (p1.getX() < r.getX()) {
                        pos.setLocation(r.getX(), pos.getY());
                    } else if (p1.getX() > r.getX() + r.getWidth()) {
                        pos.setLocation(r.getX() + r.getWidth(), pos.getY());
                    }
                    if (p1.getY() < r.getY()) {
                        pos.setLocation(pos.getX(), r.getY());
                    } else if (p1.getY() > r.getY() + r.getHeight()) {
                        pos.setLocation(pos.getX(), r.getY() + r.getHeight());
                    }
                }
            }
        }
        if (this.point == null && pos != null) {
            this.point = DiagramConstants.createPoint(pos);
            this.fixPoint();
            this.setPoint(this.point);
        }
        return pos;
    }

    public Point2D getAutoLocation(EdgeView edge) {
        Port modelAnchor = null;
        if (this.cell instanceof Port) {
            modelAnchor = ((Port)this.cell).getAnchor();
        }
        PortView anchor = (PortView)this.mapper.getMapping(modelAnchor, false);
        Point2D pos = null;
        boolean isAbsolute = DiagramConstants.isAbsolute(this.allAttributes);
        Point2D offset = DiagramConstants.getOffset(this.allAttributes);
        AbstractCellView vertex = (AbstractCellView)this.getParentView();
        if (vertex != null) {
            if (edge == null && offset == null) {
                pos = vertex.getCenterPoint();
            }
            if (offset != null) {
                double x = offset.getX();
                double y = offset.getY();
                Rectangle2D r = vertex.getBounds();
                if (!isAbsolute) {
                    x = x * (r.getWidth() - 1.0) / 1000.0;
                    y = y * (r.getHeight() - 1.0) / 1000.0;
                }
                AttributeMap attr = new AttributeMap();
                pos = anchor != null ? anchor.getLocation(edge) : attr.createPoint(r.getX(), r.getY());
                pos = attr.createPoint(pos.getX() + x, pos.getY() + y);
            } else if (edge != null) {
                Point2D p1 = this.getNextPoint(edge);
                if (p1 == null) {
                    return vertex.getCenterPoint();
                }
                pos = vertex.getPerimeterPoint(pos, p1, edge.getPointCount() <= 2);
                if (edge.getPointCount() > 2 && DiagramConstants.getRouting(edge.getAllAttributes()) == null && p1 != null) {
                    Rectangle2D r = this.getParentView().getBounds();
                    if (p1.getX() > r.getX() && p1.getX() < r.getX() + r.getWidth()) {
                        pos.setLocation(p1.getX(), pos.getY());
                    } else if (p1.getY() >= r.getY() && p1.getY() < r.getY() + r.getHeight()) {
                        pos.setLocation(pos.getX(), p1.getY());
                    }
                    if (p1.getY() < r.getY()) {
                        pos.setLocation(pos.getX(), r.getY());
                    } else if (p1.getY() > r.getY() + r.getHeight()) {
                        pos.setLocation(pos.getX(), r.getY() + r.getHeight());
                    }
                }
            }
        }
        if (edge != null && this.isAutoRoute()) {
            double step;
            Rectangle2D bounds = vertex.getBounds();
            Point2D center = vertex.getCenterPoint();
            Point2D.Double p1 = new Point2D.Double(bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight());
            Point2D.Double p2 = new Point2D.Double(bounds.getX(), bounds.getY() + bounds.getHeight());
            Point2D.Double p3 = new Point2D.Double(bounds.getX(), bounds.getY());
            Point2D.Double p4 = new Point2D.Double(bounds.getX() + bounds.getWidth(), bounds.getY());
            double alphA1 = Math.atan2(center.getY() - ((Point2D)p1).getY(), ((Point2D)p1).getX() - center.getX());
            double alphA2 = Math.atan2(center.getY() - ((Point2D)p2).getY(), ((Point2D)p2).getX() - center.getX());
            double alphA3 = Math.atan2(center.getY() - ((Point2D)p3).getY(), ((Point2D)p3).getX() - center.getX());
            double alphA4 = Math.atan2(center.getY() - ((Point2D)p4).getY(), ((Point2D)p4).getX() - center.getX());
            double alphA = Math.atan2(center.getY() - pos.getY(), pos.getX() - center.getX());
            double d = step = 10.0;
            int index = 2;
            Point2D XY = this.getDXY(alphA, alphA1, alphA2, alphA3, alphA4, d);
            int side = PortView.getVertexSide(alphA, alphA1, alphA2, alphA3, alphA4);
            double[] alphas = new double[]{alphA1, alphA2, alphA3, alphA4};
            Object[] edges = this.getEdgesToParentViewByVertexSide(edge, vertex, bounds, side, alphas);
            boolean hasSelfRefAtside = false;
            if (edges != null && !edge.isSelfReference()) {
                int i;
                ArrayList<DefaultEdge> list = new ArrayList<DefaultEdge>();
                for (i = 0; i < edges.length; ++i) {
                    try {
                        DefaultEdge ed = (DefaultEdge)edges[i];
                        EdgeView ev = (EdgeView)ed.getCellView();
                        if (ev.isSelfReference()) continue;
                        list.add(ed);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                edges = list.toArray();
                if (edges.length > 1) {
                    for (i = 0; i < edges.length; ++i) {
                        Object obj = edges[i];
                        if (i == index) {
                            index += 2;
                            XY = this.getDXY(alphA, alphA1, alphA2, alphA3, alphA4, d += 2.0 * step);
                        }
                        double max = 0.0;
                        max = XY.getY() > 0.0 ? bounds.getHeight() / 2.0 : bounds.getWidth() / 2.0;
                        double ydelta = 0.0;
                        double xdelta = 0.0;
                        double dd = 0.0;
                        if (hasSelfRefAtside) {
                            max /= 2.0;
                        }
                        if (d > max) {
                            d = max;
                            XY = this.getDXY(alphA, alphA1, alphA2, alphA3, alphA4, d);
                        }
                        if (hasSelfRefAtside) {
                            dd = XY.getY() > 0.0 ? (ydelta = bounds.getHeight() / 4.0) : (xdelta = bounds.getWidth() / 4.0);
                        }
                        if (!edge.getCell().equals(obj)) continue;
                        if (i % 2 == 0) {
                            pos.setLocation(pos.getX() - xdelta - XY.getX(), pos.getY() - ydelta - XY.getY());
                            if (edge.getSource().equals(this)) {
                                edge.setSourceOffcet(-d - dd);
                                continue;
                            }
                            edge.setTargetOffcet(-d - dd);
                            continue;
                        }
                        pos.setLocation(pos.getX() - xdelta + XY.getX(), pos.getY() - ydelta + XY.getY());
                        if (edge.getSource().equals(this)) {
                            edge.setSourceOffcet(d - dd);
                            continue;
                        }
                        edge.setTargetOffcet(d - dd);
                    }
                } else if (edge.getSource().equals(this)) {
                    edge.setSourceOffcet(0.0);
                } else if (edge.getTarget().equals(this)) {
                    edge.setTargetOffcet(0.0);
                }
            } else if (edge.isSelfReference()) {
                Rectangle2D bs = edge.getSource().getParentView().getBounds();
                AbstractCellView cellView = (AbstractCellView)edge.getSource().getParentView();
                int ind = cellView.getSelfRefPos(edge);
                int count = cellView.selfReferences.size();
                double dx = 15.0;
                double revx = (double)(count - ind) * dx;
                if (edge.getSource().equals(this)) {
                    edge.setSourceOffcet(revx);
                    return DiagramConstants.createPoint(bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight() / DefaultEdge.SELF_REF_FACTOR + revx);
                }
                if (edge.getTarget().equals(this)) {
                    edge.setTargetOffcet(revx);
                    return DiagramConstants.createPoint(bounds.getX() + bounds.getWidth() / DefaultEdge.SELF_REF_FACTOR + revx, bounds.getY() + bounds.getHeight());
                }
            }
        }
        return pos;
    }

    private Point2D getDXY(double alphA, double alphA1, double alphA2, double alphA3, double alphA4, double d) {
        double dY;
        double dX;
        if (alphA >= alphA3) {
            dX = 0.0;
            dY = d;
        } else if (alphA >= alphA4) {
            dX = d;
            dY = 0.0;
        } else if (alphA >= alphA1) {
            dX = 0.0;
            dY = d;
        } else if (alphA >= alphA2) {
            dX = d;
            dY = 0.0;
        } else {
            dX = 0.0;
            dY = d;
        }
        return new Point2D.Double(dX, dY);
    }

    private static int getVertexSide(double alphA, double alphA1, double alphA2, double alphA3, double alphA4) {
        if (alphA >= alphA3) {
            return 1;
        }
        if (alphA >= alphA4) {
            return 2;
        }
        if (alphA >= alphA1) {
            return 3;
        }
        if (alphA >= alphA2) {
            return 4;
        }
        return 1;
    }

    private Object[] getEdgesToParentViewByCoordinate(EdgeView edge, boolean useX) {
        ArrayList result = new ArrayList();
        Point2D pvp = this.getPoint();
        double ipx = pvp.getX() - this.ip.getX();
        double ipy = pvp.getY() - this.ip.getY();
        CellView pview = this.getParentView();
        pvp = this.getFixedPoint(pvp, pview);
        if (pview == null) {
            return null;
        }
        DefaultDiagramCell cell = (DefaultDiagramCell)pview.getCell();
        if (cell == null) {
            return null;
        }
        List list = DefaultDiagramModel.getEdgesList(edge.getDiagram().getModel(), cell.getChildren().toArray());
        for (Object obj : list) {
            if (!(obj instanceof DefaultEdge)) continue;
            DefaultEdge ed = (DefaultEdge)obj;
            EdgeView ev = (EdgeView)((DefaultEdge)obj).getCellView();
            EdgeView edv = (EdgeView)ed.getTopView().getCellView();
            if (ev == null) continue;
            int k = edv.getPointCount();
            Rectangle2D r = pview.getBounds();
            PortView pv = ev.getPortViewForParent(pview);
            PortView pv2 = edv.getPortViewForParent(pview);
            if (pv == null) {
                pv = pv2;
            }
            if (pv != null) {
                int l;
                Point2D p = pv.point;
                p = this.getFixedPoint(p, pview);
                Point2D p2 = null;
                if (pv2 != null) {
                    p2 = pv2.point;
                }
                if (useX) {
                    if (pv.ip.getX() == this.ip.getX() || pvp.getX() == p.getX() || p.getX() == ipx || Math.abs(p.getX() - pv.ip.getX() - ipx) <= 6.0) {
                        result.add(obj);
                        continue;
                    }
                    l = 0;
                    ++l;
                    continue;
                }
                if (p.getY() == pvp.getY() || p.getY() - pv.ip.getY() == pvp.getY()) {
                    result.add(obj);
                    continue;
                }
                l = 0;
                ++l;
                continue;
            }
            int l = 0;
            ++l;
        }
        return list.toArray();
    }

    private static Point2D getPosition(EdgeView edge, PortView pv, AbstractCellView vertex) {
        Port modelAnchor = null;
        if (pv.cell instanceof Port) {
            modelAnchor = ((Port)pv.cell).getAnchor();
        }
        PortView anchor = (PortView)pv.mapper.getMapping(modelAnchor, false);
        Point2D pos = null;
        boolean isAbsolute = DiagramConstants.isAbsolute(pv.allAttributes);
        Point2D offset = DiagramConstants.getOffset(pv.allAttributes);
        if (vertex != null) {
            if (edge == null && offset == null) {
                pos = vertex.getCenterPoint();
            }
            if (offset != null) {
                double x = offset.getX();
                double y = offset.getY();
                Rectangle2D r = vertex.getBounds();
                if (!isAbsolute) {
                    x = x * (r.getWidth() - 1.0) / 1000.0;
                    y = y * (r.getHeight() - 1.0) / 1000.0;
                }
                AttributeMap attr = new AttributeMap();
                pos = anchor != null ? anchor.getLocation(edge) : attr.createPoint(r.getX(), r.getY());
                pos = attr.createPoint(pos.getX() + x, pos.getY() + y);
            } else if (edge != null) {
                Point2D p1 = pv.getNextPoint(edge);
                if (p1 == null) {
                    return vertex.getCenterPoint();
                }
                pos = vertex.getPerimeterPoint(pos, p1, edge.getPointCount() <= 2);
                if (edge.getPointCount() > 2 && DiagramConstants.getRouting(edge.getAllAttributes()) == null && p1 != null) {
                    Rectangle2D r = vertex.getBounds();
                    if (p1.getX() > r.getX() && p1.getX() < r.getX() + r.getWidth()) {
                        pos.setLocation(p1.getX(), pos.getY());
                    } else if (p1.getY() >= r.getY() && p1.getY() < r.getY() + r.getHeight()) {
                        pos.setLocation(pos.getX(), p1.getY());
                    }
                    if (p1.getY() < r.getY()) {
                        pos.setLocation(pos.getX(), r.getY());
                    } else if (p1.getY() > r.getY() + r.getHeight()) {
                        pos.setLocation(pos.getX(), r.getY() + r.getHeight());
                    }
                }
            }
        }
        return pos;
    }

    private Object[] getEdgesToParentViewByVertexSide(EdgeView edge, AbstractCellView vertex, Rectangle2D vbounds, int side, double[] alphas) {
        ArrayList<DefaultEdge> result = new ArrayList<DefaultEdge>();
        Point2D center = vertex.getCenterPoint();
        DefaultDiagramCell cell = (DefaultDiagramCell)vertex.getCell();
        List list = DefaultDiagramModel.getEdgesList(edge.getDiagram().getModel(), cell.getChildren().toArray());
        for (Object obj : list) {
            DefaultEdge ed;
            EdgeView edv;
            if (!(obj instanceof DefaultEdge) || (edv = (EdgeView)(ed = (DefaultEdge)obj).getTopView().getCellView()) == null) continue;
            int k = edv.getPointCount();
            Rectangle2D r = vertex.getBounds();
            PortView pv = edv.getPortViewForParent(vertex);
            if (pv == null) {
                PortView pv2;
                pv = pv2 = edv.getPortViewForParent(vertex);
            }
            if (pv == null) continue;
            Point2D pos = PortView.getPosition(edv, pv, vertex);
            double alphA = Math.atan2(center.getY() - pos.getY(), pos.getX() - center.getX());
            int pside = PortView.getVertexSide(alphA, alphas[0], alphas[1], alphas[2], alphas[3]);
            if (pside == side) {
                result.add(ed);
                continue;
            }
            int p = 0;
            ++p;
        }
        return result.toArray();
    }

    private Object[] getEdgesToParentView(EdgeView edge) {
        if (this.getParentView() == null) {
            return null;
        }
        Object cell = this.getParentView().getCell();
        if (cell == null) {
            return null;
        }
        List list = DefaultDiagramModel.getEdgesList(edge.getDiagram().getModel(), new Object[]{cell});
        return list.toArray();
    }

    private Object[] getEdges(EdgeView edge) {
        if (edge.getSource() == null || edge.getTarget() == null || edge.getSource().getParentView() == null || edge.getTarget().getParentView() == null) {
            return null;
        }
        Set edges = DefaultDiagramModel.getEdges(edge.getDiagram().getModel(), new Object[]{edge.getSource().getParentView().getCell(), edge.getTarget().getParentView().getCell()});
        return edges.toArray();
    }

    public static Object[] getEdgesBetween(AbstractDiagram diagram, Object vertex1, Object vertex2) {
        return PortView.getEdgesBetween(diagram, vertex1, vertex2, false);
    }

    public static Object[] getEdgesBetween(AbstractDiagram diagram, Object vertex1, Object vertex2, boolean directed) {
        ArrayList result = new ArrayList();
        Set edges = DefaultDiagramModel.getEdges(diagram.getModel(), new Object[]{vertex1, vertex2});
        for (Object edge : edges) {
            if (PortView.isGroup(diagram, edge)) continue;
            Object source = PortView.getSourceVertex(diagram, edge);
            Object target = PortView.getTargetVertex(diagram, edge);
            if ((source != vertex1 || target != vertex2) && (source != vertex2 || target != vertex1)) continue;
            result.add(edge);
        }
        return result.toArray();
    }

    public static Object getSourceVertex(AbstractDiagram diagram, Object edge) {
        return DefaultDiagramModel.getSourceVertex(diagram.getModel(), edge);
    }

    public static Object getTargetVertex(AbstractDiagram diagram, Object edge) {
        return DefaultDiagramModel.getTargetVertex(diagram.getModel(), edge);
    }

    public static boolean isGroup(AbstractDiagram diagram, Object cell) {
        CellView view = diagram.getDiagramLayoutCache().getMapping(cell, false);
        if (view != null) {
            return !view.isLeaf();
        }
        return false;
    }

    protected Point2D getNextPoint(EdgeView edge) {
        int n = edge.getPointCount();
        if (n > 1) {
            if (edge.getSource() == this) {
                return this.getEdgePoint(edge, 1);
            }
            if (edge.getTarget() == this) {
                return this.getEdgePoint(edge, n - 2);
            }
        }
        return null;
    }

    protected Point2D getEdgePoint(EdgeView view, int index) {
        AbstractCellView vertex;
        Object obj = view.points.get(index);
        if (obj instanceof Point2D) {
            return (Point2D)obj;
        }
        if (obj instanceof PortView && (vertex = (AbstractCellView)((CellView)obj).getParentView()) != null) {
            return vertex.getCenterPoint();
        }
        return null;
    }

    @Override
    public Point2D getCenterPoint() {
        return null;
    }

    @Override
    public Point2D getPerimeterPoint(Point2D source, Point2D p, boolean simple) {
        return null;
    }
}

