/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.process.DFDRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class StoreRenderer
extends DFDRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(100, 205, 255);

    public StoreRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
    }

    @Override
    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor dfc = this.processObject.getDesign().getDesignLevelSettings().getDefaultFCObject("Information Store");
            if (dfc != null) {
                return dfc.getBackgroundColor();
            }
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor dfc = this.processObject.getDesign().getDesignLevelSettings().getDefaultFCObject("Information Store");
            if (dfc != null) {
                return dfc.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        int leftSquareWidth = width / 5;
        TopView efo = this.getTopView();
        String StoreNbr = "D" + String.valueOf(this.processObject.getDesignObjectSet().getIndexOf(this.processObject) + 1);
        g2.setPaint(this.getBackgroundColor());
        g.fillRect(0, 0, width - 1, height - 1);
        g.setColor(this.getBorderColor());
        g.drawLine(0, 0, width - 1, 0);
        g.drawLine(0, height - 1, width - 1, height - 1);
        g.drawLine(0, 0, 0, height - 1);
        g.drawLine(leftSquareWidth, 0, leftSquareWidth, height - 1);
        Font titleFont = efo.getFontObject(EditableFonts.FO_TITLE).getFont();
        g.setFont(titleFont);
        FontMetrics fm = g.getFontMetrics();
        int yCursor = height / 2 + titleFont.getSize() / 3;
        int xCursor = (width - fm.stringWidth(this.title)) / 2;
        if (xCursor < 20) {
            xCursor = 20;
        }
        BasicStroke textStroke = new BasicStroke(1.0f);
        g2.setStroke(textStroke);
        g.setColor(efo.getFontObject(EditableFonts.FO_NUMBER).getColor());
        int xPos = (leftSquareWidth - fm.stringWidth(StoreNbr)) / 2;
        g.drawString(StoreNbr, xPos + 1, yCursor);
        g.setColor(efo.getFontObject(EditableFonts.FO_TITLE).getColor());
        xPos = xCursor + leftSquareWidth / 2;
        g.drawString(this.title, xPos, yCursor);
    }
}

