/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.ExpObject;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DMDExportsPersistence {
    private static final String FILE_NAME = "dmd_exports.xml";
    private ApplicationView appView;
    private Design design;
    private static final Logger LOGGER = new Logger(DMDExportsPersistence.class);

    DMDExportsPersistence(ApplicationView appView, Design design) {
        this.appView = appView;
        this.design = design;
    }

    void saveExports() {
        StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
        buffer.append("\n");
        buffer.append("<").append("dmd_exports").append(">");
        for (ExpObject ex : this.appView.getDMDExports()) {
            buffer.append("\n");
            buffer.append("\t").append("<").append("dmd_export").append(' ');
            buffer.append("name=\"").append(StringUtilities.encodeAttributeValue(ex.getName())).append("\"").append(' ');
            buffer.append("description=\"").append(StringUtilities.encodeAttributeValue(ex.getDescription())).append("\"").append(' ');
            buffer.append("id=\"").append(ex.getExportID()).append("\"").append(' ');
            buffer.append("design=\"").append(ex.getDesignID()).append("\"").append(">");
            List l = ex.getModels();
            if (l.size() > 0) {
                buffer.append("\n");
                buffer.append("\t").append("\t").append("<").append("models").append(">");
                for (String sw : l) {
                    buffer.append("\n");
                    buffer.append("\t").append("\t").append("\t").append("<").append("model").append(' ');
                    buffer.append("id=\"").append(sw).append("\"").append(' ');
                    buffer.append("/>");
                }
                buffer.append("\n");
                buffer.append("\t").append("\t").append("</").append("models").append(">");
            }
            if ((l = ex.getSubViews()).size() > 0) {
                buffer.append("\n");
                buffer.append("\t").append("\t").append("<").append("subviews").append(">");
                for (String sw : l) {
                    buffer.append("\n");
                    buffer.append("\t").append("\t").append("\t").append("<").append("subview").append(' ');
                    buffer.append("id=\"").append(sw).append("\"").append(' ');
                    buffer.append("/>");
                }
                buffer.append("\n");
                buffer.append("\t").append("\t").append("</").append("subviews").append(">");
            }
            buffer.append("\n");
            buffer.append("\t").append("</").append("dmd_export").append(">");
        }
        buffer.append("\n");
        buffer.append("</").append("dmd_exports").append(">");
        this.writeToFile(buffer);
    }

    private void writeToFile(StringBuffer buffer) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(this.design.getDesignPath() + "/" + this.design.getFileName(), FILE_NAME));
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(buffer.toString());
            osw.close();
        }
        catch (Exception e) {
            LOGGER.error("Unable to save DMD exports: ", e);
        }
    }

    public void loadExports() {
        try {
            File file = new File(this.design.getDesignPath() + "/" + this.design.getFileName(), FILE_NAME);
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                this.loadData(doc);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load DMD exports: ", e);
        }
    }

    private void loadData(Document doc) {
        ArrayList<ExpObject> loadedExports = new ArrayList<ExpObject>();
        NodeList nodes1 = doc.getElementsByTagName("dmd_export");
        int nodesLength1 = nodes1.getLength();
        for (int i = 0; i < nodesLength1; ++i) {
            Element elm = (Element)nodes1.item(i);
            ArrayList<String> models = new ArrayList<String>();
            NodeList modelsNode = elm.getElementsByTagName("models");
            int nodesLength = modelsNode.getLength();
            for (int j = 0; j < nodesLength; ++j) {
                Element e = (Element)modelsNode.item(j);
                NodeList elements = e.getElementsByTagName("model");
                int elementsLength = elements.getLength();
                for (int k = 0; k < elementsLength; ++k) {
                    Element e1 = (Element)elements.item(k);
                    models.add(e1.getAttribute("id"));
                }
            }
            ArrayList<String> subviews = new ArrayList<String>();
            NodeList subviewsNode = elm.getElementsByTagName("subviews");
            nodesLength = subviewsNode.getLength();
            for (int j = 0; j < nodesLength; ++j) {
                Element e = (Element)subviewsNode.item(j);
                NodeList elements = e.getElementsByTagName("subview");
                int elementsLength = elements.getLength();
                for (int k = 0; k < elementsLength; ++k) {
                    Element e1 = (Element)elements.item(k);
                    subviews.add(e1.getAttribute("id"));
                }
            }
            ExpObject ex = new ExpObject(elm.getAttribute("id"), elm.getAttribute("design"), StringUtilities.decodeAttributeValue(elm.getAttribute("name")), StringUtilities.decodeAttributeValue(elm.getAttribute("description")), models, subviews);
            loadedExports.add(ex);
        }
        this.appView.getDMDExports().clear();
        this.appView.getDMDExports().addAll(loadedExports);
    }
}

