/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SensitiveTypeUsedInDialog
extends CustomDialog {
    private JButton buttonOK;
    private JButton buttonCancel;
    private JButton buttonHelp;
    private JButton buttonAdd;
    private JButton buttonRemove;
    private JPanel generalPanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JPanel containerPanel;
    private JDialog dialog;
    private JComboBox cbDesigns;
    private JComboBox cbModels;
    private List containersList = new ArrayList();
    private List availableItems = new ArrayList();
    private List selectedItems = new ArrayList();
    private Object selectedContainer;
    private JTable containersTable;
    private JTable availableItemsTable;
    private JTable selectedItemsTable;
    private List<Design> designs;
    private List<DesignPart> models;
    private SensitiveType sensitiveType;
    private JTextField tfSensitiveDataDesc;
    private Design design;

    public SensitiveTypeUsedInDialog(ApplicationView applView, SensitiveType sensitiveType, Design design) {
        super(applView);
        this.sensitiveType = sensitiveType;
        this.design = design;
        this.initDesigns(applView);
        this.initGeneralPanel();
        this.cbDesigns.setSelectedItem(this.design);
        this.initModels(this.design);
    }

    private void initGeneralPanel() {
        this.generalPanel = new JPanel(new BorderLayout());
        this.initLeftPanel();
        this.initRightPanel();
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        this.buttonOK = new JButton(this.createButtonOK());
        this.buttonOK.setMnemonic(79);
        this.buttonCancel = new JButton(this.createCancelButton());
        this.buttonCancel.setMnemonic(67);
        this.buttonHelp = new JButton(this.getHelpAction());
        this.buttonHelp.setMnemonic(72);
        buttonsPanel.add(this.buttonOK);
        buttonsPanel.add(this.buttonCancel);
        buttonsPanel.add(this.buttonHelp);
        this.buttonOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.generalPanel.add((Component)this.leftPanel, "West");
        this.generalPanel.add((Component)this.rightPanel, "Center");
        this.generalPanel.add((Component)buttonsPanel, "South");
        this.add((Component)this.generalPanel, "Center");
        this.generalPanel.setPreferredSize(new Dimension(700, 600));
        if (!this.containersList.isEmpty()) {
            this.containersTable.changeSelection(0, 0, false, false);
            this.containersTable.updateUI();
        }
    }

    private void initDesigns(ApplicationView appView) {
        this.designs = new ArrayList<Design>();
        this.models = new ArrayList<DesignPart>();
        for (Design design : appView.getDesigns()) {
            this.designs.add(design);
        }
    }

    private void initModels(Design design) {
        if (design != null) {
            this.models.clear();
            LogicalDesign logicalDesign = design.getLogicalDesign();
            this.models.add(logicalDesign);
            this.initLogicalDesign(logicalDesign);
            this.models.addAll(design.getRelationalDesigns().getElementsList());
            this.cbModels.removeAllItems();
            Iterator<DesignPart> it = this.models.iterator();
            while (it.hasNext()) {
                this.cbModels.addItem(it.next());
            }
        }
    }

    private void initLeftPanel() {
        this.leftPanel = new JPanel(new BorderLayout());
        this.containerPanel = new JPanel(new BorderLayout());
        JPanel elementList = new JPanel(new BorderLayout(10, 10));
        elementList.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectUsedInDialog.TablesEntities")));
        this.containersTable = new JTable(new ContainersModel());
        this.containersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SensitiveTypeUsedInDialog.this.initAvailableItems();
                }
            }
        });
        JPanel modelsPanel = new JPanel(new BorderLayout(10, 10));
        Dimension dim = new Dimension(170, 20);
        this.cbDesigns = new JComboBox<Object>(this.designs.toArray());
        this.cbDesigns.setEnabled(false);
        this.cbDesigns.setPreferredSize(dim);
        this.cbModels = new JComboBox();
        this.cbModels.setPreferredSize(dim);
        this.cbModels.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SensitiveTypeUsedInDialog.this.containersList.clear();
                SensitiveTypeUsedInDialog.this.availableItems.clear();
                Object designPart = evt.getItem();
                if (designPart instanceof LogicalDesign) {
                    SensitiveTypeUsedInDialog.this.initLogicalDesign((LogicalDesign)designPart);
                } else if (designPart instanceof RelationalDesign) {
                    SensitiveTypeUsedInDialog.this.initRelationalDesign((RelationalDesign)designPart);
                }
                SensitiveTypeUsedInDialog.this.containersTable.clearSelection();
                SensitiveTypeUsedInDialog.this.containersTable.updateUI();
                SensitiveTypeUsedInDialog.this.availableItemsTable.updateUI();
            }
        });
        JPanel pnDesigns = new JPanel(new BorderLayout());
        pnDesigns.add((Component)new JLabel(Messages.getString("SensitiveTypeUsedInDialog.Design")), "West");
        pnDesigns.add((Component)this.cbDesigns, "East");
        JPanel pnModels = new JPanel(new BorderLayout());
        pnModels.add((Component)new JLabel(Messages.getString("SensitiveTypeUsedInDialog.Model")), "West");
        pnModels.add((Component)this.cbModels, "East");
        modelsPanel.add((Component)pnDesigns, "North");
        modelsPanel.add((Component)pnModels, "Center");
        elementList.add((Component)modelsPanel, "North");
        JScrollPane scrollPane = new JScrollPane(this.containersTable);
        scrollPane.setPreferredSize(new Dimension(220, 600));
        elementList.add(scrollPane);
        this.containerPanel.add((Component)elementList, "Center");
        this.leftPanel.add(this.containerPanel);
    }

    private void initAvailableItems() {
        int selectedRow = this.containersTable.getSelectedRow();
        this.availableItems.clear();
        if (selectedRow > -1) {
            this.selectedContainer = this.containersList.get(selectedRow);
            if (this.selectedContainer instanceof Table) {
                for (Column column : (Column[])((ContainerWithKeyObject)this.selectedContainer).getElements()) {
                    if (this.selectedItems.contains(column)) continue;
                    this.availableItems.add(column);
                }
            } else if (this.selectedContainer instanceof Entity) {
                for (Attribute attribute : (Attribute[])((ContainerWithKeyObject)this.selectedContainer).getElements()) {
                    if (this.selectedItems.contains(attribute)) continue;
                    this.availableItems.add(attribute);
                }
            }
        } else {
            this.selectedContainer = null;
        }
        this.selectedItemsTable.updateUI();
        this.availableItemsTable.updateUI();
    }

    private void initRightPanel() {
        this.rightPanel = new JPanel(new BorderLayout());
        this.rightPanel.add((Component)this.createAvailableItemsPanel(), "North");
        JPanel bottomRightPanel = new JPanel(new BorderLayout());
        bottomRightPanel.add((Component)this.createAddRemoveButtonsPanel(), "North");
        bottomRightPanel.add((Component)this.createSelectedItemsPanel(), "Center");
        bottomRightPanel.add((Component)this.createSensitiveDataDescPanel(), "South");
        this.rightPanel.add((Component)bottomRightPanel, "Center");
    }

    private JPanel createAvailableItemsPanel() {
        JPanel availableItemsPanel = new JPanel(new BorderLayout());
        this.availableItemsTable = new JTable(new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return Messages.getString("SelectUsedInDialog.Name");
                }
                if (column == 1) {
                    return Messages.getString("SelectUsedInDialog.Type");
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int arg0, int arg1) {
                return false;
            }

            @Override
            public int getRowCount() {
                return SensitiveTypeUsedInDialog.this.availableItems.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                Object item = SensitiveTypeUsedInDialog.this.availableItems.get(row);
                if (SensitiveTypeUsedInDialog.this.availableItems != null) {
                    if (column == 0) {
                        return ((ContainedObjectWithDomain)item).getName();
                    }
                    if (column == 1) {
                        return ((ContainedObjectWithDomain)item).getGenericDatatypeString();
                    }
                    return null;
                }
                return null;
            }
        });
        this.availableItemsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SensitiveTypeUsedInDialog.this.availableItemsTable.getSelectedRow() == -1) {
                    SensitiveTypeUsedInDialog.this.buttonAdd.setEnabled(false);
                } else {
                    SensitiveTypeUsedInDialog.this.buttonAdd.setEnabled(true);
                }
            }
        });
        JScrollPane pane = new JScrollPane(this.availableItemsTable);
        pane.setPreferredSize(new Dimension(280, 220));
        availableItemsPanel.add(pane);
        availableItemsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SensitiveTypeUsedInDialog.ColumnsAttributes")));
        return availableItemsPanel;
    }

    private JPanel createSelectedItemsPanel() {
        JPanel selectedItemsPanel = new JPanel(new BorderLayout());
        this.selectedItemsTable = new JTable(new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return Messages.getString("SelectUsedInDialog.Model");
                }
                if (column == 1) {
                    return Messages.getString("TSDPPolicyPropertiesDialog.TableEntity");
                }
                if (column == 2) {
                    return Messages.getString("SelectUsedInDialog.Name");
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int arg0, int arg1) {
                return false;
            }

            @Override
            public int getRowCount() {
                return SensitiveTypeUsedInDialog.this.selectedItems.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (SensitiveTypeUsedInDialog.this.selectedItems != null) {
                    Object selectedItem = SensitiveTypeUsedInDialog.this.selectedItems.get(row);
                    if (column == 0) {
                        return ((ContainedObjectWithDomain)selectedItem).getDesignPart().getName();
                    }
                    if (column == 1) {
                        return ((ContainedObjectWithDomain)selectedItem).getContainer();
                    }
                    if (column == 2) {
                        return ((ContainedObjectWithDomain)selectedItem).getName();
                    }
                    return null;
                }
                return null;
            }
        });
        this.selectedItemsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SensitiveTypeUsedInDialog.this.selectedItemsTable.getSelectedRow() == -1) {
                    SensitiveTypeUsedInDialog.this.buttonRemove.setEnabled(false);
                } else {
                    SensitiveTypeUsedInDialog.this.buttonRemove.setEnabled(true);
                }
            }
        });
        TableColumn column = this.selectedItemsTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(40);
        JScrollPane pane = new JScrollPane(this.selectedItemsTable);
        pane.setPreferredSize(new Dimension(280, 220));
        selectedItemsPanel.add(pane);
        selectedItemsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectUsedInDialog.SelectedItems")));
        return selectedItemsPanel;
    }

    private JPanel createSensitiveDataDescPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TSDPPolicyPropertiesDialog.SensitiveDataDesc")));
        this.tfSensitiveDataDesc = new JTextField();
        jpanel.add((Component)this.tfSensitiveDataDesc, "Center");
        return jpanel;
    }

    private void initLogicalDesign(LogicalDesign logicalDesign) {
        Iterator entitiesIterator = logicalDesign.getEntitySet().iterator();
        while (entitiesIterator.hasNext()) {
            this.containersList.add(entitiesIterator.next());
        }
    }

    private void initRelationalDesign(RelationalDesign relationalDesign) {
        Iterator tablesIterator = relationalDesign.getTableSet().iterator();
        while (tablesIterator.hasNext()) {
            this.containersList.add(tablesIterator.next());
        }
    }

    private JPanel createAddRemoveButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.buttonAdd = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
        this.buttonAdd.addActionListener(new AddItemActionListener());
        this.buttonAdd.setEnabled(false);
        this.buttonAdd.setToolTipText(Messages.getString("SelectUsedInDialog.Add"));
        this.buttonRemove = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.addActionListener(new RemoveObjectActionListener());
        this.buttonRemove.setToolTipText(Messages.getString("SelectUsedInDialog.Remove"));
        this.buttonAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonRemove.setPreferredSize(this.buttonAdd.getPreferredSize());
        buttonsPanel.add((Component)this.buttonAdd, "West");
        buttonsPanel.add((Component)this.buttonRemove, "Center");
        return buttonsPanel;
    }

    @Override
    protected String getHelpIndex() {
        return "CLASSIFICATION_TYPES_DIALOG";
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("SensitiveTypeUsedInDialog.AddColumnsAttributes"), true);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.buttonOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public Action createCancelButton() {
        AbstractAction action = new AbstractAction(Messages.getString("SelectUsedInDialog.Cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensitiveTypeUsedInDialog.this.close();
            }
        };
        return action;
    }

    public Action createButtonOK() {
        AbstractAction action = new AbstractAction(Messages.getString("SelectUsedInDialog.OK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensitiveTypeUsedInDialog.this.setSensitiveType();
                SensitiveTypeUsedInDialog.this.close();
            }
        };
        return action;
    }

    public void setSensitiveType() {
        for (Object selectedItem : this.selectedItems) {
            if (!(selectedItem instanceof ContainedObjectWithDomain)) continue;
            ((ContainedObjectWithDomain)selectedItem).setSensitiveType(this.sensitiveType);
            ((ContainedObjectWithDomain)selectedItem).setSensitiveTypeDescription(this.tfSensitiveDataDesc.getText());
            ((ContainedObjectWithDomain)selectedItem).setDirty(true);
        }
    }

    private class RemoveObjectActionListener
    implements ActionListener {
        private RemoveObjectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = SensitiveTypeUsedInDialog.this.selectedItemsTable.getSelectedRows();
            for (int i = selected.length - 1; i >= 0; --i) {
                ContainedObjectWithDomain selectedItem = (ContainedObjectWithDomain)SensitiveTypeUsedInDialog.this.selectedItems.remove(selected[i]);
                if (!selectedItem.getContainer().equals(SensitiveTypeUsedInDialog.this.selectedContainer)) continue;
                SensitiveTypeUsedInDialog.this.availableItems.add(selectedItem);
            }
            SensitiveTypeUsedInDialog.this.selectedItemsTable.clearSelection();
            SensitiveTypeUsedInDialog.this.selectedItemsTable.updateUI();
            SensitiveTypeUsedInDialog.this.availableItemsTable.updateUI();
        }
    }

    private class AddItemActionListener
    implements ActionListener {
        private AddItemActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = SensitiveTypeUsedInDialog.this.availableItemsTable.getSelectedRows();
            for (int i = selected.length - 1; i >= 0; --i) {
                SensitiveTypeUsedInDialog.this.selectedItems.add(SensitiveTypeUsedInDialog.this.availableItems.remove(selected[i]));
            }
            Collections.sort(SensitiveTypeUsedInDialog.this.selectedItems, new Comparator(){

                public int compare(Object item1, Object item2) {
                    Object item1Str = "";
                    Object item2Str = "";
                    if (item1 instanceof ContainedObjectWithDomain) {
                        ContainedObjectWithDomain item11 = (ContainedObjectWithDomain)item1;
                        item1Str = item11.getDesignPart().getName() + item11.getContainer().getName() + item11.getName();
                    }
                    if (item2 instanceof ContainedObjectWithDomain) {
                        ContainedObjectWithDomain item22 = (ContainedObjectWithDomain)item2;
                        item2Str = item22.getDesignPart().getName() + item22.getContainer().getName() + item22.getName();
                    }
                    return ((String)item1Str).compareTo((String)item2Str);
                }
            });
            SensitiveTypeUsedInDialog.this.availableItemsTable.clearSelection();
            SensitiveTypeUsedInDialog.this.availableItemsTable.updateUI();
            SensitiveTypeUsedInDialog.this.selectedItemsTable.updateUI();
        }
    }

    public class ContainersModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return SensitiveTypeUsedInDialog.this.containersList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SelectUsedInDialog.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return SensitiveTypeUsedInDialog.this.containersList.get(row);
        }
    }
}

