/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.EntityViewSet;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.logical.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.MoveUpDownListJTable;

public class EntityViewBuilder
extends JPanel {
    public static final String MODIFY_LABEL = Messages.getString("EntityViewBuilder.Modify");
    public static final String ADD_LABEL = Messages.getString("EntityViewBuilder.Add");
    protected JDialog dialog;
    protected JPanel buttonPanel;
    protected JTabbedPane tpane;
    protected JPanel general;
    protected JPanel tablesPanel = new JPanel(new SpringLayout());
    protected JPanel columnsPanel = new JPanel(new SpringLayout());
    protected JPanel wherePanel = new JPanel(new SpringLayout());
    protected JPanel groupByPanel = new JPanel(new SpringLayout());
    protected JPanel havingPanel = new JPanel(new SpringLayout());
    protected JPanel orderByPanel = new JPanel(new SpringLayout());
    protected JPanel previewPanel = new JPanel(new SpringLayout());
    protected JPanel ddlPanel = new JPanel(new SpringLayout());
    protected JTextArea sqlArea = new JTextArea();
    protected JTextArea defineDDLArea = new JTextArea();
    protected JTextArea whereArea = new JTextArea();
    protected JTextArea groupByArea = new JTextArea();
    protected JTextArea havingArea = new JTextArea();
    protected JCheckBox defineDDLChBox;
    protected JButton defineWhere;
    protected DefaultListModel allTablesModel;
    protected JList allTablesList;
    protected SelectedTablesTable selectedTablesTable;
    protected JButton bnAddTables;
    protected JButton bnRemoveTables;
    protected JButton bnMoveUpTable;
    protected JButton bnMoveDownTable;
    private List containerList = new ArrayList();
    protected DefaultListModel allColumnsModel;
    protected JList allColumnsList;
    protected JTable selectedColumnsTable;
    protected JButton bnAddColumns;
    protected JButton bnRemoveColumns;
    protected JButton bnNewExpression;
    private List attributeViewList = new ArrayList();
    protected DefaultListModel allColumnsOrderByModel;
    protected JList allColumnsOrderByList;
    protected SelectedOrderByColumnsTable selectedOrderByColumnsTable;
    protected JButton bnAddOrderByColumns;
    protected JButton bnRemoveOrderByColumns;
    protected JButton bnNewOrderByColumns;
    private List orderByList = new ArrayList();
    protected EntityView view;
    protected LogicalDesign design;
    private ContainerObject contObject;
    private List expressionList = new ArrayList();

    public EntityViewBuilder(ContainerObject object) {
        this.contObject = object;
    }

    public JDialog getDialog(ApplicationView applView) {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)applView.getFrame(), Messages.getString("EntityViewBuilder.ViewBuilder"));
            this.general = new JPanel(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.general, "Center");
            this.dialog.getContentPane().add((Component)this.getButtonPanel(), "East");
            this.tpane = new JTabbedPane();
            this.general.add((Component)this.tpane, "Center");
            this.tpane.addTab(Messages.getString("EntityViewBuilder.Entities"), this.tablesPanel);
            this.tpane.addTab(Messages.getString("EntityViewBuilder.Attributes"), this.columnsPanel);
            this.tpane.addTab(Messages.getString("EntityViewBuilder.Where"), this.wherePanel);
            this.tpane.addTab(Messages.getString("EntityViewBuilder.GroupBy"), this.groupByPanel);
            this.tpane.addTab(Messages.getString("EntityViewBuilder.Having"), this.havingPanel);
            this.tpane.addTab(Messages.getString("EntityViewBuilder.OrderBy"), this.orderByPanel);
            this.tpane.addTab(Messages.getString("EntityViewBuilder.Preview"), this.previewPanel);
            this.tpane.addTab(Messages.getString("EntityViewBuilder.DefineDDL"), this.ddlPanel);
            this.tpane.addChangeListener(new TabChangeListener());
            this.initTablesPane();
            this.initColumnsPane();
            this.initWherePane();
            this.initGroupByPane();
            this.initHavingPane();
            this.initOrderByPane();
            this.initPreviewPane();
            this.initDefineDDLPane();
            this.dialog.setModal(true);
            this.dialog.setSize(new Dimension(775, 355));
            this.dialog.setResizable(false);
        }
        CommonUtil.centerOnScreen(this.dialog);
        this.clear();
        this.initProperties(this.contObject);
        return this.dialog;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout());
            this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel panel = new JPanel(new GridLayout(3, 1, 5, 5));
            JButton ok = new JButton(Messages.getString("EntityViewBuilder.OK"));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityViewBuilder.this.stopTableCellEditing(EntityViewBuilder.this.selectedTablesTable);
                    EntityViewBuilder.this.stopTableCellEditing(EntityViewBuilder.this.selectedColumnsTable);
                    EntityViewBuilder.this.stopTableCellEditing(EntityViewBuilder.this.selectedOrderByColumnsTable);
                    if (EntityViewBuilder.this.canExit()) {
                        EntityViewBuilder.this.setProperties();
                        EntityViewBuilder.this.dialog.dispose();
                    }
                }
            });
            ok.setCursor(Cursor.getPredefinedCursor(12));
            ok.setMnemonic(79);
            JButton apply = new JButton(Messages.getString("EntityViewBuilder.Apply"));
            apply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityViewBuilder.this.stopTableCellEditing(EntityViewBuilder.this.selectedTablesTable);
                    EntityViewBuilder.this.stopTableCellEditing(EntityViewBuilder.this.selectedColumnsTable);
                    EntityViewBuilder.this.stopTableCellEditing(EntityViewBuilder.this.selectedOrderByColumnsTable);
                    if (EntityViewBuilder.this.canExit()) {
                        EntityViewBuilder.this.setProperties();
                    }
                }
            });
            apply.setCursor(Cursor.getPredefinedCursor(12));
            apply.setMnemonic(65);
            JButton cancel = new JButton(Messages.getString("EntityViewBuilder.Cancel"));
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityViewBuilder.this.dialog.dispose();
                }
            });
            cancel.setMnemonic(67);
            cancel.setCursor(Cursor.getPredefinedCursor(12));
            ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            apply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            panel.add(ok);
            panel.add(apply);
            panel.add(cancel);
            this.buttonPanel.add((Component)panel, "North");
        }
        return this.buttonPanel;
    }

    protected SpringLayout getPanelLayout(JPanel panel) {
        return (SpringLayout)panel.getLayout();
    }

    protected void initTablesPane() {
        this.initAllTablesList();
        this.initSelectedTablesList();
        this.initTablesButtons();
    }

    protected void initColumnsPane() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initColumnsButtons();
    }

    protected void initWherePane() {
        JScrollPane sp = new JScrollPane(this.whereArea);
        sp.setPreferredSize(new Dimension(645, 285));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.wherePanel.add(sp);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.wherePanel), sp, 10, 12);
    }

    protected void initGroupByPane() {
        JScrollPane sp = new JScrollPane(this.groupByArea);
        this.groupByArea.setEditable(false);
        sp.setPreferredSize(new Dimension(645, 285));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.groupByPanel.add(sp);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.groupByPanel), sp, 10, 12);
    }

    protected void initHavingPane() {
        JScrollPane sp = new JScrollPane(this.havingArea);
        sp.setPreferredSize(new Dimension(645, 285));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.havingPanel.add(sp);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.havingPanel), sp, 10, 12);
    }

    protected void initOrderByPane() {
        this.initAllColumnsOrderByList();
        this.initSelectedColumnsOrderByList();
        this.initColumnsOrderByButtons();
    }

    protected void initPreviewPane() {
        JScrollPane sp = new JScrollPane(this.sqlArea);
        sp.setPreferredSize(new Dimension(645, 285));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.previewPanel.add(sp);
        this.sqlArea.setEnabled(false);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.previewPanel), sp, 10, 12);
    }

    protected void initDefineDDLPane() {
        this.defineDDLChBox = new JCheckBox(Messages.getString("EntityViewBuilder.UserDefinedDDL"));
        this.defineDDLChBox.addActionListener(new CheckBoxListener());
        this.ddlPanel.add(this.defineDDLChBox);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.ddlPanel), this.defineDDLChBox, 10, 12);
        JScrollPane sp = new JScrollPane(this.defineDDLArea);
        sp.setPreferredSize(new Dimension(645, 255));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.ddlPanel.add(sp);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.ddlPanel), sp, 10, 42);
    }

    protected void initAllTablesList() {
        JLabel label = new JLabel(Messages.getString("EntityViewBuilder.AvailableEntities"));
        this.tablesPanel.add(label);
        this.allTablesModel = new DefaultListModel();
        this.allTablesList = new JList(this.allTablesModel);
        ListSelectionModel listSelectionModel = this.allTablesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListTablesSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allTablesList);
        sp.setPreferredSize(new Dimension(210, 265));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.tablesPanel.add(sp);
        CommonUtil.setLabelConstraints(this.getPanelLayout(this.tablesPanel), label, 12, 14);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), sp, 10, 32);
    }

    protected void initSelectedTablesList() {
        this.selectedTablesTable = new SelectedTablesTable();
        this.selectedTablesTable.setModel(new SelectedTablesModel());
        JPanel tblButtonsPanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        MoveUpDownListJTable upDown = new MoveUpDownListJTable(this.containerList, this.selectedTablesTable);
        this.bnMoveUpTable = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
        this.bnMoveUpTable.setToolTipText(Messages.getString("EntityViewBuilder.MoveUp"));
        this.bnMoveUpTable.addActionListener(new MoveUpDownListJTable.MoveUpAction(upDown));
        toolBar.add(this.bnMoveUpTable);
        this.bnMoveDownTable = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
        this.bnMoveDownTable.setToolTipText(Messages.getString("EntityViewBuilder.MoveDown"));
        this.bnMoveDownTable.addActionListener(new MoveUpDownListJTable.MoveDownAction(upDown));
        toolBar.add(this.bnMoveDownTable);
        tblButtonsPanel.add((Component)toolBar, "North");
        ListSelectionModel listSelectionModel = this.selectedTablesTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedTablesHandler());
        JScrollPane sp = new JScrollPane(this.selectedTablesTable);
        sp.setPreferredSize(new Dimension(325, 248));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        tblButtonsPanel.add((Component)sp, "Center");
        this.tablesPanel.add(tblButtonsPanel);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), tblButtonsPanel, 332, 14);
    }

    protected void initTablesButtons() {
        this.bnAddTables = new JButton(ADD_LABEL);
        this.bnAddTables.addActionListener(new AddTablesActionListener());
        this.bnAddTables.setPreferredSize(new Dimension(90, 26));
        this.bnAddTables.setEnabled(false);
        this.tablesPanel.add(this.bnAddTables);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), this.bnAddTables, 232, 32);
        this.bnRemoveTables = new JButton(Messages.getString("EntityViewBuilder.Remove"));
        this.bnRemoveTables.setEnabled(false);
        this.bnRemoveTables.addActionListener(new RemoveTablesActionListener());
        this.bnRemoveTables.setPreferredSize(new Dimension(90, 26));
        this.tablesPanel.add(this.bnRemoveTables);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), this.bnRemoveTables, 232, 62);
    }

    protected void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("EntityViewBuilder.AvailableAttributes"));
        this.columnsPanel.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        this.allColumnsList.setCellRenderer(new AllListColumnsCellRenderer());
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListColumnsSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(210, 265));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsPanel.add(sp);
        CommonUtil.setLabelConstraints(this.getPanelLayout(this.columnsPanel), label, 12, 14);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), sp, 10, 32);
    }

    protected void initSelectedColumnsList() {
        this.selectedColumnsTable = new JTable();
        this.selectedColumnsTable.setModel(new SelectedAttributesModel());
        this.selectedColumnsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        TableColumn column = null;
        block5: for (int i = 0; i < 3; ++i) {
            column = this.selectedColumnsTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setCellEditor(new ExpressionCellEditor());
                    column.setPreferredWidth(120);
                    continue block5;
                }
                case 1: {
                    column.setCellRenderer(new LabelTableCellRenderer());
                    column.setCellEditor(new TextCellEditor());
                    column.setPreferredWidth(60);
                    continue block5;
                }
                case 2: {
                    column.setCellRenderer(new CheckBoxTableCellRenderer());
                    column.setCellEditor(new CheckBoxEditor());
                    column.setPreferredWidth(40);
                }
            }
        }
        JPanel tblButtonsPanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        MoveUpDownListJTable upDown = new MoveUpDownListJTable(this.attributeViewList, this.selectedColumnsTable);
        this.bnMoveUpTable = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
        this.bnMoveUpTable.setToolTipText(Messages.getString("EntityViewBuilder.MoveUp"));
        this.bnMoveUpTable.addActionListener(new MoveUpDownListJTable.MoveUpAction(upDown));
        toolBar.add(this.bnMoveUpTable);
        this.bnMoveDownTable = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
        this.bnMoveDownTable.setToolTipText(Messages.getString("EntityViewBuilder.MoveDown"));
        this.bnMoveDownTable.addActionListener(new MoveUpDownListJTable.MoveDownAction(upDown));
        toolBar.add(this.bnMoveDownTable);
        tblButtonsPanel.add((Component)toolBar, "North");
        ListSelectionModel listSelectionModel = this.selectedColumnsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsTable);
        sp.setPreferredSize(new Dimension(325, 248));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        tblButtonsPanel.add((Component)sp, "Center");
        this.columnsPanel.add(tblButtonsPanel);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), tblButtonsPanel, 332, 14);
    }

    protected void initColumnsButtons() {
        this.bnAddColumns = new JButton(ADD_LABEL);
        this.bnAddColumns.addActionListener(new AddColumnsActionListener());
        this.bnAddColumns.setPreferredSize(new Dimension(90, 26));
        this.bnAddColumns.setEnabled(false);
        this.columnsPanel.add(this.bnAddColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), this.bnAddColumns, 232, 32);
        this.bnNewExpression = new JButton(Messages.getString("EntityViewBuilder.New"));
        this.bnNewExpression.setEnabled(false);
        this.bnNewExpression.addActionListener(new NewExpressionActionListener());
        this.bnNewExpression.setPreferredSize(new Dimension(90, 26));
        this.columnsPanel.add(this.bnNewExpression);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), this.bnNewExpression, 232, 62);
        this.bnRemoveColumns = new JButton(Messages.getString("EntityViewBuilder.Remove"));
        this.bnRemoveColumns.setEnabled(false);
        this.bnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.bnRemoveColumns.setPreferredSize(new Dimension(90, 26));
        this.columnsPanel.add(this.bnRemoveColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), this.bnRemoveColumns, 232, 92);
    }

    protected void initAllColumnsOrderByList() {
        JLabel label = new JLabel(Messages.getString("EntityViewBuilder.AvailableAttributes"));
        this.orderByPanel.add(label);
        this.allColumnsOrderByModel = new DefaultListModel();
        this.allColumnsOrderByList = new JList(this.allColumnsOrderByModel);
        this.allColumnsOrderByList.setCellRenderer(new AllListOrderByColumnsCellRenderer());
        ListSelectionModel listSelectionModel = this.allColumnsOrderByList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListColumnsOrderBySelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsOrderByList);
        sp.setPreferredSize(new Dimension(210, 265));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.orderByPanel.add(sp);
        CommonUtil.setLabelConstraints(this.getPanelLayout(this.orderByPanel), label, 12, 14);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), sp, 10, 32);
    }

    protected void initSelectedColumnsOrderByList() {
        this.selectedOrderByColumnsTable = new SelectedOrderByColumnsTable();
        this.selectedOrderByColumnsTable.setModel(new SelectedOrderByColumnsModel());
        JPanel tblButtonsPanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        MoveUpDownListJTable upDown = new MoveUpDownListJTable(this.orderByList, this.selectedOrderByColumnsTable);
        this.bnMoveUpTable = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
        this.bnMoveUpTable.setToolTipText(Messages.getString("EntityViewBuilder.MoveUp"));
        this.bnMoveUpTable.addActionListener(new MoveUpDownListJTable.MoveUpAction(upDown));
        toolBar.add(this.bnMoveUpTable);
        this.bnMoveDownTable = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
        this.bnMoveDownTable.setToolTipText(Messages.getString("EntityViewBuilder.MoveDown"));
        this.bnMoveDownTable.addActionListener(new MoveUpDownListJTable.MoveDownAction(upDown));
        toolBar.add(this.bnMoveDownTable);
        tblButtonsPanel.add((Component)toolBar, "North");
        ListSelectionModel listSelectionModel = this.selectedOrderByColumnsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedOrderByColumnsHandler());
        TableColumn column = null;
        for (int i = 0; i < 2; ++i) {
            column = this.selectedOrderByColumnsTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(120);
                continue;
            }
            if (i != 1) continue;
            column.setPreferredWidth(60);
        }
        JScrollPane sp = new JScrollPane(this.selectedOrderByColumnsTable);
        sp.setPreferredSize(new Dimension(325, 248));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        tblButtonsPanel.add((Component)sp, "Center");
        this.orderByPanel.add(tblButtonsPanel);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), tblButtonsPanel, 332, 14);
    }

    protected void initColumnsOrderByButtons() {
        this.bnAddOrderByColumns = new JButton(ADD_LABEL);
        this.bnAddOrderByColumns.addActionListener(new AddOrderByColumnsActionListener());
        this.bnAddOrderByColumns.setPreferredSize(new Dimension(90, 26));
        this.bnAddOrderByColumns.setEnabled(false);
        this.orderByPanel.add(this.bnAddOrderByColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), this.bnAddOrderByColumns, 232, 32);
        this.bnNewOrderByColumns = new JButton(Messages.getString("EntityViewBuilder.New"));
        this.bnNewOrderByColumns.setEnabled(false);
        this.bnNewOrderByColumns.addActionListener(new NewOrderByColumnsActionListener());
        this.bnNewOrderByColumns.setPreferredSize(new Dimension(90, 26));
        this.orderByPanel.add(this.bnNewOrderByColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), this.bnNewOrderByColumns, 232, 62);
        this.bnRemoveOrderByColumns = new JButton(Messages.getString("EntityViewBuilder.Remove"));
        this.bnRemoveOrderByColumns.setEnabled(false);
        this.bnRemoveOrderByColumns.addActionListener(new RemoveOrderByColumnsActionListener());
        this.bnRemoveOrderByColumns.setPreferredSize(new Dimension(90, 26));
        this.orderByPanel.add(this.bnRemoveOrderByColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), this.bnRemoveOrderByColumns, 232, 92);
    }

    private String appendQuotes(String name) {
        if (name.trim().indexOf(32) > -1) {
            return "\"" + name + "\"";
        }
        return name;
    }

    private boolean hasGroupBy() {
        for (AttributeElement elem : this.attributeViewList) {
            if (!elem.getGroupBy()) continue;
            return true;
        }
        return false;
    }

    protected String generateGroupBy() {
        StringBuffer buff = new StringBuffer();
        boolean first = true;
        for (AttributeElement elem : this.attributeViewList) {
            if (!elem.getGroupBy()) continue;
            if (first) {
                first = false;
            } else {
                buff.append(",");
                buff.append("\n");
            }
            buff.append(this.appendQuotes(this.getValue(elem.getAttributeView())));
        }
        return buff.toString();
    }

    protected String generateSQL() {
        StringBuffer buff = new StringBuffer();
        if (this.selectedColumnsTable.getRowCount() > 0) {
            String alias;
            this.stopTableCellEditing(this.selectedColumnsTable);
            buff = new StringBuffer("CREATE VIEW ");
            buff.append(this.appendQuotes(this.view.getName()));
            int i = 0;
            for (Object elem : this.attributeViewList) {
                AttributeView attrView = ((AttributeElement)elem).getAttributeView();
                alias = attrView.getAlias().trim();
                if ("".equals(alias)) {
                    alias = ((AttributeElement)elem).getAlias();
                }
                if (attrView.toString().trim().equalsIgnoreCase("")) continue;
                if (i == 0) {
                    buff.append("\n");
                    buff.append("  (");
                } else {
                    buff.append(",\n   ");
                }
                buff.append(' ');
                if (!alias.trim().equalsIgnoreCase("")) {
                    buff.append(this.appendQuotes(alias));
                } else {
                    buff.append(this.appendQuotes(attrView.getReferencedName()));
                }
                ++i;
            }
            buff.append(' ');
            buff.append(')');
            buff.append("\n");
            buff.append("AS SELECT\n   ");
            i = 0;
            for (Object elem : this.attributeViewList) {
                String elem_alias = ((AttributeElement)elem).getAlias().trim();
                AttributeView cv = ((AttributeElement)elem).getAttributeView();
                if (((AttributeElement)elem).getAttributeView().toString().equalsIgnoreCase("")) continue;
                if (i > 0) {
                    buff.append(",\n   ");
                }
                buff.append(' ');
                if (((AttributeElement)elem).getAttributeView().getEntityAlias().equalsIgnoreCase("")) {
                    if (!cv.getExpression().equals("")) {
                        buff.append(this.appendQuotes(cv.getExpression()));
                        if (!"".equals(elem_alias)) {
                            buff.append(" ").append(elem_alias);
                        }
                    } else if (((AttributeElement)elem).getAlias().equalsIgnoreCase("")) {
                        buff.append(this.appendQuotes(((AttributeElement)elem).getAttributeView().getAlias()));
                    } else {
                        buff.append(this.appendQuotes(((AttributeElement)elem).getAttributeView().getName()));
                    }
                } else {
                    String alias2 = ((AttributeElement)elem).getAttributeView().getEntityAlias().trim();
                    if (!cv.getExpression().equals("")) {
                        buff.append(this.appendQuotes(cv.getExpression()));
                        if (!"".equals(elem_alias)) {
                            buff.append(" ").append(elem_alias);
                        }
                    } else if (!"".equals(alias2)) {
                        buff.append(this.appendQuotes(alias2) + "." + this.appendQuotes(((AttributeElement)elem).getAttributeView().getReferencedName()));
                    } else {
                        buff.append(this.appendQuotes(((AttributeElement)elem).getAttributeView().getReferencedName()));
                    }
                }
                ++i;
            }
            if (this.containerList.size() > 0) {
                if (this.containerList.size() > 0) {
                    buff.append("\n");
                    buff.append(" FROM \n");
                }
                i = 0;
                for (Object elem : this.containerList) {
                    if (i > 0) {
                        buff.append(",\n    ");
                    } else {
                        buff.append("    ");
                    }
                    if (((ContainerElement)elem).getContainerObject() != null) {
                        String contName = ((ContainerElement)elem).getContainerObject().getName();
                        alias = ((ContainerElement)elem).getContainerAlias();
                        buff.append(this.appendQuotes(contName));
                        if (!contName.trim().equalsIgnoreCase(alias)) {
                            buff.append(' ');
                            buff.append(this.appendQuotes(alias));
                        }
                    }
                    ++i;
                }
            }
            if (!this.whereArea.getText().trim().equalsIgnoreCase("")) {
                buff.append("\n");
                buff.append(" WHERE \n");
                buff.append("    ");
                buff.append(this.whereArea.getText());
            }
            if (this.hasGroupBy()) {
                buff.append("\n");
                buff.append(" GROUP BY \n");
                buff.append(this.generateGroupBy());
            }
            if (!this.havingArea.getText().trim().equalsIgnoreCase("")) {
                buff.append("\n");
                buff.append(" HAVING \n");
                buff.append("    ");
                buff.append(this.havingArea.getText());
            }
            if (this.orderByList.size() > 0) {
                buff.append("\n");
                buff.append(" ORDER BY \n");
                i = 0;
                for (Object elem : this.orderByList) {
                    String col = "";
                    String sort = ((OrderByElement)elem).getSort();
                    for (AttributeElement el : this.attributeViewList) {
                        if (!((OrderByElement)elem).getContainedObject().getName().equalsIgnoreCase(el.getAttributeView().getName())) continue;
                        col = el.getAlias();
                        break;
                    }
                    if (col.equalsIgnoreCase("")) {
                        col = ((OrderByElement)elem).getContainedObject().getName();
                    }
                    if (i > 0) {
                        buff.append(",\n   ");
                    } else {
                        buff.append("   ");
                    }
                    buff.append(' ');
                    buff.append(this.appendQuotes(col));
                    buff.append(' ');
                    buff.append(sort);
                    ++i;
                }
                buff.append("\n");
            }
            buff.append(';');
        }
        return buff.toString();
    }

    public void initProperties(ContainerObject object) {
        if (object instanceof EntityView) {
            this.view = (EntityView)object;
            this.design = (LogicalDesign)this.view.getDesignPart();
            EntitySet allTables = this.design.getEntitySet();
            EntityViewSet allViews = this.design.getEntityViewSet();
            Iterator it = allTables.iterator();
            while (it.hasNext()) {
                this.allTablesModel.addElement(it.next());
            }
            it = allViews.iterator();
            while (it.hasNext()) {
                EntityView v = (EntityView)it.next();
                if (v == this.view) continue;
                this.allTablesModel.addElement(v);
            }
            for (int i = 0; i < this.view.getElements().length; ++i) {
                AttributeView column = (AttributeView)this.view.getElements()[i];
                if (this.view.getGroupByList().contains(column)) {
                    this.attributeViewList.add(new AttributeElement(column, column.getAlias(), true));
                } else {
                    this.attributeViewList.add(new AttributeElement(column, column.getAlias(), false));
                }
                if (column.getExpression().equalsIgnoreCase("")) continue;
                ColumnAlias ca = new ColumnAlias(column, column.getTableAlias());
                this.expressionList.add(ca);
                this.allColumnsOrderByModel.addElement(ca);
            }
            this.enableAll(!this.view.getUserDefined());
            this.whereArea.setText(this.view.getWhere());
            this.groupByArea.setText(this.view.getGroupBy());
            this.havingArea.setText(this.view.getHaving());
            if (!this.view.getUserDefined()) {
                for (AbstractView.ContainerHolder ch : this.view.getUsedContainers()) {
                    String alias = ch.getAlias();
                    ContainerObject container = ch.getContainer();
                    if (container != null) {
                        ContainedObject[] cobjs = container.getElements();
                        for (int i = 0; i < cobjs.length; ++i) {
                            ContainedObject cob = cobjs[i];
                            this.allColumnsModel.addElement(new ColumnAlias(cob, alias));
                            this.allColumnsOrderByModel.addElement(new ColumnAlias(cob, alias));
                        }
                    }
                    if (container != null) {
                        this.containerList.add(new ContainerElement(container, alias));
                        continue;
                    }
                    this.view.getContainerMap().remove(alias);
                }
                for (AttributeView col : this.view.getOrderByList()) {
                    this.orderByList.add(new OrderByElement(col, this.view.getOrderByMap().get(col.getObjectID()).toString()));
                }
                this.sqlArea.setText(this.generateSQL());
                this.defineDDLChBox.setSelected(false);
                this.defineDDLArea.setEnabled(false);
                this.defineDDLArea.setText("");
            } else {
                this.defineDDLChBox.setSelected(true);
                this.defineDDLArea.setEnabled(true);
                this.defineDDLArea.setText(this.view.getUserDefinedSQL());
            }
        }
    }

    protected void setProperties() {
        this.stopTableCellEditing(this.selectedTablesTable);
        this.stopTableCellEditing(this.selectedColumnsTable);
        this.stopTableCellEditing(this.selectedOrderByColumnsTable);
        if (this.view != null) {
            if (this.defineDDLChBox.isSelected()) {
                this.view.setUserDefined(true);
                String statement = this.defineDDLArea.getText();
                if (!this.getViewName(statement).trim().equalsIgnoreCase("")) {
                    this.view.setName(this.getViewName(statement));
                }
                this.view.setUserDefinedSQL(statement);
                this.view.removeAllElements();
                this.view.removeAllFromElements();
                this.view.removeAllFromOrderBy();
                this.view.removeAllGroupByList();
                this.view.setWhere("");
                this.view.setGroupBy("");
                this.view.setHaving("");
                this.view.getElements(statement.replaceAll("\n", " ").replaceAll("   ", " ").replaceAll("  ", " "));
            } else {
                this.view.setUserDefined(false);
                this.view.setUserDefinedSQL(this.generateSQL());
                this.view.removeAllFromElements();
                for (ContainerElement elem : this.containerList) {
                    this.view.addToContainers(elem.getContainerObject(), elem.getContainerAlias());
                }
                ArrayList<AttributeView> cols = new ArrayList<AttributeView>();
                for (AttributeView c : this.view.getElementsCollection()) {
                    if (c.getName().trim().equalsIgnoreCase("")) continue;
                    boolean contains = false;
                    for (AttributeElement e : this.attributeViewList) {
                        if (!e.getAttributeView().getName().equalsIgnoreCase(c.getName())) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    cols.add(c);
                }
                Iterator it = cols.iterator();
                while (it.hasNext()) {
                    this.view.clear((AttributeView)it.next());
                }
                this.view.removeAllElements();
                this.view.removeAllGroupByList();
                for (Object elem : this.attributeViewList) {
                    if (((AttributeElement)elem).getAttributeView().getName().equalsIgnoreCase("")) continue;
                    if (((AttributeElement)elem).getAttributeView().getReferencedColumnView() != null) {
                        if (((AttributeElement)elem).getAlias().equalsIgnoreCase("")) {
                            ((AttributeElement)elem).getAttributeView().setAlias(((AttributeView)((AttributeElement)elem).getAttributeView().getReferencedColumnView()).getAlias());
                        } else {
                            ((AttributeElement)elem).getAttributeView().setAlias(((AttributeElement)elem).getAlias());
                        }
                    } else {
                        ((AttributeElement)elem).getAttributeView().setAlias(((AttributeElement)elem).getAlias());
                    }
                    this.view.add(((AttributeElement)elem).getAttributeView());
                    if (!((AttributeElement)elem).getGroupBy()) continue;
                    this.view.addGroupByList(((AttributeElement)elem).getAttributeView());
                }
                this.view.removeAllFromOrderBy();
                for (Object elem : this.orderByList) {
                    this.view.addToOrderBy(((OrderByElement)elem).getContainedObject(), ((OrderByElement)elem).getSort());
                }
                this.view.setWhere(this.whereArea.getText());
                this.view.setGroupBy(this.generateGroupBy());
                this.view.setHaving(this.havingArea.getText());
            }
            this.view.setDirty(true);
        }
    }

    protected void clear() {
        this.allTablesModel.clear();
        Iterator it = this.containerList.iterator();
        while (it.hasNext()) {
            this.containerList.remove(0);
        }
        this.allColumnsModel.clear();
        int rows = this.selectedColumnsTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            this.attributeViewList.remove(0);
        }
        this.allColumnsOrderByModel.clear();
        it = this.orderByList.iterator();
        while (it.hasNext()) {
            this.orderByList.remove(0);
        }
    }

    private String getViewName(String statement) {
        StringTokenizer tokenizer;
        String first = "";
        String name = "";
        String[] s = statement.split("\\s");
        for (int i = 0; i < s.length; ++i) {
            if (!s[i].equalsIgnoreCase("VIEW")) continue;
            name = s[i + 1];
            break;
        }
        if ((tokenizer = new StringTokenizer(name, ".")).countTokens() == 2) {
            first = tokenizer.nextToken().trim();
            first = Token.getValBetweenSquareBrackets(first);
            name = tokenizer.nextToken().trim();
            name = Token.getValBetweenSquareBrackets(name);
        }
        return name;
    }

    private void enableAll(boolean enabled) {
        this.whereArea.setEnabled(enabled);
        this.groupByArea.setEnabled(enabled);
        this.havingArea.setEnabled(enabled);
        this.allTablesList.setEnabled(enabled);
        this.allColumnsList.setEnabled(enabled);
        this.bnNewExpression.setEnabled(enabled);
        this.selectedTablesTable.setEnabled(enabled);
        this.selectedColumnsTable.setEnabled(enabled);
        this.selectedOrderByColumnsTable.setEnabled(enabled);
        this.bnNewOrderByColumns.setEnabled(enabled);
        this.allColumnsOrderByList.setEnabled(enabled);
        if (!enabled) {
            this.allTablesList.setSelectedIndices(new int[0]);
            this.allColumnsList.setSelectedIndices(new int[0]);
            this.allColumnsOrderByList.setSelectedIndices(new int[0]);
            this.selectedTablesTable.clearSelection();
            this.selectedColumnsTable.clearSelection();
            this.selectedOrderByColumnsTable.clearSelection();
        }
    }

    protected boolean canExit() {
        int k = 1;
        Object[] containers = this.containerList.toArray();
        for (int p = 0; p < containers.length - 1; ++p) {
            k = p + 1;
            ContainerElement element = (ContainerElement)containers[p];
            ContainerObject container = element.getContainerObject();
            String contAlias = element.getContainerAlias();
            for (int s = k; s < containers.length; ++s) {
                ContainerObject nextContainer = ((ContainerElement)containers[s]).getContainerObject();
                String nextAlias = ((ContainerElement)containers[s]).getContainerAlias();
                if (!nextAlias.equalsIgnoreCase("") && !contAlias.equalsIgnoreCase("") && nextAlias.equalsIgnoreCase(contAlias)) {
                    JOptionPane.showMessageDialog(this.dialog, Messages.getString("EntityViewBuilder.EntitiesWithEqualNames"), Messages.getString("EntityViewBuilder.WrongAlias"), 0);
                    return false;
                }
                if (!nextAlias.equalsIgnoreCase("") || !contAlias.equalsIgnoreCase("") || !container.getName().equalsIgnoreCase(nextContainer.getName())) continue;
                JOptionPane.showMessageDialog(this.dialog, Messages.getString("EntityViewBuilder.EntitiesWithEqualNames"), Messages.getString("EntityViewBuilder.WrongAlias"), 0);
                return false;
            }
        }
        Object[] elements = this.attributeViewList.toArray();
        for (int i = 0; i <= elements.length - 1; ++i) {
            k = i + 1;
            AttributeElement elem = (AttributeElement)elements[i];
            AttributeView clmView = elem.getAttributeView();
            String alias = elem.getAlias();
            String expression = clmView.getExpression();
            if (!this.checkExpression(expression, alias)) {
                JOptionPane.showMessageDialog(this.dialog, Messages.getString("EntityViewBuilder.AttributeExpressionsWithoutAlias"), Messages.getString("EntityViewBuilder.EmptyAlias"), 0);
                return false;
            }
            for (int j = k; j <= elements.length - 1; ++j) {
                AttributeView nextClmView = ((AttributeElement)elements[j]).getAttributeView();
                String nextAlias = ((AttributeElement)elements[j]).getAlias();
                if (nextAlias.equalsIgnoreCase("") && alias.equalsIgnoreCase("")) {
                    if (!clmView.getReferencedName().equalsIgnoreCase(nextClmView.getReferencedName())) continue;
                    JOptionPane.showMessageDialog(this.dialog, Messages.getString("EntityViewBuilder.AttributesWithEqualNames"), Messages.getString("EntityViewBuilder.WrongAlias"), 0);
                    return false;
                }
                if (nextAlias.equalsIgnoreCase(alias)) {
                    JOptionPane.showMessageDialog(this.dialog, Messages.getString("EntityViewBuilder.AttributesWithEqualNames"), Messages.getString("EntityViewBuilder.WrongAlias"), 0);
                    return false;
                }
                if ((!alias.equalsIgnoreCase("") || !nextAlias.equalsIgnoreCase(clmView.getName())) && (!nextAlias.equalsIgnoreCase("") || !alias.equalsIgnoreCase(nextClmView.getName()))) continue;
                JOptionPane.showMessageDialog(this.dialog, Messages.getString("EntityViewBuilder.AttributesWithEqualNames"), Messages.getString("EntityViewBuilder.WrongAlias"), 0);
                return false;
            }
        }
        return true;
    }

    public List getAttributeViewList() {
        return this.attributeViewList;
    }

    public List getContainerList() {
        return this.containerList;
    }

    public void setContainerList(List containerList) {
        this.containerList = containerList;
    }

    private String getValue(AttributeView attrView) {
        String name = attrView.getReferencedName();
        ContainerObject container = attrView.getReferencedContainer();
        if (!attrView.getEntityAlias().equalsIgnoreCase("")) {
            return name + "(" + attrView.getEntityAlias() + ")";
        }
        if (container != null) {
            return name + "(" + container.getName() + ")";
        }
        if (!attrView.getExpression().equalsIgnoreCase("")) {
            return attrView.getExpression();
        }
        return name;
    }

    private void checkOrderByModel() {
        for (ColumnAlias clmAlias : this.expressionList) {
            if (this.allColumnsOrderByModel.contains(clmAlias)) continue;
            this.allColumnsOrderByModel.addElement(clmAlias);
        }
    }

    private ColumnAlias getColumnAlias(AttributeView av) {
        for (ColumnAlias clmAlias : this.expressionList) {
            if (clmAlias.getCol() != av) continue;
            return clmAlias;
        }
        return null;
    }

    private void checkModelsForValues(ContainerElement container, String oldValue, String newValue) {
        ColumnAlias colAlias;
        for (int i = 0; i < this.allColumnsModel.size(); ++i) {
            colAlias = (ColumnAlias)this.allColumnsModel.elementAt(i);
            if (!colAlias.getTableAlias().equalsIgnoreCase(oldValue) || !colAlias.getCol().getContainer().getName().equalsIgnoreCase(container.getContainerObject().getName())) continue;
            colAlias.setTableAlias(newValue);
            this.allColumnsModel.setElementAt(colAlias, i);
        }
        container.setContainerAlias(newValue);
        for (AttributeElement elem : this.attributeViewList) {
            if ((!elem.getAttributeView().getTableAlias().equalsIgnoreCase(oldValue) || elem.getAttributeView().getEntity() == null || !elem.getAttributeView().getEntity().getName().equalsIgnoreCase(container.getContainerObject().getName())) && (elem.getAttributeView().getView() == null || !elem.getAttributeView().getView().getName().equalsIgnoreCase(container.getContainerObject().getName()))) continue;
            elem.getAttributeView().setEntityAlias(newValue);
        }
        for (int i = 0; i < this.allColumnsOrderByModel.size(); ++i) {
            colAlias = (ColumnAlias)this.allColumnsOrderByModel.elementAt(i);
            if (!colAlias.getTableAlias().equalsIgnoreCase(oldValue) || !colAlias.getCol().getContainer().getName().equalsIgnoreCase(container.getContainerObject().getName())) continue;
            colAlias.setTableAlias(newValue);
            this.allColumnsOrderByModel.setElementAt(colAlias, i);
        }
        for (OrderByElement elem : this.orderByList) {
            if ((!((AttributeView)elem.getContainedObject()).getTableAlias().equalsIgnoreCase(oldValue) || ((AttributeView)elem.getContainedObject()).getEntity() == null || !((AttributeView)elem.getContainedObject()).getEntity().getName().equalsIgnoreCase(container.getContainerObject().getName())) && (((AttributeView)elem.getContainedObject()).getView() == null || !((AttributeView)elem.getContainedObject()).getView().getName().equalsIgnoreCase(container.getContainerObject().getName()))) continue;
            ((AttributeView)elem.getContainedObject()).setTableAlias(newValue);
        }
    }

    private boolean checkExpression(String expression, String alias) {
        return expression.equalsIgnoreCase("") || !alias.equalsIgnoreCase("");
    }

    private void stopTableCellEditing(JTable table) {
        int row = table.getEditingRow();
        int col = table.getEditingColumn();
        if (row > -1 && col > -1) {
            table.getCellEditor().stopCellEditing();
        }
    }

    class OrderByElement {
        ContainedObject containedObject;
        String sort;

        public OrderByElement(ContainedObject containedObject, String sort) {
            this.containedObject = containedObject;
            this.sort = sort;
        }

        public ContainedObject getContainedObject() {
            return this.containedObject;
        }

        public void setContainedObject(ContainedObject containedObject) {
            this.containedObject = containedObject;
        }

        public String getSort() {
            return this.sort;
        }

        public void setSort(String sort) {
            this.sort = sort;
        }
    }

    class ContainerElement {
        ContainerObject containerObject;
        String containerAlias;

        public ContainerElement(ContainerObject containerObject, String containerAlias) {
            this.containerObject = containerObject;
            this.containerAlias = containerAlias;
        }

        public ContainerObject getContainerObject() {
            return this.containerObject;
        }

        public void setContainerObject(ContainerObject containerObject) {
            this.containerObject = containerObject;
        }

        public String getContainerAlias() {
            return this.containerAlias;
        }

        public void setContainerAlias(String containerAlias) {
            this.containerAlias = containerAlias;
        }
    }

    class AttributeElement {
        AttributeView attributeView;
        String alias;
        boolean groupBy;

        public AttributeElement(AttributeView attributeView, String alias, boolean groupBy) {
            this.attributeView = attributeView;
            this.alias = alias;
            this.groupBy = groupBy;
        }

        public AttributeView getAttributeView() {
            return this.attributeView;
        }

        public void setAttributeView(AttributeView attributeView) {
            this.attributeView = attributeView;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public boolean getGroupBy() {
            return this.groupBy;
        }

        public void setGroupBy(boolean groupBy) {
            this.groupBy = groupBy;
        }
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntityViewBuilder.this.defineDDLArea.setEnabled(EntityViewBuilder.this.defineDDLChBox.isSelected());
            EntityViewBuilder.this.enableAll(!EntityViewBuilder.this.defineDDLChBox.isSelected());
            if (EntityViewBuilder.this.defineDDLChBox.isSelected()) {
                EntityViewBuilder.this.defineDDLArea.setText(EntityViewBuilder.this.generateSQL());
            } else {
                EntityViewBuilder.this.defineDDLArea.setText("");
            }
        }
    }

    public class TabChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            if (EntityViewBuilder.this.tpane.getSelectedComponent() == EntityViewBuilder.this.tpane.getComponentAt(6)) {
                EntityViewBuilder.this.sqlArea.setText(EntityViewBuilder.this.generateSQL());
            } else if (EntityViewBuilder.this.tpane.getSelectedComponent() == EntityViewBuilder.this.tpane.getComponentAt(3)) {
                EntityViewBuilder.this.groupByArea.setText(EntityViewBuilder.this.generateGroupBy());
            }
        }
    }

    class ColumnAlias {
        ContainedObject col;
        String tableAlias;

        public ColumnAlias(ContainedObject col, String tableAlias) {
            this.col = col;
            this.tableAlias = tableAlias;
        }

        public String getTableAlias() {
            return this.tableAlias;
        }

        public void setTableAlias(String tableAlias) {
            this.tableAlias = tableAlias;
        }

        public ContainedObject getCol() {
            return this.col;
        }

        public void setCol(ContainedObject col) {
            this.col = col;
        }
    }

    class AllListOrderByColumnsCellRenderer
    extends JLabel
    implements ListCellRenderer {
        AllListOrderByColumnsCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ColumnAlias col = (ColumnAlias)value;
            String alias = col.getTableAlias();
            String name = col.getCol().getName();
            StringBuffer buffer = null;
            buffer = !alias.equalsIgnoreCase("") ? new StringBuffer(alias).append(".").append(name) : new StringBuffer(name);
            this.setText(buffer.toString());
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(EntityViewBuilder.this.selectedTablesTable.getSelectionBackground());
            } else {
                this.setBackground(EntityViewBuilder.this.selectedTablesTable.getBackground());
            }
            if (!list.isEnabled()) {
                this.setForeground(Color.GRAY);
            } else {
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    class AllListColumnsCellRenderer
    extends JLabel
    implements ListCellRenderer {
        AllListColumnsCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String cv_alias;
            ColumnAlias col = (ColumnAlias)value;
            String alias = col.getTableAlias();
            String name = col.getCol().getName();
            if (col.getCol() instanceof AttributeView && !"".equals(cv_alias = ((AttributeView)col.getCol()).getAlias().trim())) {
                name = cv_alias;
            }
            StringBuffer buffer = null;
            buffer = !alias.equalsIgnoreCase("") ? new StringBuffer(alias).append(".").append(name) : new StringBuffer(col.getCol().getContainer().getName()).append(".").append(name);
            this.setText(buffer.toString());
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(EntityViewBuilder.this.selectedTablesTable.getSelectionBackground());
            } else {
                this.setBackground(EntityViewBuilder.this.selectedTablesTable.getBackground());
            }
            if (!list.isEnabled()) {
                this.setForeground(Color.GRAY);
            } else {
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    class AllListColumnsOrderBySelectionHandler
    implements ListSelectionListener {
        AllListColumnsOrderBySelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (EntityViewBuilder.this.allColumnsOrderByList.getSelectedIndex() == -1) {
                    EntityViewBuilder.this.bnAddOrderByColumns.setEnabled(false);
                } else {
                    EntityViewBuilder.this.bnAddOrderByColumns.setEnabled(true);
                }
            }
        }
    }

    class RemoveOrderByColumnsActionListener
    implements ActionListener {
        RemoveOrderByColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EntityViewBuilder.this.orderByList.size() > 0) {
                ArrayList list = new ArrayList();
                int[] selectedRows = EntityViewBuilder.this.selectedOrderByColumnsTable.getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    list.add(EntityViewBuilder.this.orderByList.get(selectedRows[i]));
                }
                for (OrderByElement el : list) {
                    EntityViewBuilder.this.orderByList.remove(el);
                }
                EntityViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                EntityViewBuilder.this.selectedOrderByColumnsTable.clearSelection();
            }
        }
    }

    class NewOrderByColumnsActionListener
    implements ActionListener {
        NewOrderByColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttributeView v = new AttributeView(EntityViewBuilder.this.design);
            v.setExpression("");
            v.setName("");
            v.setDesign(EntityViewBuilder.this.view.getDesign());
            v.setContainer(EntityViewBuilder.this.view);
            EntityViewBuilder.this.orderByList.add(new OrderByElement(v, ""));
            EntityViewBuilder.this.selectedOrderByColumnsTable.updateUI();
        }
    }

    class AddOrderByColumnsActionListener
    implements ActionListener {
        AddOrderByColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!EntityViewBuilder.this.allColumnsOrderByModel.isEmpty()) {
                Object[] selectedObjects = EntityViewBuilder.this.allColumnsOrderByList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    ColumnAlias col = (ColumnAlias)selectedObjects[i];
                    ContainedObject ob = col.getCol();
                    if (ob instanceof Attribute) {
                        AttributeView v = new AttributeView(EntityViewBuilder.this.design);
                        v.setReferencedAttribute((Attribute)ob);
                        v.setName(((Attribute)ob).getName());
                        v.setDesign(EntityViewBuilder.this.view.getDesign());
                        v.setEntity((Entity)ob.getContainer());
                        v.setContainer(EntityViewBuilder.this.view);
                        v.setEntityAlias(col.getTableAlias());
                        v.setDataType(((Attribute)ob).getDataType().toString());
                        EntityViewBuilder.this.orderByList.add(new OrderByElement(v, "ASC"));
                        EntityViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                        continue;
                    }
                    if (!(ob instanceof AttributeView)) continue;
                    EntityViewBuilder.this.orderByList.add(new OrderByElement(ob, "ASC"));
                    EntityViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                }
            }
        }
    }

    class AllListColumnsSelectionHandler
    implements ListSelectionListener {
        AllListColumnsSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (EntityViewBuilder.this.allColumnsList.getSelectedIndex() == -1) {
                    EntityViewBuilder.this.bnAddColumns.setEnabled(false);
                } else {
                    EntityViewBuilder.this.bnAddColumns.setEnabled(true);
                }
            }
        }
    }

    class RemoveColumnsActionListener
    implements ActionListener {
        RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EntityViewBuilder.this.attributeViewList.size() > 0) {
                ArrayList list = new ArrayList();
                int[] selectedRows = EntityViewBuilder.this.selectedColumnsTable.getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    list.add(EntityViewBuilder.this.attributeViewList.get(selectedRows[i]));
                }
                for (AttributeElement el : list) {
                    EntityViewBuilder.this.attributeViewList.remove(el);
                    ColumnAlias ca = EntityViewBuilder.this.getColumnAlias(el.getAttributeView());
                    if (ca == null) continue;
                    EntityViewBuilder.this.expressionList.remove(ca);
                    EntityViewBuilder.this.allColumnsOrderByModel.removeElement(ca);
                    for (int i = EntityViewBuilder.this.orderByList.size() - 1; i >= 0; --i) {
                        OrderByElement element = (OrderByElement)EntityViewBuilder.this.orderByList.get(i);
                        if (element.getContainedObject() != ca.getCol()) continue;
                        EntityViewBuilder.this.orderByList.remove(element);
                        EntityViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                    }
                }
                EntityViewBuilder.this.selectedColumnsTable.updateUI();
                EntityViewBuilder.this.selectedColumnsTable.clearSelection();
            }
        }
    }

    class NewExpressionActionListener
    implements ActionListener {
        NewExpressionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttributeView v = new AttributeView(EntityViewBuilder.this.design);
            v.setExpression("");
            v.setName("");
            v.setDesign(EntityViewBuilder.this.view.getDesign());
            v.setContainer(EntityViewBuilder.this.view);
            EntityViewBuilder.this.attributeViewList.add(new AttributeElement(v, v.getAlias(), false));
            EntityViewBuilder.this.selectedColumnsTable.updateUI();
            EntityViewBuilder.this.expressionList.add(new ColumnAlias(v, v.getAlias()));
        }
    }

    class AddColumnsActionListener
    implements ActionListener {
        AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!EntityViewBuilder.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = EntityViewBuilder.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    AttributeView v;
                    ColumnAlias col = (ColumnAlias)selectedObjects[i];
                    ContainedObject ob = col.getCol();
                    if (ob instanceof Attribute) {
                        v = new AttributeView(EntityViewBuilder.this.design);
                        v.setReferencedAttribute((Attribute)ob);
                        v.setName(((Attribute)ob).getName());
                        v.setDesign(EntityViewBuilder.this.view.getDesign());
                        v.setEntity((Entity)ob.getContainer());
                        v.setContainer(EntityViewBuilder.this.view);
                        v.setEntityAlias(col.getTableAlias());
                        v.setDataType(((Attribute)ob).getDataType().toString());
                        EntityViewBuilder.this.attributeViewList.add(new AttributeElement(v, v.getAlias(), false));
                        EntityViewBuilder.this.selectedColumnsTable.updateUI();
                        continue;
                    }
                    if (!(ob instanceof AttributeView)) continue;
                    v = new AttributeView(EntityViewBuilder.this.design);
                    v.setReferencedAttribute(((AttributeView)ob).getReferencedAttribute());
                    v.setName(ob.getName());
                    v.setDesign(EntityViewBuilder.this.view.getDesign());
                    v.setReferencedColumnView((FKElement)ob);
                    v.setView((EntityView)ob.getContainer());
                    v.setContainer(EntityViewBuilder.this.view);
                    v.setEntityAlias(col.getTableAlias());
                    EntityViewBuilder.this.attributeViewList.add(new AttributeElement(v, v.getAlias(), false));
                    EntityViewBuilder.this.selectedColumnsTable.updateUI();
                }
            }
        }
    }

    class SelectedTablesTable
    extends JTable {
        SelectedTablesTable() {
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (!EntityViewBuilder.this.defineDDLChBox.isSelected()) {
                if (col == 1) {
                    return new TextCellEditor();
                }
                return super.getCellEditor();
            }
            return null;
        }
    }

    class SelectedTablesModel
    extends AbstractTableModel {
        SelectedTablesModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return EntityViewBuilder.this.containerList.size();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return Messages.getString("EntityViewBuilder.Entities");
            }
            if (col == 1) {
                return Messages.getString("EntityViewBuilder.Alias");
            }
            return "";
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object newValue, int row, int col) {
            ContainerElement container = (ContainerElement)EntityViewBuilder.this.containerList.get(row);
            if (col == 0) {
                container.setContainerObject((ContainerObject)newValue);
            }
            if (col == 1) {
                String oldValue = container.getContainerAlias();
                EntityViewBuilder.this.checkModelsForValues(container, oldValue, (String)newValue);
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            ContainerElement container = (ContainerElement)EntityViewBuilder.this.containerList.get(row);
            if (col == 0) {
                return container.getContainerObject();
            }
            if (col == 1) {
                return container.getContainerAlias();
            }
            return new Integer(row * col);
        }
    }

    class SelectedTablesHandler
    implements ListSelectionListener {
        SelectedTablesHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (EntityViewBuilder.this.selectedTablesTable.getSelectedRow() > -1) {
                EntityViewBuilder.this.bnRemoveTables.setEnabled(true);
            } else {
                EntityViewBuilder.this.bnRemoveTables.setEnabled(false);
            }
        }
    }

    class ComboCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        ComboCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cbox.setModel(new DefaultComboBoxModel<String>(new String[]{"ASC", "DESC"}));
            return this.cbox;
        }
    }

    class ExpressionCellEditor
    extends DefaultCellEditor {
        JTextField tfield;

        ExpressionCellEditor() {
            super(new JTextField());
            this.tfield = (JTextField)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof AttributeView) {
                if (!((AttributeView)value).getExpression().equalsIgnoreCase("")) {
                    this.tfield.setText(((AttributeView)value).getExpression());
                } else {
                    this.tfield.setText(((AttributeView)value).getName());
                }
            } else {
                this.tfield.setText((String)(value == null ? "" : value.toString()));
            }
            this.tfield.setBorder(null);
            return this.tfield;
        }
    }

    class TextCellEditor
    extends DefaultCellEditor {
        JTextField tfield;

        TextCellEditor() {
            super(new JTextField());
            this.tfield = (JTextField)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof AttributeView && ((AttributeView)value).getEntityAlias().equalsIgnoreCase(EntityViewBuilder.this.view.getName())) {
                this.tfield.setText(((AttributeView)value).getExpression());
            } else {
                this.tfield.setText((String)(value == null ? "" : value.toString()));
            }
            this.tfield.setBorder(null);
            return this.tfield;
        }
    }

    class SelectedOrderByColumnsTable
    extends JTable {
        SelectedOrderByColumnsTable() {
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (!EntityViewBuilder.this.defineDDLChBox.isSelected()) {
                if (col == 0) {
                    return new TextCellEditor();
                }
                return new ComboCellEditor();
            }
            return null;
        }
    }

    class SelectedOrderByColumnsModel
    extends AbstractTableModel {
        SelectedOrderByColumnsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return EntityViewBuilder.this.orderByList.size();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return Messages.getString("EntityViewBuilder.AttributesExpression");
            }
            if (col == 1) {
                return Messages.getString("EntityViewBuilder.Sort");
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            OrderByElement elem = (OrderByElement)EntityViewBuilder.this.orderByList.get(row);
            if (col == 0) {
                return elem.getContainedObject();
            }
            if (col == 1) {
                return elem.getSort();
            }
            return new Integer(row * col);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            OrderByElement elem = (OrderByElement)EntityViewBuilder.this.orderByList.get(row);
            return col != 0 || ((AttributeView)elem.getContainedObject()).getTable() == null && ((AttributeView)elem.getContainedObject()).getView() == null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            OrderByElement elem = (OrderByElement)EntityViewBuilder.this.orderByList.get(row);
            if (col == 0) {
                if (value instanceof AttributeView) {
                    elem.setContainedObject((AttributeView)value);
                } else {
                    AttributeView av = (AttributeView)elem.getContainedObject();
                    av.setExpression((String)value);
                    av.setName((String)value);
                }
            } else if (col == 1) {
                elem.setSort((String)value);
            }
        }
    }

    class SelectedOrderByColumnsHandler
    implements ListSelectionListener {
        SelectedOrderByColumnsHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (EntityViewBuilder.this.selectedOrderByColumnsTable.getSelectedRow() > -1) {
                EntityViewBuilder.this.bnRemoveOrderByColumns.setEnabled(true);
            } else {
                EntityViewBuilder.this.bnRemoveOrderByColumns.setEnabled(false);
            }
        }
    }

    class CheckBoxTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        CheckBoxTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(0);
            this.setSelected((Boolean)value);
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(2);
            if (value instanceof AttributeView && ((AttributeView)value).getEntityAlias().equalsIgnoreCase(EntityViewBuilder.this.view.getName())) {
                this.setText(((AttributeView)value).getExpression());
            } else {
                this.setText((String)(value == null ? "" : value.toString()));
            }
            return this;
        }
    }

    class CheckBoxEditor
    extends DefaultCellEditor {
        JCheckBox cbox;

        CheckBoxEditor() {
            super(new JCheckBox());
            this.cbox = (JCheckBox)this.getComponent();
            this.cbox.setHorizontalAlignment(0);
        }
    }

    class SelectedAttributesModel
    extends AbstractTableModel {
        SelectedAttributesModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return EntityViewBuilder.this.attributeViewList.size();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return Messages.getString("EntityViewBuilder.AttributesExpression");
            }
            if (col == 1) {
                return Messages.getString("EntityViewBuilder.Alias");
            }
            if (col == 2) {
                return Messages.getString("EntityViewBuilder.Groupby");
            }
            return "";
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            AttributeElement value;
            return column != 0 || (value = (AttributeElement)EntityViewBuilder.this.attributeViewList.get(row)).getAttributeView().getEntity() == null && value.getAttributeView().getView() == null;
        }

        @Override
        public Object getValueAt(int row, int col) {
            AttributeElement object = (AttributeElement)EntityViewBuilder.this.attributeViewList.get(row);
            if (col == 0) {
                return EntityViewBuilder.this.getValue(object.getAttributeView());
            }
            if (col == 1) {
                return object.getAlias();
            }
            if (col == 2) {
                return object.getGroupBy();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            AttributeElement object = (AttributeElement)EntityViewBuilder.this.attributeViewList.get(row);
            if (col == 0) {
                if (value instanceof AttributeView) {
                    object.setAttributeView((AttributeView)value);
                } else {
                    AttributeView v = object.getAttributeView();
                    v.setExpression((String)value);
                    v.setName((String)value);
                    EntityViewBuilder.this.checkOrderByModel();
                }
            } else if (col == 1) {
                object.setAlias((String)value);
            } else if (col == 2) {
                object.setGroupBy((Boolean)value);
            }
        }
    }

    class SelectedColumnsHandler
    implements ListSelectionListener {
        SelectedColumnsHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (EntityViewBuilder.this.selectedColumnsTable.getSelectedRow() > -1) {
                EntityViewBuilder.this.bnRemoveColumns.setEnabled(true);
            } else {
                EntityViewBuilder.this.bnRemoveColumns.setEnabled(false);
            }
        }
    }

    class AllListTablesSelectionHandler
    implements ListSelectionListener {
        AllListTablesSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (EntityViewBuilder.this.allTablesList.getSelectedIndex() == -1) {
                    EntityViewBuilder.this.bnAddTables.setEnabled(false);
                    EntityViewBuilder.this.bnMoveUpTable.setEnabled(false);
                    EntityViewBuilder.this.bnMoveDownTable.setEnabled(false);
                } else {
                    EntityViewBuilder.this.bnAddTables.setEnabled(true);
                    EntityViewBuilder.this.bnMoveUpTable.setEnabled(true);
                    EntityViewBuilder.this.bnMoveDownTable.setEnabled(true);
                }
            }
        }
    }

    class RemoveTablesActionListener
    implements ActionListener {
        RemoveTablesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EntityViewBuilder.this.containerList.size() > 0) {
                ArrayList list = new ArrayList();
                int[] selectedRows = EntityViewBuilder.this.selectedTablesTable.getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    list.add(EntityViewBuilder.this.containerList.get(selectedRows[i]));
                }
                for (ContainerElement elem : list) {
                    Object obj;
                    Enumeration enumeration;
                    Object obj22;
                    Enumeration enumeration2;
                    ContainedObjectWithDomain attr;
                    ContainerObject ob = elem.getContainerObject();
                    if (ob instanceof Entity) {
                        for (int k = 0; k < ob.getElements().length; ++k) {
                            attr = (Attribute)ob.getElements()[k];
                            enumeration2 = EntityViewBuilder.this.allColumnsModel.elements();
                            while (enumeration2.hasMoreElements()) {
                                obj22 = (ColumnAlias)enumeration2.nextElement();
                                if (((ColumnAlias)obj22).getCol() != attr || !elem.getContainerAlias().equalsIgnoreCase(((ColumnAlias)obj22).getTableAlias())) continue;
                                EntityViewBuilder.this.allColumnsModel.removeElement(obj22);
                            }
                            for (Object obj22 : EntityViewBuilder.this.attributeViewList) {
                                if (((AttributeElement)obj22).getAttributeView().getReferencedColumn() != attr || ((AttributeElement)obj22).getAttributeView().getView() != null && ((AttributeElement)obj22).getAttributeView().getView() != EntityViewBuilder.this.view || ((AttributeElement)obj22).getAttributeView().getContainer() != ob && ((AttributeElement)obj22).getAttributeView().getContainer() != EntityViewBuilder.this.view) continue;
                                EntityViewBuilder.this.attributeViewList.remove(obj22);
                                EntityViewBuilder.this.selectedColumnsTable.updateUI();
                                break;
                            }
                            enumeration = EntityViewBuilder.this.allColumnsOrderByModel.elements();
                            while (enumeration.hasMoreElements()) {
                                obj = (ColumnAlias)enumeration.nextElement();
                                if (((ColumnAlias)obj).getCol() != attr || !elem.getContainerAlias().equalsIgnoreCase(((ColumnAlias)obj).getTableAlias())) continue;
                                EntityViewBuilder.this.allColumnsOrderByModel.removeElement(obj);
                            }
                            for (OrderByElement element : EntityViewBuilder.this.orderByList) {
                                obj = (AttributeView)element.getContainedObject();
                                if (((AbstractViewElement)obj).getReferencedColumn() != attr || ((AbstractViewElement)obj).getView() != null && ((AbstractViewElement)obj).getView() != EntityViewBuilder.this.view || ((ContainedObject)obj).getContainer() != ob && ((ContainedObject)obj).getContainer() != EntityViewBuilder.this.view) continue;
                                EntityViewBuilder.this.orderByList.remove(element);
                                EntityViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                            }
                        }
                    } else if (ob instanceof EntityView) {
                        for (int j = 0; j < ob.getElements().length; ++j) {
                            attr = (AttributeView)ob.getElements()[j];
                            enumeration2 = EntityViewBuilder.this.allColumnsModel.elements();
                            while (enumeration2.hasMoreElements()) {
                                obj22 = (ColumnAlias)enumeration2.nextElement();
                                if (((ColumnAlias)obj22).getCol() != attr || !elem.getContainerAlias().equalsIgnoreCase(((ColumnAlias)obj22).getTableAlias())) continue;
                                EntityViewBuilder.this.allColumnsModel.removeElement(obj22);
                            }
                            for (AttributeElement attrView : EntityViewBuilder.this.attributeViewList) {
                                if (attrView.getAttributeView().getReferencedColumn() != ((AbstractViewElement)attr).getReferencedColumn() || !elem.getContainerAlias().equalsIgnoreCase(attrView.getAttributeView().getTableAlias())) continue;
                                EntityViewBuilder.this.attributeViewList.remove(attrView);
                                EntityViewBuilder.this.selectedColumnsTable.updateUI();
                                break;
                            }
                            enumeration = EntityViewBuilder.this.allColumnsOrderByModel.elements();
                            while (enumeration.hasMoreElements()) {
                                obj = (ColumnAlias)enumeration.nextElement();
                                if (((ColumnAlias)obj).getCol() != attr || !elem.getContainerAlias().equalsIgnoreCase(((ColumnAlias)obj).getTableAlias())) continue;
                                EntityViewBuilder.this.allColumnsOrderByModel.removeElement(obj);
                            }
                            for (OrderByElement element : EntityViewBuilder.this.orderByList) {
                                if (((AttributeView)element.getContainedObject()).getReferencedColumn() != ((AbstractViewElement)attr).getReferencedColumn() || !elem.getContainerAlias().equalsIgnoreCase(((AttributeView)element.getContainedObject()).getTableAlias())) continue;
                                EntityViewBuilder.this.orderByList.remove(element);
                                EntityViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                            }
                        }
                    }
                    EntityViewBuilder.this.containerList.remove(elem);
                    EntityViewBuilder.this.selectedTablesTable.updateUI();
                }
            }
        }
    }

    class AddTablesActionListener
    implements ActionListener {
        AddTablesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!EntityViewBuilder.this.allTablesModel.isEmpty()) {
                Object[] selectedObjects = EntityViewBuilder.this.allTablesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    ContainedObjectWithDomain col;
                    int j;
                    ContainerObject ob = (ContainerObject)selectedObjects[i];
                    String alias = this.generateAlias(ob);
                    EntityViewBuilder.this.containerList.add(new ContainerElement(ob, alias));
                    EntityViewBuilder.this.selectedTablesTable.updateUI();
                    if (ob instanceof Entity) {
                        for (j = 0; j < ob.getElements().length; ++j) {
                            col = (Attribute)ob.getElements()[j];
                            EntityViewBuilder.this.allColumnsModel.addElement(new ColumnAlias(col, alias));
                            EntityViewBuilder.this.allColumnsOrderByModel.addElement(new ColumnAlias(col, alias));
                        }
                        continue;
                    }
                    if (!(ob instanceof EntityView)) continue;
                    for (j = 0; j < ob.getElements().length; ++j) {
                        col = (AttributeView)ob.getElements()[j];
                        EntityViewBuilder.this.allColumnsModel.addElement(new ColumnAlias(col, alias));
                        EntityViewBuilder.this.allColumnsOrderByModel.addElement(new ColumnAlias(col, alias));
                    }
                }
            }
        }

        private String generateAlias(ContainerObject ob) {
            ArrayList<String> list = new ArrayList<String>();
            Iterator it = EntityViewBuilder.this.containerList.iterator();
            while (it.hasNext()) {
                list.add(((ContainerElement)it.next()).getContainerAlias());
            }
            if (!list.contains(ob.getName())) {
                return ob.getName();
            }
            StringBuffer buffer = new StringBuffer(ob.getName());
            String newName = ob.getName();
            buffer.append("v");
            int length = buffer.length();
            for (int i = 1; i <= list.size(); ++i) {
                buffer.setLength(length);
                buffer.append(i);
                newName = buffer.toString();
                if (list.contains(newName)) continue;
                return newName;
            }
            return null;
        }
    }
}

