/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class AddStructureDialog
extends JDialog
implements AbstractEditorConstants {
    public static final String KEY_ESCAPE = "ESCAPE";
    private DesignPart designPart;
    private List sList;
    private JPanel generalPanel;
    private List allList = new ArrayList();
    private JTable allTable;
    private JRadioButton rbNew;
    private JRadioButton rbAll;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AddStructureDialog.this.dispose();
        }
    };

    public AddStructureDialog(ApplicationView view, DesignPart designPart, List sList) {
        super(view.getFrame());
        this.setModal(true);
        this.designPart = designPart;
        this.sList = sList;
        this.setTitle(Messages.getString("AddStructureDialog.AddInformationStructure"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AddStructureDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        JPanel pnTop = new JPanel(new GridLayout(0, 1));
        pnTop.setBorder(BorderFactory.createTitledBorder(Messages.getString("AddStructureDialog.SelectStructure")));
        RadioListener listener = new RadioListener();
        this.rbNew = new JRadioButton(Messages.getString("AddStructureDialog.NewInformationStructure"));
        this.rbNew.addActionListener(listener);
        this.rbNew.setMnemonic(78);
        this.rbAll = new JRadioButton(Messages.getString("AddStructureDialog.AvailableInformationStructure"));
        this.rbAll.addActionListener(listener);
        this.rbAll.setMnemonic(65);
        this.rbNew.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbNew);
        group.add(this.rbAll);
        pnTop.add(this.rbNew);
        pnTop.add(this.rbAll);
        this.generalPanel.add((Component)pnTop, "North");
        JPanel pnList = new JPanel();
        pnList.setBorder(BorderFactory.createTitledBorder(Messages.getString("AddStructureDialog.AllInformationStructures")));
        this.allList.addAll(this.getAllStructures());
        this.allTable = new JTable(new AllStructuresModel());
        this.allTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.allTable);
        scrollpane.setPreferredSize(new Dimension(240, 220));
        pnList.add(scrollpane);
        this.generalPanel.add(pnList);
        this.enableControls(!this.rbNew.isSelected());
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setPreferredSize(bnCancel.getPreferredSize());
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void enableControls(boolean enable) {
        this.allTable.setEnabled(enable);
        this.allTable.clearSelection();
        if (!enable) {
            this.allTable.setBackground(Color.LIGHT_GRAY);
        } else {
            this.allTable.setBackground(Color.WHITE);
        }
    }

    private ProcessModel getProcessModel() {
        return this.designPart.getDesign().getProcessModel();
    }

    private List getAllStructures() {
        ArrayList<InfoStructure> list = new ArrayList<InfoStructure>();
        int length = this.getProcessModel().getInfoStructureSet().size();
        for (int i = 0; i < length; ++i) {
            InfoStructure structure = (InfoStructure)this.getProcessModel().getInfoStructureSet().getElement(i);
            if (this.sList.contains(structure)) continue;
            list.add(structure);
        }
        return list;
    }

    public void centerOnScreen(JDialog window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = window.getSize();
        Point newLocation = new Point((screenSize.width - mySize.width) / 2, (screenSize.height - mySize.height) / 2);
        window.setLocation(newLocation);
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddStructureDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AddStructureDialog.this.rbNew.isSelected()) {
                InfoStructure structure = AddStructureDialog.this.getProcessModel().createInfoStructure();
                AddStructureDialog.this.sList.add(structure);
            } else {
                int row = AddStructureDialog.this.allTable.getSelectedRow();
                if (row != -1 && AddStructureDialog.this.allList.size() > 0 && row < AddStructureDialog.this.allList.size()) {
                    InfoStructure structure = (InfoStructure)AddStructureDialog.this.allList.get(row);
                    AddStructureDialog.this.sList.add(structure);
                }
            }
            AddStructureDialog.this.dispose();
        }
    }

    private class AllStructuresModel
    extends AbstractTableModel {
        private AllStructuresModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AddStructureDialog.this.allList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AddStructureDialog.InformationStructures");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            InfoStructure structure = (InfoStructure)AddStructureDialog.this.allList.get(row);
            if (col == 0) {
                return structure.getName();
            }
            return new Integer(row * col);
        }
    }

    private class RadioListener
    implements ActionListener {
        private RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddStructureDialog.this.enableControls(!AddStructureDialog.this.rbNew.isSelected());
        }
    }
}

