/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.JCharField;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class AgentPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfSynonym;
    private JComboBox cbType;
    private List ifList;
    private JTable iftable;
    private JPanel pnIncomingFlows;
    private List ofList;
    private JPanel pnOutgoingFlows;
    private JTable oftable;
    private JPanel pnDataFile;
    private JPanel pnDataFileGrid;
    private JTextField tfOwner;
    private JTextField tfSource;
    private JTextField tfFileName;
    private JTextField tfLocation;
    private JComboBox cbFileType;
    private JCharField tfFieldSeparator;
    private JComboBox cbTransferType;
    private JCheckBox chSelfDescribing;
    private JIntegerField tfSkipRecords;
    private JCharField tfTextDelimiter;
    private JPanel pnDataElement;
    private ArrayList edList;
    private JTable edTable;
    private JButton btnDEProperties;
    private JButton btnDEAdd;
    private JButton btnDERemove;
    private ExternalAgent agent;
    private List newExtDatas;
    private List attrMWList = new ArrayList();
    private List edWList = new ArrayList();
    private List attributes;
    public static final String[] TYPES = new String[]{Messages.getString("AgentPropertiesDialogEx.OrganizationUnit"), Messages.getString("AgentPropertiesDialogEx.System"), Messages.getString("AgentPropertiesDialogEx.Role"), Messages.getString("AgentPropertiesDialogEx.Other")};
    private JButton btnIncomingFlowProperties;
    private JButton btnOutgoingFlowProperties;

    public AgentPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbSynonym = new JLabel(LB_SYNOMYM);
        lbSynonym.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSynonym, this.tfSynonym));
        JLabel lbType = new JLabel(LB_TYPE);
        lbType.setPreferredSize(this.getDefaultSize());
        this.cbType = new JComboBox<String>(TYPES);
        this.cbType.setFont(this.cbType.getFont().deriveFont(0));
        this.cbType.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbType, this.cbType));
    }

    @Override
    public String getCaption() {
        return Messages.getString("AgentPropertiesDialogEx.ExternalAgentProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof ExternalAgent) {
            this.agent = (ExternalAgent)object;
            this.initDefaults(false);
            this.tfSynonym.setText(this.agent.getSynonym());
            this.cbType.setSelectedIndex(this.agent.getType());
            this.tfObjectID.setText(this.agent.getObjectID());
            this.tfCreationTime.setText(this.agent.getCreationTime());
            this.tfCreator.setText(this.agent.getCreator().getName());
            this.tfDesign.setText(this.agent.getOwnerDesignName());
            if (this.agent.getGenerator() != null) {
                this.tfGeneratorName.setText(this.agent.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.agent.getChanger().getName());
            this.tfLastChangedTime.setText(this.agent.getChangeTime());
            this.ifList.addAll(this.agent.getIncomingFlows());
            this.ofList.addAll(this.agent.getOutgoingFlows());
            this.tfOwner.setText(this.agent.getOwner());
            this.tfSource.setText(this.agent.getSource());
            this.tfFileName.setText(this.agent.getFileName());
            this.tfLocation.setText(this.agent.getLocation());
            this.cbFileType.setSelectedItem(this.translate(this.agent.getFileType(), ExternalAgent.FILE_TYPES_INTERNAL, ExternalAgent.FILE_TYPES_DISPLAY));
            this.tfFieldSeparator.setText(this.agent.getFieldSeparator());
            this.cbTransferType.setSelectedItem(this.translate(this.agent.getTransferType(), ExternalAgent.TRANSFER_TYPES_INTERNAL, ExternalAgent.TRANSFER_TYPES_DISPLAY));
            this.chSelfDescribing.setSelected(this.agent.isSelfDescribing());
            this.tfSkipRecords.setValue((long)this.agent.getSkipRecords());
            this.tfTextDelimiter.setText(this.agent.getTextDelimiter());
            this.edList.addAll(this.agent.getExternalDatas());
            this.makeWrapperList();
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.initDynamicProperties();
        }
    }

    @Override
    protected void setProperties() {
        this.agent.setName(this.tfName.getText());
        this.agent.setComment(this.taComments.getText());
        this.agent.setSynonym(this.tfSynonym.getText());
        this.agent.setNotes(this.taNotes.getText());
        this.agent.setType(this.cbType.getSelectedIndex());
        this.agent.setOwner(this.tfOwner.getText());
        this.agent.setSource(this.tfSource.getText());
        this.agent.setFileName(this.tfFileName.getText());
        this.agent.setLocation(this.tfLocation.getText());
        this.agent.setFileType(this.translate((String)this.cbFileType.getSelectedItem(), ExternalAgent.FILE_TYPES_DISPLAY, ExternalAgent.FILE_TYPES_INTERNAL));
        this.agent.setFieldSeparator(this.tfFieldSeparator.getText());
        this.agent.setTransferType(this.translate((String)this.cbTransferType.getSelectedItem(), ExternalAgent.TRANSFER_TYPES_DISPLAY, ExternalAgent.TRANSFER_TYPES_INTERNAL));
        this.agent.setSelfDescribing(this.chSelfDescribing.isSelected());
        this.agent.setSkipRecords(this.tfSkipRecords.getIntValue());
        this.agent.setTextDelimiter(this.tfTextDelimiter.getText());
        for (ExternalData data : this.agent.getExternalDatas()) {
            if (this.edList.contains(data)) continue;
            data.remove();
        }
        this.agent.getExternalDatas().clear();
        for (ExternalData extData : this.edList) {
            this.agent.addExternalData(extData);
        }
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        AgentPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.agent.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.agent.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getIncomingFlowsPanel());
        this.addToTree(root, this.getOutgoingFlowsPanel());
        this.addToTree(root, this.getDataFileSpecPanel());
        this.addToTree(root, this.getDataElementsPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "EXTERNAL_AGENT_PROPERTIES_DIALOG";
    }

    private JPanel getIncomingFlowsPanel() {
        if (this.pnIncomingFlows == null) {
            this.pnIncomingFlows = this.createPage(Messages.getString("AgentPropertiesDialogEx.IncomingFlows"));
            this.ifList = new ArrayList();
            this.iftable = new JTable(new IncomingFlowsModel());
            this.iftable.setSelectionMode(0);
            this.iftable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = AgentPropertiesDialogEx.this.iftable.getSelectedRow();
                    if (row != -1) {
                        if (e.getClickCount() == 2 && AgentPropertiesDialogEx.this.ifList.size() > 0 && row < AgentPropertiesDialogEx.this.ifList.size()) {
                            Flow flow = (Flow)AgentPropertiesDialogEx.this.ifList.get(row);
                            flow.showPropertyDialog();
                        }
                        AgentPropertiesDialogEx.this.btnIncomingFlowProperties.setEnabled(true);
                    } else {
                        AgentPropertiesDialogEx.this.btnIncomingFlowProperties.setEnabled(false);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.iftable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnIncomingFlowProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnIncomingFlowProperties.setEnabled(false);
            this.btnIncomingFlowProperties.setToolTipText(Messages.getString("AgentPropertiesDialogEx.Properties"));
            this.btnIncomingFlowProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = AgentPropertiesDialogEx.this.iftable.getSelectedRow();
                    if (row != -1 && AgentPropertiesDialogEx.this.ifList.size() > 0 && row < AgentPropertiesDialogEx.this.ifList.size()) {
                        Flow flow = (Flow)AgentPropertiesDialogEx.this.ifList.get(row);
                        flow.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnIncomingFlowProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 300));
            JPanel ifPanel = new JPanel(new BorderLayout());
            ifPanel.add((Component)buttonGeneral, "North");
            ifPanel.add(scrollpane);
            this.pnIncomingFlows.add(ifPanel);
        }
        return this.pnIncomingFlows;
    }

    private JPanel getOutgoingFlowsPanel() {
        if (this.pnOutgoingFlows == null) {
            this.pnOutgoingFlows = this.createPage(Messages.getString("AgentPropertiesDialogEx.OutgoingFlows"));
            this.ofList = new ArrayList();
            this.oftable = new JTable(new OutgoingFlowsModel());
            this.oftable.setSelectionMode(0);
            this.oftable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = AgentPropertiesDialogEx.this.oftable.getSelectedRow();
                    if (row != -1) {
                        if (e.getClickCount() == 2 && AgentPropertiesDialogEx.this.ofList.size() > 0 && row < AgentPropertiesDialogEx.this.ofList.size()) {
                            Flow flow = (Flow)AgentPropertiesDialogEx.this.ofList.get(row);
                            flow.showPropertyDialog();
                        }
                        AgentPropertiesDialogEx.this.btnOutgoingFlowProperties.setEnabled(true);
                    } else {
                        AgentPropertiesDialogEx.this.btnOutgoingFlowProperties.setEnabled(false);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.oftable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnOutgoingFlowProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnOutgoingFlowProperties.setEnabled(false);
            this.btnOutgoingFlowProperties.setToolTipText(Messages.getString("AgentPropertiesDialogEx.Properties"));
            this.btnOutgoingFlowProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = AgentPropertiesDialogEx.this.oftable.getSelectedRow();
                    if (row != -1 && AgentPropertiesDialogEx.this.ofList.size() > 0 && row < AgentPropertiesDialogEx.this.ofList.size()) {
                        Flow flow = (Flow)AgentPropertiesDialogEx.this.ofList.get(row);
                        flow.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnOutgoingFlowProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 300));
            JPanel ofPanel = new JPanel(new BorderLayout());
            ofPanel.add((Component)buttonGeneral, "North");
            ofPanel.add(scrollpane);
            this.pnOutgoingFlows.add(ofPanel);
        }
        return this.pnOutgoingFlows;
    }

    private JPanel getDataFileSpecPanel() {
        if (this.pnDataFile == null) {
            this.pnDataFile = this.createPage(Messages.getString("AgentPropertiesDialogEx.DataFileSpecification"));
            JPanel jpanel = new JPanel(new BorderLayout());
            this.pnDataFileGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbOwner = new JLabel(LB_OWNER);
            lbOwner.setPreferredSize(this.getDefaultSize());
            this.tfOwner = new JTextField();
            this.tfOwner.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(lbOwner, this.tfOwner));
            JLabel lbSource = new JLabel(LB_SOURCE);
            lbSource.setPreferredSize(this.getDefaultSize());
            this.tfSource = new JTextField();
            this.tfSource.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(lbSource, this.tfSource));
            JLabel lbFileName = new JLabel(LB_FILE_NAME);
            lbFileName.setPreferredSize(this.getDefaultSize());
            this.tfFileName = new JTextField();
            this.tfFileName.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(lbFileName, this.tfFileName));
            JLabel lbLocation = new JLabel(LB_LOCATION);
            lbLocation.setPreferredSize(this.getDefaultSize());
            this.tfLocation = new JTextField();
            this.tfLocation.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(lbLocation, this.tfLocation));
            JLabel lbFileType = new JLabel(LB_FILE_TYPE);
            lbFileType.setPreferredSize(this.getDefaultSize());
            this.cbFileType = new JComboBox<String>(ExternalAgent.FILE_TYPES_DISPLAY);
            this.cbFileType.setFont(this.cbFileType.getFont().deriveFont(0));
            this.cbFileType.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(lbFileType, this.cbFileType));
            JLabel lbFieldSeparator = new JLabel(LB_FIELD_SEPARATOR);
            lbFieldSeparator.setPreferredSize(this.getDefaultSize());
            this.tfFieldSeparator = new JCharField();
            this.tfFieldSeparator.setPreferredSize(new Dimension(20, 20));
            JPanel lbpanel = new JPanel(new BorderLayout());
            lbpanel.setPreferredSize(new Dimension(30, 20));
            lbpanel.add((Component)this.tfFieldSeparator, "West");
            this.pnDataFileGrid.add(this.createRow(lbFieldSeparator, lbpanel));
            JLabel lbTransferType = new JLabel(LB_TRANSFER_TYPE);
            lbTransferType.setPreferredSize(this.getDefaultSize());
            this.cbTransferType = new JComboBox<String>(ExternalAgent.TRANSFER_TYPES_DISPLAY);
            this.cbTransferType.setFont(this.cbTransferType.getFont().deriveFont(0));
            this.cbTransferType.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(lbTransferType, this.cbTransferType));
            JLabel lbIsSelfDescribing = new JLabel(LB_SELF_DESCRIBING);
            lbIsSelfDescribing.setPreferredSize(this.getDefaultSize());
            this.chSelfDescribing = new JCheckBox();
            this.pnDataFileGrid.add(this.createRow(lbIsSelfDescribing, this.chSelfDescribing));
            JLabel lbSkipRecords = new JLabel(LB_SKIP_RECORDS);
            lbSkipRecords.setPreferredSize(this.getDefaultSize());
            this.tfSkipRecords = new JIntegerField();
            this.tfSkipRecords.setPreferredSize(new Dimension(20, 20));
            JPanel srpanel = new JPanel(new BorderLayout());
            srpanel.setPreferredSize(new Dimension(30, 20));
            srpanel.add((Component)this.tfSkipRecords, "West");
            this.pnDataFileGrid.add(this.createRow(lbSkipRecords, srpanel));
            JLabel lbTextDelimiter = new JLabel(LB_TEXT_DELIMITER);
            lbTextDelimiter.setPreferredSize(this.getDefaultSize());
            this.tfTextDelimiter = new JCharField();
            this.tfTextDelimiter.setPreferredSize(new Dimension(20, 20));
            JPanel tdpanel = new JPanel(new BorderLayout());
            tdpanel.setPreferredSize(new Dimension(20, 20));
            tdpanel.add((Component)this.tfTextDelimiter, "West");
            this.pnDataFileGrid.add(this.createRow(lbTextDelimiter, tdpanel));
            jpanel.add((Component)this.pnDataFileGrid, "North");
            this.pnDataFile.add((Component)jpanel, "Center");
        }
        return this.pnDataFile;
    }

    private JPanel getDataElementsPanel() {
        if (this.pnDataElement == null) {
            this.pnDataElement = this.createPage(Messages.getString("AgentPropertiesDialogEx.DataElements"));
            this.edList = new ArrayList();
            this.newExtDatas = new ArrayList();
            this.edTable = new JTable(new ExternalDataModel());
            this.edTable.setSelectionMode(0);
            this.edTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = AgentPropertiesDialogEx.this.edTable.getSelectedRow();
                    if (row > -1) {
                        if (e.getClickCount() == 2 && AgentPropertiesDialogEx.this.edList.size() > 0 && row < AgentPropertiesDialogEx.this.edList.size()) {
                            ExternalData extData = (ExternalData)AgentPropertiesDialogEx.this.edList.get(row);
                            extData.showModal = AgentPropertiesDialogEx.this.agent.showModal || AgentPropertiesDialogEx.this.agent.showForFirstTime();
                            extData.showPropertyDialog();
                            ((ExternalDataModel)AgentPropertiesDialogEx.this.edTable.getModel()).fireTableDataChanged();
                        }
                        AgentPropertiesDialogEx.this.btnDEProperties.setEnabled(true);
                        AgentPropertiesDialogEx.this.btnDERemove.setEnabled(true);
                    } else {
                        AgentPropertiesDialogEx.this.btnDEProperties.setEnabled(false);
                        AgentPropertiesDialogEx.this.btnDERemove.setEnabled(false);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.edTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnDEProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnDEProperties.setEnabled(false);
            this.btnDEProperties.setToolTipText(BTN_PROPERTIES);
            this.btnDEProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = AgentPropertiesDialogEx.this.edTable.getSelectedRow();
                    if (row > -1 && AgentPropertiesDialogEx.this.edList.size() > 0 && row < AgentPropertiesDialogEx.this.edList.size()) {
                        ExternalData extData = (ExternalData)AgentPropertiesDialogEx.this.edList.get(row);
                        extData.showModal = AgentPropertiesDialogEx.this.agent.showModal || AgentPropertiesDialogEx.this.agent.showForFirstTime();
                        extData.showPropertyDialog();
                        ((ExternalDataModel)AgentPropertiesDialogEx.this.edTable.getModel()).fireTableDataChanged();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnDEProperties);
            if (this.isEditable()) {
                this.btnDEAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnDEAdd.setToolTipText(BTN_ADD);
                this.btnDEAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ExternalData extData = AgentPropertiesDialogEx.this.agent.getDesign().getProcessModel().createExternalData();
                        extData.setType(AgentPropertiesDialogEx.this.agent.getDesign().getDomainSet().getDefaultDomain().getLogicalDatatype());
                        AgentPropertiesDialogEx.this.newExtDatas.add(extData);
                        AgentPropertiesDialogEx.this.edList.add(extData);
                        AgentPropertiesDialogEx.this.edTable.updateUI();
                    }
                });
                this.btnDERemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnDERemove.setEnabled(false);
                this.btnDERemove.setToolTipText(BTN_REMOVE);
                this.btnDERemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = AgentPropertiesDialogEx.this.edTable.getSelectedRow();
                        if (objectNumber != -1 && AgentPropertiesDialogEx.this.edList.size() > 0 && objectNumber < AgentPropertiesDialogEx.this.edList.size()) {
                            AgentPropertiesDialogEx.this.edList.remove(objectNumber);
                            AgentPropertiesDialogEx.this.edTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(this.btnDEAdd);
                toolBar.add(this.btnDERemove);
            }
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 300));
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add((Component)buttonGeneral, "North");
            aPanel.add(scrollpane);
            this.pnDataElement.add(aPanel);
        }
        return this.pnDataElement;
    }

    private void makeWrapperList() {
        this.attrMWList.clear();
        this.edWList.clear();
        this.attributes = this.agent.getAttributes();
        Iterator it = this.attributes.iterator();
        while (it.hasNext()) {
            this.attrMWList.add(new DesignObjectWrapper((DesignObject)it.next()));
        }
        for (int i = 0; i < this.edList.size(); ++i) {
            ExternalData ed = (ExternalData)this.edList.get(i);
            this.edWList.add(i, this.getWrapper(ed, this.attrMWList));
        }
    }

    private DesignObjectWrapper getWrapper(ExternalData ed, List wlist) {
        Iterator it = wlist.iterator();
        DesignObject obj = ed.getMappedDesignObject();
        while (it.hasNext()) {
            DesignObjectWrapper dow = (DesignObjectWrapper)it.next();
            if (obj != dow.getDesignObject()) continue;
            return dow;
        }
        return null;
    }

    @Override
    protected int getMinimumHeight() {
        return 440;
    }

    @Override
    protected int getMinimumTreeWidth() {
        return 200;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    public class DesignObjectWrapper {
        DesignObject dobject;

        public DesignObjectWrapper(DesignObject object) {
            this.dobject = object;
        }

        public DesignObject getDesignObject() {
            return this.dobject;
        }

        public String toString() {
            if (this.dobject != null) {
                return this.dobject.getLongName();
            }
            return "";
        }
    }

    private class ExternalDataModel
    extends AbstractTableModel {
        private ExternalDataModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return AgentPropertiesDialogEx.this.edList.size();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Messages.getString("AgentPropertiesDialogEx.ExternalDatas");
                }
                case 1: {
                    return Messages.getString("AgentPropertiesDialogEx.Type");
                }
                case 2: {
                    return Messages.getString("AgentPropertiesDialogEx.StartingPosition");
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ExternalData extData = (ExternalData)AgentPropertiesDialogEx.this.edList.get(row);
            switch (col) {
                case 0: {
                    return extData.getName();
                }
                case 1: {
                    if (extData.isStructured()) {
                        return extData.getRecordStructure() != null ? extData.getRecordStructure().getName() : "";
                    }
                    return extData.getType();
                }
                case 2: {
                    return Integer.toString(extData.getStartingPos());
                }
            }
            return new Integer(row * col);
        }
    }

    private class OutgoingFlowsModel
    extends AbstractTableModel {
        private OutgoingFlowsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AgentPropertiesDialogEx.this.ofList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AgentPropertiesDialogEx.OutgoingFlows");
            }
            if (column == 1) {
                return Messages.getString("AgentPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Flow flow = (Flow)AgentPropertiesDialogEx.this.ofList.get(row);
            if (col == 0) {
                return flow.getName();
            }
            if (col == 1) {
                return flow.getSynonym();
            }
            return new Integer(row * col);
        }
    }

    private class IncomingFlowsModel
    extends AbstractTableModel {
        private IncomingFlowsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AgentPropertiesDialogEx.this.ifList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AgentPropertiesDialogEx.IncomingFlows");
            }
            if (column == 1) {
                return Messages.getString("AgentPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Flow flow = (Flow)AgentPropertiesDialogEx.this.ifList.get(row);
            if (col == 0) {
                return flow.getName();
            }
            if (col == 1) {
                return flow.getSynonym();
            }
            return new Integer(row * col);
        }
    }
}

