/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class EventPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfSynonym;
    private Event event;
    private JButton btnFlow;
    private JTextField tfText;
    private List pList;
    private JTable pTable;
    private JPanel pnProcess;
    private JIntegerField ifFrequency;
    private JRadioButton rbEvery;
    private JRadioButton rbOn;
    private JLabel lbFrequency;
    private JComboBox cbDayOfWeek;
    private JIntegerField ifDayOfMonth;
    private JComboBox cbMonth;
    private JRadioButton rbFirst;
    private JRadioButton rbSecond;
    private JRadioButton rbThird;
    private JRadioButton rbFourth;
    private JRadioButton rbAll;
    private JIntegerField ifYear;
    private JRadioButton rbFiscal;
    private JRadioButton rbCalendar;
    private JPanel pnDays;
    private int quarter;
    private JRadioButton rbAtOpenDay;
    private JRadioButton rbAtCloseDay;
    private JRadioButton rbDuringDay;
    private JRadioButton rbAtSpecifiedTime;
    private JRadioButton rbAt;
    private JRadioButton rbEveryTime;
    private JLabel lbTimeFrequency;
    private JIntegerField ifTimeFreq;
    private JLabel lbHour;
    private JIntegerField ifHour;
    private JLabel lbMinute;
    private JIntegerField ifMinute;
    private JPanel pnTimes;
    private int timesWhenRun;
    private JTextField tfType;
    private JLabel lbDayOfWeek;
    private JLabel lbDayOfMonth;
    private JLabel lbMonth;
    private JLabel lbYear;
    private JButton btnProcessProperties;

    public EventPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public EventPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbSynonym = new JLabel(LB_SYNOMYM);
        lbSynonym.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSynonym, this.tfSynonym));
        JLabel lbFlow = new JLabel(LB_FLOW);
        lbFlow.setPreferredSize(this.getDefaultSize());
        this.btnFlow = new JButton();
        this.btnFlow.setPreferredSize(this.getDefaultSize());
        this.btnFlow.setFont(this.btnFlow.getFont().deriveFont(0));
        this.btnFlow.setEnabled(false);
        this.btnFlow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EventPropertiesDialogEx.this.event.getFlow() != null) {
                    EventPropertiesDialogEx.this.event.getFlow().showPropertyDialog();
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbFlow, this.btnFlow));
        JLabel lbText = new JLabel(LB_EVENT_TEXT);
        lbText.setPreferredSize(this.getDefaultSize());
        this.tfText = new JTextField();
        this.tfText.setEnabled(false);
        this.tfText.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbText, this.tfText));
        JLabel lbType = new JLabel(LB_TYPE);
        lbType.setPreferredSize(this.getDefaultSize());
        this.tfType = new JTextField();
        this.tfType.setPreferredSize(this.getDefaultSize());
        this.tfType.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(lbType, this.tfType));
    }

    @Override
    public String getCaption() {
        return Messages.getString("EventPropertiesDialogEx.EventProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Event) {
            this.event = (Event)object;
            this.initDefaults(false);
            this.tfSynonym.setText(this.event.getSynonym());
            int type = this.event.getEventType();
            if (type == 2 || type == 3) {
                this.tfText.setEnabled(true);
                this.tfText.setText(this.event.getText());
            }
            if (type == 0) {
                String flowName = this.event.getFlow() != null ? this.event.getFlow().getName() : Messages.getString("EventPropertiesDialogEx.NONE");
                this.btnFlow.setEnabled(true);
                this.btnFlow.setText(flowName);
            }
            switch (type) {
                case 0: {
                    this.tfType.setText(Messages.getString("EventPropertiesDialogEx.InformationFlow"));
                    break;
                }
                case 1: {
                    this.tfType.setText(Messages.getString("EventPropertiesDialogEx.ClockCalendar"));
                    break;
                }
                case 2: {
                    this.tfType.setText(Messages.getString("EventPropertiesDialogEx.Person"));
                    break;
                }
                case 3: {
                    this.tfType.setText(Messages.getString("EventPropertiesDialogEx.Storage"));
                    break;
                }
                default: {
                    this.tfType.setText(Messages.getString("EventPropertiesDialogEx.InformationFlow"));
                }
            }
            if (this.event.getFlow() != null) {
                AbstractProcessObject obj = this.event.getFlow().getTargetProcessObject();
                if (obj instanceof Process) {
                    this.pList.add(obj);
                } else {
                    this.pList.add(this.event.getFlow().getSourceProcessObject());
                }
            }
            this.pList.addAll(this.event.getProcessTriggered());
            if (this.event.isOnDay()) {
                this.rbOn.setSelected(true);
            } else {
                this.rbEvery.setSelected(true);
            }
            if (this.event.isFiscal()) {
                this.rbFiscal.setSelected(true);
            } else {
                this.rbCalendar.setSelected(true);
            }
            this.setFrequency();
            this.ifFrequency.setValue((long)this.event.getFrequency());
            this.cbDayOfWeek.setSelectedItem(this.translate(this.event.getDayOfWeek(), Event.DAYS_OF_WEEK, Event.DAYS_OF_WEEK_DISPLAY));
            this.ifDayOfMonth.setValue((long)this.event.getDayOfMonth());
            this.cbMonth.setSelectedItem(this.translate(this.event.getMonths(), Event.MONTHS, Event.MONTHS_DISPLAY));
            this.ifYear.setValue((long)this.event.getYear());
            this.quarter = this.event.getQuarter();
            switch (this.quarter) {
                case 1: {
                    this.rbFirst.setSelected(true);
                    break;
                }
                case 2: {
                    this.rbSecond.setSelected(true);
                    break;
                }
                case 3: {
                    this.rbThird.setSelected(true);
                    break;
                }
                case 4: {
                    this.rbFourth.setSelected(true);
                    break;
                }
                case 0: {
                    this.rbAll.setSelected(true);
                    break;
                }
                default: {
                    this.rbAll.setSelected(true);
                }
            }
            this.timesWhenRun = this.event.getTimesWhenRun();
            switch (this.timesWhenRun) {
                case 1: {
                    this.rbAtOpenDay.setSelected(true);
                    break;
                }
                case 2: {
                    this.rbAtCloseDay.setSelected(true);
                    break;
                }
                case 3: {
                    this.rbDuringDay.setSelected(true);
                    break;
                }
                case 4: {
                    this.rbAtSpecifiedTime.setSelected(true);
                    break;
                }
                default: {
                    this.rbAtOpenDay.setSelected(true);
                }
            }
            if (this.event.isAtTime()) {
                this.rbAt.setSelected(true);
            } else {
                this.rbEveryTime.setSelected(true);
            }
            this.ifTimeFreq.setValue((long)this.event.getTimeFreq());
            this.ifHour.setValue((long)this.event.getHour());
            this.ifMinute.setValue((long)this.event.getMinute());
            this.setTimeFreq();
            this.enableTimePanel();
            this.enableTimePage();
            this.enableDaysPage();
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.initDynamicProperties();
        }
    }

    @Override
    protected void setProperties() {
        this.event.setName(this.tfName.getText());
        this.event.setComment(this.taComments.getText());
        this.event.setSynonym(this.tfSynonym.getText());
        this.event.setNotes(this.taNotes.getText());
        int type = this.event.getEventType();
        if (!(type != 2 && type != 3 || this.tfText.getText().trim().equals(""))) {
            this.event.setText(this.tfText.getText());
        }
        if (this.event.getEventType() == 1) {
            boolean onDay = this.rbOn.isSelected();
            this.event.setOnDay(onDay);
            if (!onDay) {
                this.event.setFrequency(this.ifFrequency.getIntValue());
            }
            this.event.setDayOfWeek(this.translate((String)this.cbDayOfWeek.getSelectedItem(), Event.DAYS_OF_WEEK_DISPLAY, Event.DAYS_OF_WEEK));
            this.event.setDayOfMonth(this.ifDayOfMonth.getIntValue());
            this.event.setMonths(this.translate((String)this.cbMonth.getSelectedItem(), Event.MONTHS_DISPLAY, Event.MONTHS));
            this.event.setQuarter(this.quarter);
            this.event.setYear(this.ifYear.getIntValue());
            this.event.setFiscal(this.rbFiscal.isSelected());
            this.event.setTimesWhenRun(this.timesWhenRun);
            if (this.timesWhenRun == 4) {
                boolean atTime = this.rbAt.isSelected();
                this.event.setAtTime(atTime);
                if (!atTime) {
                    this.event.setTimeFreq(this.ifTimeFreq.getIntValue());
                }
                this.event.setHour(this.ifHour.getIntValue());
                this.event.setMinute(this.ifMinute.getIntValue());
            }
        }
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        EventPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.event.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.event.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getProcessPanel());
        this.addToTree(root, this.getDaysWhenRunPanel());
        this.addToTree(root, this.getTimesWhenRunPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "EVENT_PROPERTIES_DIALOG";
    }

    private JPanel getProcessPanel() {
        this.pList = new ArrayList();
        if (this.pnProcess == null) {
            this.pnProcess = this.createPage(Messages.getString("EventPropertiesDialogEx.ProcessTriggered"));
            this.pTable = new JTable(new ProcessTableModel());
            this.pTable.setSelectionMode(0);
            this.pTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = EventPropertiesDialogEx.this.pTable.getSelectedRow();
                    if (row != -1) {
                        if (e.getClickCount() == 2 && EventPropertiesDialogEx.this.pList.size() > 0 && row < EventPropertiesDialogEx.this.pList.size()) {
                            Process process = (Process)EventPropertiesDialogEx.this.pList.get(row);
                            process.showPropertyDialog();
                        }
                        EventPropertiesDialogEx.this.btnProcessProperties.setEnabled(true);
                    } else {
                        EventPropertiesDialogEx.this.btnProcessProperties.setEnabled(false);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.pTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnProcessProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProcessProperties.setEnabled(false);
            this.btnProcessProperties.setToolTipText(Messages.getString("EventPropertiesDialogEx.Properties"));
            this.btnProcessProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = EventPropertiesDialogEx.this.pTable.getSelectedRow();
                    if (row != -1 && EventPropertiesDialogEx.this.pList.size() > 0 && row < EventPropertiesDialogEx.this.pList.size()) {
                        Process process = (Process)EventPropertiesDialogEx.this.pList.get(row);
                        process.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnProcessProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 195));
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnProcess.add(pPanel);
        }
        return this.pnProcess;
    }

    private JPanel getDaysWhenRunPanel() {
        if (this.pnDays == null) {
            this.pnDays = this.createPage(Messages.getString("EventPropertiesDialogEx.DaysWhenRun"));
            JPanel jpanel = new JPanel(new BorderLayout(10, 10));
            JPanel pnFrequency = new JPanel(new GridLayout(0, 2));
            JPanel pnWhen = new JPanel(new GridLayout(0, 2));
            DayListener dayListener = new DayListener();
            this.rbEvery = new JRadioButton(Messages.getString("EventPropertiesDialogEx.Every"));
            this.rbEvery.addActionListener(dayListener);
            this.rbEvery.setMnemonic(69);
            this.rbOn = new JRadioButton(Messages.getString("EventPropertiesDialogEx.On"));
            this.rbOn.addActionListener(dayListener);
            this.rbOn.setMnemonic(79);
            ButtonGroup group = new ButtonGroup();
            group.add(this.rbEvery);
            group.add(this.rbOn);
            pnWhen.add(this.rbEvery);
            pnWhen.add(this.rbOn);
            pnFrequency.add((Component)pnWhen, "West");
            this.lbFrequency = new JLabel(LB_FREQUENCY);
            this.ifFrequency = new JIntegerField();
            this.ifFrequency.setPreferredSize(new Dimension(70, 20));
            JPanel row = new JPanel(new BorderLayout(20, 20));
            row.add((Component)this.lbFrequency, "West");
            row.add(this.ifFrequency);
            pnFrequency.add((Component)row, "East");
            jpanel.add((Component)pnFrequency, "North");
            JPanel panelDate = new JPanel(new BorderLayout(10, 10));
            panelDate.setBorder(BorderFactory.createTitledBorder(""));
            JPanel pnDate = new JPanel(new GridLayout(0, 1, 10, 10));
            this.lbDayOfWeek = new JLabel(LB_DAY_OF_WEEK);
            this.lbDayOfWeek.setPreferredSize(this.getDefaultSize());
            this.cbDayOfWeek = new JComboBox<String>(Event.DAYS_OF_WEEK_DISPLAY);
            this.cbDayOfWeek.setFont(this.cbDayOfWeek.getFont().deriveFont(0));
            this.cbDayOfWeek.setPreferredSize(this.getDefaultSize());
            this.cbDayOfWeek.setMaximumRowCount(Event.DAYS_OF_WEEK_DISPLAY.length);
            pnDate.add(this.createRow(this.lbDayOfWeek, this.cbDayOfWeek));
            this.lbDayOfMonth = new JLabel(LB_DAY_OF_MONTH);
            this.lbDayOfMonth.setPreferredSize(this.getDefaultSize());
            this.ifDayOfMonth = new JIntegerField();
            this.ifDayOfMonth.setFont(this.ifDayOfMonth.getFont().deriveFont(0));
            this.ifDayOfMonth.setPreferredSize(this.getDefaultSize());
            this.ifDayOfMonth.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String value = EventPropertiesDialogEx.this.ifDayOfMonth.getText();
                    if (!"".equalsIgnoreCase(value)) {
                        if (EventPropertiesDialogEx.this.ifDayOfMonth.getIntValue() > 31) {
                            EventPropertiesDialogEx.this.ifDayOfMonth.setValue(0L);
                            JOptionPane.showMessageDialog(EventPropertiesDialogEx.this, Messages.getString("EventPropertiesDialogEx.DayValueMustBePositiveInteger"));
                            EventPropertiesDialogEx.this.ifDayOfMonth.grabFocus();
                        }
                    } else {
                        EventPropertiesDialogEx.this.ifDayOfMonth.setValue(0L);
                    }
                }
            });
            pnDate.add(this.createRow(this.lbDayOfMonth, this.ifDayOfMonth));
            this.lbMonth = new JLabel(LB_MONTH);
            this.lbMonth.setPreferredSize(this.getDefaultSize());
            this.cbMonth = new JComboBox<String>(Event.MONTHS_DISPLAY);
            this.cbMonth.setFont(this.cbMonth.getFont().deriveFont(0));
            this.cbMonth.setPreferredSize(this.getDefaultSize());
            this.cbMonth.setMaximumRowCount(Event.MONTHS_DISPLAY.length);
            pnDate.add(this.createRow(this.lbMonth, this.cbMonth));
            panelDate.add((Component)pnDate, "North");
            jpanel.add((Component)panelDate, "Center");
            JPanel pnDown = new JPanel(new BorderLayout(20, 20));
            JPanel pnQuarter = new JPanel(new GridLayout(0, 5));
            pnQuarter.setBorder(BorderFactory.createTitledBorder(Messages.getString("EventPropertiesDialogEx.Quarter")));
            QuarterListener quarterListener = new QuarterListener();
            this.rbFirst = new JRadioButton(Messages.getString("EventPropertiesDialogEx.1st"));
            this.rbFirst.addActionListener(quarterListener);
            this.rbFirst.setMnemonic(49);
            this.rbSecond = new JRadioButton(Messages.getString("EventPropertiesDialogEx.2nd"));
            this.rbSecond.addActionListener(quarterListener);
            this.rbSecond.setMnemonic(50);
            this.rbThird = new JRadioButton(Messages.getString("EventPropertiesDialogEx.3rd"));
            this.rbThird.addActionListener(quarterListener);
            this.rbThird.setMnemonic(51);
            this.rbFourth = new JRadioButton(Messages.getString("EventPropertiesDialogEx.4th"));
            this.rbFourth.addActionListener(quarterListener);
            this.rbFourth.setMnemonic(52);
            this.rbAll = new JRadioButton(Messages.getString("EventPropertiesDialogEx.All"));
            this.rbAll.addActionListener(quarterListener);
            this.rbAll.setMnemonic(65);
            group = new ButtonGroup();
            group.add(this.rbFirst);
            group.add(this.rbSecond);
            group.add(this.rbThird);
            group.add(this.rbFourth);
            group.add(this.rbAll);
            pnQuarter.add(this.rbFirst);
            pnQuarter.add(this.rbSecond);
            pnQuarter.add(this.rbThird);
            pnQuarter.add(this.rbFourth);
            pnQuarter.add(this.rbAll);
            pnDown.add((Component)pnQuarter, "North");
            JPanel pnYear = new JPanel(new GridLayout(0, 2, 10, 10));
            this.lbYear = new JLabel(LB_YEAR);
            this.lbYear.setPreferredSize(new Dimension(50, 20));
            this.ifYear = new JIntegerField();
            this.ifYear.setPreferredSize(new Dimension(110, 20));
            pnYear.add(this.createRow(this.lbYear, this.ifYear));
            JPanel pnYearType = new JPanel(new GridLayout(0, 2));
            this.rbFiscal = new JRadioButton(Messages.getString("EventPropertiesDialogEx.Fiscal"));
            this.rbFiscal.setMnemonic(70);
            this.rbCalendar = new JRadioButton(Messages.getString("EventPropertiesDialogEx.Calendar"));
            this.rbCalendar.setMnemonic(67);
            group = new ButtonGroup();
            group.add(this.rbFiscal);
            group.add(this.rbCalendar);
            pnYearType.add(this.rbFiscal);
            pnYearType.add(this.rbCalendar);
            pnYear.add(pnYearType);
            pnDown.add(pnYear);
            jpanel.add((Component)pnDown, "South");
            this.pnDays.add(jpanel);
        }
        return this.pnDays;
    }

    private void setFrequency() {
        this.ifFrequency.setEnabled(this.rbEvery.isSelected());
        this.lbFrequency.setEnabled(this.ifFrequency.isEnabled());
    }

    private JPanel getTimesWhenRunPanel() {
        if (this.pnTimes == null) {
            this.pnTimes = this.createPage(Messages.getString("EventPropertiesDialogEx.TimesWhenRun"));
            JPanel jpanel = new JPanel(new GridLayout(0, 1));
            JPanel pnUp = new JPanel(new GridLayout(0, 1));
            TimeListener timeListener = new TimeListener();
            this.rbAtOpenDay = new JRadioButton(Messages.getString("EventPropertiesDialogEx.OBD"));
            this.rbAtOpenDay.addActionListener(timeListener);
            this.rbAtOpenDay.setMnemonic(79);
            this.rbAtCloseDay = new JRadioButton(Messages.getString("EventPropertiesDialogEx.COB"));
            this.rbAtCloseDay.addActionListener(timeListener);
            this.rbAtCloseDay.setMnemonic(67);
            this.rbDuringDay = new JRadioButton(Messages.getString("EventPropertiesDialogEx.WhenConvenientDuringDay"));
            this.rbDuringDay.addActionListener(timeListener);
            this.rbDuringDay.setMnemonic(68);
            this.rbAtSpecifiedTime = new JRadioButton(Messages.getString("EventPropertiesDialogEx.AtSpecifiedTime"));
            this.rbAtSpecifiedTime.addActionListener(timeListener);
            this.rbAtSpecifiedTime.setMnemonic(83);
            ButtonGroup group = new ButtonGroup();
            group.add(this.rbAtOpenDay);
            group.add(this.rbAtCloseDay);
            group.add(this.rbDuringDay);
            group.add(this.rbAtSpecifiedTime);
            pnUp.add(this.rbAtOpenDay);
            pnUp.add(this.rbAtCloseDay);
            pnUp.add(this.rbDuringDay);
            pnUp.add(this.rbAtSpecifiedTime);
            jpanel.add(pnUp);
            JPanel pnDown = new JPanel(new BorderLayout(30, 30));
            pnDown.setBorder(BorderFactory.createTitledBorder(Messages.getString("EventPropertiesDialogEx.Time")));
            JPanel pnTimeFreq = new JPanel(new GridLayout(0, 2));
            JPanel pnWhen = new JPanel(new GridLayout(0, 2));
            TimeFreqListener timeFreqListener = new TimeFreqListener();
            this.rbAt = new JRadioButton(Messages.getString("EventPropertiesDialogEx.At"));
            this.rbAt.addActionListener(timeFreqListener);
            this.rbAt.setMnemonic(65);
            this.rbEveryTime = new JRadioButton(Messages.getString("EventPropertiesDialogEx.Every"));
            this.rbEveryTime.addActionListener(timeFreqListener);
            this.rbEveryTime.setMnemonic(69);
            group = new ButtonGroup();
            group.add(this.rbAt);
            group.add(this.rbEveryTime);
            pnWhen.add(this.rbAt);
            pnWhen.add(this.rbEveryTime);
            pnTimeFreq.add(pnWhen);
            this.lbTimeFrequency = new JLabel(LB_FREQUENCY);
            this.ifTimeFreq = new JIntegerField();
            JPanel row = new JPanel(new BorderLayout(20, 20));
            row.add((Component)this.lbTimeFrequency, "West");
            row.add(this.ifTimeFreq);
            pnTimeFreq.add((Component)row, "East");
            this.setTimeFreq();
            pnDown.add((Component)pnTimeFreq, "North");
            JPanel panelTime = new JPanel(new BorderLayout(10, 10));
            JPanel pnTime = new JPanel(new GridLayout(0, 2, 10, 10));
            this.lbHour = new JLabel(LB_HOUR);
            this.lbHour.setPreferredSize(this.lbTimeFrequency.getPreferredSize());
            this.ifHour = new JIntegerField();
            this.ifHour.setFont(this.ifHour.getFont().deriveFont(0));
            this.ifHour.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String value = EventPropertiesDialogEx.this.ifHour.getText();
                    if (!"".equalsIgnoreCase(value)) {
                        if (EventPropertiesDialogEx.this.ifHour.getIntValue() > 31) {
                            EventPropertiesDialogEx.this.ifHour.setValue(0L);
                            JOptionPane.showMessageDialog(EventPropertiesDialogEx.this, Messages.getString("EventPropertiesDialogEx.HourValueMustBePositiveInteger"));
                            EventPropertiesDialogEx.this.ifHour.grabFocus();
                        }
                    } else {
                        EventPropertiesDialogEx.this.ifHour.setValue(0L);
                    }
                }
            });
            pnTime.add(this.createRow(this.lbHour, this.ifHour));
            this.lbMinute = new JLabel(LB_MINUTE);
            this.lbMinute.setPreferredSize(this.lbTimeFrequency.getPreferredSize());
            this.ifMinute = new JIntegerField();
            this.ifMinute.setFont(this.ifMinute.getFont().deriveFont(0));
            this.ifMinute.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String value = EventPropertiesDialogEx.this.ifMinute.getText();
                    if (!"".equalsIgnoreCase(value)) {
                        if (EventPropertiesDialogEx.this.ifMinute.getIntValue() > 31) {
                            EventPropertiesDialogEx.this.ifMinute.setValue(0L);
                            JOptionPane.showMessageDialog(EventPropertiesDialogEx.this, Messages.getString("EventPropertiesDialogEx.MinuteValueMustBePositiveInteger"));
                            EventPropertiesDialogEx.this.ifMinute.grabFocus();
                        }
                    } else {
                        EventPropertiesDialogEx.this.ifMinute.setValue(0L);
                    }
                }
            });
            pnTime.add(this.createRow(this.lbMinute, this.ifMinute));
            panelTime.add((Component)pnTime, "North");
            pnDown.add((Component)panelTime, "Center");
            jpanel.add(pnDown);
            this.pnTimes.add(jpanel);
        }
        return this.pnTimes;
    }

    private void setTimeFreq() {
        this.ifTimeFreq.setEnabled(this.rbAt.isSelected());
        this.lbTimeFrequency.setEnabled(this.rbAt.isSelected());
    }

    private void enableTimePanel() {
        boolean enabled = this.rbAtSpecifiedTime.isSelected();
        this.rbAt.setEnabled(enabled);
        this.rbEveryTime.setEnabled(enabled);
        this.ifTimeFreq.setEnabled(enabled);
        this.lbTimeFrequency.setEnabled(enabled);
        this.ifHour.setEnabled(enabled);
        this.ifMinute.setEnabled(enabled);
        this.lbHour.setEnabled(enabled);
        this.lbMinute.setEnabled(enabled);
    }

    private void enableTimePage() {
        boolean enabled = this.event.getEventType() == 1;
        this.rbAtOpenDay.setEnabled(enabled);
        this.rbAtCloseDay.setEnabled(enabled);
        this.rbDuringDay.setEnabled(enabled);
        this.rbAtSpecifiedTime.setEnabled(enabled);
        this.enableTimePanel();
    }

    private void enableDaysPage() {
        boolean enabled = this.event.getEventType() == 1;
        this.rbEvery.setEnabled(enabled);
        this.rbOn.setEnabled(enabled);
        this.lbDayOfWeek.setEnabled(enabled);
        this.cbDayOfWeek.setEnabled(enabled);
        this.lbDayOfMonth.setEnabled(enabled);
        this.ifDayOfMonth.setEnabled(enabled);
        this.lbMonth.setEnabled(enabled);
        this.cbMonth.setEnabled(enabled);
        this.rbFirst.setEnabled(enabled);
        this.rbSecond.setEnabled(enabled);
        this.rbThird.setEnabled(enabled);
        this.rbFourth.setEnabled(enabled);
        this.rbAll.setEnabled(enabled);
        this.lbYear.setEnabled(enabled);
        this.ifYear.setEnabled(enabled);
        this.rbFiscal.setEnabled(enabled);
        this.rbCalendar.setEnabled(enabled);
        this.setFrequency();
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class TimeFreqListener
    implements ActionListener {
        private TimeFreqListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventPropertiesDialogEx.this.setTimeFreq();
        }
    }

    private class TimeListener
    implements ActionListener {
        private TimeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventPropertiesDialogEx.this.enableTimePanel();
            JRadioButton source = (JRadioButton)e.getSource();
            EventPropertiesDialogEx.this.timesWhenRun = source == EventPropertiesDialogEx.this.rbAtSpecifiedTime ? 4 : (source == EventPropertiesDialogEx.this.rbAtCloseDay ? 2 : (source == EventPropertiesDialogEx.this.rbDuringDay ? 3 : 1));
        }
    }

    private class QuarterListener
    implements ActionListener {
        private QuarterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButton source = (JRadioButton)e.getSource();
            EventPropertiesDialogEx.this.quarter = source == EventPropertiesDialogEx.this.rbFirst ? 1 : (source == EventPropertiesDialogEx.this.rbSecond ? 2 : (source == EventPropertiesDialogEx.this.rbThird ? 3 : (source == EventPropertiesDialogEx.this.rbFourth ? 4 : 0)));
        }
    }

    private class DayListener
    implements ActionListener {
        private DayListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventPropertiesDialogEx.this.setFrequency();
        }
    }

    private class ProcessTableModel
    extends AbstractTableModel {
        private ProcessTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return EventPropertiesDialogEx.this.pList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("EventPropertiesDialogEx.Processes");
            }
            if (column == 1) {
                return Messages.getString("EventPropertiesDialogEx.Synonym");
            }
            if (column == 2) {
                return Messages.getString("EventPropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Process process = (Process)EventPropertiesDialogEx.this.pList.get(row);
            if (col == 0) {
                return process.getName();
            }
            if (col == 1) {
                return process.getSynonym();
            }
            if (col == 2) {
                return process.getProcessTypeName();
            }
            return new Integer(row * col);
        }
    }
}

