/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.TransformationFlow;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.AddStructureDialog;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.swingui.process.TVFlow;

public class TransformationFlowPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JPanel pnGeneral;
    private JPanel pnGeneralGrid;
    private JTextField tfSynonym;
    private JButton bnSource;
    private TransformationFlow flow;
    private JButton bnDestination;
    private JLabel lbLoggingFlow;
    private JCheckBox chbLoggingFlow;
    private JCheckBox chbCRUDCreate;
    private JCheckBox chbCRUDRead;
    private JCheckBox chbCRUDUpdate;
    private JCheckBox chbCRUDDelete;
    private JPanel pnInfoStructure;
    private ArrayList isList;
    private JTable istable;
    private JButton btnProperties;
    private JButton btnAdd;
    private JButton btnRemove;
    private JPanel pnExternalData;
    private ArrayList edList;
    private JTable edtable;
    private JButton btnExProperties;
    private JPanel pnSystemObjective;
    private JTextArea taSystemObjective;

    public TransformationFlowPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
    }

    @Override
    public String getCaption() {
        return Messages.getString("TransformationFlowPropertiesDialogEx.TransformationFlowProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof TransformationFlow) {
            this.flow = (TransformationFlow)object;
            this.initDefaults(false);
            this.tfSynonym.setText(this.flow.getSynonym());
            String sourceName = this.flow.getSource() != null ? this.flow.getSource().getName() : Messages.getString("TransformationFlowPropertiesDialogEx.NONE");
            this.bnSource.setText(sourceName);
            String destName = this.flow.getDestination() != null ? this.flow.getDestination().getName() : Messages.getString("TransformationFlowPropertiesDialogEx.NONE");
            this.bnDestination.setText(destName);
            this.chbLoggingFlow.setSelected(this.flow.isLogging());
            this.taSystemObjective.setText(this.flow.getSystemObjective());
            this.chbCRUDCreate.setSelected(this.flow.isOpCreate());
            this.chbCRUDRead.setSelected(this.flow.isOpRead());
            this.chbCRUDUpdate.setSelected(this.flow.isOpUpdate());
            this.chbCRUDDelete.setSelected(this.flow.isOpDelete());
            if (this.flow.isConnecedTotCompositeProc() || !this.flow.isConnectedToInfoStore()) {
                this.disableCRUD();
            }
            if (this.flow.isConnecedTotCompositeProc()) {
                this.btnAdd.setEnabled(false);
                this.btnRemove.setEnabled(false);
            }
            if (this.flow.getTargetProcessObject() instanceof InfoStore) {
                this.chbCRUDRead.setEnabled(false);
            }
            if (this.flow.getSourceProcessObject() instanceof InfoStore) {
                this.chbCRUDCreate.setEnabled(false);
                this.chbCRUDUpdate.setEnabled(false);
                this.chbCRUDDelete.setEnabled(false);
                this.chbCRUDRead.setSelected(true);
                this.chbCRUDRead.setEnabled(false);
            }
            if (!this.flow.getExternalData().isEmpty()) {
                this.enableComponents(true);
            } else {
                this.enableComponents(false);
            }
            this.isList.addAll(this.flow.getInfoStructures());
            this.edList.addAll(this.flow.getExternalData());
            this.initDynamicProperties();
        }
    }

    @Override
    protected void setProperties() {
        this.flow.setName(this.tfName.getText());
        this.flow.setNotes(this.taNotes.getText());
        this.flow.setComment(this.taComments.getText());
        this.flow.setSynonym(this.tfSynonym.getText());
        this.flow.setLogging(this.chbLoggingFlow.isSelected());
        this.flow.setOpCreate(this.chbCRUDCreate.isSelected());
        this.flow.setOpRead(this.chbCRUDRead.isSelected());
        this.flow.setOpUpdate(this.chbCRUDUpdate.isSelected());
        this.flow.setOpDelete(this.chbCRUDDelete.isSelected());
        this.flow.setSystemObjective(this.taSystemObjective.getText());
        this.flow.getInfoStructures().clear();
        for (InfoStructure structure : this.isList) {
            this.flow.addInfoStructure(structure);
        }
        if (this.flow.getTopView() != null) {
            ((TVFlow)this.flow.getTopView()).displayLabels();
        }
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        TransformationFlowPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.flow.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.flow.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getInfoStructuresPanel());
        this.addToTree(root, this.getExternalDataPanel());
        this.addToTree(root, this.getSystemObjectivePanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "TRANSFORMATION_FLOW_PROPERTIES_DIALOG";
    }

    @Override
    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(Messages.getString("TransformationFlowPropertiesDialogEx.General"));
            JPanel jpanel = new JPanel(new BorderLayout(10, 10));
            this.pnGeneralGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbName = new JLabel(LB_NAME);
            lbName.setPreferredSize(this.getDefaultSize());
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.getDefaultSize());
            this.pnGeneralGrid.add(this.createRow(lbName, this.tfName));
            JLabel lbSynonym = new JLabel(LB_SYNOMYM);
            lbSynonym.setPreferredSize(this.getDefaultSize());
            this.tfSynonym = new JTextField();
            this.tfSynonym.setPreferredSize(this.getDefaultSize());
            this.pnGeneralGrid.add(this.createRow(lbSynonym, this.tfSynonym));
            JLabel lbSource = new JLabel(LB_SOURCE);
            lbSource.setPreferredSize(this.getDefaultSize());
            this.bnSource = new JButton();
            this.bnSource.setPreferredSize(this.getDefaultSize());
            this.bnSource.setFont(this.bnSource.getFont().deriveFont(0));
            this.bnSource.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TransformationFlowPropertiesDialogEx.this.flow.getSource() != null) {
                        TransformationFlowPropertiesDialogEx.this.flow.getSource().showPropertyDialog();
                    }
                }
            });
            this.pnGeneralGrid.add(this.createRow(lbSource, this.bnSource));
            JLabel lbDestination = new JLabel(LB_DESTINATION);
            lbDestination.setPreferredSize(this.getDefaultSize());
            this.bnDestination = new JButton();
            this.bnDestination.setPreferredSize(this.getDefaultSize());
            this.bnDestination.setFont(this.bnDestination.getFont().deriveFont(0));
            this.bnDestination.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TransformationFlowPropertiesDialogEx.this.flow.getDestination() != null) {
                        TransformationFlowPropertiesDialogEx.this.flow.getDestination().showPropertyDialog();
                    }
                }
            });
            this.pnGeneralGrid.add(this.createRow(lbDestination, this.bnDestination));
            this.lbLoggingFlow = new JLabel(Messages.getString("TransformationFlowPropertiesDialogEx.LoggingFlow"));
            this.lbLoggingFlow.setPreferredSize(this.getDefaultSize());
            this.chbLoggingFlow = new JCheckBox();
            this.chbLoggingFlow.setPreferredSize(this.getDefaultSize());
            this.pnGeneralGrid.add(this.createRow(this.lbLoggingFlow, this.chbLoggingFlow));
            JPanel bottomPanel = new JPanel(new BorderLayout());
            JPanel jOperation = new JPanel(new GridLayout(0, 2, 10, 10));
            jOperation.setBorder(BorderFactory.createTitledBorder(Messages.getString("TransformationFlowPropertiesDialogEx.Operations")));
            this.chbCRUDCreate = new JCheckBox(Messages.getString("TransformationFlowPropertiesDialogEx.Create"));
            this.chbCRUDRead = new JCheckBox(Messages.getString("TransformationFlowPropertiesDialogEx.Read"));
            this.chbCRUDUpdate = new JCheckBox(Messages.getString("TransformationFlowPropertiesDialogEx.Update"));
            this.chbCRUDDelete = new JCheckBox(Messages.getString("TransformationFlowPropertiesDialogEx.Delete"));
            jOperation.add(this.chbCRUDCreate);
            jOperation.add(this.chbCRUDRead);
            jOperation.add(this.chbCRUDUpdate);
            jOperation.add(this.chbCRUDDelete);
            bottomPanel.add((Component)jOperation, "North");
            jpanel.add((Component)this.pnGeneralGrid, "North");
            jpanel.add((Component)bottomPanel, "Center");
            this.pnGeneral.add((Component)jpanel, "Center");
        }
        return this.pnGeneral;
    }

    private JPanel getInfoStructuresPanel() {
        if (this.pnInfoStructure == null) {
            this.pnInfoStructure = this.createPage(Messages.getString("TransformationFlowPropertiesDialogEx.InformationStructures"));
            this.isList = new ArrayList();
            this.istable = new JTable(new InfoStructuresModel());
            this.istable.setSelectionMode(0);
            this.istable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = TransformationFlowPropertiesDialogEx.this.istable.getSelectedRow();
                    if (row != -1) {
                        if (e.getClickCount() == 2 && TransformationFlowPropertiesDialogEx.this.isList.size() > 0 && row < TransformationFlowPropertiesDialogEx.this.isList.size()) {
                            InfoStructure structure = (InfoStructure)TransformationFlowPropertiesDialogEx.this.isList.get(row);
                            structure.showPropertyDialog();
                        }
                        TransformationFlowPropertiesDialogEx.this.btnProperties.setEnabled(true);
                        TransformationFlowPropertiesDialogEx.this.btnRemove.setEnabled(true);
                    } else {
                        TransformationFlowPropertiesDialogEx.this.btnProperties.setEnabled(false);
                        TransformationFlowPropertiesDialogEx.this.btnRemove.setEnabled(false);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.istable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setEnabled(false);
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = TransformationFlowPropertiesDialogEx.this.istable.getSelectedRow();
                    if (row != -1 && TransformationFlowPropertiesDialogEx.this.isList.size() > 0 && row < TransformationFlowPropertiesDialogEx.this.isList.size()) {
                        InfoStructure structure = (InfoStructure)TransformationFlowPropertiesDialogEx.this.isList.get(row);
                        structure.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AddStructureDialog dialog = new AddStructureDialog(TransformationFlowPropertiesDialogEx.this.getAppView(), TransformationFlowPropertiesDialogEx.this.flow.getDesignPart(), TransformationFlowPropertiesDialogEx.this.isList);
                        dialog.show();
                        TransformationFlowPropertiesDialogEx.this.istable.updateUI();
                    }
                });
                this.btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setEnabled(false);
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = TransformationFlowPropertiesDialogEx.this.istable.getSelectedRow();
                        if (objectNumber != -1 && TransformationFlowPropertiesDialogEx.this.isList.size() > 0 && objectNumber < TransformationFlowPropertiesDialogEx.this.isList.size()) {
                            TransformationFlowPropertiesDialogEx.this.isList.remove(objectNumber);
                            TransformationFlowPropertiesDialogEx.this.istable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(this.btnAdd);
                toolBar.add(this.btnRemove);
            }
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 300));
            JPanel infostructurePanel = new JPanel(new BorderLayout());
            infostructurePanel.add((Component)buttonGeneral, "North");
            infostructurePanel.add(scrollpane);
            this.pnInfoStructure.add(infostructurePanel);
        }
        return this.pnInfoStructure;
    }

    private JPanel getExternalDataPanel() {
        if (this.pnExternalData == null) {
            this.pnExternalData = this.createPage(Messages.getString("TransformationFlowPropertiesDialogEx.ExternalData"));
            this.edList = new ArrayList();
            this.edtable = new JTable(new ExternalDataModel());
            this.edtable.setSelectionMode(0);
            this.edtable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = TransformationFlowPropertiesDialogEx.this.edtable.getSelectedRow()) != -1 && TransformationFlowPropertiesDialogEx.this.edList.size() > 0 && row < TransformationFlowPropertiesDialogEx.this.edList.size()) {
                        ExternalData ed = (ExternalData)TransformationFlowPropertiesDialogEx.this.edList.get(row);
                        ed.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.edtable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnExProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnExProperties.setToolTipText(Messages.getString("TransformationFlowPropertiesDialogEx.Properties"));
            this.btnExProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = TransformationFlowPropertiesDialogEx.this.edtable.getSelectedRow();
                    if (row != -1 && TransformationFlowPropertiesDialogEx.this.edList.size() > 0 && row < TransformationFlowPropertiesDialogEx.this.edList.size()) {
                        ExternalData ed = (ExternalData)TransformationFlowPropertiesDialogEx.this.edList.get(row);
                        ed.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnExProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 305));
            JPanel extDataPanel = new JPanel(new BorderLayout());
            extDataPanel.add((Component)buttonGeneral, "North");
            extDataPanel.add(scrollpane);
            this.pnExternalData.add(extDataPanel);
        }
        return this.pnExternalData;
    }

    private JPanel getSystemObjectivePanel() {
        if (this.pnSystemObjective == null) {
            this.pnSystemObjective = this.createPage(Messages.getString("TransformationFlowPropertiesDialogEx.SystemObjective"));
            this.taSystemObjective = new JTextArea();
            this.pnSystemObjective.add(new JScrollPane(this.taSystemObjective));
        }
        return this.pnSystemObjective;
    }

    private void disableCRUD() {
        this.chbCRUDCreate.setEnabled(false);
        this.chbCRUDRead.setEnabled(false);
        this.chbCRUDUpdate.setEnabled(false);
        this.chbCRUDDelete.setEnabled(false);
    }

    private void enableComponents(boolean enabled) {
        if (this.isEditable()) {
            this.edtable.setEnabled(enabled);
            this.btnExProperties.setEnabled(enabled);
            this.istable.setEnabled(!enabled);
            this.btnProperties.setEnabled(!enabled);
            this.btnAdd.setEnabled(!enabled);
            this.btnRemove.setEnabled(!enabled);
        }
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class ExternalDataModel
    extends AbstractTableModel {
        private ExternalDataModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return TransformationFlowPropertiesDialogEx.this.edList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TransformationFlowPropertiesDialogEx.ExternalDatas");
            }
            if (column == 1) {
                return Messages.getString("TransformationFlowPropertiesDialogEx.Synonym");
            }
            if (column == 2) {
                return Messages.getString("TransformationFlowPropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ExternalData ed = (ExternalData)TransformationFlowPropertiesDialogEx.this.edList.get(row);
            if (col == 0) {
                return ed.getName();
            }
            if (col == 1) {
                return ed.getSynonym();
            }
            if (col == 2) {
                return ed.getType() != null ? ed.getType().getName() : "";
            }
            return new Integer(row * col);
        }
    }

    private class InfoStructuresModel
    extends AbstractTableModel {
        private InfoStructuresModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TransformationFlowPropertiesDialogEx.this.isList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TransformationFlowPropertiesDialogEx.InformationStructures");
            }
            if (column == 1) {
                return Messages.getString("TransformationFlowPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            InfoStructure structure = (InfoStructure)TransformationFlowPropertiesDialogEx.this.isList.get(row);
            if (col == 0) {
                return structure.getName();
            }
            if (col == 1) {
                return structure.getSynonym();
            }
            return new Integer(row * col);
        }
    }
}

