/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.undo.CompoundEdit;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.Dependencies;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKDiscoverer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.ImpliedForeignKey;
import oracle.dbtools.crest.model.design.relational.Join;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.undo.GroupRemoveEdit;
import oracle.dbtools.crest.model.design.undo.PropertyEdit;
import oracle.dbtools.crest.model.design.undo.PropertySetter;
import oracle.dbtools.crest.model.design.undo.relational.FKCreateEdit;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.dmw.CompareDBDiagramsDialog;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;
import oracle.dbtools.util.Closeables;
import oracle.jdeveloper.db.DatabaseConnections;

public class ImpliedFKDiscovererDialog
extends CustomDialog {
    private JDialog dialog;
    private JDialog closingDialog;
    private JPanel generalPanel;
    private String title = "Create discovered implied foreign keys";
    private boolean cancelled = true;
    private FKDiscoverer fkDiscoverer;
    private JTable fkTable;
    private ImpliedFKmodel ifkModel;
    private Dimension dimension = new Dimension(900, 750);
    private static String REFERRED_TABLE = "Referred Table";
    private static String REFERRED_COLUMNS = "Referred Columns";
    private static String TABLE = "Table";
    private static String COLUMNS = "Columns";
    private static String SOURCES = "Sources";
    private JTextField filterText;
    private JCheckBox chbAll = new JCheckBox("All Methods");
    private JCheckBox chbSQLDimensions = new JCheckBox("SQL Dimensions");
    private JCheckBox chbBitmapJoinIndexes = new JCheckBox("Bitmap Join Indexes");
    private JCheckBox chbMViewsAggregations = new JCheckBox("Materialized Views with Aggregations");
    private JCheckBox chbAttributeClustering = new JCheckBox("Attribute Clustering");
    private JCheckBox chbOLAP = new JCheckBox("OLAP definitions");
    private JCheckBox chbAnalyticViews = new JCheckBox("Analytic Views");
    private Boolean all = new Boolean(true);
    private Boolean sqlDim = new Boolean(false);
    private Boolean bJoin = new Boolean(false);
    private Boolean mviews = new Boolean(false);
    private Boolean atrClust = new Boolean(false);
    private Boolean olap = new Boolean(false);
    private Boolean anViews = new Boolean(false);
    String empty = "";
    private JCheckBox[] methods = new JCheckBox[]{this.chbAll, this.chbSQLDimensions, this.chbBitmapJoinIndexes, this.chbMViewsAggregations, this.chbAttributeClustering, this.chbOLAP, this.chbAnalyticViews};
    private Boolean[] choices = new Boolean[]{this.all, this.sqlDim, this.bJoin, this.mviews, this.atrClust, this.olap, this.anViews};
    private JComboBox cbConn;
    private List<Join> joins = new ArrayList<Join>();
    RelationalDesign model = null;
    private boolean createImpliedFKs = true;
    private boolean setClassificationTypes = true;
    private static String PROPERTY_NAME = "createdByFKDiscoverer";
    private static String TRUE = "true";
    private static String PROPERTY_NAME_IFK = "createdByImpliedFKDiscoverer";
    DPVRelational selectedSubView = null;
    private JComboBox modelSubViewCombo;
    Connection conn = null;

    public ImpliedFKDiscovererDialog(ApplicationView appView, RelationalDesign model, DPVRelational selectedSubview) {
        super(appView);
        this.model = model;
        this.selectedSubView = selectedSubview;
        this.generalPanel = new JPanel(new BorderLayout());
        this.generalPanel.setPreferredSize(this.dimension);
        this.generalPanel.setMinimumSize(this.dimension);
        this.init();
        this.add((Component)this.generalPanel, "Center");
        int prefw = 1000;
        int minw = 950;
        int prefh = 800;
        int minh = 700;
        int divloc = 0;
        int locx = 100;
        int locy = 100;
        Point location = new Point(locx, locy);
        Settings.DialogSettings ds = appView.getSettings().getDialogSettings(this.getClass().getName());
        if (ds != null) {
            prefw = Math.max(minw, (int)ds.rec.getSize().getWidth());
            prefh = Math.max(minh, (int)ds.rec.getSize().getHeight());
            this.setSize(prefw, prefh);
            location = ds.rec.getLocation();
            divloc = ds.dividerLocation;
        }
        this.setPreferredSize(new Dimension(prefw, prefh));
        this.setMinimumSize(new Dimension(minw, minh));
        this.generalPanel.add((Component)this.getToolbar(), "North");
        this.add((Component)this.getOptionsPanel(), "North");
        this.add((Component)this.getButtonPanel(), "South");
    }

    JPanel getOptionsPanel() {
        JPanel tb = new JPanel(new FlowLayout(0));
        tb.setBorder(BorderFactory.createRaisedBevelBorder());
        JLabel lbConn = new JLabel(oracle.dbtools.crest.exports.Messages.getString("AWExportOptions.JDBCConnection") + ":");
        this.cbConn = new JComboBox();
        this.cbConn.setPreferredSize(new Dimension(180, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        this.cbConn.setMaximumSize(new Dimension(200, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        this.cbConn.setRenderer(new CompareDBDiagramsDialog.ComboBoxRenderer());
        CompareDBDiagramsDialog.updateConnections(this.cbConn, this.model);
        lbConn.setLabelFor(this.cbConn);
        tb.add(lbConn);
        tb.add(this.cbConn);
        tb.add(new JLabel("  "));
        this.cbConn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        JLabel lbObjects = new JLabel("Objects in:");
        tb.add(lbObjects);
        tb.add(this.getModelSubViewCombo());
        JLabel emptyLabel = new JLabel("     ");
        tb.add(emptyLabel);
        JButton but = new JButton("Methods");
        tb.add(but);
        this.chbAll.setSelected(true);
        but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpliedFKDiscovererDialog.this.chbAll.setSelected(ImpliedFKDiscovererDialog.this.all);
                ImpliedFKDiscovererDialog.this.chbSQLDimensions.setSelected(ImpliedFKDiscovererDialog.this.sqlDim);
                ImpliedFKDiscovererDialog.this.chbBitmapJoinIndexes.setSelected(ImpliedFKDiscovererDialog.this.bJoin);
                ImpliedFKDiscovererDialog.this.chbMViewsAggregations.setSelected(ImpliedFKDiscovererDialog.this.mviews);
                ImpliedFKDiscovererDialog.this.chbAttributeClustering.setSelected(ImpliedFKDiscovererDialog.this.atrClust);
                ImpliedFKDiscovererDialog.this.chbOLAP.setSelected(ImpliedFKDiscovererDialog.this.olap);
                ImpliedFKDiscovererDialog.this.chbAnalyticViews.setSelected(ImpliedFKDiscovererDialog.this.anViews);
                int res = JOptionPane.showConfirmDialog(ImpliedFKDiscovererDialog.this, ImpliedFKDiscovererDialog.this.methods, "Methods for discovering Implied FKs", 2);
                if (res == 0) {
                    ImpliedFKDiscovererDialog.this.all = ImpliedFKDiscovererDialog.this.chbAll.isSelected();
                    ImpliedFKDiscovererDialog.this.sqlDim = ImpliedFKDiscovererDialog.this.chbSQLDimensions.isSelected();
                    ImpliedFKDiscovererDialog.this.bJoin = ImpliedFKDiscovererDialog.this.chbBitmapJoinIndexes.isSelected();
                    ImpliedFKDiscovererDialog.this.mviews = ImpliedFKDiscovererDialog.this.chbMViewsAggregations.isSelected();
                    ImpliedFKDiscovererDialog.this.atrClust = ImpliedFKDiscovererDialog.this.chbAttributeClustering.isSelected();
                    ImpliedFKDiscovererDialog.this.olap = ImpliedFKDiscovererDialog.this.chbOLAP.isSelected();
                    ImpliedFKDiscovererDialog.this.anViews = ImpliedFKDiscovererDialog.this.chbAnalyticViews.isSelected();
                }
            }
        });
        JButton scan = new JButton("Scan database");
        scan.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block6: {
                    Properties pr = (Properties)ImpliedFKDiscovererDialog.this.cbConn.getSelectedItem();
                    if (pr != null) {
                        String cname = ConnectionInfo.getConnectionName(pr);
                        try {
                            ImpliedFKDiscovererDialog.this.conn = DatabaseConnections.getInstance().getUniqueConnection(cname);
                            if (ImpliedFKDiscovererDialog.this.conn == null) break block6;
                            String err = "";
                            if (err.isEmpty()) {
                                final ProgressDialog pd = new ProgressDialog(ImpliedFKDiscovererDialog.this.getApplicationView(), ImpliedFKDiscovererDialog.this.getClosingDialog(), "scanning", 0, 60, false, true);
                                pd.setProgress(10);
                                ImpliedFKDiscovererDialog.this.joins.clear();
                                Runnable r = new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            Dependencies.scanForJoins(ImpliedFKDiscovererDialog.this.conn, ImpliedFKDiscovererDialog.this.joins, ImpliedFKDiscovererDialog.this.model, ImpliedFKDiscovererDialog.this.all, ImpliedFKDiscovererDialog.this.sqlDim, ImpliedFKDiscovererDialog.this.bJoin, ImpliedFKDiscovererDialog.this.mviews, ImpliedFKDiscovererDialog.this.atrClust, ImpliedFKDiscovererDialog.this.olap, ImpliedFKDiscovererDialog.this.anViews, pd, ImpliedFKDiscovererDialog.this.selectedSubView);
                                            ImpliedFKDiscovererDialog.this.validateJoins(ImpliedFKDiscovererDialog.this.model, ImpliedFKDiscovererDialog.this.joins);
                                            ImpliedFKDiscovererDialog.this.ifkModel.fireTableDataChanged();
                                            pd.close();
                                        }
                                        finally {
                                            Closeables.close((Object)ImpliedFKDiscovererDialog.this.conn);
                                        }
                                    }
                                };
                                new Thread(r).start();
                                break block6;
                            }
                            JOptionPane.showMessageDialog(null, err, "Connection error", 0);
                        }
                        catch (Exception e1) {
                            String err = e1.getMessage();
                            JOptionPane.showMessageDialog(null, err, "Connection error", 0);
                        }
                    }
                }
            }
        });
        tb.add(scan);
        return tb;
    }

    void validateJoins(RelationalDesign model, List<Join> joins) {
        for (Join join : joins) {
            FKIndexAssociation fk;
            FKContainer cont = model.getTableSet().getBySchemaAndName(join.getSchema(), join.getTableName());
            if (cont == null) {
                cont = (FKContainer)model.getTableViewSet().getBySchemaAndName(join.getSchema(), join.getTableName());
            }
            if (cont == null) continue;
            ImpliedForeignKey ifk = cont.getEquivalentImpliedFKey(join);
            if (ifk != null) {
                join.existingIFK = ifk;
                for (String source : join.getDiscoverySourcesAslist()) {
                    if (ifk.containsSource(source)) continue;
                    join.canMergeintoExistingIFK = true;
                    break;
                }
                join.selected = join.canMergeintoExistingIFK;
            }
            if ((fk = cont.getEquivalentFKey(join)) != null) {
                join.existingFK = fk;
            }
            join.selected = join.selected && fk == null;
        }
    }

    private JToolBar getToolbar() {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        JButton bnSelectAll = new JButton(configuration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
        bnSelectAll.addActionListener(new SelectAllAction());
        bnSelectAll.setToolTipText(Messages.getString("FKDiscovererDialog.SelectAll"));
        JButton bnDeselectAll = new JButton(configuration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
        bnDeselectAll.addActionListener(new DeselectAllAction());
        bnDeselectAll.setToolTipText(Messages.getString("FKDiscovererDialog.DeselectAll"));
        JLabel flabel = new JLabel("   " + Messages.getString("FKDiscovererDialog.Filter"), 11);
        this.filterText = new JTextField();
        this.filterText.setPreferredSize(new Dimension(200, MessageDialogs.BUTTON_SIZE_EX.height));
        this.filterText.setMaximumSize(new Dimension(200, MessageDialogs.BUTTON_SIZE_EX.height));
        this.filterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ImpliedFKDiscovererDialog.this.newFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImpliedFKDiscovererDialog.this.newFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImpliedFKDiscovererDialog.this.newFilter();
            }
        });
        flabel.setLabelFor(this.filterText);
        toolBar.add(bnSelectAll);
        toolBar.add(bnDeselectAll);
        toolBar.addSeparator();
        toolBar.add(flabel);
        toolBar.add(this.filterText);
        JPanel pan = new JPanel(new FlowLayout(2));
        final JCheckBox chbImpFK = new JCheckBox("Create Implied Foreign Keys", this.createImpliedFKs);
        pan.add(chbImpFK);
        pan.setPreferredSize(new Dimension(330, MessageDialogs.BUTTON_SIZE_EX.height));
        JLabel emptyLabel = new JLabel("     ");
        pan.add(emptyLabel);
        chbImpFK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpliedFKDiscovererDialog.this.createImpliedFKs = chbImpFK.isSelected();
            }
        });
        final JCheckBox classifTypes = new JCheckBox("Set Classification Types", true);
        classifTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpliedFKDiscovererDialog.this.setClassificationTypes = classifTypes.isSelected();
            }
        });
        pan.add(classifTypes);
        pan.add(new JLabel("   "));
        toolBar.add(pan);
        return toolBar;
    }

    private void init() {
        this.ifkModel = new ImpliedFKmodel();
        this.fkTable = new JTable(this.ifkModel);
        TableColumn tcol = this.fkTable.getColumnModel().getColumn(0);
        tcol.setPreferredWidth(40);
        tcol.setMaxWidth(40);
        tcol = this.fkTable.getColumnModel().getColumn(1);
        tcol.setPreferredWidth(40);
        tcol.setMaxWidth(40);
        this.fkTable.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(this.fkTable, 2);
        this.fkTable.getColumnModel().getColumn(6).setCellRenderer(new MultiLineCellRenderer());
        JScrollPane sp = new JScrollPane(this.fkTable);
        this.generalPanel.add(sp);
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    @Override
    protected void close() {
        if (this.getClosingDialog() != null) {
            this.getClosingDialog().dispose();
        } else {
            this.getDialog().dispose();
        }
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return !this.cancelled;
    }

    @Override
    protected Window getDialog() {
        if (this.closingDialog != null) {
            return this.closingDialog;
        }
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.title);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setResizable(true);
            this.dialog.setPreferredSize(this.dimension);
            this.dialog.setMinimumSize(this.dimension);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "FK_DISCOVERER_DIALOG";
    }

    private void setProperties() {
        if (this.createImpliedFKs) {
            ImpliedForeignKey.createImpliedFKs(this.model, this.joins, this.setClassificationTypes);
        } else {
            try {
                this.createFKs(this.model, this.joins);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFKs(RelationalDesign model, List<Join> joins) {
        CompoundEdit groupEdit = null;
        PropertySetter ps = new PropertySetter(ContainerWithKeyObject.class, "typeID", "getTypeID", "setTypeID");
        model.getUndoManager().setLocked(true);
        try {
            for (Join join : joins) {
                FKContainer rcont;
                boolean contEdited;
                FKIndexAssociation ifk;
                if (!join.selected) continue;
                FKContainer cont = model.getTableSet().getBySchemaAndName(join.getSchema(), join.getTableName());
                if (cont == null) {
                    cont = (FKContainer)model.getTableViewSet().getBySchemaAndName(join.getSchema(), join.getTableName());
                }
                if (cont == null || (ifk = cont.getEquivalentFKey(join)) != null) continue;
                String cname = join.getColumnName();
                FKElement lco = null;
                if (cname == null || cname.isEmpty() || (lco = (FKElement)cont.getElementByName(cname)) != null) {
                    // empty if block
                }
                if (contEdited = false) {
                    // empty if block
                }
                if ((rcont = model.getTableSet().getBySchemaAndName(join.getRefSchema(), join.getRefTable())) == null) {
                    rcont = (FKContainer)model.getTableViewSet().getBySchemaAndName(join.getRefSchema(), join.getRefTable());
                }
                Object name = cont.getName() + "_";
                if (lco != null && rcont != null) {
                    FKElement rco;
                    name = (String)name + rcont.getName() + "_";
                    cname = join.getRefColumnName();
                    if (cname != null && !cname.isEmpty() && (rco = (FKElement)rcont.getElementByName(cname)) != null) {
                        KeyObject key = rcont.getPk_UK_forColumns(new String[]{rco.getName()});
                        ArrayList<FKElement> local = new ArrayList<FKElement>();
                        local.add(lco);
                        ifk = cont.addForeignKey(key, local);
                        if (ifk != null) {
                            if (groupEdit == null) {
                                groupEdit = new GroupRemoveEdit(ifk, "Create discovered Foreign keys", "Remove discovered Foreign keys");
                            }
                            ifk.addToAllDPVs();
                            if (this.setClassificationTypes) {
                                String cltype = cont.getTypeID();
                                if (cltype != null && !cltype.isEmpty()) {
                                    if (!"1".equalsIgnoreCase(cltype)) {
                                        cont.getAdditionalClassificationTypes().add("1");
                                        contEdited = true;
                                    }
                                } else {
                                    PropertyEdit pe = new PropertyEdit(cont, ps, "1");
                                    pe.apply();
                                    groupEdit.addEdit(pe);
                                    contEdited = true;
                                }
                            }
                        }
                    }
                    if (this.setClassificationTypes) {
                        String cltype = rcont.getTypeID();
                        if (cltype != null && !cltype.isEmpty()) {
                            if (!"2".equalsIgnoreCase(cltype)) {
                                rcont.getAdditionalClassificationTypes().add("2");
                            }
                        } else {
                            PropertyEdit pe = new PropertyEdit(rcont, ps, "2");
                            pe.apply();
                            groupEdit.addEdit(pe);
                        }
                    }
                }
                if (ifk == null) continue;
                NamingStandardRule nsr = model.getDesign().getNamingStandardRule();
                name = ApplyNamingStandards.createFK_Name(ifk, nsr);
                ifk.setName((String)name);
                ifk.setProperty(PROPERTY_NAME, TRUE);
                ifk.setProperty(PROPERTY_NAME_IFK, TRUE);
                FKCreateEdit edit = new FKCreateEdit(ifk);
                edit.end();
                groupEdit.addEdit(edit);
            }
        }
        finally {
            model.getUndoManager().setLocked(false);
            if (groupEdit != null) {
                groupEdit.end();
                model.postUndoableEdit(groupEdit);
            }
        }
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton ok = new JButton(Messages.getString("FKDiscovererDialog.OK"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpliedFKDiscovererDialog.this.setProperties();
                ImpliedFKDiscovererDialog.this.cancelled = false;
                ImpliedFKDiscovererDialog.this.close();
            }
        });
        JButton cancel = new JButton(Messages.getString("FKDiscovererDialog.Cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpliedFKDiscovererDialog.this.cancelled = true;
                ImpliedFKDiscovererDialog.this.close();
            }
        });
        JButton btnHelp = new JButton(this.getHelpAction());
        btnHelp.setMnemonic(72);
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        buttonPanel.add(btnHelp);
        return buttonPanel;
    }

    private void newFilter() {
        RowFilter rf = null;
        JTable current = this.fkTable;
        if (current != null) {
            if (!"".equals(this.filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + this.filterText.getText(), new int[0]);
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)current.getRowSorter()).setRowFilter(rf);
            } else {
                current.clearSelection();
                ((DefaultRowSorter)current.getRowSorter()).setRowFilter(null);
            }
        }
    }

    protected void checkAll(JTable table, List objects, boolean checked) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            this.selectAll(table, objects, checked);
        } else {
            for (int i = 0; i < objects.size(); ++i) {
                if (!selectionModel.isSelectedIndex(table.convertRowIndexToView(i))) continue;
                Join fkp = (Join)objects.get(i);
                fkp.selected = checked;
            }
        }
        table.updateUI();
    }

    protected void selectAll(JTable table, List<DBObject> objects, boolean selected) {
        if (selected) {
            this.selectAll(table, objects);
        } else {
            this.deselectAll(table, objects);
        }
    }

    private void selectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                Join fkp = (Join)list.get(index);
                fkp.selected = true;
            }
        } else {
            for (Join fkp : list) {
                fkp.selected = true;
            }
        }
    }

    private void deselectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                Join fkp = (Join)list.get(index);
                fkp.selected = false;
            }
        } else {
            for (Join fkp : list) {
                fkp.selected = false;
            }
        }
    }

    public JDialog getClosingDialog() {
        if (this.closingDialog == null) {
            return (JDialog)this.getDialog();
        }
        return this.closingDialog;
    }

    public void setClosingDialog(JDialog closingDialog) {
        this.closingDialog = closingDialog;
    }

    public JComboBox getModelSubViewCombo() {
        if (this.modelSubViewCombo == null) {
            DesignPartView[] choices = this.model.getMainViewAndSubViews();
            this.modelSubViewCombo = new JComboBox<DesignPartView>(choices);
            this.modelSubViewCombo.setMaximumRowCount(20);
            if (this.selectedSubView != null) {
                this.modelSubViewCombo.setSelectedItem(this.selectedSubView);
            }
            this.modelSubViewCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (ImpliedFKDiscovererDialog.this.modelSubViewCombo.getItemCount() > 0) {
                        ImpliedFKDiscovererDialog.this.selectedSubView = (DPVRelational)ImpliedFKDiscovererDialog.this.modelSubViewCombo.getSelectedItem();
                        if (ImpliedFKDiscovererDialog.this.selectedSubView == ImpliedFKDiscovererDialog.this.selectedSubView.getDesignPart().getMainView()) {
                            ImpliedFKDiscovererDialog.this.selectedSubView = null;
                        }
                    }
                }
            });
            this.modelSubViewCombo.setPreferredSize(new Dimension(200, 23));
            this.modelSubViewCombo.setToolTipText(Messages.getString("DDLFileMakerEditor.SelectSubView"));
        }
        return this.modelSubViewCombo;
    }

    public class MultiLineCellRenderer
    extends JList<String>
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof String) {
                String[] lines = ((String)value).split("\n");
                this.setListData(lines);
            }
            int height = this.getPreferredSize().height;
            if (table.getRowHeight(row) < height) {
                table.setRowHeight(row, height);
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }

    private class SelectAllAction
    implements ActionListener {
        private SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImpliedFKDiscovererDialog.this.checkAll(ImpliedFKDiscovererDialog.this.fkTable, ImpliedFKDiscovererDialog.this.joins, true);
        }
    }

    private class DeselectAllAction
    implements ActionListener {
        private DeselectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImpliedFKDiscovererDialog.this.checkAll(ImpliedFKDiscovererDialog.this.fkTable, ImpliedFKDiscovererDialog.this.joins, false);
        }
    }

    class ImpliedFKmodel
    extends DefaultTableModel {
        final String[] columns = new String[]{"", "", TABLE, COLUMNS, REFERRED_TABLE, REFERRED_COLUMNS, SOURCES};

        ImpliedFKmodel() {
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column];
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < ImpliedFKDiscovererDialog.this.joins.size()) {
                Join jh = ImpliedFKDiscovererDialog.this.joins.get(row);
                if (column == 0) {
                    int trow = ImpliedFKDiscovererDialog.this.fkTable.convertRowIndexToView(row);
                    return trow + 1;
                }
                if (column == 1) {
                    return jh.selected;
                }
                if (column == 4) {
                    return jh.getRefTableLongName();
                }
                if (column == 5) {
                    return jh.getRefColumnName();
                }
                if (column == 2) {
                    return jh.getTableLongName();
                }
                if (column == 3) {
                    String cols = "";
                    cols = jh.getColumnName();
                    return cols;
                }
                if (column == 6) {
                    return jh.getFormattedDiscoverySource();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 1) {
                Join jh = ImpliedFKDiscovererDialog.this.joins.get(row);
                return jh.existingFK == null && (jh.existingIFK == null || jh.canMergeintoExistingIFK);
            }
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 1 && row < ImpliedFKDiscovererDialog.this.joins.size()) {
                Join fkp = ImpliedFKDiscovererDialog.this.joins.get(row);
                fkp.selected = (Boolean)aValue;
            }
        }

        @Override
        public int getRowCount() {
            if (ImpliedFKDiscovererDialog.this.joins == null) {
                return 0;
            }
            return ImpliedFKDiscovererDialog.this.joins.size();
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Integer.class;
            }
            if (columnIndex == 1) {
                return Boolean.class;
            }
            return String.class;
        }
    }
}

