/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.CompoundEdit;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.ImpliedForeignKey;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.design.undo.GroupUpdateEdit;
import oracle.dbtools.crest.model.design.undo.relational.ImpliedFKCreateEdit;
import oracle.dbtools.crest.model.design.undo.relational.ImpliedFKRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.ImpliedFKUpdateEdit;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.javatools.ui.layout.VerticalFlowLayout;

public class ImpliedForeignKeysDialog
extends JDialog
implements AbstractEditorConstants {
    public static final String KEY_ESCAPE = "ESCAPE";
    protected static final int FIELD_WIDTH = 280;
    protected static final int FIELD_HEIGHT = 20;
    private Dimension defaultSize = new Dimension(280, 20);
    private JTable aTable;
    private List<DesignObjectEdit.ImpliedFKProperties> aList;
    private JPanel generalPanel;
    private JPanel buttonsPanel;
    private JToolBar toolBar;
    private JButton btnAdd;
    private JButton btnRemove;
    private JComboBox cbReferencedObject;
    private JComboBox cbLocalColumn;
    private JComboBox cbReferencedColumn;
    private JTextField tfTargetObject;
    private JTextField tfDiscoverySources;
    private JTextArea taComments;
    private List<ImpliedForeignKey> deletedIFKList;
    private FKContainer sourceObject;
    private DesignObjectEdit.ImpliedFKProperties currentIFK = null;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ImpliedForeignKeysDialog.this.dispose();
        }
    };

    public ImpliedForeignKeysDialog(JFrame frame, FKContainer sourceObject) {
        super(frame);
        this.setModal(true);
        this.sourceObject = sourceObject;
        this.setTitle(Messages.getString("ImpliedForeignKeysDialog.title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ImpliedForeignKeysDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.createUIComponents();
        this.init();
        this.clearValues();
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setPreferredSize(bnCancel.getPreferredSize());
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        this.getContentPane().add((Component)bottomPanel, "South");
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private void init() {
        if (this.sourceObject != null) {
            for (ImpliedForeignKey ifk : this.sourceObject.getImpliedForeignKeyList()) {
                ifk.setExisting(true);
                DesignObjectEdit.ImpliedFKProperties prop = DesignObjectEdit.backupImpliedFK(ifk);
                this.aList.add(prop);
            }
            this.initReferencedObjects();
            this.initColumns();
        }
    }

    private void createUIComponents() {
        this.buttonsPanel = new JPanel(new FlowLayout(3));
        this.buttonsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.generalPanel.add(this.buttonsPanel);
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAdd = new JButton(configuration.getIcon("ADD_ICON", 16));
        this.btnAdd.addActionListener(new AddActionListener());
        this.btnAdd.setToolTipText(Messages.getString("ColumnGroupColumnsPanel.Add"));
        this.btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemove.addActionListener(new RemoveActionListener());
        this.btnRemove.setToolTipText(Messages.getString("ColumnGroupColumnsPanel.Remove"));
        this.btnRemove.setEnabled(false);
        this.toolBar = new JToolBar(0);
        this.toolBar.setFloatable(false);
        this.toolBar.setBorder(BorderFactory.createEmptyBorder());
        this.toolBar.add(this.btnAdd);
        this.toolBar.add(this.btnRemove);
        this.buttonsPanel.add(this.toolBar);
        this.aList = new ArrayList<DesignObjectEdit.ImpliedFKProperties>();
        this.deletedIFKList = new ArrayList<ImpliedForeignKey>();
        this.aTable = new JTable(new ImpliedForeignKeysModel()){

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                if (this.editCellAt(row, column)) {
                    Component editor = this.getEditorComponent();
                    editor.requestFocusInWindow();
                }
            }
        };
        this.aTable.setSelectionMode(0);
        this.aTable.getTableHeader().setReorderingAllowed(false);
        this.aTable.setCellSelectionEnabled(true);
        this.aTable.getSelectionModel().setSelectionMode(0);
        this.aTable.getSelectionModel().addListSelectionListener(new SelectedImpliedForeignKeyListener());
        JScrollPane sp = new JScrollPane(this.aTable);
        sp.setPreferredSize(new Dimension(600, 200));
        this.generalPanel.add(sp);
        JPanel pnProperties = new JPanel(new GridLayout(0, 2, 20, 10));
        this.tfTargetObject = new JTextField();
        this.tfTargetObject.setEditable(false);
        this.tfTargetObject.setPreferredSize(this.defaultSize);
        this.addRowToPanel(pnProperties, Messages.getString("ImpliedForeignKeysDialog.TargetObject"), this.tfTargetObject, true);
        this.cbReferencedObject = new JComboBox();
        this.cbReferencedObject.setPreferredSize(this.defaultSize);
        this.cbReferencedObject.setMaximumRowCount(8);
        this.cbReferencedObject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpliedForeignKeysDialog.this.updateRefColumnList();
            }
        });
        this.addRowToPanel(pnProperties, Messages.getString("ImpliedForeignKeysDialog.ReferencedObject"), this.cbReferencedObject, true);
        this.cbLocalColumn = new JComboBox();
        this.cbLocalColumn.setPreferredSize(this.defaultSize);
        this.cbLocalColumn.setMaximumRowCount(8);
        this.addRowToPanel(pnProperties, Messages.getString("ImpliedForeignKeysDialog.LocalColumn"), this.cbLocalColumn, true);
        this.cbReferencedColumn = new JComboBox();
        this.cbReferencedColumn.setPreferredSize(this.defaultSize);
        this.cbReferencedColumn.setMaximumRowCount(8);
        this.addRowToPanel(pnProperties, Messages.getString("ImpliedForeignKeysDialog.ReferencedColumn"), this.cbReferencedColumn, true);
        JPanel pnDS = new JPanel(new BorderLayout());
        this.tfDiscoverySources = new JTextField();
        this.addRowToPanel(pnDS, Messages.getString("ImpliedForeignKeysDialog.DiscoverySources"), this.tfDiscoverySources, true);
        JPanel pnComments = new JPanel(new BorderLayout());
        this.taComments = new JTextArea();
        this.taComments.setAutoscrolls(true);
        JScrollPane spComments = new JScrollPane(this.taComments);
        spComments.setPreferredSize(new Dimension(600, 60));
        this.addRowToPanel(pnComments, Messages.getString("ImpliedForeignKeysDialog.Comments"), spComments, true);
        JPanel pnBottom = new JPanel(new BorderLayout(10, 10));
        pnBottom.add((Component)pnDS, "Center");
        pnBottom.add((Component)pnComments, "South");
        JPanel pnCenter = new JPanel(new BorderLayout(10, 10));
        pnCenter.add((Component)pnProperties, "Center");
        pnCenter.add((Component)pnBottom, "South");
        this.generalPanel.add(pnCenter);
    }

    protected void addRowToPanel(JPanel panel, String labelText, JComponent rightComp, boolean labelOnTop) {
        JLabel label = new JLabel(labelText);
        label.setLabelFor(rightComp);
        label.setPreferredSize(this.defaultSize);
        panel.add(this.createRow(label, rightComp, labelOnTop));
    }

    protected JPanel createRow(Component leftComp, Component rightComp, boolean labelOnTop) {
        JPanel newRow = new JPanel(new BorderLayout());
        if (labelOnTop) {
            newRow.add(leftComp, "North");
        } else {
            newRow.add(leftComp, "West");
        }
        newRow.add(rightComp, "Center");
        return newRow;
    }

    private void initReferencedObjects() {
        if (this.sourceObject != null) {
            FKContainer container;
            Iterator it = this.sourceObject.getRelationalModel().getTableSet().iterator();
            while (it.hasNext()) {
                container = (FKContainer)it.next();
                if (this.sourceObject == container) continue;
                this.cbReferencedObject.addItem(container);
            }
            it = this.sourceObject.getRelationalModel().getTableViewSet().iterator();
            while (it.hasNext()) {
                container = (FKContainer)it.next();
                if (this.sourceObject == container) continue;
                this.cbReferencedObject.addItem(container);
            }
        }
    }

    private void initColumns() {
        if (this.sourceObject != null) {
            Iterator it = this.sourceObject.getElementsCollection().iterator();
            while (it.hasNext()) {
                this.cbLocalColumn.addItem(it.next());
            }
        }
    }

    private void updateRefColumnList() {
        this.cbReferencedColumn.removeAllItems();
        FKContainer referencedObject = (FKContainer)this.cbReferencedObject.getSelectedItem();
        if (referencedObject != null) {
            Iterator it = referencedObject.getElementsCollection().iterator();
            while (it.hasNext()) {
                this.cbReferencedColumn.addItem(it.next());
            }
        }
    }

    private void updateCurrentIFK() {
        if (this.currentIFK != null) {
            this.currentIFK.setLocalColumn((FKElement)this.cbLocalColumn.getSelectedItem());
            FKContainer remoteTable = (FKContainer)this.cbReferencedObject.getSelectedItem();
            if (this.currentIFK.getRemoteTable() != remoteTable) {
                this.currentIFK.setRemoteTable(remoteTable);
                this.currentIFK.setModified(true);
            }
            this.currentIFK.setReferredColumn((FKElement)this.cbReferencedColumn.getSelectedItem());
            this.currentIFK.setDiscoverySources(this.tfDiscoverySources.getText());
            this.currentIFK.setComment(this.taComments.getText());
        }
    }

    private void setCurrentIFK() {
        DesignObjectEdit.ImpliedFKProperties ifk;
        try {
            this.updateCurrentIFK();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.currentIFK = ifk = this.aList.get(this.aTable.getSelectedRow());
        this.cbReferencedObject.setEnabled(true);
        this.cbLocalColumn.setEnabled(true);
        this.cbReferencedColumn.setEnabled(true);
        this.tfDiscoverySources.setEditable(true);
        this.taComments.setEditable(true);
        if (ifk.getTable() != null) {
            this.tfTargetObject.setText(ifk.getTable().getName());
        }
        this.cbReferencedObject.setSelectedItem(ifk.getRemoteTable());
        this.cbLocalColumn.setSelectedItem(ifk.getLocalColumn());
        this.cbReferencedColumn.setSelectedItem(ifk.getReferredColumn());
        this.tfDiscoverySources.setText(ifk.getDiscoverySources());
        this.taComments.setText(ifk.getComment());
    }

    private void clearValues() {
        this.currentIFK = null;
        this.tfTargetObject.setText("");
        this.cbReferencedObject.setSelectedIndex(-1);
        this.cbLocalColumn.setSelectedIndex(-1);
        this.cbReferencedColumn.setSelectedIndex(-1);
        this.tfDiscoverySources.setText("");
        this.taComments.setText("");
        this.cbReferencedObject.setEnabled(false);
        this.cbLocalColumn.setEnabled(false);
        this.cbReferencedColumn.setEnabled(false);
        this.tfDiscoverySources.setEditable(false);
        this.taComments.setEditable(false);
    }

    private class SelectedImpliedForeignKeyListener
    implements ListSelectionListener {
        private SelectedImpliedForeignKeyListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (ImpliedForeignKeysDialog.this.aTable.getSelectedRow() > -1) {
                    ImpliedForeignKeysDialog.this.btnRemove.setEnabled(true);
                    ImpliedForeignKeysDialog.this.setCurrentIFK();
                } else {
                    ImpliedForeignKeysDialog.this.btnRemove.setEnabled(false);
                    ImpliedForeignKeysDialog.this.clearValues();
                }
            }
        }
    }

    public class ImpliedForeignKeysModel
    extends AbstractTableModel {
        private String[] COL_NAMES = new String[]{Messages.getString("ImpliedForeignKeysDialog.Name"), Messages.getString("ImpliedForeignKeysDialog.TargetObject"), Messages.getString("ImpliedForeignKeysDialog.ReferencedObject")};

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return ImpliedForeignKeysDialog.this.aList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            DesignObjectEdit.ImpliedFKProperties ifk = ImpliedForeignKeysDialog.this.aList.get(row);
            ifk.setName((String)value);
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObjectEdit.ImpliedFKProperties ifk = ImpliedForeignKeysDialog.this.aList.get(row);
            if (col == 0) {
                return ifk.name;
            }
            if (col == 1) {
                return ifk.getTable() != null ? ifk.getTable().getName() : "";
            }
            if (col == 2) {
                return ifk.getRemoteTable() != null ? ifk.getRemoteTable().getName() : "";
            }
            return "";
        }
    }

    private class RemoveActionListener
    implements ActionListener {
        private RemoveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImpliedForeignKeysDialog.stopCellEditing(ImpliedForeignKeysDialog.this.aTable);
            int selected = ImpliedForeignKeysDialog.this.aTable.getSelectedRow();
            if (selected > -1) {
                DesignObjectEdit.ImpliedFKProperties prop = ImpliedForeignKeysDialog.this.aList.get(selected);
                if (prop.fk.isExisting()) {
                    ImpliedForeignKeysDialog.this.deletedIFKList.add(prop.fk);
                }
                ImpliedForeignKeysDialog.this.aList.remove(selected);
                ImpliedForeignKeysDialog.this.aTable.updateUI();
                ImpliedForeignKeysDialog.this.aTable.getSelectionModel().clearSelection();
            }
        }
    }

    private class AddActionListener
    implements ActionListener {
        private AddActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImpliedForeignKeysDialog.this.updateCurrentIFK();
            RelationalDesign dp = null;
            if (ImpliedForeignKeysDialog.this.sourceObject != null) {
                dp = (RelationalDesign)ImpliedForeignKeysDialog.this.sourceObject.getDesignPart();
            }
            ImpliedForeignKey ifk = dp.createImpliedForeignKey();
            ifk.setName(ifk.createUniqueNameFromProp(ImpliedForeignKeysDialog.this.aList));
            ifk.setExisting(false);
            if (ImpliedForeignKeysDialog.this.sourceObject != null) {
                ifk.setContainerWithKeyObject(ImpliedForeignKeysDialog.this.sourceObject);
            }
            DesignObjectEdit.ImpliedFKProperties prop = DesignObjectEdit.backupImpliedFK(ifk);
            ImpliedForeignKeysDialog.this.aList.add(prop);
            ImpliedForeignKeysDialog.this.aTable.updateUI();
            ImpliedForeignKeysDialog.this.aTable.getSelectionModel().clearSelection();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImpliedForeignKeysDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ImpliedForeignKeysDialog.stopCellEditing(ImpliedForeignKeysDialog.this.aTable);
                ImpliedForeignKeysDialog.this.updateCurrentIFK();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            String presentation = " Redo Edit Implied Foreign keys for " + ImpliedForeignKeysDialog.this.sourceObject.getLongName();
            String presentation2 = " Undo Edit Implied Foreign keys for " + ImpliedForeignKeysDialog.this.sourceObject.getLongName();
            CompoundEdit groupEdit = null;
            ImpliedForeignKeysDialog.this.sourceObject.getDesignPart().getUndoManager().setLocked(true);
            try {
                for (ImpliedForeignKey ifk : ImpliedForeignKeysDialog.this.deletedIFKList) {
                    ImpliedFKRemoveEdit edit = new ImpliedFKRemoveEdit(ifk);
                    edit.end();
                    ImpliedForeignKeysDialog.this.sourceObject.deleteImpliedForeignKey(ifk);
                    if (groupEdit == null) {
                        groupEdit = new GroupUpdateEdit(ifk, presentation, presentation2);
                    }
                    groupEdit.addEdit(edit);
                }
                for (DesignObjectEdit.ImpliedFKProperties prop : ImpliedForeignKeysDialog.this.aList) {
                    DesignObjectEdit edit;
                    ImpliedForeignKey ifk = prop.fk;
                    if (groupEdit == null) {
                        groupEdit = new GroupUpdateEdit(ifk, presentation, presentation2);
                    }
                    if (!ifk.isExisting()) {
                        ifk = DesignObjectEdit.restoreImpliedFK(prop, false);
                        ImpliedForeignKeysDialog.this.sourceObject.addImpliedForeignKey(ifk);
                        edit = new ImpliedFKCreateEdit(ifk);
                        edit.end();
                        groupEdit.addEdit(edit);
                        continue;
                    }
                    if (!prop.isModified()) continue;
                    edit = new ImpliedFKUpdateEdit(ifk, prop);
                    ((ImpliedFKUpdateEdit)edit).applyUpdates();
                    edit.end();
                    groupEdit.addEdit(edit);
                }
                ImpliedForeignKeysDialog.this.sourceObject.setDirty(true);
                ImpliedForeignKeysDialog.this.dispose();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                ImpliedForeignKeysDialog.this.sourceObject.getDesignPart().getUndoManager().setLocked(false);
                if (groupEdit != null) {
                    groupEdit.end();
                    ImpliedForeignKeysDialog.this.sourceObject.getDesignPart().postUndoableEdit(groupEdit);
                }
            }
        }
    }
}

