/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.relational.memento.IndexMemento;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.relational.AbstractIndexPanel;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class IndexColumnsPanel
extends AbstractIndexPanel {
    private static final long serialVersionUID = 5771060872641952722L;
    private static final int PREFERRED_HEIGHT = 145;
    private static final int PREFERRED_WIDTH = 145;
    private static final String COLUMNS = Messages.getString("IndexColumnsPanel.Columns");
    private JPanel mainPanel;
    private JButton btnAddColumns;
    private JButton btnRemoveColumns;
    private JButton btnUp;
    private JButton btnDown;
    private JList allColumnsList;
    private DefaultListModel allColumnsModel;
    private List<Column> selectedColumnsList;
    private JPanel pnSelected;
    private JTable selectedColumnsTable;
    private JScrollPane selectedColumnsScrollPane;
    private JScrollPane allColumnsScrollPane;
    private JPanel pnAttributes;
    private Collection<Column> tableColumns;

    public IndexColumnsPanel(Index index, boolean editable, int buttonsSize, boolean showDesc) {
        super(index, editable, buttonsSize, showDesc);
    }

    @Override
    protected void init(Collection<Column> tableColumns) {
        this.tableColumns = tableColumns;
        this.allColumnsModel.clear();
        for (Column column : tableColumns) {
            if (this.selectedColumnsList.contains(column) || !this.canBeUsed(column)) continue;
            this.allColumnsModel.addElement(column);
        }
    }

    @Override
    protected void init(Index index) {
        if (this.index != index) {
            this.selectedColumnsList.clear();
            if (index != null) {
                this.selectedColumnsList.addAll(index.getElementsCollection());
            }
            this.selectedColumnsTable.updateUI();
        }
        this.index = index;
    }

    public void refresh() {
        if (this.tableColumns != null) {
            this.init(this.tableColumns);
        }
        this.allColumnsList.updateUI();
        this.selectedColumnsTable.updateUI();
    }

    public void removeSelectedColumn(Column column) {
        this.selectedColumnsList.remove(column);
        this.selectedColumnsTable.updateUI();
    }

    protected boolean canBeUsed(Column column) {
        Datatype columnDataType = column.getDataType();
        String columnDataTypeName = columnDataType.getName();
        return !column.isReference() && (!(columnDataType instanceof StructuredType) || this.index != null && this.index.isSpatialIndex() && "SDO_GEOMETRY".equals(columnDataTypeName)) && !(columnDataType instanceof CollectionType) && !column.isOid() && !columnDataTypeName.equalsIgnoreCase("BLOB") && !columnDataTypeName.equalsIgnoreCase("CLOB");
    }

    @Override
    public void init(Index index, Collection<Column> tableColumns) {
        super.init(index, tableColumns);
        this.selectedColumnsList.clear();
        if (index != null) {
            if (index.isPK()) {
                for (Column column : (Column[])index.getElements()) {
                    this.selectedColumnsList.add(column);
                }
            } else {
                IndexMemento indexMemento = (IndexMemento)index.getIndexMemento(false);
                Table indexTable = indexMemento.table;
                if (indexTable != null) {
                    for (IndexMemento.ColWr colWr : indexMemento.columns) {
                        Column column = this.findColumnByID(colWr.col_id, tableColumns);
                        if (column == null) continue;
                        this.selectedColumnsList.add(column);
                    }
                }
            }
        }
        this.init(tableColumns);
        this.enableComponents(index != null && this.editable);
        ((SelectedColumnsModel)this.selectedColumnsTable.getModel()).fireTableDataChanged();
    }

    private Column findColumnByID(String id, Collection<Column> columns) {
        for (Column column : columns) {
            if (!column.getObjectID().equals(id)) continue;
            return column;
        }
        return null;
    }

    public List<Column> getSelectedColumns() {
        return this.selectedColumnsList;
    }

    @Override
    protected void createUIComponents() {
        this.setLayout(new BorderLayout(0, 10));
        this.setName(COLUMNS);
        this.setBorder(BorderFactory.createTitledBorder(COLUMNS));
        this.selectedColumnsList = new ArrayList<Column>();
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddColumns = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.buttonsSize));
        this.btnAddColumns.setPreferredSize(new Dimension(32, 32));
        this.btnRemoveColumns = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.buttonsSize));
        this.btnRemoveColumns.setPreferredSize(new Dimension(32, 32));
        this.btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.buttonsSize));
        this.btnUp.setPreferredSize(new Dimension(32, 32));
        this.btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.buttonsSize));
        this.btnDown.setPreferredSize(new Dimension(32, 32));
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.btnAddColumns);
        verticalBox.add(this.btnRemoveColumns);
        verticalBox.add(this.btnUp);
        verticalBox.add(this.btnDown);
        verticalBox.add(Box.createVerticalGlue());
        this.selectedColumnsTable = new JTable(new SelectedColumnsModel(this.showDesc));
        if (!this.isEditable()) {
            this.selectedColumnsTable.setEnabled(false);
        }
        this.selectedColumnsScrollPane = new JScrollPane(this.selectedColumnsTable);
        this.selectedColumnsScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("IndexColumnsPanel.Selected")));
        this.selectedColumnsScrollPane.setPreferredSize(new Dimension(145, 145));
        this.pnSelected = new JPanel(new BorderLayout());
        this.pnSelected.add(this.selectedColumnsScrollPane);
        this.allColumnsScrollPane = new JScrollPane(this.allColumnsList);
        this.allColumnsScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("IndexColumnsPanel.Available")));
        this.allColumnsScrollPane.setPreferredSize(new Dimension(145, 145));
        this.pnAttributes = new JPanel(new BorderLayout());
        this.pnAttributes.add(this.allColumnsScrollPane);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 2));
        this.mainPanel.add(this.pnAttributes);
        this.mainPanel.add(verticalBox);
        this.mainPanel.add(this.pnSelected);
        this.add(this.mainPanel);
    }

    @Override
    protected void initUIComponents() {
        this.allColumnsList.getSelectionModel().addListSelectionListener(new AllColumnsListSelectionListener());
        this.selectedColumnsTable.getSelectionModel().addListSelectionListener(new SelectedColumnsListSelectionListener());
        this.initColumnsButtons(this.mainPanel);
        this.initSelectedColumnsList(this.mainPanel);
    }

    private void enableComponents(boolean enabled) {
        this.allColumnsList.setEnabled(enabled);
        this.selectedColumnsTable.setEnabled(enabled);
    }

    private void initSelectedColumnsList(JPanel jpanel) {
        TableColumn col0 = this.selectedColumnsTable.getColumnModel().getColumn(0);
        col0.setWidth(220);
        if (this.showDesc) {
            TableColumn col1 = this.selectedColumnsTable.getColumnModel().getColumn(1);
            col1.setWidth(40);
            col1.setMaxWidth(40);
            col1.setCellRenderer(new ColumnOrderRenderer());
        }
        this.selectedColumnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (IndexColumnsPanel.this.selectedColumnsTable.getSelectedRow() == -1) {
                    IndexColumnsPanel.this.btnRemoveColumns.setEnabled(false);
                } else {
                    IndexColumnsPanel.this.btnRemoveColumns.setEnabled(true);
                }
            }
        });
    }

    private void initColumnsButtons(JPanel jpanel) {
        this.btnAddColumns.addActionListener(new AddColumnsActionListener());
        this.btnAddColumns.setEnabled(false);
        this.btnAddColumns.setToolTipText(Messages.getString("IndexPropertiesDialogEx.Add"));
        this.btnRemoveColumns.setEnabled(false);
        this.btnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveColumns.setToolTipText(Messages.getString("IndexPropertiesDialogEx.Remove"));
        this.btnUp.setToolTipText(Messages.getString("IndexPropertiesDialogEx.MoveUp"));
        this.btnUp.addActionListener(new MoveUpAction());
        this.btnDown.setToolTipText(Messages.getString("IndexPropertiesDialogEx.MoveDown"));
        this.btnDown.addActionListener(new MoveDownAction());
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
    }

    public void onAddColumn(Column column) {
    }

    public void onRemoveColumn(Column column) {
    }

    private boolean moveToIndex(Object object, int index) {
        if (this.selectedColumnsList.contains(object) && this.selectedColumnsList.size() > index && index >= 0) {
            this.selectedColumnsList.remove(object);
            this.selectedColumnsList.add(index, (Column)object);
            return true;
        }
        return false;
    }

    public void clearSelectedColumns() {
        if (this.selectedColumnsList != null) {
            this.selectedColumnsList.clear();
            this.selectedColumnsTable.updateUI();
        }
    }

    public void clearReferences() {
        this.allColumnsModel.clear();
        this.selectedColumnsList.clear();
        this.tableColumns.clear();
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = IndexColumnsPanel.this.selectedColumnsTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[selection.length - 1]) < IndexColumnsPanel.this.selectedColumnsList.size() - 1) {
                for (int i = selection.length - 1; i > -1; --i) {
                    objectNumber = selection[i];
                    Column obj = IndexColumnsPanel.this.selectedColumnsList.get(objectNumber);
                    IndexColumnsPanel.this.moveToIndex(obj, objectNumber + 1);
                    selection[i] = objectNumber + 1;
                }
                IndexColumnsPanel.this.selectedColumnsTable.updateUI();
                IndexColumnsPanel.this.selectedColumnsTable.getSelectionModel().setSelectionInterval(objectNumber + 1, objectNumber + 1);
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = IndexColumnsPanel.this.selectedColumnsTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[0]) > 0) {
                for (int i = 0; i < selection.length; ++i) {
                    objectNumber = selection[i];
                    Column obj = IndexColumnsPanel.this.selectedColumnsList.get(objectNumber);
                    IndexColumnsPanel.this.moveToIndex(obj, objectNumber - 1);
                    selection[i] = objectNumber - 1;
                }
                IndexColumnsPanel.this.selectedColumnsTable.updateUI();
                IndexColumnsPanel.this.selectedColumnsTable.getSelectionModel().setSelectionInterval(objectNumber - 1, objectNumber - 1);
            }
        }
    }

    private class ColumnOrderRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -2118305663241552544L;

        private ColumnOrderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            boolean val = (Boolean)value;
            this.setOpaque(false);
            this.setEnabled(true);
            this.setSelected(val);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private class SelectedColumnsModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8480891404209029651L;
        private String[] COL_NAMES = new String[]{Messages.getString("IndexColumnsPanel.Column"), Messages.getString("IndexColumnsPanel.Desc")};
        private boolean showDesc;

        public SelectedColumnsModel(boolean showDesc) {
            this.showDesc = showDesc;
        }

        @Override
        public int getColumnCount() {
            return this.showDesc ? 2 : 1;
        }

        @Override
        public int getRowCount() {
            return IndexColumnsPanel.this.selectedColumnsList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Column column = IndexColumnsPanel.this.selectedColumnsList.get(row);
            if (value instanceof Boolean) {
                IndexColumnsPanel.this.index.setColumnSortOrder(column, (Boolean)value != false ? "DESC" : "ASC");
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            Column column = IndexColumnsPanel.this.selectedColumnsList.get(row);
            if (col == 0) {
                return column.getName();
            }
            if (col == 1) {
                return new Boolean("DESC".equals(IndexColumnsPanel.this.index.getColumnSortOrder(column)));
            }
            return "";
        }
    }

    private class SelectedColumnsListSelectionListener
    implements ListSelectionListener {
        private SelectedColumnsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (IndexColumnsPanel.this.editable && !e.getValueIsAdjusting()) {
                if (IndexColumnsPanel.this.selectedColumnsTable.getSelectedRow() == -1) {
                    IndexColumnsPanel.this.btnRemoveColumns.setEnabled(false);
                    IndexColumnsPanel.this.btnUp.setEnabled(false);
                    IndexColumnsPanel.this.btnDown.setEnabled(false);
                } else {
                    IndexColumnsPanel.this.btnRemoveColumns.setEnabled(true);
                    IndexColumnsPanel.this.btnUp.setEnabled(true);
                    IndexColumnsPanel.this.btnDown.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionListener
    implements ListSelectionListener {
        private AllColumnsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (IndexColumnsPanel.this.editable && !e.getValueIsAdjusting()) {
                if (IndexColumnsPanel.this.allColumnsList.getSelectedIndex() == -1) {
                    IndexColumnsPanel.this.btnAddColumns.setEnabled(false);
                } else {
                    IndexColumnsPanel.this.btnAddColumns.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            int[] selected = IndexColumnsPanel.this.selectedColumnsTable.getSelectedRows();
            for (i = 0; i < selected.length; ++i) {
                Column column = IndexColumnsPanel.this.selectedColumnsList.get(selected[i]);
                if (IndexColumnsPanel.this.allColumnsModel.contains(column) || !IndexColumnsPanel.this.canBeUsed(column)) continue;
                IndexColumnsPanel.this.allColumnsModel.addElement(column);
                IndexColumnsPanel.this.allColumnsList.setSelectedValue(column, true);
            }
            for (i = selected.length - 1; i >= 0; --i) {
                IndexColumnsPanel.this.onRemoveColumn(IndexColumnsPanel.this.selectedColumnsList.remove(selected[i]));
            }
            IndexColumnsPanel.this.selectedColumnsTable.getSelectionModel().clearSelection();
            ((SelectedColumnsModel)IndexColumnsPanel.this.selectedColumnsTable.getModel()).fireTableDataChanged();
        }
    }

    public class AddColumnsActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (!IndexColumnsPanel.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = IndexColumnsPanel.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Column column = (Column)selectedObjects[i];
                    if (IndexColumnsPanel.this.selectedColumnsList.contains(column)) continue;
                    IndexColumnsPanel.this.selectedColumnsList.add(column);
                    IndexColumnsPanel.this.allColumnsModel.removeElement(column);
                    IndexColumnsPanel.this.onAddColumn(column);
                }
            }
            IndexColumnsPanel.this.allColumnsList.getSelectionModel().clearSelection();
            ((SelectedColumnsModel)IndexColumnsPanel.this.selectedColumnsTable.getModel()).fireTableDataChanged();
            IndexColumnsPanel.this.selectedColumnsTable.getSelectionModel().setSelectionInterval(IndexColumnsPanel.this.selectedColumnsTable.getRowCount() - 1, IndexColumnsPanel.this.selectedColumnsTable.getRowCount() - 1);
        }
    }
}

