/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.GlobalIndexSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.util.TreeUtils;
import oracle.javatools.dialogs.MessageDialog;

public class SchemaObjectPropertiesDialogEx
extends AbstractPropertiesDialog {
    private static final long serialVersionUID = -3640605097703231194L;
    private static final String INDEXES_TAB_NAME = Messages.getString("SchemaPropertiesDialogEx.Indexes");
    private static final String TABLES_TAB_NAME = Messages.getString("SchemaPropertiesDialogEx.Tables");
    private static final String VIEWS_TAB_NAME = Messages.getString("SchemaPropertiesDialogEx.Views");
    private static final String ORDS_TAB_NAME = Messages.getString("SchemaPropertiesDialogEx.ORDS");
    private final String TABLES = "Tables";
    private final String VIEWS = "Views";
    private SchemaObject schemaObject;
    private JPanel pnTables;
    private JPanel pnViews;
    private JPanel pnIndexes;
    private JPanel pnORDS;
    private JButton buttonTableAdd;
    private JButton buttonTableRemove;
    private JButton buttonIndexAdd;
    private JButton buttonIndexRemove;
    private JButton buttonViewAdd;
    private JButton buttonViewRemove;
    private DefaultListModel selectedTablesModel;
    private DefaultListModel allTablesModel;
    private JList allTablesList;
    private JList selectedTablesList;
    private DefaultListModel selectedViewsModel;
    private DefaultListModel allViewsModel;
    private JList allViewsList;
    private JList selectedViewsList;
    private DefaultListModel selectedIndexesModel;
    private DefaultListModel allIndexesModel;
    private JList allIndexesList;
    private JList selectedIndexesList;
    private RelationalDesign rd = (RelationalDesign)this.getDesignObject().getDesignPart();
    private TableSet allTablesSet;
    private TableViewSet allViewsSet;
    private GlobalIndexSet allIndexesSet;
    private JCheckBox chbORDSDrop;
    private JCheckBox chbORDSEnable;
    private JCheckBox chbORDSAuth;
    private JTextField tfORDSAlias;
    private JTabbedPane tpane;
    private JTextField tableNamefilter;
    private JTextField viewNamefilter;
    private JButton btnEnableAllTables;
    private JButton btnDisableAllTables;
    private JButton btnEnableAllViews;
    private JButton btnDisableAllViews;
    private JButton btnAuthAllTables;
    private JButton btnNoneAuthAllTables;
    private JButton btnAuthAllViews;
    private JButton btnNoneAuthAllViews;
    private List tablesList;
    private List viewsList;
    private JTable tbTables;
    private JTable tbViews;
    private TableRowSorter<ORDSTableModel> CSorter;
    private TableRowSorter<ORDSTableModel> CSorterViews;
    private boolean ordsAliasOK = true;

    public SchemaObjectPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
    }

    @Override
    public String getCaption() {
        return Messages.getString("SchemaPropertiesDialogEx.SchemaProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "SCHEMA_PROPERTIES_DIALOG";
    }

    @Override
    protected int getMinimumWidth() {
        return 900;
    }

    @Override
    protected int getMinimumHeight() {
        return 600;
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof SchemaObject) {
            this.schemaObject = (SchemaObject)object;
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.taCommentsInRDBMS.setText(this.schemaObject.getCommentInRDBMS());
            this.taComments.setText(this.schemaObject.getComment());
            this.taNotes.setText(this.schemaObject.getNotes());
            this.tfName.setText(this.schemaObject.getName());
            this.allTablesSet = this.rd.getTableSet();
            Iterator it1 = this.allTablesSet.iterator();
            while (it1.hasNext()) {
                Table t = (Table)it1.next();
                if (object == t.getSchemaObject()) {
                    this.selectedTablesModel.addElement(t);
                    continue;
                }
                this.allTablesModel.addElement(t);
            }
            this.sort(this.selectedTablesModel);
            this.sort(this.allTablesModel);
            this.allViewsSet = this.rd.getTableViewSet();
            Iterator it2 = this.allViewsSet.iterator();
            while (it2.hasNext()) {
                TableView tv = (TableView)it2.next();
                if (object == tv.getSchemaObject()) {
                    this.selectedViewsModel.addElement(tv);
                    continue;
                }
                this.allViewsModel.addElement(tv);
            }
            this.sort(this.selectedViewsModel);
            this.sort(this.allViewsModel);
            this.allIndexesSet = this.rd.getGlobalIndexSet();
            for (Index i : this.allIndexesSet) {
                if (object == i.getSchemaObject()) {
                    this.selectedIndexesModel.addElement(i);
                    continue;
                }
                if (i.isUnique() || i.isFK() || i.isPK()) continue;
                this.allIndexesModel.addElement(i);
            }
            this.sort(this.selectedIndexesModel);
            this.sort(this.allIndexesModel);
            this.initDynamicProperties();
            this.initORDSObjects();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getTablesPanel());
        this.addToTree(root, this.getViewsPanel());
        this.addToTree(root, this.getIndexesPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getCommentsInRDBMSPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getORDSPanel());
    }

    protected JPanel getTablesPanel() {
        if (this.pnTables == null) {
            this.pnTables = this.createPage(TABLES_TAB_NAME);
        }
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel allTablesPanel = new JPanel(new GridBagLayout());
        allTablesPanel.setPreferredSize(new Dimension(100, 100));
        allTablesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.AllTables")));
        this.allTablesModel = new DefaultListModel();
        this.allTablesList = new JList(this.allTablesModel);
        this.allTablesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SchemaObjectPropertiesDialogEx.this.allTablesList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonTableAdd.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonTableAdd.setEnabled(true);
                }
            }
        });
        JScrollPane allTablesScrollPane = new JScrollPane(this.allTablesList);
        allTablesPanel.add((Component)allTablesScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel selectedTablesPanel = new JPanel(new GridBagLayout());
        selectedTablesPanel.setPreferredSize(new Dimension(100, 100));
        selectedTablesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.SelectedTables")));
        this.selectedTablesModel = new DefaultListModel();
        this.selectedTablesList = new JList(this.selectedTablesModel);
        this.selectedTablesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SchemaObjectPropertiesDialogEx.this.selectedTablesList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonTableRemove.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonTableRemove.setEnabled(true);
                }
            }
        });
        JScrollPane selectedTablesScrollPane = new JScrollPane(this.selectedTablesList);
        selectedTablesPanel.add((Component)selectedTablesScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)allTablesPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)selectedTablesPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.initTablesPanelAddRemoveButtons(mainPanel);
        this.pnTables.add(mainPanel);
        return this.pnTables;
    }

    protected JPanel getORDSPanel() {
        if (this.pnORDS == null) {
            this.pnORDS = this.createPage(ORDS_TAB_NAME);
        }
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel pnTop = new JPanel(new BorderLayout());
        pnTop.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.ORDSOptions")));
        JPanel pnDrop = new JPanel(new FlowLayout(0));
        JPanel pnEnable = new JPanel(new FlowLayout(0));
        this.chbORDSDrop = new JCheckBox(Messages.getString("SchemaPropertiesDialogEx.ORDSDrop"));
        pnDrop.add(this.chbORDSDrop);
        this.chbORDSEnable = new JCheckBox(Messages.getString("SchemaPropertiesDialogEx.ORDSEnable"));
        pnEnable.add(this.chbORDSEnable);
        pnEnable.add(new JPanel());
        this.tfORDSAlias = new JTextField(10);
        JLabel lbAlias = new JLabel(Messages.getString("SchemaPropertiesDialogEx.ORDSAlias"));
        pnEnable.add(lbAlias);
        pnEnable.add(this.tfORDSAlias);
        pnEnable.add(new JPanel());
        this.chbORDSAuth = new JCheckBox(Messages.getString("SchemaPropertiesDialogEx.ORDSAuth"));
        pnEnable.add(this.chbORDSAuth);
        pnTop.add((Component)pnDrop, "North");
        pnTop.add((Component)pnEnable, "Center");
        JPanel pnCenter = new JPanel(new BorderLayout());
        this.tpane = new JTabbedPane();
        this.initORDSTables();
        this.initORDSViews();
        pnCenter.add((Component)this.tpane, "Center");
        mainPanel.add((Component)pnTop, "North");
        mainPanel.add((Component)pnCenter, "Center");
        this.pnORDS.add(mainPanel);
        return this.pnORDS;
    }

    private void enableAll(JTable table, List objects, boolean enabled) {
        for (int i = 0; i < table.getRowCount(); ++i) {
            Object obj = objects.get(table.convertRowIndexToModel(i));
            ((ORDSObject)obj).enable = enabled;
        }
        table.updateUI();
    }

    private void authAll(JTable table, List objects, boolean auth) {
        for (int i = table.getRowCount() - 1; i >= 0; --i) {
            Object obj = objects.get(table.convertRowIndexToModel(i));
            ((ORDSObject)obj).auth = auth;
        }
        table.updateUI();
    }

    private void newFilter(JTextField filterText, JTable currentTable, int column) {
        RowFilter rf = null;
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), currentTable.convertColumnIndexToModel(column));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    private void initORDSObjects() {
        ORDSObject ordsObj;
        this.chbORDSDrop.setSelected(this.schemaObject.isORDSDropSchema());
        this.chbORDSEnable.setSelected(this.schemaObject.isORDSEnable());
        this.chbORDSAuth.setSelected(this.schemaObject.isORDSAuth());
        this.tfORDSAlias.setText(this.schemaObject.getORDSAliasNotEmpty());
        Iterator it = this.rd.getTableSet().iterator();
        while (it.hasNext()) {
            ContainerObject table = (ContainerObject)it.next();
            if (table.getSchemaObject() != this.schemaObject) continue;
            ordsObj = new ORDSObject(table);
            this.tablesList.add(ordsObj);
        }
        if (this.tablesList.size() > 0) {
            this.tbTables.setRowSorter(this.CSorter);
            this.tbTables.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.tbTables, 0);
            this.btnEnableAllTables.setEnabled(true);
            this.btnDisableAllTables.setEnabled(true);
            this.btnAuthAllTables.setEnabled(true);
            this.btnNoneAuthAllTables.setEnabled(true);
            this.tableNamefilter.setEnabled(true);
        }
        it = this.rd.getTableViewSet().iterator();
        while (it.hasNext()) {
            ContainerObject view = (ContainerObject)it.next();
            if (view.getSchemaObject() != this.schemaObject) continue;
            ordsObj = new ORDSObject(view);
            this.viewsList.add(ordsObj);
        }
        if (this.viewsList.size() > 0) {
            this.tbViews.setRowSorter(this.CSorterViews);
            this.tbViews.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.tbViews, 0);
            this.btnEnableAllViews.setEnabled(true);
            this.btnDisableAllViews.setEnabled(true);
            this.btnAuthAllViews.setEnabled(true);
            this.btnNoneAuthAllViews.setEnabled(true);
            this.viewNamefilter.setEnabled(true);
        }
    }

    private void setORDSObjects() {
        DesignObject desObj;
        this.schemaObject.setORDSDropSchema(this.chbORDSDrop.isSelected());
        this.schemaObject.setORDSEnable(this.chbORDSEnable.isSelected());
        this.schemaObject.setORDSAuth(this.chbORDSAuth.isSelected());
        this.schemaObject.setORDSAlias(this.tfORDSAlias.getText());
        for (ORDSObject ordsObj : this.tablesList) {
            desObj = ordsObj.designObject;
            desObj.setORDSEnable(ordsObj.enable);
            desObj.setORDSAuth(ordsObj.auth);
            desObj.setORDSAlias(ordsObj.alias);
        }
        for (ORDSObject ordsObj : this.viewsList) {
            desObj = ordsObj.designObject;
            desObj.setORDSEnable(ordsObj.enable);
            desObj.setORDSAuth(ordsObj.auth);
            desObj.setORDSAlias(ordsObj.alias);
        }
    }

    @Override
    protected boolean canExit() {
        this.ordsAliasOK = true;
        SchemaObjectPropertiesDialogEx.stopCellEditing(this.tbTables);
        SchemaObjectPropertiesDialogEx.stopCellEditing(this.tbViews);
        if (!this.ordsAliasOK) {
            return false;
        }
        if (super.canExit()) {
            Pattern p = Pattern.compile("\\p{Lower}([[\\p{Lower}\\p{Digit}]#$_])*$");
            Matcher m = p.matcher(this.tfORDSAlias.getText().toString());
            this.ordsAliasOK = true;
            if (!m.matches()) {
                MessageDialog.error((Component)this, (Object)MessageFormat.format(Messages.getString("SchemaPropertiesDialogEx.INVALID_ALIAS"), this.tfORDSAlias.getText().toString()), (String)Messages.getString("SchemaPropertiesDialogEx.INVALID_ALIAS_TITLE"), null);
                this.ordsAliasOK = false;
            }
            if (!this.ordsAliasOK) {
                String[] names = new String[]{"", ORDS_TAB_NAME};
                TreePath tp = TreeUtils.findByName(this.getTree(), names);
                if (tp != null) {
                    this.getTree().setSelectionPath(tp);
                }
                this.tfORDSAlias.requestFocus();
                return false;
            }
            return true;
        }
        return false;
    }

    private void initORDSTables() {
        JPanel tablesPanel = new JPanel(new BorderLayout());
        JLabel filterLabel = new JLabel(Messages.getString("SchemaPropertiesDialogEx.Filter"));
        this.tableNamefilter = new JTextField();
        this.tableNamefilter.setEnabled(false);
        Dimension fDim = new Dimension(100, 20);
        this.tableNamefilter.setPreferredSize(fDim);
        this.btnEnableAllTables = new JButton(Messages.getString("SchemaPropertiesDialogEx.EnableAll"));
        this.btnEnableAllTables.setEnabled(false);
        this.btnEnableAllTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaObjectPropertiesDialogEx.this.enableAll(SchemaObjectPropertiesDialogEx.this.tbTables, SchemaObjectPropertiesDialogEx.this.tablesList, true);
                SchemaObjectPropertiesDialogEx.this.tbTables.updateUI();
            }
        });
        this.btnDisableAllTables = new JButton(Messages.getString("SchemaPropertiesDialogEx.DisableAll"));
        this.btnDisableAllTables.setEnabled(false);
        this.btnDisableAllTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaObjectPropertiesDialogEx.this.enableAll(SchemaObjectPropertiesDialogEx.this.tbTables, SchemaObjectPropertiesDialogEx.this.tablesList, false);
                SchemaObjectPropertiesDialogEx.this.tbTables.updateUI();
            }
        });
        this.btnAuthAllTables = new JButton(Messages.getString("SchemaPropertiesDialogEx.AuthAll"));
        this.btnAuthAllTables.setEnabled(false);
        this.btnAuthAllTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaObjectPropertiesDialogEx.this.authAll(SchemaObjectPropertiesDialogEx.this.tbTables, SchemaObjectPropertiesDialogEx.this.tablesList, true);
                SchemaObjectPropertiesDialogEx.this.tbTables.updateUI();
            }
        });
        this.btnNoneAuthAllTables = new JButton(Messages.getString("SchemaPropertiesDialogEx.NoneAuthAll"));
        this.btnNoneAuthAllTables.setEnabled(false);
        this.btnNoneAuthAllTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaObjectPropertiesDialogEx.this.authAll(SchemaObjectPropertiesDialogEx.this.tbTables, SchemaObjectPropertiesDialogEx.this.tablesList, false);
                SchemaObjectPropertiesDialogEx.this.tbTables.updateUI();
            }
        });
        JPanel toolBar = new JPanel(new FlowLayout(0));
        toolBar.add(filterLabel);
        toolBar.add(this.tableNamefilter);
        toolBar.add(this.btnEnableAllTables);
        toolBar.add(this.btnDisableAllTables);
        toolBar.add(this.btnAuthAllTables);
        toolBar.add(this.btnNoneAuthAllTables);
        tablesPanel.add((Component)toolBar, "North");
        this.tablesList = new ArrayList();
        ORDSTableModel model = new ORDSTableModel(this.tablesList, "Tables");
        this.tbTables = new JTable(model);
        this.tableNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.tableNamefilter, this.tbTables, 0));
        TableColumn col0 = this.tbTables.getColumnModel().getColumn(0);
        col0.setWidth(100);
        TableColumn col1 = this.tbTables.getColumnModel().getColumn(1);
        col1.setWidth(60);
        col1.setMaxWidth(60);
        TableColumn col2 = this.tbTables.getColumnModel().getColumn(2);
        col2.setWidth(120);
        this.CSorter = new TableRowSorter<ORDSTableModel>(model);
        this.CSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.tbTables);
        tablesPanel.add((Component)sp, "Center");
        this.tpane.addTab("Tables", GUIConfiguration.getInstance().getIcon("TABLE_ICON"), tablesPanel);
    }

    private void initORDSViews() {
        JPanel viewsPanel = new JPanel(new BorderLayout());
        JLabel filterLabel = new JLabel(Messages.getString("SchemaPropertiesDialogEx.Filter"));
        this.viewNamefilter = new JTextField();
        this.viewNamefilter.setEnabled(false);
        Dimension fDim = new Dimension(100, 20);
        this.viewNamefilter.setPreferredSize(fDim);
        this.btnEnableAllViews = new JButton(Messages.getString("SchemaPropertiesDialogEx.EnableAll"));
        this.btnEnableAllViews.setEnabled(false);
        this.btnEnableAllViews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaObjectPropertiesDialogEx.this.enableAll(SchemaObjectPropertiesDialogEx.this.tbViews, SchemaObjectPropertiesDialogEx.this.viewsList, true);
                SchemaObjectPropertiesDialogEx.this.tbViews.updateUI();
            }
        });
        this.btnDisableAllViews = new JButton(Messages.getString("SchemaPropertiesDialogEx.DisableAll"));
        this.btnDisableAllViews.setEnabled(false);
        this.btnDisableAllViews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaObjectPropertiesDialogEx.this.enableAll(SchemaObjectPropertiesDialogEx.this.tbViews, SchemaObjectPropertiesDialogEx.this.viewsList, false);
                SchemaObjectPropertiesDialogEx.this.tbViews.updateUI();
            }
        });
        this.btnAuthAllViews = new JButton(Messages.getString("SchemaPropertiesDialogEx.AuthAll"));
        this.btnAuthAllViews.setEnabled(false);
        this.btnAuthAllViews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaObjectPropertiesDialogEx.this.authAll(SchemaObjectPropertiesDialogEx.this.tbViews, SchemaObjectPropertiesDialogEx.this.viewsList, true);
                SchemaObjectPropertiesDialogEx.this.tbViews.updateUI();
            }
        });
        this.btnNoneAuthAllViews = new JButton(Messages.getString("SchemaPropertiesDialogEx.NoneAuthAll"));
        this.btnNoneAuthAllViews.setEnabled(false);
        this.btnNoneAuthAllViews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaObjectPropertiesDialogEx.this.authAll(SchemaObjectPropertiesDialogEx.this.tbViews, SchemaObjectPropertiesDialogEx.this.viewsList, false);
                SchemaObjectPropertiesDialogEx.this.tbViews.updateUI();
            }
        });
        JPanel toolBar = new JPanel(new FlowLayout(0));
        toolBar.add(filterLabel);
        toolBar.add(this.viewNamefilter);
        toolBar.add(this.btnEnableAllViews);
        toolBar.add(this.btnDisableAllViews);
        toolBar.add(this.btnAuthAllViews);
        toolBar.add(this.btnNoneAuthAllViews);
        viewsPanel.add((Component)toolBar, "North");
        this.viewsList = new ArrayList();
        ORDSTableModel model = new ORDSTableModel(this.viewsList, "Views");
        this.tbViews = new JTable(model);
        this.viewNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.viewNamefilter, this.tbViews, 0));
        TableColumn col0 = this.tbViews.getColumnModel().getColumn(0);
        col0.setWidth(100);
        TableColumn col1 = this.tbViews.getColumnModel().getColumn(1);
        col1.setWidth(60);
        col1.setMaxWidth(60);
        TableColumn col2 = this.tbViews.getColumnModel().getColumn(2);
        col2.setWidth(120);
        this.CSorterViews = new TableRowSorter<ORDSTableModel>(model);
        this.CSorterViews.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.tbViews);
        viewsPanel.add((Component)sp, "Center");
        this.tpane.addTab("Views", GUIConfiguration.getInstance().getIcon("VIEW_ICON"), viewsPanel);
    }

    private void initTablesPanelAddRemoveButtons(JPanel main) {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.buttonTableAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON"));
        this.buttonTableAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonTableAdd.addActionListener(new AddTable());
        this.buttonTableAdd.setEnabled(false);
        this.buttonTableAdd.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Add"));
        this.buttonTableRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON"));
        this.buttonTableRemove.setPreferredSize(new Dimension(32, 32));
        this.buttonTableRemove.setEnabled(false);
        this.buttonTableRemove.addActionListener(new RemoveTable());
        this.buttonTableRemove.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Remove"));
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.buttonTableAdd);
        verticalBox.add(this.buttonTableRemove);
        verticalBox.add(Box.createVerticalGlue());
        main.add((Component)verticalBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JPanel getIndexesPanel() {
        if (this.pnIndexes == null) {
            this.pnIndexes = this.createPage(INDEXES_TAB_NAME);
        }
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel allIndexesPanel = new JPanel(new GridBagLayout());
        allIndexesPanel.setPreferredSize(new Dimension(100, 100));
        allIndexesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.AllIndexes")));
        this.allIndexesModel = new DefaultListModel();
        this.allIndexesList = new JList(this.allIndexesModel);
        this.allIndexesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SchemaObjectPropertiesDialogEx.this.allIndexesList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonIndexAdd.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonIndexAdd.setEnabled(true);
                }
            }
        });
        JScrollPane allIndexesScrollPane = new JScrollPane(this.allIndexesList);
        allIndexesPanel.add((Component)allIndexesScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel selectedIndexesPanel = new JPanel(new GridBagLayout());
        selectedIndexesPanel.setPreferredSize(new Dimension(100, 100));
        selectedIndexesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.SelectedIndexes")));
        this.selectedIndexesModel = new DefaultListModel();
        this.selectedIndexesList = new JList(this.selectedIndexesModel);
        this.selectedIndexesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SchemaObjectPropertiesDialogEx.this.selectedIndexesList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonIndexRemove.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonIndexRemove.setEnabled(true);
                }
            }
        });
        JScrollPane selectedIndexesScrollPane = new JScrollPane(this.selectedIndexesList);
        selectedIndexesPanel.add((Component)selectedIndexesScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)allIndexesPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)selectedIndexesPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.initIndexesPanelAddRemoveButtons(mainPanel);
        this.pnIndexes.add(mainPanel);
        return this.pnIndexes;
    }

    private void initIndexesPanelAddRemoveButtons(JPanel main) {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.buttonIndexAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonIndexAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonIndexAdd.addActionListener(new AddIndex());
        this.buttonIndexAdd.setEnabled(false);
        this.buttonIndexAdd.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Add"));
        this.buttonIndexRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonIndexRemove.setPreferredSize(new Dimension(32, 32));
        this.buttonIndexRemove.setEnabled(false);
        this.buttonIndexRemove.addActionListener(new RemoveIndex());
        this.buttonIndexRemove.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Remove"));
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.buttonIndexAdd);
        verticalBox.add(this.buttonIndexRemove);
        verticalBox.add(Box.createVerticalGlue());
        main.add((Component)verticalBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JPanel getViewsPanel() {
        if (this.pnViews == null) {
            this.pnViews = this.createPage(VIEWS_TAB_NAME);
        }
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel allViewsPanel = new JPanel(new GridBagLayout());
        allViewsPanel.setPreferredSize(new Dimension(100, 100));
        allViewsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.AllViews")));
        this.allViewsModel = new DefaultListModel();
        this.allViewsList = new JList(this.allViewsModel);
        this.allViewsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SchemaObjectPropertiesDialogEx.this.allViewsList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonViewAdd.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonViewAdd.setEnabled(true);
                }
            }
        });
        JScrollPane allIndexesScrollPane = new JScrollPane(this.allViewsList);
        allViewsPanel.add((Component)allIndexesScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel selectedViewsPanel = new JPanel(new GridBagLayout());
        selectedViewsPanel.setPreferredSize(new Dimension(100, 100));
        selectedViewsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.SelectedViews")));
        this.selectedViewsModel = new DefaultListModel();
        this.selectedViewsList = new JList(this.selectedViewsModel);
        this.selectedViewsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SchemaObjectPropertiesDialogEx.this.selectedViewsList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonViewRemove.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonViewRemove.setEnabled(true);
                }
            }
        });
        JScrollPane selectedViewsScrollPane = new JScrollPane(this.selectedViewsList);
        selectedViewsPanel.add((Component)selectedViewsScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)allViewsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)selectedViewsPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.initViewsPanelAddRemoveButtons(mainPanel);
        this.pnViews.add(mainPanel);
        return this.pnViews;
    }

    private void initViewsPanelAddRemoveButtons(JPanel main) {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.buttonViewAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON"));
        this.buttonViewAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonViewAdd.addActionListener(new AddView());
        this.buttonViewAdd.setEnabled(false);
        this.buttonViewAdd.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Add"));
        this.buttonViewRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON"));
        this.buttonViewRemove.setPreferredSize(new Dimension(32, 32));
        this.buttonViewRemove.setEnabled(false);
        this.buttonViewRemove.addActionListener(new RemoveView());
        this.buttonViewRemove.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Remove"));
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.buttonViewAdd);
        verticalBox.add(this.buttonViewRemove);
        verticalBox.add(Box.createVerticalGlue());
        main.add((Component)verticalBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected void setProperties() {
        ContainerObject item;
        int i;
        String oldName = this.schemaObject.getName();
        this.schemaObject.setName(this.tfName.getText());
        this.schemaObject.setComment(this.taComments.getText());
        this.schemaObject.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.schemaObject.setNotes(this.taNotes.getText());
        for (i = 0; i < this.selectedTablesList.getModel().getSize(); ++i) {
            item = (Table)this.selectedTablesList.getModel().getElementAt(i);
            item.setSchemaObject(this.schemaObject, oldName);
            item.fireNameChangedNoDirty();
        }
        for (i = 0; i < this.selectedViewsList.getModel().getSize(); ++i) {
            item = (TableView)this.selectedViewsList.getModel().getElementAt(i);
            item.setSchemaObject(this.schemaObject, oldName);
            item.fireNameChangedNoDirty();
        }
        for (i = 0; i < this.selectedIndexesList.getModel().getSize(); ++i) {
            item = (Index)this.selectedIndexesList.getModel().getElementAt(i);
            item.setSchemaObject(this.schemaObject, oldName);
        }
        for (i = 0; i < this.allTablesList.getModel().getSize(); ++i) {
            item = (Table)this.allTablesList.getModel().getElementAt(i);
            if (item.getSchemaObject() != this.schemaObject) continue;
            item.setSchemaObject(null);
            item.fireNameChangedNoDirty();
        }
        for (i = 0; i < this.allViewsList.getModel().getSize(); ++i) {
            item = (TableView)this.allViewsList.getModel().getElementAt(i);
            if (item.getSchemaObject() != this.schemaObject) continue;
            item.setSchemaObject(null);
            item.fireNameChangedNoDirty();
        }
        for (i = 0; i < this.allIndexesList.getModel().getSize(); ++i) {
            item = (Index)this.allIndexesList.getModel().getElementAt(i);
            if (item.getSchemaObject() != this.schemaObject) continue;
            item.setSchemaObject(null);
        }
        this.setMeasurements(this.schemaObject);
        this.setChangeRequests(this.schemaObject);
        this.setResponsibleParties(this.schemaObject);
        this.setDocuments(this.schemaObject);
        this.setORDSObjects();
        SchemaObjectPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.schemaObject.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.schemaObject.setProperty(dp.getName(), dp.getValue());
        }
        this.schemaObject.updateRemoteObjectListeners();
    }

    public DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                if (list.get(i).toString().compareTo(list.get(i - 1).toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class RemoveView
    implements ActionListener {
        private RemoveView() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = SchemaObjectPropertiesDialogEx.this.selectedViewsList.getSelectedValuesList().toArray();
            for (int i = 0; i < selected.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.allViewsModel.contains(selected[i])) continue;
                SchemaObjectPropertiesDialogEx.this.selectedViewsModel.removeElement(selected[i]);
                SchemaObjectPropertiesDialogEx.this.allViewsModel.addElement(selected[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.allViewsModel);
        }
    }

    private class AddView
    implements ActionListener {
        private AddView() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = SchemaObjectPropertiesDialogEx.this.allViewsList.getSelectedValuesList().toArray();
            for (int i = 0; i < selected.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.selectedViewsModel.contains(selected[i])) continue;
                SchemaObjectPropertiesDialogEx.this.selectedViewsModel.addElement(selected[i]);
                SchemaObjectPropertiesDialogEx.this.allViewsModel.removeElement(selected[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.selectedViewsModel);
        }
    }

    private class RemoveIndex
    implements ActionListener {
        private RemoveIndex() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = SchemaObjectPropertiesDialogEx.this.selectedIndexesList.getSelectedValuesList().toArray();
            for (int i = 0; i < selected.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.allIndexesModel.contains(selected[i])) continue;
                SchemaObjectPropertiesDialogEx.this.allIndexesModel.addElement(selected[i]);
                SchemaObjectPropertiesDialogEx.this.selectedIndexesModel.removeElement(selected[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.allIndexesModel);
        }
    }

    private class AddIndex
    implements ActionListener {
        private AddIndex() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = SchemaObjectPropertiesDialogEx.this.allIndexesList.getSelectedValuesList().toArray();
            for (int i = 0; i < selected.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.selectedIndexesModel.contains(selected[i])) continue;
                SchemaObjectPropertiesDialogEx.this.selectedIndexesModel.addElement(selected[i]);
                SchemaObjectPropertiesDialogEx.this.allIndexesModel.removeElement(selected[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.selectedIndexesModel);
        }
    }

    private class RemoveTable
    implements ActionListener {
        private RemoveTable() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = SchemaObjectPropertiesDialogEx.this.selectedTablesList.getSelectedValuesList().toArray();
            for (int i = 0; i < selected.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.allTablesModel.contains(selected[i])) continue;
                SchemaObjectPropertiesDialogEx.this.selectedTablesModel.removeElement(selected[i]);
                SchemaObjectPropertiesDialogEx.this.allTablesModel.addElement(selected[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.allTablesModel);
        }
    }

    private class AddTable
    implements ActionListener {
        private AddTable() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = SchemaObjectPropertiesDialogEx.this.allTablesList.getSelectedValuesList().toArray();
            for (int i = 0; i < selected.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.selectedTablesModel.contains(selected[i])) continue;
                SchemaObjectPropertiesDialogEx.this.selectedTablesModel.addElement(selected[i]);
                SchemaObjectPropertiesDialogEx.this.allTablesModel.removeElement(selected[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.selectedTablesModel);
        }
    }

    private class FilterObjectListener
    implements DocumentListener {
        JTextField objectsFilter;
        JTable objectsTable;
        int column;

        FilterObjectListener(JTextField objectsFilter, JTable objectsTable, int column) {
            this.objectsFilter = objectsFilter;
            this.objectsTable = objectsTable;
            this.column = column;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SchemaObjectPropertiesDialogEx.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SchemaObjectPropertiesDialogEx.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SchemaObjectPropertiesDialogEx.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }
    }

    private class ORDSTableModel
    extends AbstractTableModel {
        private List modelList;
        private String type;

        public ORDSTableModel(List modelList, String type) {
            this.modelList = modelList;
            this.type = type;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return this.type;
            }
            if (column == 1) {
                return Messages.getString("SchemaPropertiesDialogEx.ORDSEnableObject");
            }
            if (column == 2) {
                return Messages.getString("SchemaPropertiesDialogEx.ORDSObjectAuth");
            }
            if (column == 3) {
                return Messages.getString("SchemaPropertiesDialogEx.ORDSAlias");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ORDSObject o = (ORDSObject)this.modelList.get(rowIndex);
            if (columnIndex == 0) {
                return o.designObject.getName();
            }
            if (columnIndex == 1) {
                return o.enable;
            }
            if (columnIndex == 2) {
                return o.auth;
            }
            if (columnIndex == 3) {
                return o.alias;
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ORDSObject o = (ORDSObject)this.modelList.get(rowIndex);
            if (columnIndex == 1) {
                o.enable = (Boolean)value;
            } else if (columnIndex == 2) {
                o.auth = (Boolean)value;
            } else if (columnIndex == 3) {
                Pattern p = Pattern.compile("\\p{Lower}([[\\p{Lower}\\p{Digit}]#$_])*$");
                Matcher m = p.matcher(value.toString());
                SchemaObjectPropertiesDialogEx.this.ordsAliasOK = true;
                if (!m.matches()) {
                    MessageDialog.error((Component)SchemaObjectPropertiesDialogEx.this, (Object)MessageFormat.format(Messages.getString("SchemaPropertiesDialogEx.INVALID_ALIAS"), value.toString()), (String)Messages.getString("SchemaPropertiesDialogEx.INVALID_ALIAS_TITLE"), null);
                    SchemaObjectPropertiesDialogEx.this.ordsAliasOK = false;
                } else {
                    for (int i = 0; i < this.modelList.size(); ++i) {
                        ORDSObject ordsObj;
                        if (i == rowIndex || (ordsObj = (ORDSObject)this.modelList.get(i)) == null || !ordsObj.alias.equalsIgnoreCase(value.toString())) continue;
                        MessageDialog.error((Component)SchemaObjectPropertiesDialogEx.this, (Object)MessageFormat.format(Messages.getString("SchemaPropertiesDialogEx.DUPLICATE_ALIAS"), value.toString()), (String)Messages.getString("SchemaPropertiesDialogEx.DUPLICATE_ALIAS_TITLE"), null);
                        SchemaObjectPropertiesDialogEx.this.ordsAliasOK = false;
                    }
                }
                if (SchemaObjectPropertiesDialogEx.this.ordsAliasOK) {
                    o.alias = (String)value;
                }
            }
        }
    }

    private class ORDSObject {
        DesignObject designObject;
        boolean enable;
        boolean auth;
        String alias;

        public ORDSObject(DesignObject designObject) {
            this.designObject = designObject;
            this.enable = designObject.isORDSEnable();
            this.auth = designObject.isORDSAuth();
            this.alias = designObject.getORDSAliasNotEmpty();
        }
    }
}

