/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentityDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnProxyDB2v80;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JDecimalField;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.JNumericField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class ColumnPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private static final int MAX_DIGITS = 31;
    private static final String TRIGGER = Messages.getString("ColumnPropertyDialogDB2.Trigger");
    private static final String IDENTITY_CLAUSE = Messages.getString("ColumnPropertyDialogDB2.IDENTITYClause");
    protected static final String[] AUTOINCREMENTDDL = new String[]{"", NONE, TRIGGER, IDENTITY_CLAUSE};
    protected ColumnProxyDB2 column;
    protected JTextField tfDataType;
    protected JComboBox cbNullsAllowed;
    protected JIntegerField ifColNo;
    protected JIntegerField ifKeySeq;
    protected JComboBox cbDataFormat;
    protected JComboBox cbDefault;
    protected JComboBox cbDefaultValue;
    protected JTextField tfDefaultConstant;
    protected JTextField tfLabel;
    protected JPanel designStats;
    protected JPanel distinctValues;
    protected JPanel fieldProc;
    protected JPanel columnIdentity;
    protected JDecimalField dfUpdateRatePercent;
    protected JDecimalField dfAverageLength;
    protected JDecimalField dfGrowthPercent;
    protected JIntegerField ifInitial;
    protected JIntegerField ifFrequencyCount;
    protected JDecimalField dfFrequencyPercent;
    protected JTextField tfProgram;
    protected JTextField tfConstant;
    protected JCheckBox chbUse;
    protected JComboBox cbGenerate;
    protected JTextField tfStartWith;
    protected JIntegerField ifIncrementBy;
    protected JNumericField ifMaxValue;
    protected JNumericField ifMinValue;
    protected JComboBox cbCycle;
    protected JTextField ifCache;
    private String comment;
    private String commentInRDBMS;
    private boolean generateAlways;
    private String startWith;
    private Integer incrementBy;
    private String minValue;
    private String maxValue;
    private boolean cycle;
    private Integer cache;
    protected JComboBox cbAutoIncrementDDL;

    public ColumnPropertyDialogDB2(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.column = (ColumnProxyDB2)object;
        this.setHeight(400);
        this.initCommentsView(140);
        this.initCommentsInRDBMS(140);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ColumnPropertyDialogDB2.ColumnProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDataType();
        this.initNullsAllowed();
        this.initColNo();
        this.initKeySeq();
        this.initDataFormat();
        this.initDefault();
        this.initDefaultValue();
        this.initDefaultConstant();
        this.initLabel();
    }

    protected void initDataType() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.DataType"));
        this.general.add(label);
        this.tfDataType = new JTextField("", 26);
        this.tfDataType.setEditable(false);
        this.general.add(this.tfDataType);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfDataType, 50);
    }

    protected void initNullsAllowed() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.NullsAllowed"));
        this.general.add(label);
        this.cbNullsAllowed = new JComboBox<String>(YES_NO);
        this.setBG(this.cbNullsAllowed);
        this.cbNullsAllowed.setEnabled(false);
        this.cbNullsAllowed.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbNullsAllowed);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbNullsAllowed, 80);
    }

    protected void initColNo() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.ColumnNo"));
        this.general.add(label);
        this.ifColNo = new JIntegerField(0, 26);
        this.ifColNo.setEditable(false);
        this.general.add(this.ifColNo);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.ifColNo, 110);
    }

    protected void initKeySeq() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.KeySequence"));
        this.general.add(label);
        this.ifKeySeq = new JIntegerField(0, 26);
        this.ifKeySeq.setEditable(false);
        this.general.add(this.ifKeySeq);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.ifKeySeq, 140);
    }

    protected void initDataFormat() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.DataFormat"));
        this.general.add(label);
        this.cbDataFormat = new JComboBox<String>(ColumnProxyDB2.getBitDataChoices());
        this.setBG(this.cbDataFormat);
        this.cbDataFormat.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataFormat);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbDataFormat, 170);
    }

    protected void initDefault() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.Default"));
        this.general.add(label);
        this.cbDefault = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDefault);
        this.cbDefault.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDefault);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbDefault, 200);
        this.cbDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnPropertyDialogDB2.this.enableFieldProc(ColumnPropertyDialogDB2.this.column);
            }
        });
    }

    protected void initDefaultValue() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.DefaultValue"));
        this.general.add(label);
        this.cbDefaultValue = new JComboBox<String>(ColumnProxyDB2.getDefaultValueChoices());
        this.setBG(this.cbDefaultValue);
        this.cbDefaultValue.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDefaultValue);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbDefaultValue, 230);
    }

    protected void initDefaultConstant() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.DefaultConstant"));
        this.general.add(label);
        this.tfDefaultConstant = new JTextField("", 26);
        this.general.add(this.tfDefaultConstant);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.tfDefaultConstant, 260);
    }

    protected void initLabel() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.Label"));
        this.general.add(label);
        this.tfLabel = new JTextField("", 26);
        this.general.add(this.tfLabel);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.tfLabel, 290);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.column.getName());
        this.tfName.setText(this.column.getName());
        this.tfDataType.setText(this.column.getDatatypeString());
        this.cbNullsAllowed.setSelectedItem(this.column.getColumn().getNullsAllowed() ? YES_NO[0] : YES_NO[1]);
        this.ifColNo.setValue((long)this.column.getColno());
        this.ifKeySeq.setValue((long)this.column.getKeyseq());
        this.cbDataFormat.setSelectedItem(this.column.getBitData());
        this.cbDataFormat.setEnabled(this.dataTypeIsCharacter(this.column));
        this.cbDefault.setSelectedItem(this.column.getDefault() ? YES_NO[0] : YES_NO[1]);
        this.cbDefaultValue.setSelectedItem(this.column.getDefaultValue());
        this.tfDefaultConstant.setText(this.column.getDefaultValueConstant());
        this.tfLabel.setText(this.column.getLabel());
        this.dfUpdateRatePercent.setValue(this.column.getUpdateRatePercent());
        this.dfAverageLength.setValue(this.column.getAverageLength());
        this.dfGrowthPercent.setValue(this.column.getGrowthPercent());
        this.ifInitial.setValue(this.column.getInitial());
        this.ifFrequencyCount.setValue(this.column.getFrequencyCount());
        this.dfFrequencyPercent.setValue(this.column.getFrequencyPercent());
        this.tfProgram.setText(this.column.getProgram());
        this.tfConstant.setText(this.column.getConstant());
        this.initColumnIdentityProperties();
        this.comment = this.column.getObject().getComment();
        this.commentInRDBMS = this.column.getObject().getCommentInRDBMS();
        if (this.column.isCommentChanged()) {
            this.getCommentsList().insert(this.column.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.column.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.column.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.enableFieldProc(this.column);
    }

    protected void initColumnIdentityProperties() {
        Column columnObject = (Column)this.column.getObject();
        this.generateAlways = columnObject.isAutoIncrementGenerateAlways();
        this.startWith = columnObject.getAutoIncrementStartWith();
        this.incrementBy = columnObject.getAutoIncrementIncrementBy();
        this.minValue = columnObject.getAutoIncrementMinValue();
        this.maxValue = columnObject.getAutoIncrementMaxValue();
        this.cycle = columnObject.isAutoIncrementCycle();
        this.cache = columnObject.getAutoIncrementCache();
        if (!this.isNumericDataType(this.column.getDataType().toString()) && !((Column)this.column.getObject()).isOid()) {
            this.chbUse.setSelected(false);
            this.setIdentityUse(false);
            this.chbUse.setEnabled(false);
        } else if (columnObject.isAutoIncrementColumn() || columnObject.isComputed().booleanValue()) {
            ColumnIdentityDB2 identity = this.column.getColumnIdentity();
            boolean useIdentity = this.column.isUseIdentity() || columnObject.isComputed() != false;
            this.chbUse.setSelected(useIdentity);
            this.setIdentityUse(useIdentity);
            if (this.column.isGenerateAlwaysChanged()) {
                this.cbGenerate.setSelectedItem(identity.getGenerate());
            } else {
                this.cbGenerate.setSelectedItem(this.generateAlways ? ColumnIdentityDB2.getGenerateValues()[0] : ColumnIdentityDB2.getGenerateValues()[1]);
            }
            if (this.column.isStartWithChanged()) {
                this.tfStartWith.setText(identity.getStartWith());
            } else {
                this.tfStartWith.setText(this.startWith);
            }
            if (this.column.isIncrementByChanged()) {
                this.ifIncrementBy.setValue((long)identity.getIncrementBy());
            } else {
                this.ifIncrementBy.setValue(this.incrementBy);
            }
            if (this.column.isMinValueChanged()) {
                this.ifMinValue.setText(identity.getMinValue());
            } else {
                this.ifMinValue.setText(this.minValue);
            }
            if (this.column.isMaxValueChanged()) {
                this.ifMaxValue.setText(identity.getMaxValue());
            } else {
                this.ifMaxValue.setText(this.maxValue);
            }
            if (this.column.isCycleChanged()) {
                this.cbCycle.setSelectedItem(identity.isCycle() ? YES_NO[0] : YES_NO[1]);
            } else {
                this.cbCycle.setSelectedItem(this.cycle ? YES_NO[0] : YES_NO[1]);
            }
            if (this.column.isCacheChanged()) {
                if (identity.getCache() == 0) {
                    this.ifCache.setText(NO);
                } else {
                    this.ifCache.setText(Integer.toString(identity.getCache()));
                }
            } else if (this.cache == null || this.cache == 0) {
                this.ifCache.setText(NO);
            } else {
                this.ifCache.setText(Integer.toString(this.cache));
            }
            this.cbAutoIncrementDDL.setSelectedItem(this.translate(((ColumnProxyDB2v80)this.column).getAutoIncrementDDL(), ColumnProxyDB2v80.getAutoIncrementDDLChoices(), AUTOINCREMENTDDL));
            if (!(columnObject.isIdentityColumn() && this.column.getDatatypeString().indexOf("CHAR") == -1 || this.cbAutoIncrementDDL.getSelectedItem().equals(IDENTITY_CLAUSE))) {
                this.cbAutoIncrementDDL.removeItem(IDENTITY_CLAUSE);
            }
            this.initColumnIdentityAdditionalProperties(identity);
        } else {
            this.chbUse.setSelected(false);
            this.setIdentityUse(false);
            this.tfStartWith.setText("1");
            this.ifIncrementBy.setValue(1L);
            this.ifMinValue.setText("");
            this.ifMaxValue.setText("");
            this.cbCycle.setSelectedItem(YES_NO[1]);
            this.ifCache.setText(NO);
            this.cbAutoIncrementDDL.setSelectedItem("");
            this.initColumnIdentityAdditionalProperties(null);
        }
        if (!(columnObject.isAutoIncrementColumn() || columnObject.isIdentityColumn() || columnObject.isComputed().booleanValue())) {
            this.chbUse.setSelected(false);
            this.chbUse.setEnabled(false);
            this.setIdentityUse(false);
        }
    }

    protected void initColumnIdentityAdditionalProperties(ColumnIdentityDB2 identity) {
    }

    @Override
    protected void setProperties() {
        if (this.column != null) {
            this.column.setName(this.tfName.getText());
            this.column.setBitData((String)this.cbDataFormat.getSelectedItem());
            Object selected = this.cbDefault.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.column.setDefault(result);
            this.column.setDefaultValue((String)this.cbDefaultValue.getSelectedItem());
            this.column.setDefaultValueConstant(this.tfDefaultConstant.getText());
            this.column.setLabel(this.tfLabel.getText());
            this.column.setUpdateRatePercent(this.dfUpdateRatePercent.getFloatValue());
            this.column.setAverageLength(this.dfAverageLength.getFloatValue());
            this.column.setGrowthPercent(this.dfGrowthPercent.getFloatValue());
            this.column.setInitial(this.ifInitial.getIntValue());
            this.column.setFrequencyCount(this.ifFrequencyCount.getIntValue());
            this.column.setFrequencyPercent(this.dfFrequencyPercent.getFloatValue());
            this.column.setProgram(this.tfProgram.getText());
            this.column.setConstant(this.tfConstant.getText());
            this.setColumnIdentityProperties();
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equalsIgnoreCase(commentText)) {
                this.column.setComment(commentText);
                this.column.setCommentChanged(true);
            } else {
                this.column.setComment("");
                this.column.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equalsIgnoreCase(commentInRDBMSText)) {
                this.column.setCommentInRDBMS(commentInRDBMSText);
                this.column.setCommentInRDBMSChanged(true);
            } else {
                this.column.setCommentInRDBMS("");
                this.column.setCommentInRDBMSChanged(false);
            }
        }
    }

    protected void setColumnIdentityProperties() {
        if (this.chbUse.isEnabled()) {
            if (this.chbUse.isSelected()) {
                int newCacheVal;
                ColumnIdentityDB2 identity;
                this.column.setUseIdentity(true);
                if (this.column.getColumnIdentity() != null) {
                    identity = this.column.getColumnIdentity();
                } else {
                    identity = this.getStorageDesign().getColumnIdentitySet().createColumnIdentity();
                    this.column.setColumnIdentity(identity);
                }
                if (this.notEquals(this.generateAlways, this.cbGenerate, ColumnIdentityDB2.getGenerateValues()[0], ColumnIdentityDB2.getGenerateValues()[1])) {
                    identity.setGenerate((String)this.cbGenerate.getSelectedItem());
                    this.column.setGenerateAlwaysChanged(true);
                } else {
                    this.column.setGenerateAlwaysChanged(false);
                }
                if (this.notEquals(this.startWith, this.tfStartWith)) {
                    identity.setStartWith(this.tfStartWith.getText());
                    this.column.setStartWithChanged(true);
                } else {
                    this.column.setStartWithChanged(false);
                }
                if (this.notEquals(this.incrementBy, this.ifIncrementBy)) {
                    identity.setIncrementBy(this.ifIncrementBy.getIntValue());
                    this.column.setIncrementByChanged(true);
                } else {
                    this.column.setIncrementByChanged(false);
                }
                if (this.notEquals(this.minValue, this.ifMinValue)) {
                    identity.setMinValue(this.ifMinValue.getText());
                    this.column.setMinValueChanged(true);
                } else {
                    this.column.setMinValueChanged(false);
                }
                if (this.notEquals(this.maxValue, this.ifMaxValue)) {
                    identity.setMaxValue(this.ifMaxValue.getText());
                    this.column.setMaxValueChanged(true);
                } else {
                    this.column.setMaxValueChanged(false);
                }
                if (this.notEquals(this.cycle, this.cbCycle, YES, NO)) {
                    identity.setCycle(YES_NO[0].equalsIgnoreCase((String)this.cbCycle.getSelectedItem()));
                    this.column.setCycleChanged(true);
                } else {
                    this.column.setCycleChanged(false);
                }
                int columnCacheVal = this.cache == null ? 0 : this.cache;
                String cacheText = this.ifCache.getText().trim();
                if (cacheText.equalsIgnoreCase(NO)) {
                    newCacheVal = 0;
                } else if (cacheText.equalsIgnoreCase(YES)) {
                    newCacheVal = 20;
                } else {
                    try {
                        newCacheVal = Integer.parseInt(cacheText);
                    }
                    catch (NumberFormatException e) {
                        newCacheVal = columnCacheVal;
                    }
                }
                if (newCacheVal != columnCacheVal) {
                    identity.setCache(newCacheVal);
                    this.column.setCacheChanged(true);
                } else {
                    this.column.setCacheChanged(false);
                }
                if (this.cbAutoIncrementDDL.isEnabled()) {
                    ((ColumnProxyDB2v80)this.column).setAutoIncrementDDL(this.translate((String)this.cbAutoIncrementDDL.getSelectedItem(), AUTOINCREMENTDDL, ColumnProxyDB2v80.getAutoIncrementDDLChoices()));
                }
                this.setColumnIdentityAdditionalProperties(identity);
            } else {
                this.column.setUseIdentity(false);
            }
        }
    }

    protected void setColumnIdentityAdditionalProperties(ColumnIdentityDB2 identity) {
    }

    @Override
    protected void addTabs() {
        this.initDesignStatsView();
        this.initDistinctValuesView();
        this.initFieldProcView();
        this.initColumnIdentityView();
    }

    private void initDesignStatsView() {
        this.designStats = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogDB2.DesignStats"), this.designStats);
        this.initDesignStats();
    }

    private void initDistinctValuesView() {
        this.distinctValues = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogDB2.DistinctValues"), this.distinctValues);
        this.initDistinctValues();
    }

    private void initFieldProcView() {
        this.fieldProc = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogDB2.FieldProc"), this.fieldProc);
        this.initFieldProc();
    }

    private void initColumnIdentityView() {
        this.columnIdentity = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogDB2.ColumnIdentity"), this.columnIdentity);
        this.initColumnIdentity();
    }

    private void initDesignStats() {
        this.initUpdateRatePercent();
        this.initAverageLength();
        this.initGrowthPercent();
    }

    private void initDistinctValues() {
        this.initInitial();
        this.initFrequencyCount();
        this.initFrequencyPercent();
    }

    private void initFieldProc() {
        this.initProgram();
        this.initConstant();
    }

    protected void initColumnIdentity() {
        this.initUseIdentity();
        this.initGenerate();
        this.initStartWith();
        this.initIncremetBy();
        this.initMinValue();
        this.initMaxValue();
        this.initCycle();
        this.initCache();
        this.initAutoIncrementDDL();
        this.setIdentityUse(false);
    }

    protected SpringLayout getDesignStatsLayout() {
        return (SpringLayout)this.designStats.getLayout();
    }

    protected SpringLayout getDistinctValuesLayout() {
        return (SpringLayout)this.distinctValues.getLayout();
    }

    protected SpringLayout getFieldProcLayout() {
        return (SpringLayout)this.fieldProc.getLayout();
    }

    protected SpringLayout getColumnIdentityLayout() {
        return (SpringLayout)this.columnIdentity.getLayout();
    }

    protected void initUpdateRatePercent() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.UpdRatePercent"));
        this.designStats.add(label);
        this.dfUpdateRatePercent = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfUpdateRatePercent);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 20);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfUpdateRatePercent, 20);
    }

    protected void initAverageLength() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.AverageLength"));
        this.designStats.add(label);
        this.dfAverageLength = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfAverageLength);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 50);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAverageLength, 50);
    }

    protected void initGrowthPercent() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.GrowthPercent"));
        this.designStats.add(label);
        this.dfGrowthPercent = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfGrowthPercent);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 80);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfGrowthPercent, 80);
    }

    protected void initInitial() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.Initial"));
        this.distinctValues.add(label);
        this.ifInitial = new JIntegerField(0, 26);
        this.distinctValues.add(this.ifInitial);
        this.setLabelConstraints(this.getDistinctValuesLayout(), label, 20);
        this.setObjectConstraints(this.getDistinctValuesLayout(), this.ifInitial, 20);
    }

    private void initFrequencyCount() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.FrequencyCount"));
        this.distinctValues.add(label);
        this.ifFrequencyCount = new JIntegerField(0, 26);
        this.distinctValues.add(this.ifFrequencyCount);
        this.setLabelConstraints(this.getDistinctValuesLayout(), label, 50);
        this.setObjectConstraints(this.getDistinctValuesLayout(), this.ifFrequencyCount, 50);
    }

    protected void initFrequencyPercent() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.FrequencyPercent"));
        this.distinctValues.add(label);
        this.dfFrequencyPercent = new JDecimalField(0.0, 26);
        this.distinctValues.add(this.dfFrequencyPercent);
        this.setLabelConstraints(this.getDistinctValuesLayout(), label, 80);
        this.setObjectConstraints(this.getDistinctValuesLayout(), this.dfFrequencyPercent, 80);
    }

    protected void initProgram() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.Program"));
        this.fieldProc.add(label);
        this.tfProgram = new JTextField("", 26);
        this.fieldProc.add(this.tfProgram);
        this.setLabelConstraints(this.getFieldProcLayout(), label, 20);
        this.setObjectConstraints(this.getFieldProcLayout(), this.tfProgram, 20);
    }

    protected void initConstant() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.Constant"));
        this.fieldProc.add(label);
        this.tfConstant = new JTextField("", 26);
        this.fieldProc.add(this.tfConstant);
        this.setLabelConstraints(this.getFieldProcLayout(), label, 50);
        this.setObjectConstraints(this.getFieldProcLayout(), this.tfConstant, 50);
    }

    protected void initUseIdentity() {
        this.chbUse = new JCheckBox(Messages.getString("ColumnPropertyDialogDB2.Use"));
        this.chbUse.addActionListener(new CheckBoxListener());
        this.columnIdentity.add(this.chbUse);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.chbUse, 10, 20);
    }

    protected void initGenerate() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.Generate"));
        this.columnIdentity.add(label);
        this.cbGenerate = new JComboBox<String>(ColumnIdentityDB2.getGenerateValues());
        this.setBG(this.cbGenerate);
        this.cbGenerate.setPreferredSize(this.tfName.getPreferredSize());
        this.columnIdentity.add(this.cbGenerate);
        this.setLabelConstraints(this.getColumnIdentityLayout(), label, 50);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.cbGenerate, 50);
    }

    protected void initStartWith() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.StartWith"));
        this.columnIdentity.add(label);
        this.tfStartWith = new JNumericField(31, 26);
        this.columnIdentity.add(this.tfStartWith);
        this.setLabelConstraints(this.getColumnIdentityLayout(), label, 80);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.tfStartWith, 80);
    }

    protected void initIncremetBy() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.IncrementBy"));
        this.columnIdentity.add(label);
        this.ifIncrementBy = new JIntegerField(0, 26);
        this.columnIdentity.add(this.ifIncrementBy);
        this.setLabelConstraints(this.getColumnIdentityLayout(), label, 110);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.ifIncrementBy, 110);
    }

    protected void initMinValue() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.MinValue"));
        this.columnIdentity.add(label);
        this.ifMinValue = new JNumericField(31, 26);
        this.columnIdentity.add(this.ifMinValue);
        this.setLabelConstraints(this.getColumnIdentityLayout(), label, 140);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.ifMinValue, 140);
    }

    protected void initMaxValue() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.MaxValue"));
        this.columnIdentity.add(label);
        this.ifMaxValue = new JNumericField(31, 26);
        this.columnIdentity.add(this.ifMaxValue);
        this.setLabelConstraints(this.getColumnIdentityLayout(), label, 170);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.ifMaxValue, 170);
    }

    protected void initCycle() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.Cycle"));
        this.columnIdentity.add(label);
        this.cbCycle = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCycle);
        this.cbCycle.setPreferredSize(this.tfName.getPreferredSize());
        this.columnIdentity.add(this.cbCycle);
        this.setLabelConstraints(this.getColumnIdentityLayout(), label, 200);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.cbCycle, 200);
    }

    protected void initCache() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.Cache"));
        this.columnIdentity.add(label);
        this.ifCache = new JTextField("", 26);
        this.columnIdentity.add(this.ifCache);
        this.setLabelConstraints(this.getColumnIdentityLayout(), label, 230);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.ifCache, 230);
    }

    protected void initAutoIncrementDDL() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2.AutoIncrementDDL"));
        this.columnIdentity.add(label);
        this.cbAutoIncrementDDL = new JComboBox<String>(AUTOINCREMENTDDL);
        this.setBG(this.cbAutoIncrementDDL);
        this.cbAutoIncrementDDL.setPreferredSize(this.tfName.getPreferredSize());
        this.columnIdentity.add(this.cbAutoIncrementDDL);
        this.setLabelConstraints(this.getColumnIdentityLayout(), label, 260);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.cbAutoIncrementDDL, 260);
    }

    protected void setIdentityUse(boolean use) {
        this.cbGenerate.setEnabled(use);
        this.tfStartWith.setEditable(use);
        this.ifIncrementBy.setEditable(use);
        this.ifMinValue.setEditable(use);
        this.ifMaxValue.setEditable(use);
        this.cbCycle.setEnabled(use);
        this.ifCache.setEditable(use);
        this.cbAutoIncrementDDL.setEnabled(use);
    }

    protected boolean dataTypeIsCharacter(ColumnProxyDB2 column) {
        String[] VALID_DATA_TYPES = new String[]{"CHARACTER", "CHAR", "VARCHAR", "LONG VARCHAR", "CLOB", "CHARACTER VARYING", "CHAR VARYING"};
        HashSet<String> vdt = new HashSet<String>();
        vdt.addAll(Arrays.asList(VALID_DATA_TYPES));
        String dataType = column.getDataType().getName().toUpperCase();
        int ind = dataType.indexOf(40);
        if (ind > 0) {
            dataType = dataType.substring(0, ind);
        }
        return vdt.contains(dataType);
    }

    protected boolean dataTypeIsForFieldProc(ColumnProxyDB2 column) {
        String size;
        int k;
        String[] VALID_DATA_TYPES = new String[]{"CHARACTER", "CHAR", "VARCHAR"};
        HashSet<String> vdt = new HashSet<String>();
        vdt.addAll(Arrays.asList(VALID_DATA_TYPES));
        String dataType = column.getDataType().getName().toUpperCase();
        return vdt.contains(dataType) && (k = Integer.valueOf(size = column.getDataType().getSize()).intValue()) < 256;
    }

    protected boolean isNumericDataType(String datatype) {
        String dtype = datatype.toUpperCase();
        return dtype.indexOf("INT") > -1 || dtype.indexOf("DEC") > -1 || dtype.indexOf("NUM") > -1 || dtype.indexOf("FLOAT") > -1 || dtype.indexOf("REAL") > -1 || dtype.indexOf("DOUBLE") > -1;
    }

    protected void enableFieldProc(ColumnProxyDB2 column) {
        String def = (String)this.cbDefault.getSelectedItem();
        boolean enable = false;
        if (this.dataTypeIsForFieldProc(column) && def != null && def.equalsIgnoreCase(NO)) {
            enable = true;
        }
        int fieldProcInd = this.getPane().indexOfComponent(this.fieldProc);
        this.getPane().setEnabledAt(fieldProcInd, enable);
    }

    protected class CheckBoxListener
    implements ActionListener {
        protected CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnPropertyDialogDB2.this.setIdentityUse(ColumnPropertyDialogDB2.this.chbUse.isSelected());
        }
    }
}

