/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AUXTableIndexPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.IndexPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.TSPartitionPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.TableSpacePropertyDialogDB2;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class StorageTemplatePropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private StorageTemplateDB2 template;
    private JIntegerField ifSGPRIQTY;
    private JIntegerField ifSGSECQTY;
    private JComboBox cbSGErase;
    private JIntegerField ifFreePage;
    private JIntegerField ifPCTFREE;
    private JComboBox cbGBCACHE;
    private JComboBox cbTrackMode;
    private JComboBox cbDefine;
    private JPanel tableSpaces;
    private DefaultListModel tsListModel;
    private JList tsList;
    private JScrollPane spTS;
    private JPanel indexes;
    private DefaultListModel indexesListModel;
    private JList indexesList;
    private JScrollPane spIndexes;
    private JPanel tsPartitions;
    private DefaultListModel tsPartListModel;
    private JList tsPartList;
    private JScrollPane spTSPart;
    private JPanel auxTableIndexes;
    private DefaultListModel auxTableIndexesListModel;
    private JList auxTableIndexesList;
    private JScrollPane spAUXTableIndexes;
    private JComboBox cbVcat;
    private JComboBox cbStorageGroup;

    public StorageTemplatePropertyDialogDB2(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.template = (StorageTemplateDB2)object;
        this.setHeight(400);
        this.initCommentsView(355);
        this.pack();
        this.setResizable(false);
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 520;
    }

    @Override
    public String getCaption() {
        return Messages.getString("StorageTemplatePropertyDialogDB2.StorageTemplateProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initVcat();
        this.initStorageGroup();
        this.initSGPIQTY();
        this.initSGSECQTY();
        this.initSGErase();
        this.initFreePage();
        this.initPCTFREE();
        this.initGBCACHE();
        this.initTrackMode();
        this.initDefine();
    }

    @Override
    protected void addTabs() {
        this.initTSView();
        this.initTSPartitionsView();
        this.initIndexesView();
        this.initAUXTableIndexesView();
    }

    private void initAUXTableIndexesView() {
        this.auxTableIndexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("StorageTemplatePropertyDialogDB2.AUXTableIndexes"), this.auxTableIndexes);
        this.initAUXTableIndexes();
    }

    private void initAUXTableIndexes() {
        this.auxTableIndexesListModel = new DefaultListModel();
        this.auxTableIndexesList = new JList(this.auxTableIndexesListModel);
        this.auxTableIndexesList.addMouseListener(new listMouseListenerAUXTableIndexes());
        this.spAUXTableIndexes = new JScrollPane(this.auxTableIndexesList);
        this.spAUXTableIndexes.setPreferredSize(new Dimension(504, 357));
        this.spAUXTableIndexes.setBorder(BorderFactory.createEtchedBorder(0));
        this.auxTableIndexes.add(this.spAUXTableIndexes);
        this.setObjectConstraints(this.getAUXTableIndexesLayout(), this.spAUXTableIndexes, 10, 12);
    }

    private SpringLayout getAUXTableIndexesLayout() {
        return (SpringLayout)this.auxTableIndexes.getLayout();
    }

    private void initTSPartitionsView() {
        this.tsPartitions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("StorageTemplatePropertyDialogDB2.TableSpacePartitions"), this.tsPartitions);
        this.initTSPartitions();
    }

    private void initTSPartitions() {
        this.tsPartListModel = new DefaultListModel();
        this.tsPartList = new JList(this.tsPartListModel);
        this.tsPartList.addMouseListener(new listMouseListenerTSPart());
        this.spTSPart = new JScrollPane(this.tsPartList);
        this.spTSPart.setPreferredSize(new Dimension(504, 357));
        this.spTSPart.setBorder(BorderFactory.createEtchedBorder(0));
        this.tsPartitions.add(this.spTSPart);
        this.setObjectConstraints(this.getTSPartLayout(), this.spTSPart, 10, 12);
    }

    private SpringLayout getTSPartLayout() {
        return (SpringLayout)this.tsPartitions.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("StorageTemplatePropertyDialogDB2.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        this.indexesListModel = new DefaultListModel();
        this.indexesList = new JList(this.indexesListModel);
        this.indexesList.addMouseListener(new listMouseListenerIndex());
        this.spIndexes = new JScrollPane(this.indexesList);
        this.spIndexes.setPreferredSize(new Dimension(504, 357));
        this.spIndexes.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(this.spIndexes);
        this.setObjectConstraints(this.getIndexesLayout(), this.spIndexes, 10, 12);
    }

    private SpringLayout getIndexesLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    private void initTSView() {
        this.tableSpaces = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("StorageTemplatePropertyDialogDB2.TableSpaces"), this.tableSpaces);
        this.initTableSpaces();
    }

    private void initTableSpaces() {
        this.tsListModel = new DefaultListModel();
        this.tsList = new JList(this.tsListModel);
        this.tsList.addMouseListener(new listMouseListenerTS());
        this.spTS = new JScrollPane(this.tsList);
        this.spTS.setPreferredSize(new Dimension(504, 357));
        this.spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tableSpaces.add(this.spTS);
        this.setObjectConstraints(this.getTSLayout(), this.spTS, 10, 12);
    }

    protected SpringLayout getTSLayout() {
        return (SpringLayout)this.tableSpaces.getLayout();
    }

    private void initVcat() {
        JLabel label = new JLabel("VCAT");
        this.general.add(label);
        this.cbVcat = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getVCatSet().toArray(), this.cbVcat);
        }
        this.setBG(this.cbVcat);
        this.cbVcat.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbVcat);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbVcat, 50);
    }

    private void initStorageGroup() {
        JLabel label = new JLabel(Messages.getString("StorageTemplatePropertyDialogDB2.StorageGroup"));
        this.general.add(label);
        this.cbStorageGroup = new JComboBox();
        this.setBG(this.cbStorageGroup);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getStorageGroupSet().toArray(), this.cbStorageGroup);
        }
        this.cbStorageGroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbStorageGroup);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbStorageGroup, 80);
    }

    private void initSGPIQTY() {
        JLabel label = new JLabel("SGPRIQTY");
        this.general.add(label);
        this.ifSGPRIQTY = new JIntegerField(0, 26);
        this.general.add(this.ifSGPRIQTY);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.ifSGPRIQTY, 110);
    }

    private void initSGSECQTY() {
        JLabel label = new JLabel("SGSECQTY");
        this.general.add(label);
        this.ifSGSECQTY = new JIntegerField(0, 26);
        this.general.add(this.ifSGSECQTY);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.ifSGSECQTY, 140);
    }

    private void initSGErase() {
        JLabel label = new JLabel(Messages.getString("StorageTemplatePropertyDialogDB2.SGErase"));
        this.general.add(label);
        this.cbSGErase = new JComboBox<String>(YES_NO);
        this.setBG(this.cbSGErase);
        this.cbSGErase.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSGErase);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbSGErase, 170);
    }

    private void initFreePage() {
        JLabel label = new JLabel(Messages.getString("StorageTemplatePropertyDialogDB2.FreePage"));
        this.general.add(label);
        this.ifFreePage = new JIntegerField(0, 26);
        this.general.add(this.ifFreePage);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.ifFreePage, 200);
    }

    private void initPCTFREE() {
        JLabel label = new JLabel("PCTFREE");
        this.general.add(label);
        this.ifPCTFREE = new JIntegerField(0, 26);
        this.general.add(this.ifPCTFREE);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.ifPCTFREE, 230);
    }

    private void initGBCACHE() {
        JLabel label = new JLabel("GBCACHE");
        this.general.add(label);
        this.cbGBCACHE = new JComboBox<String>(StorageTemplateDB2.getGBCacheValues());
        this.setBG(this.cbGBCACHE);
        this.cbGBCACHE.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbGBCACHE);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbGBCACHE, 260);
    }

    private void initTrackMode() {
        JLabel label = new JLabel(Messages.getString("StorageTemplatePropertyDialogDB2.TrackMode"));
        this.general.add(label);
        this.cbTrackMode = new JComboBox<String>(YES_NO);
        this.setBG(this.cbTrackMode);
        this.cbTrackMode.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTrackMode);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbTrackMode, 290);
    }

    private void initDefine() {
        JLabel label = new JLabel(Messages.getString("StorageTemplatePropertyDialogDB2.Define"));
        this.general.add(label);
        this.cbDefine = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDefine);
        this.cbDefine.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDefine);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbDefine, 320);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.template.getName());
        this.tfName.setText(this.template.getName());
        this.cbVcat.setSelectedItem(this.template.getVCat());
        this.cbStorageGroup.setSelectedItem(this.template.getStorageGroup());
        this.ifSGPRIQTY.setValue((long)this.template.getSgPriqty());
        this.ifSGSECQTY.setValue((long)this.template.getSgSeqty());
        this.cbSGErase.setSelectedItem(this.template.isSgErase() ? YES_NO[0] : YES_NO[1]);
        this.ifFreePage.setValue((long)this.template.getFreePage());
        this.ifPCTFREE.setValue((long)this.template.getPctFree());
        this.cbGBCACHE.setSelectedItem(this.template.getGbCache());
        this.cbTrackMode.setSelectedItem(this.template.isTrackMode() ? YES_NO[0] : YES_NO[1]);
        this.cbDefine.setSelectedItem(this.template.isDefine() ? YES_NO[0] : YES_NO[1]);
        this.getCommentsList().insert(this.template.getComment(), 0);
        TableSpaceDB2[] tss = (TableSpaceDB2[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tss.length; ++i) {
            TableSpaceDB2 ts = tss[i];
            if (ts.getStorageTemplate() == null || ts.getStorageTemplate() != this.template) continue;
            this.tsListModel.addElement(ts);
        }
        Object[] indexes = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i = 0; i < indexes.length; ++i) {
            IndexProxyDB2 index;
            if (!(indexes[i] instanceof IndexProxyDB2) || (index = (IndexProxyDB2)indexes[i]).getStorageTemplate() == null || index.getStorageTemplate() != this.template) continue;
            this.indexesListModel.addElement(index);
        }
        PartitionDB2[] tsParts = (PartitionDB2[])this.getStorageDesign().getPartitionSet().toArray();
        for (int i = 0; i < tsParts.length; ++i) {
            PartitionDB2 part = tsParts[i];
            if (part.getStorageTemplate() == null || part.getStorageTemplate() != this.template) continue;
            this.tsPartListModel.addElement(part);
        }
        AUXTableIndexDB2[] tableIndexDB2s = (AUXTableIndexDB2[])this.getStorageDesign().getAUXTableIndexSet().toArray();
        for (int i = 0; i < tableIndexDB2s.length; ++i) {
            AUXTableIndexDB2 tableIndexDB2 = tableIndexDB2s[i];
            if (tableIndexDB2.getStorageTemplate() == null || tableIndexDB2.getStorageTemplate() != this.template) continue;
            this.auxTableIndexesListModel.addElement(tableIndexDB2);
        }
    }

    @Override
    protected void setProperties() {
        if (this.template != null) {
            this.template.setName(this.tfName.getText());
            this.template.setVCat((VCatDB2)this.cbVcat.getSelectedItem());
            this.template.setStorageGroup((StorageGroupDB2)this.cbStorageGroup.getSelectedItem());
            this.template.setSgPriqty(this.ifSGPRIQTY.getIntValue());
            this.template.setSgSeqty(this.ifSGSECQTY.getIntValue());
            Object selected = this.cbSGErase.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.template.setSgErase(result);
            this.template.setFreePage(this.ifFreePage.getIntValue());
            this.template.setPctFree(this.ifPCTFREE.getIntValue());
            selected = this.cbGBCACHE.getSelectedItem();
            this.template.setGbCache((String)selected);
            selected = this.cbTrackMode.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.template.setTrackMode(result);
            selected = this.cbDefine.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.template.setDefine(result);
            this.template.setComment(this.getCommentsList().getText());
        }
    }

    private class listMouseListenerAUXTableIndexes
    extends MouseAdapter {
        private listMouseListenerAUXTableIndexes() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            AUXTableIndexDB2 selected;
            if (e.getClickCount() == 2 && (selected = (AUXTableIndexDB2)StorageTemplatePropertyDialogDB2.this.auxTableIndexesList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                AUXTableIndexPropertyDialogDB2 dialog = new AUXTableIndexPropertyDialogDB2(StorageTemplatePropertyDialogDB2.this.template.getDesign().getAppView(), StorageTemplatePropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class listMouseListenerTSPart
    extends MouseAdapter {
        private listMouseListenerTSPart() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PartitionDB2 selected;
            if (e.getClickCount() == 2 && (selected = (PartitionDB2)StorageTemplatePropertyDialogDB2.this.tsPartList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TSPartitionPropertyDialogDB2 dialog = new TSPartitionPropertyDialogDB2(StorageTemplatePropertyDialogDB2.this.template.getDesign().getAppView(), StorageTemplatePropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class listMouseListenerIndex
    extends MouseAdapter {
        private listMouseListenerIndex() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            IndexProxyDB2 selected;
            if (e.getClickCount() == 2 && (selected = (IndexProxyDB2)StorageTemplatePropertyDialogDB2.this.indexesList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                IndexPropertyDialogDB2 dialog = new IndexPropertyDialogDB2(StorageTemplatePropertyDialogDB2.this.template.getDesign().getAppView(), StorageTemplatePropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class listMouseListenerTS
    extends MouseAdapter {
        private listMouseListenerTS() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableSpaceDB2 selected;
            if (e.getClickCount() == 2 && (selected = (TableSpaceDB2)StorageTemplatePropertyDialogDB2.this.tsList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TableSpacePropertyDialogDB2 dialog = new TableSpacePropertyDialogDB2(StorageTemplatePropertyDialogDB2.this.template.getDesign().getAppView(), StorageTemplatePropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }
}

