/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.LocalIndexPropertyDialogOraclev10g;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class HashPartitionDialogOraclev10g
extends AbstractOraclePropertyDialog
implements ListSelectionListener {
    private HashPartitionOraclev10g partition;
    private JComboBox cbTableSpace;
    private JComboBox cbIOTOverflowTablespace;
    private JList list;
    private JPanel indexesButtonPanel;
    private DefaultListModel listModel;
    private JButton edit;

    public HashPartitionDialogOraclev10g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.partition = (HashPartitionOraclev10g)object;
        this.setHeight(150);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("HashPartitionDialogOracle.HashPartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTableSpace();
        this.initIOTOverflowTablespace();
    }

    private void initTableSpace() {
        JLabel label = new JLabel(Messages.getString("HashPartitionDialogOracle.Tablespace"));
        this.general.add(label);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbTableSpace, 50);
    }

    private void initIOTOverflowTablespace() {
        JLabel label = new JLabel(Messages.getString("HashPartitionDialogOracle.IOTTablespace"));
        this.general.add(label);
        this.cbIOTOverflowTablespace = new JComboBox();
        this.setBG(this.cbIOTOverflowTablespace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbIOTOverflowTablespace);
        }
        this.cbIOTOverflowTablespace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIOTOverflowTablespace);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbIOTOverflowTablespace, 80);
    }

    @Override
    public void initProperties() {
        AbstractStorageObjectOracle owningPartition;
        this.initCaption(this.partition.getName());
        this.tfName.setText(this.partition.getName());
        this.selectObject(this.cbTableSpace, this.partition.getTableSpace());
        this.selectObject(this.cbIOTOverflowTablespace, this.partition.getIotOverflowTablespace());
        PartitionListOracle partitionList = this.partition.getPartitionList();
        if (partitionList == null && (owningPartition = this.partition.getSubPartitionOf()) != null) {
            if (owningPartition instanceof PartitionOracle) {
                partitionList = ((PartitionOracle)owningPartition).getPartitionList();
            } else if (owningPartition instanceof ListPartitionOracle) {
                partitionList = ((ListPartitionOracle)owningPartition).getPartitionList();
            } else if (owningPartition instanceof HashPartitionOracle) {
                partitionList = ((HashPartitionOracle)owningPartition).getPartitionList();
            }
        }
        TableProxyOracle table = null;
        if (partitionList != null) {
            SnapshotOracle snapshot;
            table = partitionList.getTable();
            if (table == null && (snapshot = partitionList.getSnapshot()) != null) {
                table = snapshot.getImplementedTable();
            }
        } else {
            table = this.partition.getPartOfStorageTable();
        }
        if (table != null) {
            this.cbIOTOverflowTablespace.setEnabled(table.getOrganization().equals(TableProxyOracle.getOrganizationChoices()[1]));
            for (StorageObject index : table.getIndexes()) {
                if (!index.getIndexPartitioned().equalsIgnoreCase("local")) continue;
                this.listModel.addElement(index);
            }
            for (BitmapJoinIndexOraclev10g bji : table.getBjIndexes()) {
                if (!bji.getLocalPartitioning().equalsIgnoreCase("YES")) continue;
                this.listModel.addElement(bji);
            }
            for (UniqueOraclev10g unique : table.getUniqueKeys()) {
                if (!unique.getUsingIndex().equalsIgnoreCase("local")) continue;
                this.listModel.addElement(unique);
            }
            for (PKProxyOraclev10g pk : table.getPrimaryKeys()) {
                if (!pk.getUsingIndex().equalsIgnoreCase("local")) continue;
                this.listModel.addElement(pk);
            }
        }
        this.getCommentsList().insert(this.partition.getComment(), 0);
        for (int i = 0; i < this.listModel.size(); ++i) {
            LocalIndexProperties lip;
            StorageObject index;
            if (this.listModel.get(i) instanceof IndexProxyOraclev10g) {
                index = (IndexProxyOraclev10g)this.listModel.get(i);
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, index);
                if (lip != null) continue;
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                lip.setPartition(this.partition);
                lip.setIndex(index);
                continue;
            }
            if (this.listModel.get(i) instanceof BitmapJoinIndexOraclev10g) {
                index = (BitmapJoinIndexOraclev10g)this.listModel.get(i);
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, index);
                if (lip != null) continue;
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                lip.setPartition(this.partition);
                lip.setIndex(index);
                continue;
            }
            if (this.listModel.get(i) instanceof UniqueOraclev10g) {
                index = (UniqueOraclev10g)this.listModel.get(i);
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, index);
                if (lip != null) continue;
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                lip.setPartition(this.partition);
                lip.setIndex(index);
                continue;
            }
            if (!(this.listModel.get(i) instanceof PKProxyOraclev10g)) continue;
            index = (PKProxyOraclev10g)this.listModel.get(i);
            lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, index);
            if (lip != null) continue;
            lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
            lip.setPartition(this.partition);
            lip.setIndex(index);
        }
    }

    @Override
    protected void setProperties() {
        if (this.partition != null) {
            this.partition.setName(this.tfName.getText());
            Object selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOraclev10g) {
                this.partition.setTableSpace((TableSpaceOraclev10g)selected);
            } else {
                this.partition.setTableSpace(null);
            }
            this.partition.setIotOverflowTablespace((TableSpaceOraclev10g)this.cbIOTOverflowTablespace.getSelectedItem());
            this.partition.setComment(this.getCommentsList().getText());
        }
    }

    private void initIndexesTab() {
        JPanel constraintPanel = new JPanel();
        JScrollPane pane = new JScrollPane(this.getList());
        pane.setPreferredSize(new Dimension(390, 60));
        constraintPanel.add((Component)this.getIndexesButtonPanel(), "North");
        constraintPanel.add((Component)pane, "Center");
        this.getPane().addTab(Messages.getString("HashPartitionDialogOracle.LocalIndexes"), constraintPanel);
    }

    private JList getList() {
        this.list = new JList(this.getLocIndexes());
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new IndexesCellRenderer());
        this.list.addMouseListener(new listMouseListener());
        this.list.addListSelectionListener(this);
        return this.list;
    }

    private DefaultListModel getLocIndexes() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    protected JPanel getIndexesButtonPanel() {
        if (this.indexesButtonPanel == null) {
            this.indexesButtonPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.edit = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.edit.setToolTipText(Messages.getString("HashPartitionDialogOracle.Properties"));
            this.edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HashPartitionDialogOraclev10g.this.editSelected();
                }
            });
            this.edit.setEnabled(false);
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.edit);
            toolBar.addSeparator();
            this.indexesButtonPanel.add(toolBar);
            this.indexesButtonPanel.setPreferredSize(new Dimension(390, 30));
        }
        return this.indexesButtonPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.edit.setEnabled(false);
            } else {
                this.edit.setEnabled(true);
            }
        }
    }

    @Override
    protected void addTabs() {
        this.initIndexesTab();
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void editSelected() {
        Object selected = this.list.getSelectedValue();
        LocalIndexPropertyDialogOraclev10g editor = new LocalIndexPropertyDialogOraclev10g(this.partition.getDesign().getAppView(), this.getStorageDesign(), this.partition, (StorageObject)selected);
        editor.show();
    }

    private class listMouseListener
    extends MouseAdapter {
        private listMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                HashPartitionDialogOraclev10g.this.editSelected();
            }
        }
    }

    class IndexesCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public IndexesCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Index) {
                this.setText(((Index)value).getName());
            } else {
                this.setText(value.toString());
            }
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            return this;
        }
    }
}

