/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.UserAndRolePermissionsDialogOracle;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UserPropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private static final long serialVersionUID = 7556452542536120399L;
    private UserOraclev10g user;
    private JComboBox cbAuthentication;
    private JPasswordField tfIdentifier;
    private JComboBox cbTableSpace;
    private JComboBox cbTempTableSpace;
    private JTextField tfTempTSGroup;
    private JTextField tfProfile;
    private JComboBox cbPasswordExpire;
    private JComboBox cbAccountLock;
    private JPanel clusters;
    private DefaultListModel clusterListModel;
    private JList clusterList;
    private JPanel tables;
    private DefaultListModel tableListModel;
    private JList tableList;
    private JPanel indexes;
    private DefaultListModel indexListModel;
    private JList indexList;
    private JPanel snapshots;
    private DefaultListModel snapshotListModel;
    private JList snapshotList;
    private JPanel triggers;
    private DefaultListModel triggerListModel;
    private JList triggerList;
    private JPanel views;
    private DefaultListModel viewListModel;
    private JList viewList;
    private JPanel dimensions;
    private DefaultListModel dimensionListModel;
    private JList dimensionList;
    private JPanel sequences;
    private DefaultListModel seqListModel;
    private JList seqList;
    private JPanel synonyms;
    private DefaultListModel synListModel;
    private JList synList;
    private JPanel procedures;
    private DefaultListModel procListModel;
    private JList procList;
    private JPanel packages;
    private DefaultListModel packagesListModel;
    private JList packagesList;
    private JPanel quotasPanel;
    private JTable quotasTable;
    private List<Quota> quotasList;
    private JTextField quotafilter;
    private List deletedQuotasList = new ArrayList();
    private int qCounter = 0;
    private JPanel functions;
    private DefaultListModel functionsListModel;
    private JList functionsList;
    private JPanel panelRoles;
    private JPanel panelSystemPrivileges;
    private JList allPrivilegesList;
    private DefaultListModel allPrivilegesModel;
    private JButton bnAddPrivileges;
    private JButton bnRemovePrivileges;
    private JList allRolesList;
    private JTable selectedRolesTable;
    private JTable selectedSystemPrivilegesTable;
    private List<Role> selectedRolesList;
    private List<SystemPrivilege> selectedSystemPrivilegesList;
    private DefaultListModel allRolesModel;
    private JButton bnAddRoles;
    private JButton bnRemoveRoles;
    private JTextField tfexternalName;
    private JButton bnPermissions;
    private UserAndRolePermissionsDialogOracle dialog;
    private JComboBox cbSchemaObject;
    private JButton btnSelectAllPrivileges;
    private JButton btnDeselectAllPrivileges;
    private JButton btnSelectAllRoles;
    private JButton btnDeselectAllRoles;
    private TableRowSorter<SelectedSystemPrivilegesModel> spSorter;
    private TableRowSorter<SelectedRolesModel> rSorter;

    public UserPropertyDialogOraclev10g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.user = (UserOraclev10g)object;
        this.setHeight(460);
        this.initCommentsView(370);
        this.setResizable(false);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("UserPropertyDialogOracle.UserProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initAuthentication();
        this.initIdentifier();
        this.initTableSpace();
        this.initTempTableSpace();
        this.initTempTSGroup();
        this.initProfile();
        this.initPasswordExpire();
        this.initAccountLock();
        this.initExternalName();
        this.initSchemaObject();
        if (this.isEditable()) {
            this.initPropagatePropsButton(350);
        }
        this.initPermissionsButton();
    }

    private void initAuthentication() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogOracle.Authentication"));
        this.general.add(label);
        this.cbAuthentication = new JComboBox<String>(UserOracle.getAuthTypes());
        this.setBG(this.cbAuthentication);
        this.cbAuthentication.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAuthentication);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbAuthentication, 50);
    }

    private void initIdentifier() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogOracle.Identifier"));
        this.general.add(label);
        this.tfIdentifier = new JPasswordField("", 26);
        this.general.add(this.tfIdentifier);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfIdentifier, 80);
    }

    private void initTableSpace() {
        JLabel lbTableSpace = new JLabel(Messages.getString("UserPropertyDialogOracle.TableSpace"));
        this.general.add(lbTableSpace);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(lbTableSpace, 110);
        this.setObjectConstraints(this.cbTableSpace, 110);
    }

    private void initTempTableSpace() {
        JLabel lbTableSpace = new JLabel(Messages.getString("UserPropertyDialogOracle.TempTableSpace"));
        this.general.add(lbTableSpace);
        this.cbTempTableSpace = new JComboBox();
        this.setBG(this.cbTempTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTemporaryTablespaceSet().toArray(), this.cbTempTableSpace);
        }
        this.cbTempTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTempTableSpace);
        this.setLabelConstraints(lbTableSpace, 140);
        this.setObjectConstraints(this.cbTempTableSpace, 140);
    }

    private void initTempTSGroup() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogOracle.TempTSGroup"));
        this.general.add(label);
        this.tfTempTSGroup = new JTextField("", 26);
        this.general.add(this.tfTempTSGroup);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.tfTempTSGroup, 170);
    }

    private void initProfile() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogOracle.Profile"));
        this.general.add(label);
        this.tfProfile = new JTextField("", 26);
        this.general.add(this.tfProfile);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.tfProfile, 200);
    }

    private void initPasswordExpire() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogOracle.PasswordExpire"));
        this.general.add(label);
        this.cbPasswordExpire = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPasswordExpire);
        this.cbPasswordExpire.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPasswordExpire);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbPasswordExpire, 230);
    }

    private void initAccountLock() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogOracle.AccountLock"));
        this.general.add(label);
        this.cbAccountLock = new JComboBox<String>(YES_NO);
        this.setBG(this.cbAccountLock);
        this.cbAccountLock.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAccountLock);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbAccountLock, 260);
    }

    private void initExternalName() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogOracle.ExternalName"));
        this.general.add(label);
        this.tfexternalName = new JTextField("", 26);
        this.general.add(this.tfexternalName);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.tfexternalName, 290);
    }

    private void initSchemaObject() {
        JLabel lbImplementsSchema = new JLabel(Messages.getString("UserPropertyDialogOracle.ImplementsSchema"));
        this.general.add(lbImplementsSchema);
        this.cbSchemaObject = new JComboBox();
        this.setBG(this.cbSchemaObject);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getPhysicalDesign().getSchemaObjectSet().toArray(), this.cbSchemaObject);
        }
        this.cbSchemaObject.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSchemaObject);
        this.setLabelConstraints(lbImplementsSchema, 320);
        this.setObjectConstraints(this.cbSchemaObject, 320);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("UserPropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 350);
    }

    @Override
    protected void addTabs() {
        this.initRolesView();
        this.initSystemPrivilegesView();
        this.initClustersView();
        this.initTablesView();
        this.initIndexesView();
        this.initSnapshotsView();
        this.initTriggersView();
        this.initViewsView();
        this.initDimensionsView();
        this.initSequencesView();
        this.initSynonymsView();
        this.initProceduresView();
        this.initFunctionsView();
        this.initPackagesView();
        this.initQuotasView();
    }

    private void initRolesView() {
        this.panelRoles = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Roles"), this.panelRoles);
        this.initRoles();
    }

    private void initRoles() {
        this.initAllRolesList();
        this.initSelectedRolesList();
    }

    private void initSystemPrivilegesView() {
        this.panelSystemPrivileges = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.SystemPrivileges"), this.panelSystemPrivileges);
        this.initPrivileges();
    }

    private void initPrivileges() {
        this.initAllPrivilegesList();
        this.initSelectedPrivilegesList();
    }

    protected SpringLayout getSystemPrivilegesLayout() {
        return (SpringLayout)this.panelSystemPrivileges.getLayout();
    }

    private void initAllPrivilegesList() {
        this.allPrivilegesModel = new DefaultListModel();
        this.allPrivilegesList = new JList(this.allPrivilegesModel);
        ListSelectionModel listSelectionModel = this.allPrivilegesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllPrivilegesListSelectionHandler());
        JPanel jp = new JPanel(new BorderLayout());
        jp.setPreferredSize(new Dimension(425, 190));
        JPanel jpSP = new JPanel(new BorderLayout());
        jpSP.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserPropertyDialogOracle.Available")));
        JScrollPane sp = new JScrollPane(this.allPrivilegesList);
        sp.setPreferredSize(new Dimension(415, 130));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        jpSP.add(sp);
        jp.add((Component)jpSP, "Center");
        this.setObjectConstraints(this.getSystemPrivilegesLayout(), jp, 10, 10);
        this.initPrivilegesButtons(jp);
        this.panelSystemPrivileges.add(jp);
    }

    private void initSelectedPrivilegesList() {
        JPanel jp = new JPanel(new BorderLayout());
        jp.setPreferredSize(new Dimension(425, 193));
        jp.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserPropertyDialogOracle.Selected")));
        JPanel selectButtonsPanel = new JPanel(new SpringLayout());
        selectButtonsPanel.setPreferredSize(new Dimension(425, 25));
        this.btnSelectAllPrivileges = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL"));
        this.btnSelectAllPrivileges.setToolTipText(Messages.getString("UserPropertyDialogOracle.GrantAllPrivilegesAdmin"));
        this.btnSelectAllPrivileges.setEnabled(false);
        this.btnSelectAllPrivileges.setMnemonic(83);
        this.btnSelectAllPrivileges.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSelectAllPrivileges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPropertyDialogOraclev10g.this.checkAllSysPrivs(UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable, UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList, true);
                UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.updateUI();
            }
        });
        this.btnDeselectAllPrivileges = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL"));
        this.btnDeselectAllPrivileges.setToolTipText(Messages.getString("UserPropertyDialogOracle.RevokeAllPrivilegesAdmin"));
        this.btnDeselectAllPrivileges.setEnabled(false);
        this.btnDeselectAllPrivileges.setMnemonic(68);
        this.btnDeselectAllPrivileges.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnDeselectAllPrivileges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPropertyDialogOraclev10g.this.checkAllSysPrivs(UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable, UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList, false);
                UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.updateUI();
            }
        });
        selectButtonsPanel.add(this.btnSelectAllPrivileges);
        selectButtonsPanel.add(this.btnDeselectAllPrivileges);
        CommonUtil.setObjectConstraints((SpringLayout)selectButtonsPanel.getLayout(), this.btnSelectAllPrivileges, 355, 0);
        CommonUtil.setObjectConstraints((SpringLayout)selectButtonsPanel.getLayout(), this.btnDeselectAllPrivileges, 385, 0);
        this.selectedSystemPrivilegesList = new ArrayList<SystemPrivilege>();
        SelectedSystemPrivilegesModel pModel = new SelectedSystemPrivilegesModel();
        this.selectedSystemPrivilegesTable = new JTable(pModel);
        this.spSorter = new TableRowSorter<SelectedSystemPrivilegesModel>(pModel);
        this.spSorter.setSortsOnUpdates(true);
        ColumnAdminRenderer columnAdminRenderer = new ColumnAdminRenderer();
        TableColumn col0 = this.selectedSystemPrivilegesTable.getColumnModel().getColumn(0);
        col0.setWidth(375);
        col0.setMaxWidth(375);
        TableColumn col1 = this.selectedSystemPrivilegesTable.getColumnModel().getColumn(1);
        col1.setWidth(50);
        col1.setMaxWidth(50);
        col1.setCellRenderer(columnAdminRenderer);
        this.selectedSystemPrivilegesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.getSelectedRow() == -1) {
                    UserPropertyDialogOraclev10g.this.bnRemovePrivileges.setEnabled(false);
                } else {
                    UserPropertyDialogOraclev10g.this.bnRemovePrivileges.setEnabled(true);
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.selectedSystemPrivilegesTable);
        sp.setPreferredSize(new Dimension(425, 165));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        jp.add((Component)selectButtonsPanel, "North");
        jp.add((Component)sp, "Center");
        this.panelSystemPrivileges.add(jp);
        this.setObjectConstraints(this.getSystemPrivilegesLayout(), jp, 10, 197);
    }

    private void checkAllSysPrivs(JTable table, List objects, boolean checked) {
        int[] selected = table.getSelectedRows();
        if (selected.length > 0) {
            for (int i = selected.length - 1; i >= 0; --i) {
                SystemPrivilege obj = this.selectedSystemPrivilegesList.get(table.convertRowIndexToModel(selected[i]));
                obj.setAdminOption(checked);
            }
        } else {
            this.selectAll(table, objects, checked);
        }
        table.updateUI();
    }

    private void checkAllRoles(JTable table, List objects, boolean checked) {
        int[] selected = table.getSelectedRows();
        if (selected.length > 0) {
            for (int i = selected.length - 1; i >= 0; --i) {
                Role obj = this.selectedRolesList.get(table.convertRowIndexToModel(selected[i]));
                obj.setAdminOption(checked);
            }
        } else {
            this.selectAll(table, objects, checked);
        }
        table.updateUI();
    }

    private void selectAll(JTable table, List objects, boolean selected) {
        if (selected) {
            this.selectAll(table, objects);
        } else {
            this.deselectAll(table, objects);
        }
    }

    private void selectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                this.setSelected(list.get(index), true);
            }
        } else {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.setSelected(it.next(), true);
            }
        }
    }

    private void deselectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                this.setSelected(list.get(index), false);
            }
        } else {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.setSelected(it.next(), false);
            }
        }
    }

    private void setSelected(Object obj, boolean selected) {
        if (obj != null) {
            if (obj instanceof SystemPrivilege) {
                ((SystemPrivilege)obj).setAdminOption(selected);
            } else if (obj instanceof Role) {
                ((Role)obj).setAdminOption(selected);
            }
        }
    }

    private void initPrivilegesButtons(JPanel jp) {
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        this.bnAddPrivileges = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_DOWN_ICON"));
        this.bnAddPrivileges.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.bnAddPrivileges.addActionListener(new AddPrivilegesActionListener());
        this.bnAddPrivileges.setEnabled(false);
        this.bnRemovePrivileges = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_UP_ICON"));
        this.bnRemovePrivileges.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.bnRemovePrivileges.setEnabled(false);
        this.bnRemovePrivileges.addActionListener(new RemovePrivilegesActionListener());
        buttonsPanel.add(this.bnAddPrivileges);
        buttonsPanel.add(this.bnRemovePrivileges);
        jp.add((Component)buttonsPanel, "South");
    }

    private void initAllRolesList() {
        this.allRolesModel = new DefaultListModel();
        this.allRolesList = new JList(this.allRolesModel);
        ListSelectionModel listSelectionModel = this.allRolesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllRolesListSelectionHandler());
        this.allRolesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserPropertyDialogOraclev10g.this.bnAddRoles.doClick();
                }
            }
        });
        JPanel jp = new JPanel(new BorderLayout());
        jp.setPreferredSize(new Dimension(425, 190));
        JPanel jpSP = new JPanel(new BorderLayout());
        jpSP.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserPropertyDialogOracle.Available")));
        JScrollPane sp = new JScrollPane(this.allRolesList);
        sp.setPreferredSize(new Dimension(415, 130));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        jpSP.add(sp);
        jp.add((Component)jpSP, "Center");
        this.setObjectConstraints(this.getRolesLayout(), jp, 10, 10);
        this.initRolesButtons(jp);
        this.panelRoles.add(jp);
    }

    private void initSelectedRolesList() {
        JPanel jp = new JPanel(new BorderLayout());
        jp.setPreferredSize(new Dimension(425, 193));
        jp.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserPropertyDialogOracle.Selected")));
        JPanel selectButtonsPanel = new JPanel(new SpringLayout());
        selectButtonsPanel.setPreferredSize(new Dimension(425, 25));
        this.btnSelectAllRoles = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL"));
        this.btnSelectAllRoles.setToolTipText(Messages.getString("UserPropertyDialogOracle.GrantAllRolesAdmin"));
        this.btnSelectAllRoles.setEnabled(false);
        this.btnSelectAllRoles.setMnemonic(83);
        this.btnSelectAllRoles.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSelectAllRoles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPropertyDialogOraclev10g.this.checkAllRoles(UserPropertyDialogOraclev10g.this.selectedRolesTable, UserPropertyDialogOraclev10g.this.selectedRolesList, true);
                UserPropertyDialogOraclev10g.this.selectedRolesTable.updateUI();
            }
        });
        this.btnDeselectAllRoles = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL"));
        this.btnDeselectAllRoles.setToolTipText(Messages.getString("UserPropertyDialogOracle.RevokeAllRolesAdmin"));
        this.btnDeselectAllRoles.setEnabled(false);
        this.btnDeselectAllRoles.setMnemonic(68);
        this.btnDeselectAllRoles.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnDeselectAllRoles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPropertyDialogOraclev10g.this.checkAllRoles(UserPropertyDialogOraclev10g.this.selectedRolesTable, UserPropertyDialogOraclev10g.this.selectedRolesList, false);
                UserPropertyDialogOraclev10g.this.selectedRolesTable.updateUI();
            }
        });
        selectButtonsPanel.add(this.btnSelectAllRoles);
        selectButtonsPanel.add(this.btnDeselectAllRoles);
        CommonUtil.setObjectConstraints((SpringLayout)selectButtonsPanel.getLayout(), this.btnSelectAllRoles, 355, 0);
        CommonUtil.setObjectConstraints((SpringLayout)selectButtonsPanel.getLayout(), this.btnDeselectAllRoles, 385, 0);
        this.selectedRolesList = new ArrayList<Role>();
        SelectedRolesModel rModel = new SelectedRolesModel();
        this.selectedRolesTable = new JTable(rModel);
        this.rSorter = new TableRowSorter<SelectedRolesModel>(rModel);
        this.rSorter.setSortsOnUpdates(true);
        ColumnAdminRenderer columnAdminRenderer = new ColumnAdminRenderer();
        TableColumn col0 = this.selectedRolesTable.getColumnModel().getColumn(0);
        col0.setWidth(375);
        col0.setMaxWidth(375);
        TableColumn col1 = this.selectedRolesTable.getColumnModel().getColumn(1);
        col1.setWidth(50);
        col1.setMaxWidth(50);
        col1.setCellRenderer(columnAdminRenderer);
        this.selectedRolesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserPropertyDialogOraclev10g.this.selectedRolesTable.getSelectedRow() == -1) {
                    UserPropertyDialogOraclev10g.this.bnRemoveRoles.setEnabled(false);
                } else {
                    UserPropertyDialogOraclev10g.this.bnRemoveRoles.setEnabled(true);
                }
            }
        });
        this.selectedRolesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserPropertyDialogOraclev10g.this.bnRemoveRoles.doClick();
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.selectedRolesTable);
        sp.setPreferredSize(new Dimension(425, 165));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        jp.add((Component)selectButtonsPanel, "North");
        jp.add((Component)sp, "Center");
        this.panelRoles.add(jp);
        this.setObjectConstraints(this.getRolesLayout(), jp, 10, 197);
    }

    private void initRolesButtons(JPanel jp) {
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        this.bnAddRoles = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_DOWN_ICON"));
        this.bnAddRoles.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.bnAddRoles.addActionListener(new AddRolesActionListener());
        this.bnAddRoles.setEnabled(false);
        this.bnRemoveRoles = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_UP_ICON"));
        this.bnRemoveRoles.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.bnRemoveRoles.setEnabled(false);
        this.bnRemoveRoles.addActionListener(new RemoveRolesActionListener());
        buttonsPanel.add(this.bnAddRoles);
        buttonsPanel.add(this.bnRemoveRoles);
        jp.add((Component)buttonsPanel, "South");
    }

    protected SpringLayout getRolesLayout() {
        return (SpringLayout)this.panelRoles.getLayout();
    }

    private void initClustersView() {
        this.clusters = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Clusters"), this.clusters);
        this.initClusters();
    }

    private void initClusters() {
        this.clusterListModel = new DefaultListModel();
        this.clusterList = new JList(this.clusterListModel);
        this.clusterList.addMouseListener(new ClusterListMouseListener());
        JScrollPane spTS = new JScrollPane(this.clusterList);
        spTS.setPreferredSize(new Dimension(425, 370));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusters.add(spTS);
        this.setObjectConstraints(this.getClusterLayout(), spTS, 10, 12);
    }

    protected SpringLayout getClusterLayout() {
        return (SpringLayout)this.clusters.getLayout();
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tableListModel = new DefaultListModel();
        this.tableList = new JList(this.tableListModel);
        this.tableList.addMouseListener(new TableListMouseListener());
        JScrollPane spTS = new JScrollPane(this.tableList);
        spTS.setPreferredSize(new Dimension(425, 370));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(spTS);
        this.setObjectConstraints(this.getTableLayout(), spTS, 10, 12);
    }

    protected SpringLayout getTableLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        this.indexListModel = new DefaultListModel();
        this.indexList = new JList(this.indexListModel);
        this.indexList.addMouseListener(new IndexListMouseListener());
        JScrollPane spTS = new JScrollPane(this.indexList);
        spTS.setPreferredSize(new Dimension(425, 370));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(spTS);
        this.setObjectConstraints(this.getIndexLayout(), spTS, 10, 12);
    }

    protected SpringLayout getIndexLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    private void initSnapshotsView() {
        this.snapshots = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Snapshots"), this.snapshots);
        this.initSnapshots();
    }

    private void initSnapshots() {
        this.snapshotListModel = new DefaultListModel();
        this.snapshotList = new JList(this.snapshotListModel);
        this.snapshotList.addMouseListener(new SnapshotListMouseListener());
        JScrollPane spTS = new JScrollPane(this.snapshotList);
        spTS.setPreferredSize(new Dimension(425, 370));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.snapshots.add(spTS);
        this.setObjectConstraints(this.getSnapshotLayout(), spTS, 10, 12);
    }

    protected SpringLayout getSnapshotLayout() {
        return (SpringLayout)this.snapshots.getLayout();
    }

    private void initTriggersView() {
        this.triggers = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Triggers"), this.triggers);
        this.initTriggers();
    }

    private void initTriggers() {
        this.triggerListModel = new DefaultListModel();
        this.triggerList = new JList(this.triggerListModel);
        this.triggerList.addMouseListener(new TriggerListMouseListener());
        JScrollPane spTS = new JScrollPane(this.triggerList);
        spTS.setPreferredSize(new Dimension(425, 370));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.triggers.add(spTS);
        this.setObjectConstraints(this.getTriggerLayout(), spTS, 10, 12);
    }

    protected SpringLayout getTriggerLayout() {
        return (SpringLayout)this.triggers.getLayout();
    }

    private void initViewsView() {
        this.views = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Views"), this.views);
        this.initViews();
    }

    private void initViews() {
        this.viewListModel = new DefaultListModel();
        this.viewList = new JList(this.viewListModel);
        this.viewList.addMouseListener(new ViewListMouseListener());
        JScrollPane spTS = new JScrollPane(this.viewList);
        spTS.setPreferredSize(new Dimension(425, 370));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.views.add(spTS);
        this.setObjectConstraints(this.getViewLayout(), spTS, 10, 12);
    }

    protected SpringLayout getViewLayout() {
        return (SpringLayout)this.views.getLayout();
    }

    private void initDimensionsView() {
        this.dimensions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Dimensions"), this.dimensions);
        this.initDimensions();
    }

    private void initDimensions() {
        this.dimensionListModel = new DefaultListModel();
        this.dimensionList = new JList(this.dimensionListModel);
        this.dimensionList.addMouseListener(new DimensionListMouseListener());
        JScrollPane spTS = new JScrollPane(this.dimensionList);
        spTS.setPreferredSize(new Dimension(425, 370));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.dimensions.add(spTS);
        this.setObjectConstraints(this.getDimensionLayout(), spTS, 10, 12);
    }

    protected SpringLayout getDimensionLayout() {
        return (SpringLayout)this.dimensions.getLayout();
    }

    private void initSequencesView() {
        this.sequences = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Sequences"), this.sequences);
        this.initSequences();
    }

    private void initSequences() {
        this.seqListModel = new DefaultListModel();
        this.seqList = new JList(this.seqListModel);
        this.seqList.addMouseListener(new SequencesListMouseListener());
        JScrollPane spTS = new JScrollPane(this.seqList);
        spTS.setPreferredSize(new Dimension(425, 370));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.sequences.add(spTS);
        this.setObjectConstraints(this.getSequencesLayout(), spTS, 10, 12);
    }

    protected SpringLayout getSequencesLayout() {
        return (SpringLayout)this.sequences.getLayout();
    }

    private void initSynonymsView() {
        this.synonyms = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Synonyms"), this.synonyms);
        this.initSynonyms();
    }

    private void initSynonyms() {
        this.synListModel = new DefaultListModel();
        this.synList = new JList(this.synListModel);
        this.synList.addMouseListener(new SynonymsListMouseListener());
        JScrollPane spTS = new JScrollPane(this.synList);
        spTS.setPreferredSize(new Dimension(425, 370));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.synonyms.add(spTS);
        this.setObjectConstraints(this.getSynonymsLayout(), spTS, 10, 12);
    }

    protected SpringLayout getSynonymsLayout() {
        return (SpringLayout)this.synonyms.getLayout();
    }

    private void initProceduresView() {
        this.procedures = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Procedures"), this.procedures);
        this.initProcedures();
    }

    private void initPackagesView() {
        this.packages = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Packages"), this.packages);
        this.initPackages();
    }

    private void initQuotasView() {
        this.quotasPanel = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOraclev10g.Quotas"), this.quotasPanel);
        this.initQuotas();
    }

    private void initFunctionsView() {
        this.functions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogOracle.Functions"), this.functions);
        this.initFunctions();
    }

    private void initProcedures() {
        this.procListModel = new DefaultListModel();
        this.procList = new JList(this.procListModel);
        this.procList.addMouseListener(new ProceduresListMouseListener());
        JScrollPane spTS = new JScrollPane(this.procList);
        spTS.setPreferredSize(new Dimension(425, 370));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.procedures.add(spTS);
        this.setObjectConstraints(this.getProceduresLayout(), spTS, 10, 12);
    }

    private void initPackages() {
        this.packagesListModel = new DefaultListModel();
        this.packagesList = new JList(this.packagesListModel);
        this.packagesList.addMouseListener(new PackagesListMouseListener());
        JScrollPane spTS = new JScrollPane(this.packagesList);
        spTS.setPreferredSize(new Dimension(425, 370));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.packages.add(spTS);
        this.setObjectConstraints(this.getPackagesLayout(), spTS, 10, 12);
    }

    private void initQuotas() {
        JButton btnAddQuota = new JButton(GUIConfiguration.getInstance().getIcon("ADD_ICON", 16));
        btnAddQuota.setToolTipText(Messages.getString("UserPropertyDialogOraclev10g.Add"));
        final JButton btnRemoveQuota = new JButton(GUIConfiguration.getInstance().getIcon("DELETE_ICON", 16));
        btnRemoveQuota.setToolTipText(Messages.getString("UserPropertyDialogOraclev10g.Delete"));
        btnRemoveQuota.setEnabled(false);
        btnAddQuota.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Quota q = new Quota();
                if (UserPropertyDialogOraclev10g.this.quotasTable.getRowSorter() != null && UserPropertyDialogOraclev10g.this.quotasList.size() >= 1) {
                    UserPropertyDialogOraclev10g.this.quotasTable.getRowSorter().setSortKeys(null);
                }
                UserPropertyDialogOraclev10g.this.quotasList.add(q);
                UserPropertyDialogOraclev10g.this.quotasTable.updateUI();
                UserPropertyDialogOraclev10g.this.quotasTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(UserPropertyDialogOraclev10g.this.quotasTable, 0);
                int lastRow = UserPropertyDialogOraclev10g.this.quotasTable.convertRowIndexToView(UserPropertyDialogOraclev10g.this.quotasTable.getModel().getRowCount() - 1);
                UserPropertyDialogOraclev10g.this.quotasTable.setRowSelectionInterval(lastRow, lastRow);
                UserPropertyDialogOraclev10g.this.quotafilter.setEnabled(true);
            }
        });
        btnRemoveQuota.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(UserPropertyDialogOraclev10g.this, Messages.getString("UserPropertyDialogOraclev10g.AreYouSure"), Messages.getString("UserPropertyDialogOraclev10g.DeleteConfirmation"), 0);
                if (result == 0) {
                    int icol = UserPropertyDialogOraclev10g.this.quotasTable.getEditingColumn();
                    int irow = UserPropertyDialogOraclev10g.this.quotasTable.getEditingRow();
                    if (icol > -1 && irow > -1) {
                        UserPropertyDialogOraclev10g.this.quotasTable.getCellEditor(irow, icol).stopCellEditing();
                    }
                    if (UserPropertyDialogOraclev10g.this.quotasTable.getRowSorter() != null) {
                        if (UserPropertyDialogOraclev10g.this.quotasList.size() >= 1) {
                            UserPropertyDialogOraclev10g.this.quotasTable.getRowSorter().setSortKeys(null);
                        } else {
                            UserPropertyDialogOraclev10g.this.quotasTable.setAutoCreateRowSorter(false);
                            UserPropertyDialogOraclev10g.this.quotasTable.setRowSorter(null);
                        }
                    }
                    UserPropertyDialogOraclev10g.this.deletedQuotasList.clear();
                    int[] selected = UserPropertyDialogOraclev10g.this.quotasTable.getSelectedRows();
                    for (int i = 0; i < selected.length; ++i) {
                        UserPropertyDialogOraclev10g.this.deletedQuotasList.add(UserPropertyDialogOraclev10g.this.quotasList.get(selected[i]));
                    }
                    UserPropertyDialogOraclev10g.this.quotasList.removeAll(UserPropertyDialogOraclev10g.this.deletedQuotasList);
                    UserPropertyDialogOraclev10g.this.quotasTable.updateUI();
                    UserPropertyDialogOraclev10g.this.quotasTable.clearSelection();
                }
            }
        });
        JLabel filterLabel = new JLabel(Messages.getString("UserPropertyDialogOraclev10g.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.quotafilter = new JTextField();
        this.quotafilter.setPreferredSize(new Dimension(200, 20));
        this.quotafilter.setMinimumSize(new Dimension(200, 20));
        this.quotafilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(btnAddQuota);
        toolBar.add(btnRemoveQuota);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.quotafilter);
        this.quotasList = new ArrayList<Quota>();
        QuotasModel model = new QuotasModel();
        this.quotasTable = new JTable(model);
        this.quotasTable.getTableHeader().setReorderingAllowed(false);
        DefaultCellEditor singleclick = new DefaultCellEditor(new JTextField());
        singleclick.setClickCountToStart(1);
        TableColumn col0 = this.quotasTable.getColumnModel().getColumn(0);
        col0.setCellEditor(new QuotaTablespaceCellEditor());
        this.quotasTable.getColumnModel().getColumn(1).setCellEditor(singleclick);
        this.quotasTable.getColumnModel().getColumn(2).setCellEditor(singleclick);
        this.quotasTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selRow = UserPropertyDialogOraclev10g.this.quotasTable.getSelectedRow();
                if (selRow == -1) {
                    btnRemoveQuota.setEnabled(false);
                } else {
                    btnRemoveQuota.setEnabled(true);
                }
            }
        });
        this.quotafilter.getDocument().addDocumentListener(new FilterObjectListener(this.quotafilter, this.quotasTable, 0));
        JScrollPane sp = new JScrollPane(this.quotasTable);
        sp.setPreferredSize(new Dimension(425, 165));
        this.quotasPanel.add((Component)toolBar, "North");
        this.quotasPanel.add((Component)sp, "Center");
    }

    private void initFunctions() {
        this.functionsListModel = new DefaultListModel();
        this.functionsList = new JList(this.functionsListModel);
        this.functionsList.addMouseListener(new FunctionsListMouseListener());
        JScrollPane spTS = new JScrollPane(this.functionsList);
        spTS.setPreferredSize(new Dimension(425, 370));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.functions.add(spTS);
        this.setObjectConstraints(this.getFunctionsLayout(), spTS, 10, 12);
    }

    protected SpringLayout getProceduresLayout() {
        return (SpringLayout)this.procedures.getLayout();
    }

    protected SpringLayout getPackagesLayout() {
        return (SpringLayout)this.packages.getLayout();
    }

    protected SpringLayout getFunctionsLayout() {
        return (SpringLayout)this.functions.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.user.getName());
        this.tfName.setText(this.user.getName());
        this.cbAuthentication.setSelectedItem(this.user.getAuthType());
        this.tfIdentifier.setText(this.user.decodeIdentifier());
        this.selectObject(this.cbTableSpace, this.user.getDefTableSpace());
        this.selectObject(this.cbTempTableSpace, this.user.getTempTableSpace());
        this.tfTempTSGroup.setText(this.user.getTempTSGroupName());
        this.tfProfile.setText(this.user.getProfile());
        this.cbPasswordExpire.setSelectedItem(UserPropertyDialogOraclev10g.translateYesNoForDisplay(this.user.getPasswordExpire()));
        this.cbAccountLock.setSelectedItem(UserPropertyDialogOraclev10g.translateYesNoForDisplay(this.user.getAccountLock()));
        this.tfexternalName.setText(this.user.getExternalName());
        Object[] allRolesSet = this.getStorageDesign().getRoleSet().toArray();
        for (int i = 0; i < allRolesSet.length; ++i) {
            StringTokenizer st = new StringTokenizer(this.user.getRoles(), ",");
            StringTokenizer st1 = new StringTokenizer(this.user.getRolesWithAdminOption(), ",");
            Role roleOracle = new Role(allRolesSet[i]);
            roleOracle.setObjectID(((RoleOracle)allRolesSet[i]).getObjectID());
            boolean treated = false;
            while (st.hasMoreTokens()) {
                String item = st.nextToken().trim();
                if (!roleOracle.getObjectID().equalsIgnoreCase(item)) continue;
                this.selectedRolesList.add(roleOracle);
                treated = true;
                break;
            }
            while (st1.hasMoreTokens()) {
                String item1 = st1.nextToken().trim();
                if (!roleOracle.getObjectID().equalsIgnoreCase(item1)) continue;
                roleOracle.setAdminOption(true);
                this.selectedRolesList.add(roleOracle);
                treated = true;
                break;
            }
            if (treated) continue;
            this.allRolesModel.addElement(roleOracle.getObject());
        }
        this.sort(this.allRolesModel);
        if (this.allRolesModel.getSize() > 0) {
            this.allRolesList.getSelectionModel().setSelectionInterval(0, 0);
        } else if (this.selectedRolesList.size() > 0) {
            this.selectedRolesTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (this.selectedRolesList.size() > 0) {
            this.selectedRolesTable.setRowSorter(this.rSorter);
            this.selectedRolesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.selectedRolesTable, 0);
            this.btnSelectAllRoles.setEnabled(true);
            this.btnDeselectAllRoles.setEnabled(true);
        }
        String[] allPrivilegesSet = this.user.getPrivilegeValues();
        for (int i = 0; i < allPrivilegesSet.length; ++i) {
            StringTokenizer st = new StringTokenizer(this.user.getPrivileges(), ",");
            StringTokenizer st1 = new StringTokenizer(this.user.getPrivilegesWithAdminOption(), ",");
            String privilege = allPrivilegesSet[i].trim();
            SystemPrivilege p = null;
            boolean treated = false;
            while (st.hasMoreTokens()) {
                String item = st.nextToken().trim();
                if (!privilege.equalsIgnoreCase(item)) continue;
                p = new SystemPrivilege(item.trim());
                p.setName(item);
                this.selectedSystemPrivilegesList.add(p);
                treated = true;
                break;
            }
            while (st1.hasMoreTokens()) {
                String item1 = st1.nextToken().trim();
                if (!privilege.equalsIgnoreCase(item1)) continue;
                p = new SystemPrivilege(item1.trim());
                p.setName(item1);
                p.setAdminOption(true);
                this.selectedSystemPrivilegesList.add(p);
                treated = true;
                break;
            }
            if (treated) continue;
            this.allPrivilegesModel.addElement(privilege);
        }
        this.sort(this.allPrivilegesModel);
        if (this.allPrivilegesModel.getSize() > 0) {
            this.allPrivilegesList.getSelectionModel().setSelectionInterval(0, 0);
        } else if (this.selectedSystemPrivilegesList.size() > 0) {
            this.selectedSystemPrivilegesTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (this.selectedSystemPrivilegesList.size() > 0) {
            this.selectedSystemPrivilegesTable.setRowSorter(this.spSorter);
            this.selectedSystemPrivilegesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.selectedSystemPrivilegesTable, 0);
            this.btnSelectAllPrivileges.setEnabled(true);
            this.btnDeselectAllPrivileges.setEnabled(true);
        }
        Object[] cluster = this.getStorageDesign().getClusterSet().toArray();
        for (int i = 0; i < cluster.length; ++i) {
            if (((ClusterOracle)cluster[i]).getUser() != this.user) continue;
            this.clusterListModel.addElement(cluster[i]);
        }
        Iterator it = this.getStorageDesign().getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyOracle tp = (TableProxyOracle)it.next();
            if (tp.getUser() != this.user) continue;
            this.tableListModel.addElement(tp);
        }
        Object[] index = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i = 0; i < index.length; ++i) {
            if (((IndexProxyOracle)index[i]).getUser() != this.user) continue;
            this.indexListModel.addElement(index[i]);
        }
        Object[] snapshot = this.getStorageDesign().getSnapshotSet().toArray();
        for (int i = 0; i < snapshot.length; ++i) {
            if (((SnapshotOracle)snapshot[i]).getUser() != this.user) continue;
            this.snapshotListModel.addElement(snapshot[i]);
        }
        Object[] tr = this.getStorageDesign().getTriggerSet().toArray();
        for (int i = 0; i < tr.length; ++i) {
            if (((TriggerOracle)tr[i]).getOwner() != this.user) continue;
            this.triggerListModel.addElement(tr[i]);
        }
        Object[] view = this.getStorageDesign().getTableViewProxySet().toArray();
        for (int i = 0; i < view.length; ++i) {
            if (((TableViewProxyOracle)view[i]).getUser() != this.user) continue;
            this.viewListModel.addElement(view[i]);
        }
        Object[] dim = this.getStorageDesign().getDimensionSet().toArray();
        for (int i = 0; i < dim.length; ++i) {
            if (((DimensionOracle)dim[i]).getUser() != this.user) continue;
            this.dimensionListModel.addElement(dim[i]);
        }
        Object[] seq = this.getStorageDesign().getSequenceSet().toArray();
        for (int i = 0; i < seq.length; ++i) {
            if (((SequenceOracle)seq[i]).getUser() != this.user) continue;
            this.seqListModel.addElement(seq[i]);
        }
        Object[] syn = this.getStorageDesign().getSynonymSet().toArray();
        for (int i = 0; i < syn.length; ++i) {
            if (((SynonymOracle)syn[i]).getUser() != this.user) continue;
            this.synListModel.addElement(syn[i]);
        }
        Object[] proc = this.getStorageDesign().getStoredProcedureSet().toArray();
        for (int i = 0; i < proc.length; ++i) {
            if (((StoredProcedureOracle)proc[i]).getOwner() != this.user) continue;
            this.procListModel.addElement(proc[i]);
        }
        Object[] functions = this.getStorageDesign().getFunctionSet().toArray();
        for (int i = 0; i < functions.length; ++i) {
            if (((FunctionOracle)functions[i]).getOwner() != this.user) continue;
            this.functionsListModel.addElement(functions[i]);
        }
        Object[] packages = this.getStorageDesign().getPackageSet().toArray();
        for (int i = 0; i < packages.length; ++i) {
            if (((PackageOracle)packages[i]).getOwner() != this.user) continue;
            this.packagesListModel.addElement(packages[i]);
        }
        Object[] quotas = this.getStorageDesign().getQuotaItemSet().toArray();
        for (int i = 0; i < quotas.length; ++i) {
            if (((QuotaItemOracle)quotas[i]).getUser() != this.user) continue;
            QuotaItemOracle q = (QuotaItemOracle)quotas[i];
            Quota newQI = new Quota();
            newQI.setObjectID(q.getObjectID());
            newQI.setName(q.getName());
            newQI.setTableSpace(q.getTableSpace());
            newQI.setSize(q.getSize());
            newQI.setComment(q.getComment());
            this.quotasList.add(newQI);
        }
        if (this.quotasList.size() > 0) {
            this.quotasTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.quotasTable, 0);
        }
        this.getCommentsList().insert(this.user.getComment(), 0);
        this.cbSchemaObject.setSelectedItem(this.user.getSchemaObject());
    }

    @Override
    protected void setProperties() {
        if (this.user != null) {
            QuotaItemOracle q;
            int i;
            this.user.clear();
            this.user.setSchemaObject((SchemaObject)this.cbSchemaObject.getSelectedItem());
            this.user.setName(this.tfName.getText());
            this.user.setAuthType((String)this.cbAuthentication.getSelectedItem());
            this.user.encodeIdentifier(String.valueOf(this.tfIdentifier.getPassword()));
            Object selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOraclev10g) {
                this.user.setDefTableSpace((TableSpaceOraclev10g)selected);
            } else {
                this.user.setDefTableSpace(null);
            }
            selected = this.cbTempTableSpace.getSelectedItem();
            if (selected instanceof TemporaryTablespaceOraclev10g) {
                this.user.setTempTableSpace((TemporaryTablespaceOraclev10g)selected);
            } else {
                this.user.setTempTableSpace(null);
            }
            this.user.setTempTSGroupName(this.tfTempTSGroup.getText());
            this.user.setProfile(this.tfProfile.getText());
            this.user.setPasswordExpire(UserPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbPasswordExpire.getSelectedItem()));
            this.user.setAccountLock(UserPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbAccountLock.getSelectedItem()));
            this.user.setExternalName(this.tfexternalName.getText());
            Object[] roleSet = this.selectedRolesList.toArray();
            for (int i2 = 0; i2 < roleSet.length; ++i2) {
                Role ro = (Role)roleSet[i2];
                boolean admin = ro.getAdminOption();
                if (admin) {
                    this.user.setRolesWithAdminOption(ro.getObjectID());
                    continue;
                }
                this.user.setRoles(ro.getObjectID());
            }
            Object[] privSet = this.selectedSystemPrivilegesList.toArray();
            for (int i3 = 0; i3 < privSet.length; ++i3) {
                Object pr = privSet[i3];
                if (!(pr instanceof SystemPrivilege)) continue;
                SystemPrivilege sp = (SystemPrivilege)pr;
                if (sp.getAdminOption()) {
                    this.user.setPrivilegesWithAdminOption(sp.getObject().toString());
                    continue;
                }
                this.user.setPrivileges(sp.getObject().toString());
            }
            int icol = this.quotasTable.getEditingColumn();
            int irow = this.quotasTable.getEditingRow();
            if (icol > -1 && irow > -1) {
                this.quotasTable.getCellEditor(irow, icol).stopCellEditing();
            }
            Object[] sdQuotas = this.getStorageDesign().getQuotaItemSet().toArray();
            for (Quota quota : this.quotasList) {
                boolean quotaIsFound = false;
                for (i = 0; i < sdQuotas.length; ++i) {
                    q = (QuotaItemOracle)sdQuotas[i];
                    if (!quota.getObjectID().equals(q.getObjectID())) continue;
                    q.setName(quota.getName());
                    q.setTableSpace(quota.getTableSpace());
                    q.setSize(quota.getSize());
                    q.setComment(quota.getComment());
                    quotaIsFound = true;
                    break;
                }
                if (quotaIsFound) continue;
                QuotaItemOracle newQuota = this.getStorageDesign().getQuotaItemSet().createQuotaItem();
                newQuota.setUser(this.user);
                newQuota.setName(quota.getName());
                newQuota.setTableSpace(quota.getTableSpace());
                newQuota.setSize(quota.getSize());
                newQuota.setComment(quota.getComment());
            }
            for (Quota quota : this.deletedQuotasList) {
                for (i = 0; i < sdQuotas.length; ++i) {
                    q = (QuotaItemOracle)sdQuotas[i];
                    if (!quota.getObjectID().equals(q.getObjectID())) continue;
                    q.remove();
                }
            }
            this.user.setComment(this.getCommentsList().getText());
        }
    }

    public DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                if (list.get(i).toString().compareTo(list.get(i - 1).toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private void initPropagatePropsButton(int yCoord) {
        JButton bnPropagateProps = new JButton(Messages.getString("TablePropertyDialogOracle.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                UserPropertyDialogOraclev10g.this.getStorageDesign().getUserSet().addAllElementsTo(list);
                list.remove(UserPropertyDialogOraclev10g.this.user);
                new PropertiesPropagationDialog(UserPropertyDialogOraclev10g.this.getAppView(), UserPropertyDialogOraclev10g.this.user, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, yCoord);
    }

    private void newFilter(JTextField filterText, JTable currentTable, int column) {
        RowFilter rf = null;
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), new int[0]);
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    private class Quota {
        private final String TYPE_NAME = "QuotaItem";
        private String objectID = "";
        private String name = this.generateName();
        private TableSpaceOracle tableSpace;
        private String size = "UNLIMITED";
        private String comment = "";

        Quota() {
        }

        public String getObjectID() {
            return this.objectID;
        }

        public void setObjectID(String objectID) {
            this.objectID = objectID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public TableSpaceOracle getTableSpace() {
            return this.tableSpace;
        }

        public void setTableSpace(TableSpaceOracle tableSpace) {
            this.tableSpace = tableSpace;
        }

        public String getSize() {
            return this.size;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        protected String generateName() {
            String name = "QuotaItem";
            int newNumber = 0;
            int lastNumber = UserPropertyDialogOraclev10g.this.quotasList.size();
            if (lastNumber != 0) {
                newNumber = UserPropertyDialogOraclev10g.this.qCounter = lastNumber + 1;
            } else {
                ++UserPropertyDialogOraclev10g.this.qCounter;
                newNumber = UserPropertyDialogOraclev10g.this.qCounter;
            }
            String qName = name.concat("_").concat(Integer.toString(newNumber));
            while (this.nameExists(qName)) {
                newNumber = ++UserPropertyDialogOraclev10g.this.qCounter;
                qName = name.concat("_").concat(Integer.toString(newNumber));
            }
            return qName;
        }

        private boolean nameExists(String name) {
            for (int i = 0; i < UserPropertyDialogOraclev10g.this.quotasList.size(); ++i) {
                Quota q = UserPropertyDialogOraclev10g.this.quotasList.get(i);
                if (!name.equalsIgnoreCase(q.getName())) continue;
                return true;
            }
            return false;
        }
    }

    public class QuotaTablespaceCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TableCellEditor editor;

        @Override
        public Object getCellEditorValue() {
            if (this.editor != null) {
                return this.editor.getCellEditorValue();
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox<Object> cb = new JComboBox<Object>(UserPropertyDialogOraclev10g.this.getStorageDesign().getTableSpaceSet().toArray());
            this.editor = new DefaultCellEditor(cb);
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private class FilterObjectListener
    implements DocumentListener {
        JTextField objectsFilter;
        JTable objectsTable;
        int column;

        FilterObjectListener(JTextField objectsFilter, JTable objectsTable, int column) {
            this.objectsFilter = objectsFilter;
            this.objectsTable = objectsTable;
            this.column = column;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            UserPropertyDialogOraclev10g.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            UserPropertyDialogOraclev10g.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            UserPropertyDialogOraclev10g.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }
    }

    public class ColumnAdminRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -215127161678321822L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            boolean val = (Boolean)value;
            this.setOpaque(false);
            this.setEnabled(true);
            this.setSelected(val);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private class SelectedRolesModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 3109094884784088828L;
        final String[] COL_NAMES = new String[]{Messages.getString("UserPropertyDialogOraclev10g.Role"), Messages.getString("UserPropertyDialogOraclev10g.Admin")};

        private SelectedRolesModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return UserPropertyDialogOraclev10g.this.selectedRolesList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Role ro = UserPropertyDialogOraclev10g.this.selectedRolesList.get(row);
            if (value instanceof Boolean && col == 1) {
                ro.setAdminOption((Boolean)value);
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            Role ro = UserPropertyDialogOraclev10g.this.selectedRolesList.get(row);
            if (col == 0) {
                return ro.getObject();
            }
            if (col == 1) {
                return ro.getAdminOption();
            }
            return "";
        }
    }

    private class QuotasModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("UserPropertyDialogOraclev10g.Tablespace"), Messages.getString("UserPropertyDialogOraclev10g.Size"), Messages.getString("UserPropertyDialogOraclev10g.Comments")};

        private QuotasModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public int getRowCount() {
            return UserPropertyDialogOraclev10g.this.quotasList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Quota q = UserPropertyDialogOraclev10g.this.quotasList.get(rowIndex);
            if (columnIndex == 0) {
                q.setTableSpace((TableSpaceOracle)aValue);
            } else if (columnIndex == 1) {
                q.setSize((String)aValue);
            } else if (columnIndex == 2) {
                q.setComment((String)aValue);
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Quota q = UserPropertyDialogOraclev10g.this.quotasList.get(rowIndex);
            if (columnIndex == 0) {
                return q.getTableSpace() != null ? q.getTableSpace() : "";
            }
            if (columnIndex == 1) {
                return q.getSize();
            }
            if (columnIndex == 2) {
                return q.getComment();
            }
            return "";
        }
    }

    private class SelectedSystemPrivilegesModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4043791265287763172L;
        final String[] COL_NAMES = new String[]{Messages.getString("UserPropertyDialogOraclev10g.Privilege"), Messages.getString("UserPropertyDialogOraclev10g.Admin")};

        private SelectedSystemPrivilegesModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            SystemPrivilege sp = UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.get(row);
            if (value instanceof Boolean && col == 1) {
                sp.setAdminOption((Boolean)value);
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            SystemPrivilege sp = UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.get(row);
            if (col == 0) {
                return sp.getObject();
            }
            if (col == 1) {
                return sp.getAdminOption();
            }
            return "";
        }
    }

    class Role {
        Object obj = null;
        String name = "";
        String objectID = "";
        boolean adminOption = false;

        Role(Object object) {
            this.obj = object;
        }

        Object getObject() {
            return this.obj;
        }

        void setName(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        void setObjectID(String objectID) {
            this.objectID = objectID;
        }

        String getObjectID() {
            return this.objectID;
        }

        void setAdminOption(boolean adminOption) {
            this.adminOption = adminOption;
        }

        boolean getAdminOption() {
            return this.adminOption;
        }
    }

    class SystemPrivilege {
        Object obj = null;
        String name = "";
        boolean adminOption = false;

        SystemPrivilege(Object object) {
            this.obj = object;
        }

        Object getObject() {
            return this.obj;
        }

        void setName(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        void setAdminOption(boolean adminOption) {
            this.adminOption = adminOption;
        }

        boolean getAdminOption() {
            return this.adminOption;
        }
    }

    private class FunctionsListMouseListener
    extends MouseAdapter {
        private FunctionsListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            FunctionOracle selected;
            if (e.getClickCount() == 2 && (selected = (FunctionOracle)UserPropertyDialogOraclev10g.this.functionsList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class PackagesListMouseListener
    extends MouseAdapter {
        private PackagesListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PackageOracle selected;
            if (e.getClickCount() == 2 && (selected = (PackageOracle)UserPropertyDialogOraclev10g.this.packagesList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class ProceduresListMouseListener
    extends MouseAdapter {
        private ProceduresListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            StoredProcedureOracle selected;
            if (e.getClickCount() == 2 && (selected = (StoredProcedureOracle)UserPropertyDialogOraclev10g.this.procList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class SynonymsListMouseListener
    extends MouseAdapter {
        private SynonymsListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SynonymOracle selected;
            if (e.getClickCount() == 2 && (selected = (SynonymOracle)UserPropertyDialogOraclev10g.this.synList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class SequencesListMouseListener
    extends MouseAdapter {
        private SequencesListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SequenceOracle selected;
            if (e.getClickCount() == 2 && (selected = (SequenceOracle)UserPropertyDialogOraclev10g.this.seqList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class DimensionListMouseListener
    extends MouseAdapter {
        private DimensionListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DimensionOracle selected;
            if (e.getClickCount() == 2 && (selected = (DimensionOracle)UserPropertyDialogOraclev10g.this.dimensionList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class ViewListMouseListener
    extends MouseAdapter {
        private ViewListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableViewProxyOracle selected;
            if (e.getClickCount() == 2 && (selected = (TableViewProxyOracle)UserPropertyDialogOraclev10g.this.viewList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class TriggerListMouseListener
    extends MouseAdapter {
        private TriggerListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TriggerOracle selected;
            if (e.getClickCount() == 2 && (selected = (TriggerOracle)UserPropertyDialogOraclev10g.this.triggerList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class SnapshotListMouseListener
    extends MouseAdapter {
        private SnapshotListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SnapshotOracle selected;
            if (e.getClickCount() == 2 && (selected = (SnapshotOracle)UserPropertyDialogOraclev10g.this.snapshotList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class IndexListMouseListener
    extends MouseAdapter {
        private IndexListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            IndexProxyOracle selected;
            if (e.getClickCount() == 2 && (selected = (IndexProxyOracle)UserPropertyDialogOraclev10g.this.indexList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class TableListMouseListener
    extends MouseAdapter {
        private TableListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableProxyOracle selected;
            if (e.getClickCount() == 2 && (selected = (TableProxyOracle)UserPropertyDialogOraclev10g.this.tableList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class ClusterListMouseListener
    extends MouseAdapter {
        private ClusterListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ClusterOracle selected;
            if (e.getClickCount() == 2 && (selected = (ClusterOracle)UserPropertyDialogOraclev10g.this.clusterList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class RemoveRolesActionListener
    implements ActionListener {
        private RemoveRolesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Role> removalList = new ArrayList<Role>();
            int[] selectedObjects = UserPropertyDialogOraclev10g.this.selectedRolesTable.getSelectedRows();
            Object ob1 = null;
            for (int i = 0; i < selectedObjects.length; ++i) {
                Role ob = UserPropertyDialogOraclev10g.this.selectedRolesList.get(UserPropertyDialogOraclev10g.this.selectedRolesTable.convertRowIndexToModel(selectedObjects[i]));
                ob1 = ob.getObject();
                if (UserPropertyDialogOraclev10g.this.allRolesModel.contains(ob1)) continue;
                UserPropertyDialogOraclev10g.this.allRolesModel.addElement(ob1);
                removalList.add(ob);
            }
            UserPropertyDialogOraclev10g.this.selectedRolesTable.setRowSorter(null);
            UserPropertyDialogOraclev10g.this.selectedRolesTable.setAutoCreateRowSorter(false);
            UserPropertyDialogOraclev10g.this.selectedRolesList.removeAll(removalList);
            UserPropertyDialogOraclev10g.this.selectedRolesTable.updateUI();
            UserPropertyDialogOraclev10g.this.selectedRolesTable.clearSelection();
            if (UserPropertyDialogOraclev10g.this.selectedRolesList.size() > 0) {
                UserPropertyDialogOraclev10g.this.selectedRolesTable.setRowSorter(UserPropertyDialogOraclev10g.this.rSorter);
                UserPropertyDialogOraclev10g.this.selectedRolesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(UserPropertyDialogOraclev10g.this.selectedRolesTable, 0);
            }
            UserPropertyDialogOraclev10g.this.sort(UserPropertyDialogOraclev10g.this.allRolesModel);
            UserPropertyDialogOraclev10g.this.allRolesList.setSelectedValue(ob1, true);
            UserPropertyDialogOraclev10g.this.btnSelectAllRoles.setEnabled(UserPropertyDialogOraclev10g.this.selectedRolesList.size() > 0);
            UserPropertyDialogOraclev10g.this.btnDeselectAllRoles.setEnabled(UserPropertyDialogOraclev10g.this.selectedRolesList.size() > 0);
        }
    }

    private class AddRolesActionListener
    implements ActionListener {
        private AddRolesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object ob = null;
            if (!UserPropertyDialogOraclev10g.this.allRolesModel.isEmpty()) {
                Object[] selectedObjects = UserPropertyDialogOraclev10g.this.allRolesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    ob = selectedObjects[i];
                    if (UserPropertyDialogOraclev10g.this.selectedRolesList.contains(ob)) continue;
                    Role ro = new Role(ob);
                    ro.setName(ob.toString());
                    ro.setObjectID(((RoleOracle)selectedObjects[i]).getObjectID());
                    UserPropertyDialogOraclev10g.this.selectedRolesList.add(ro);
                    UserPropertyDialogOraclev10g.this.allRolesModel.removeElement(selectedObjects[i]);
                }
                ((AbstractTableModel)UserPropertyDialogOraclev10g.this.selectedRolesTable.getModel()).fireTableDataChanged();
                if (UserPropertyDialogOraclev10g.this.selectedRolesTable.getRowSorter() == null) {
                    UserPropertyDialogOraclev10g.this.selectedRolesTable.setRowSorter(UserPropertyDialogOraclev10g.this.rSorter);
                    UserPropertyDialogOraclev10g.this.selectedRolesTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(UserPropertyDialogOraclev10g.this.selectedRolesTable, 0);
                }
                UserPropertyDialogOraclev10g.this.btnSelectAllRoles.setEnabled(true);
                UserPropertyDialogOraclev10g.this.btnDeselectAllRoles.setEnabled(true);
            }
            UserPropertyDialogOraclev10g.this.selectedRolesTable.updateUI();
            UserPropertyDialogOraclev10g.this.selectedRolesTable.getSelectionModel().setSelectionInterval(UserPropertyDialogOraclev10g.this.selectedRolesTable.getRowCount() - 1, UserPropertyDialogOraclev10g.this.selectedRolesTable.getRowCount() - 1);
        }
    }

    private class AllRolesListSelectionHandler
    implements ListSelectionListener {
        private AllRolesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (UserPropertyDialogOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (UserPropertyDialogOraclev10g.this.allRolesList.getSelectedIndex() == -1) {
                    UserPropertyDialogOraclev10g.this.bnAddRoles.setEnabled(false);
                } else {
                    UserPropertyDialogOraclev10g.this.bnAddRoles.setEnabled(true);
                }
            }
        }
    }

    private class AllPrivilegesListSelectionHandler
    implements ListSelectionListener {
        private AllPrivilegesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (UserPropertyDialogOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (UserPropertyDialogOraclev10g.this.allPrivilegesList.getSelectedIndex() == -1) {
                    UserPropertyDialogOraclev10g.this.bnAddPrivileges.setEnabled(false);
                } else {
                    UserPropertyDialogOraclev10g.this.bnAddPrivileges.setEnabled(true);
                }
            }
        }
    }

    private class RemovePrivilegesActionListener
    implements ActionListener {
        private RemovePrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<SystemPrivilege> removalList = new ArrayList<SystemPrivilege>();
            int[] selectedObjects = UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.getSelectedRows();
            Object currentObject = null;
            for (int i = 0; i < selectedObjects.length; ++i) {
                SystemPrivilege selectedObject = UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.get(UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.convertRowIndexToModel(selectedObjects[i]));
                currentObject = selectedObject.getObject();
                if (UserPropertyDialogOraclev10g.this.allPrivilegesModel.contains(currentObject)) continue;
                UserPropertyDialogOraclev10g.this.allPrivilegesModel.addElement(currentObject);
                removalList.add(selectedObject);
            }
            UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.setRowSorter(null);
            UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.setAutoCreateRowSorter(false);
            UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.removeAll(removalList);
            UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.updateUI();
            UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.clearSelection();
            if (UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.size() > 0) {
                UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.setRowSorter(UserPropertyDialogOraclev10g.this.spSorter);
                UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable, 0);
            }
            UserPropertyDialogOraclev10g.this.sort(UserPropertyDialogOraclev10g.this.allPrivilegesModel);
            UserPropertyDialogOraclev10g.this.allPrivilegesList.setSelectedValue(currentObject, true);
            UserPropertyDialogOraclev10g.this.btnSelectAllPrivileges.setEnabled(UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.size() > 0);
            UserPropertyDialogOraclev10g.this.btnDeselectAllPrivileges.setEnabled(UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.size() > 0);
        }
    }

    private class AddPrivilegesActionListener
    implements ActionListener {
        private AddPrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object ob = null;
            if (!UserPropertyDialogOraclev10g.this.allPrivilegesModel.isEmpty()) {
                Object[] selectedObjects = UserPropertyDialogOraclev10g.this.allPrivilegesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    ob = selectedObjects[i];
                    if (UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.contains(ob)) continue;
                    SystemPrivilege sp = new SystemPrivilege(ob);
                    sp.setName(ob.toString());
                    UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesList.add(sp);
                    UserPropertyDialogOraclev10g.this.allPrivilegesModel.removeElement(ob);
                }
                ((AbstractTableModel)UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.getModel()).fireTableDataChanged();
                if (UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.getRowSorter() == null) {
                    UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.setRowSorter(UserPropertyDialogOraclev10g.this.spSorter);
                    UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable, 0);
                }
                UserPropertyDialogOraclev10g.this.btnSelectAllPrivileges.setEnabled(true);
                UserPropertyDialogOraclev10g.this.btnDeselectAllPrivileges.setEnabled(true);
            }
            UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.updateUI();
            UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.getSelectionModel().setSelectionInterval(UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.getRowCount() - 1, UserPropertyDialogOraclev10g.this.selectedSystemPrivilegesTable.getRowCount() - 1);
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserPropertyDialogOraclev10g.this.dialog = new UserAndRolePermissionsDialogOracle(UserPropertyDialogOraclev10g.this.getAppView(), UserPropertyDialogOraclev10g.this.getStorageDesign(), UserPropertyDialogOraclev10g.this.user);
            UserPropertyDialogOraclev10g.this.dialog.showDialog();
        }
    }
}

