/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.BitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.LocalIndexPropertyDialogOraclev9i;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ListPartitionPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog
implements ListSelectionListener {
    private ListPartitionOraclev9i listPartition;
    private JTextField tfValueList;
    private JComboBox cbCompression;
    private JComboBox cbTableSpace;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JPanel indexesButtonPanel;
    private JList list;
    private DefaultListModel listModel;
    private JButton edit;

    public ListPartitionPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.listPartition = (ListPartitionOraclev9i)object;
        this.setHeight(230);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ListPartitionPropertyDialogOracle.ListPartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initValueList();
        this.initDataSegmentCompression();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
    }

    private void initValueList() {
        JLabel label = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.ValueList"));
        this.general.add(label);
        this.tfValueList = new JTextField("", 26);
        this.general.add(this.tfValueList);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfValueList, 50);
    }

    private void initDataSegmentCompression() {
        JLabel label = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.Compression"));
        this.general.add(label);
        this.cbCompression = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbCompression);
        this.cbCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCompression);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbCompression, 80);
    }

    private void initTableSpace() {
        JLabel label = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.TableSpace"));
        this.general.add(label);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbTableSpace, 110);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.Logging"));
        this.general.add(label);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbLogging, 140);
    }

    private void initSegment() {
        JLabel label = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.Segment"));
        this.general.add(label);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbSegment, 170);
    }

    @Override
    protected void addTabs() {
        this.initIndexesTab();
    }

    private void initIndexesTab() {
        JPanel constraintPanel = new JPanel();
        JScrollPane pane = new JScrollPane(this.getList());
        pane.setPreferredSize(new Dimension(390, 150));
        constraintPanel.add((Component)this.getIndexesButtonPanel(), "North");
        constraintPanel.add((Component)pane, "Center");
        this.getPane().addTab(Messages.getString("ListPartitionPropertyDialogOracle.LocalIndexes"), constraintPanel);
    }

    private JList getList() {
        this.list = new JList(this.getLocIndexes());
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new IndexesCellRenderer());
        this.list.addMouseListener(new listMouseListener());
        this.list.addListSelectionListener(this);
        return this.list;
    }

    private DefaultListModel getLocIndexes() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    protected JPanel getIndexesButtonPanel() {
        if (this.indexesButtonPanel == null) {
            this.indexesButtonPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.edit = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.edit.setToolTipText(Messages.getString("ListPartitionPropertyDialogOracle.Properties"));
            this.edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListPartitionPropertyDialogOraclev9i.this.editSelected();
                }
            });
            this.edit.setEnabled(false);
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.edit);
            toolBar.addSeparator();
            this.indexesButtonPanel.add(toolBar);
            this.indexesButtonPanel.setPreferredSize(new Dimension(390, 30));
        }
        return this.indexesButtonPanel;
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void editSelected() {
        Object selected = this.list.getSelectedValue();
        LocalIndexPropertyDialogOraclev9i editor = new LocalIndexPropertyDialogOraclev9i(this.listPartition.getDesign().getAppView(), this.getStorageDesign(), this.listPartition, (StorageObject)selected);
        editor.show();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.listPartition.getName());
        this.tfName.setText(this.listPartition.getName());
        this.tfValueList.setText(this.listPartition.getColumns());
        this.cbCompression.setSelectedItem(ListPartitionPropertyDialogOraclev9i.translateYesNoForDisplay(this.listPartition.getDataSegmentCompression()));
        this.selectObject(this.cbTableSpace, this.listPartition.getTablespace());
        this.cbLogging.setSelectedItem(ListPartitionPropertyDialogOraclev9i.translateYesNoForDisplay(this.listPartition.getLogging()));
        this.selectObject(this.cbSegment, this.listPartition.getSegment());
        PartitionListOracle partitionList = this.listPartition.getPartitionList();
        if (partitionList != null) {
            SnapshotOracle snapshot;
            TableProxyOraclev9i table = (TableProxyOraclev9i)partitionList.getTable();
            if (table == null && (snapshot = partitionList.getSnapshot()) != null) {
                table = (TableProxyOraclev9i)snapshot.getImplementedTable();
            }
            if (table != null) {
                for (IndexProxyOraclev9i index : table.getIndexes()) {
                    if (!index.getIndexPartitioned().equalsIgnoreCase("local")) continue;
                    this.listModel.addElement(index);
                }
                for (BitmapJoinIndexOraclev9i bji : table.getBjIndexes()) {
                    if (!bji.getLocalPartitioning().equalsIgnoreCase("YES")) continue;
                    this.listModel.addElement(bji);
                }
            }
        }
        for (int i = 0; i < this.listModel.size(); ++i) {
            LocalIndexProperties lip;
            StorageObject index;
            if (this.listModel.get(i) instanceof IndexProxyOraclev9i) {
                index = (IndexProxyOraclev9i)this.listModel.get(i);
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.listPartition, index);
                if (lip != null) continue;
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                lip.setPartition(this.listPartition);
                lip.setIndex(index);
                continue;
            }
            if (!(this.listModel.get(i) instanceof BitmapJoinIndexOraclev9i)) continue;
            index = (BitmapJoinIndexOraclev9i)this.listModel.get(i);
            lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.listPartition, index);
            if (lip != null) continue;
            lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
            lip.setPartition(this.listPartition);
            lip.setIndex(index);
        }
        this.getCommentsList().insert(this.listPartition.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.listPartition != null) {
            this.listPartition.setName(this.tfName.getText());
            this.listPartition.setColumns(this.tfValueList.getText());
            this.listPartition.setDataSegmentCompression(ListPartitionPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbCompression.getSelectedItem()));
            Object selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOracle) {
                this.listPartition.setTablespace((TableSpaceOracle)selected);
            } else {
                this.listPartition.setTablespace(null);
            }
            this.listPartition.setLogging(ListPartitionPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            selected = this.cbSegment.getSelectedItem();
            if (selected instanceof SegmentOracle) {
                this.listPartition.setSegment((SegmentOracle)selected);
            } else {
                this.listPartition.setSegment(null);
            }
            this.listPartition.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.edit.setEnabled(false);
            } else {
                this.edit.setEnabled(true);
            }
        }
    }

    private class listMouseListener
    extends MouseAdapter {
        private listMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                ListPartitionPropertyDialogOraclev9i.this.editSelected();
            }
        }
    }

    class IndexesCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public IndexesCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Index) {
                this.setText(((Index)value).getName());
            } else {
                this.setText(value.toString());
            }
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            return this;
        }
    }
}

