/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.BitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.LocalIndexPropertyDialogOraclev9i;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class TBPartitionPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog
implements ListSelectionListener {
    private PartitionOraclev9i partition;
    private JTextField tfValueList;
    private JIntegerField ifPosition;
    private JComboBox cbTableSpace;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JIntegerField ifIotCompress;
    private JComboBox cbIotOverflowSegment;
    private JComboBox cbSegmentCompression;
    private JIntegerField ifSubPartQuantity;
    private JPanel subPartTS;
    private JList allSubPartTSList;
    private JList selectedSubPartTSList;
    private DefaultListModel allSubPartTSModel;
    private DefaultListModel selectedSubPartTSModel;
    private JButton bnAddSubPartTS;
    private JButton bnRemoveSubPartTS;
    private JList list;
    private JPanel indexesButtonPanel;
    private DefaultListModel listModel;
    private JButton edit;

    public TBPartitionPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.partition = (PartitionOraclev9i)object;
        this.setHeight(350);
        this.initCommentsView(300);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TBPartitionPropertyDialogOracle.PartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initValueList();
        this.initPosition();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
        this.initSegmentCompression();
        this.initIOTCompress();
        this.initIOTOverflowSegment();
        this.initSubPartQuantity();
    }

    private void initValueList() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.ValueList"));
        this.general.add(label);
        this.tfValueList = new JTextField("", 26);
        this.general.add(this.tfValueList);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfValueList, 50);
    }

    private void initPosition() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.Position"));
        this.general.add(label);
        this.ifPosition = new JIntegerField(0, 26);
        this.general.add(this.ifPosition);
        this.ifPosition.setEnabled(false);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.ifPosition, 80);
    }

    private void initTableSpace() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.TableSpace"));
        this.general.add(label);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbTableSpace, 110);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.Logging"));
        this.general.add(label);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbLogging, 140);
    }

    private void initSegment() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.Segment"));
        this.general.add(label);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbSegment, 170);
    }

    private void initSegmentCompression() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.SegCompression"));
        this.general.add(label);
        this.cbSegmentCompression = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbSegmentCompression);
        this.cbSegmentCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegmentCompression);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbSegmentCompression, 200);
    }

    private void initIOTCompress() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.IOTCompress"));
        this.general.add(label);
        this.ifIotCompress = new JIntegerField(0, 26);
        this.general.add(this.ifIotCompress);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.ifIotCompress, 230);
    }

    private void initIOTOverflowSegment() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.OverflowSegment"));
        this.general.add(label);
        this.cbIotOverflowSegment = new JComboBox();
        this.setBG(this.cbIotOverflowSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbIotOverflowSegment);
        }
        this.cbIotOverflowSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIotOverflowSegment);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbIotOverflowSegment, 260);
    }

    private void initSubPartQuantity() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.SubPartQuantity"));
        this.general.add(label);
        this.ifSubPartQuantity = new JIntegerField(0, 26);
        this.ifSubPartQuantity.setToolTipText(Messages.getString("TBPartitionPropertyDialogOracle.PropertyAvailableIf"));
        this.general.add(this.ifSubPartQuantity);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.ifSubPartQuantity, 290);
    }

    private DefaultListModel getLocIndexes() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    private void initIndexesTab() {
        JPanel constraintPanel = new JPanel();
        JScrollPane pane = new JScrollPane(this.getList());
        pane.setPreferredSize(new Dimension(390, 270));
        constraintPanel.add((Component)this.getIndexesButtonPanel(), "North");
        constraintPanel.add((Component)pane, "Center");
        this.getPane().addTab(Messages.getString("TBPartitionPropertyDialogOracle.LocalIndexes"), constraintPanel);
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    protected JPanel getIndexesButtonPanel() {
        if (this.indexesButtonPanel == null) {
            this.indexesButtonPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.edit = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.edit.setToolTipText(Messages.getString("TBPartitionPropertyDialogOracle.Properties"));
            this.edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TBPartitionPropertyDialogOraclev9i.this.editSelected();
                }
            });
            this.edit.setEnabled(false);
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.edit);
            toolBar.addSeparator();
            this.indexesButtonPanel.add(toolBar);
            this.indexesButtonPanel.setPreferredSize(new Dimension(390, 30));
        }
        return this.indexesButtonPanel;
    }

    private void editSelected() {
        Object selected = this.list.getSelectedValue();
        LocalIndexPropertyDialogOraclev9i editor = new LocalIndexPropertyDialogOraclev9i(this.partition.getDesign().getAppView(), this.getStorageDesign(), this.partition, (StorageObject)selected);
        editor.show();
    }

    private JList getList() {
        this.list = new JList(this.getLocIndexes());
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new IndexesCellRenderer());
        this.list.addMouseListener(new listMouseListener());
        this.list.addListSelectionListener(this);
        return this.list;
    }

    @Override
    protected void addTabs() {
        this.initSubPartTSView();
        this.initIndexesTab();
    }

    private void initSubPartTSView() {
        this.subPartTS = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TBPartitionPropertyDialogOracle.SubPartTableSpaces"), this.subPartTS);
        this.initSubPartTS();
    }

    protected SpringLayout getSubPartTSLayout() {
        return (SpringLayout)this.subPartTS.getLayout();
    }

    private void initSubPartTS() {
        this.initAllSubPartTSList();
        this.initSelectedSubPartTSList();
        this.initSubPartTSButtons();
    }

    private void initAllSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.AllTableSpaces"));
        this.subPartTS.add(label);
        this.allSubPartTSModel = new DefaultListModel();
        this.allSubPartTSList = new JList(this.allSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allSubPartTSList);
        sp.setPreferredSize(new Dimension(144, 290));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(sp);
        this.setLabelConstraints(this.getSubPartTSLayout(), label, 8, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), sp, 6, 22);
    }

    private void initSelectedSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.SelectedTableSpaces"));
        this.subPartTS.add(label);
        this.selectedSubPartTSModel = new DefaultListModel();
        this.selectedSubPartTSList = new JList(this.selectedSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedSubPartTSList);
        sp.setPreferredSize(new Dimension(145, 290));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(sp);
        this.setLabelConstraints(this.getSubPartTSLayout(), label, 292, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), sp, 290, 22);
    }

    private void initSubPartTSButtons() {
        this.bnAddSubPartTS = new JButton(Messages.getString("TBPartitionPropertyDialogOracle.Add"));
        this.bnAddSubPartTS.addActionListener(new AddSubPartTSActionListener());
        this.bnAddSubPartTS.setEnabled(false);
        this.subPartTS.add(this.bnAddSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnAddSubPartTS, 175, 135);
        this.bnRemoveSubPartTS = new JButton(Messages.getString("TBPartitionPropertyDialogOracle.Remove"));
        this.bnRemoveSubPartTS.setEnabled(false);
        this.bnRemoveSubPartTS.addActionListener(new RemoveSubPartTSActionListener());
        this.subPartTS.add(this.bnRemoveSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnRemoveSubPartTS, 175, 165);
        TBPartitionPropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddSubPartTS, this.bnRemoveSubPartTS);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.partition.getName());
        this.tfName.setText(this.partition.getName());
        this.tfValueList.setText(this.partition.getValueList());
        this.ifPosition.setValue((long)this.partition.getPosition());
        this.selectObject(this.cbTableSpace, this.partition.getTableSpace());
        this.cbLogging.setSelectedItem(TBPartitionPropertyDialogOraclev9i.translateYesNoForDisplay(this.partition.getLogging()));
        this.selectObject(this.cbSegment, this.partition.getSegment());
        this.cbSegmentCompression.setSelectedItem(TBPartitionPropertyDialogOraclev9i.translateYesNoForDisplay(this.partition.getDataSegmentCompression()));
        this.ifIotCompress.setValue((long)this.partition.getIOTCompress());
        this.selectObject(this.cbIotOverflowSegment, this.partition.getIOTOverflowSegment());
        PartitionListOracle pl = this.partition.getPartitionList();
        if (this.partition.hasSubPartitions() || !pl.getPartitionType().equalsIgnoreCase("COMPOSITE BY HASH")) {
            this.ifSubPartQuantity.setEnabled(false);
            int ind = this.getPane().indexOfComponent(this.subPartTS);
            if (ind > -1) {
                this.getPane().setEnabledAt(ind, false);
            }
        } else {
            this.ifSubPartQuantity.setValue((long)this.partition.getSubPartitionsQuantity());
        }
        if (pl != null) {
            SnapshotOracle snapshot;
            TableProxyOracle table = pl.getTable();
            if (table == null && (snapshot = pl.getSnapshot()) != null) {
                table = snapshot.getImplementedTable();
            }
            if (table != null) {
                boolean indexOrg = table.getOrganization().equals(TableProxyOracle.getOrganizationChoices()[1]);
                this.ifIotCompress.setEnabled(indexOrg);
                this.cbIotOverflowSegment.setEnabled(indexOrg);
                IndexProxy[] indexSet = table.getIndexProxies();
                for (int i = 0; i < indexSet.length; ++i) {
                    IndexProxyOracle index = (IndexProxyOracle)indexSet[i];
                    if (index == null || !index.getIndexPartitioned().equalsIgnoreCase(IndexProxyOracle.getPartitionedChoices()[1])) continue;
                    this.listModel.addElement(index);
                }
                for (UniqueOraclev9i unique : table.getUniqueKeys()) {
                    if (!unique.getUsingIndex().equalsIgnoreCase(UniqueOraclev9i.getUsingIndexChoices()[1])) continue;
                    this.listModel.addElement(unique);
                }
                for (PKProxyOraclev9i pk : table.getPrimaryKeys()) {
                    if (!pk.getUsingIndex().equalsIgnoreCase(PKProxyOraclev9i.getUsingIndexChoices()[1])) continue;
                    this.listModel.addElement(pk);
                }
                for (BitmapJoinIndexOraclev9i bji : table.getBjIndexes()) {
                    if (!bji.getLocalPartitioning().equalsIgnoreCase("YES")) continue;
                    this.listModel.addElement(bji);
                }
            }
        }
        for (int i = 0; i < this.listModel.size(); ++i) {
            LocalIndexProperties lip;
            StorageObject index;
            if (this.listModel.get(i) instanceof IndexProxyOraclev9i) {
                index = (IndexProxyOraclev9i)this.listModel.get(i);
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, index);
                if (lip != null) continue;
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                lip.setIndex(index);
                lip.setPartition(this.partition);
                continue;
            }
            if (!(this.listModel.get(i) instanceof BitmapJoinIndexOraclev9i)) continue;
            index = (BitmapJoinIndexOraclev9i)this.listModel.get(i);
            lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, index);
            if (lip != null) continue;
            lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
            lip.setIndex(index);
            lip.setPartition(this.partition);
        }
        Iterator tsIt = this.partition.getSubPartTSSet().iterator();
        while (tsIt.hasNext()) {
            ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
            if (!(ts instanceof TableSpaceOracle)) continue;
            this.selectedSubPartTSModel.addElement(ts);
        }
        TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            TableSpaceOracle ts = tsSet[i];
            if (this.selectedSubPartTSModel.contains(ts)) continue;
            this.allSubPartTSModel.addElement(ts);
        }
        this.getCommentsList().insert(this.partition.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.partition != null) {
            this.partition.setName(this.tfName.getText());
            this.partition.setValueList(this.tfValueList.getText());
            Object selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOraclev9i) {
                this.partition.setTableSpace((TableSpaceOraclev9i)selected);
            } else {
                this.partition.setTableSpace(null);
            }
            this.partition.setLogging(TBPartitionPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            selected = this.cbSegment.getSelectedItem();
            if (selected instanceof SegmentOraclev9i) {
                this.partition.setSegment((SegmentOraclev9i)selected);
            } else {
                this.partition.setSegment(null);
            }
            this.partition.setDataSegmentCompression(TBPartitionPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbSegmentCompression.getSelectedItem()));
            this.partition.setIOTCompress(this.ifIotCompress.getIntValue());
            selected = this.cbIotOverflowSegment.getSelectedItem();
            if (selected instanceof SegmentOraclev9i) {
                this.partition.setIOTOverflowSegment((SegmentOraclev9i)selected);
            } else {
                this.partition.setIOTOverflowSegment(null);
            }
            this.partition.setSubPartitionsQuantity(this.ifSubPartQuantity.getIntValue());
            this.partition.getSubPartTSSet().clear();
            Object[] tsSet = this.selectedSubPartTSModel.toArray();
            for (int i = 0; i < tsSet.length; ++i) {
                Object ts = tsSet[i];
                if (!(ts instanceof TableSpaceOraclev9i)) continue;
                this.partition.setSubPartitionsTableSpaces(((TableSpaceOraclev9i)ts).getObjectID());
            }
            this.partition.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.edit.setEnabled(false);
            } else {
                this.edit.setEnabled(true);
            }
        }
    }

    private class RemoveSubPartTSActionListener
    implements ActionListener {
        private RemoveSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TBPartitionPropertyDialogOraclev9i.this.selectedSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = TBPartitionPropertyDialogOraclev9i.this.selectedSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TBPartitionPropertyDialogOraclev9i.this.allSubPartTSModel.contains(ob)) continue;
                    TBPartitionPropertyDialogOraclev9i.this.allSubPartTSModel.addElement(ob);
                    TBPartitionPropertyDialogOraclev9i.this.selectedSubPartTSModel.removeElement(ob);
                }
            }
        }
    }

    private class AddSubPartTSActionListener
    implements ActionListener {
        private AddSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TBPartitionPropertyDialogOraclev9i.this.allSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = TBPartitionPropertyDialogOraclev9i.this.allSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TBPartitionPropertyDialogOraclev9i.this.selectedSubPartTSModel.contains(ob)) continue;
                    TBPartitionPropertyDialogOraclev9i.this.selectedSubPartTSModel.addElement(ob);
                    TBPartitionPropertyDialogOraclev9i.this.allSubPartTSModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TBPartitionPropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TBPartitionPropertyDialogOraclev9i.this.selectedSubPartTSList.getSelectedIndex() == -1) {
                    TBPartitionPropertyDialogOraclev9i.this.bnRemoveSubPartTS.setEnabled(false);
                } else {
                    TBPartitionPropertyDialogOraclev9i.this.bnRemoveSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AllSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TBPartitionPropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TBPartitionPropertyDialogOraclev9i.this.allSubPartTSList.getSelectedIndex() == -1) {
                    TBPartitionPropertyDialogOraclev9i.this.bnAddSubPartTS.setEnabled(false);
                } else {
                    TBPartitionPropertyDialogOraclev9i.this.bnAddSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class listMouseListener
    extends MouseAdapter {
        private listMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                TBPartitionPropertyDialogOraclev9i.this.editSelected();
            }
        }
    }

    class IndexesCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public IndexesCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Index) {
                this.setText(((Index)value).getName());
            } else {
                this.setText(value.toString());
            }
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            return this;
        }
    }
}

