/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UserAndRolePermissionsDialogSqlServer
extends CustomDialog
implements AbstractEditorConstants {
    private static String EMPTY_VALUE = "";
    private static String CHECKED = "v";
    private static String CHECKED_WITH_GRANT_OPTION = "v->";
    protected static final String EDIT = Messages.getString("UserAndRolePermissionsDialogSqlServer.Edit");
    private StorageObject storageObject;
    private TableProxySetSqlServer tablesSet;
    private TableViewProxySetSqlServer viewSet;
    private StorageDesignSqlServer storageDesign;
    private JButton bnCancel;
    private JTabbedPane tpane;
    private JPanel jpanel;
    private JPanel objectsPanel;
    private TableTable tablesTable;
    private ViewsTable viewsTable;
    private JDialog dialog;

    public UserAndRolePermissionsDialogSqlServer(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view);
        this.storageDesign = (StorageDesignSqlServer)storageDesign;
        this.storageObject = object;
        this.jpanel = new JPanel(new BorderLayout());
        this.jpanel.add((Component)this.getTabbedPane(), "Center");
        JPanel bottomPanel = new JPanel();
        if (this.isEditable()) {
            JButton bnOK = new JButton(Messages.getString("UserAndRolePermissionsDialogSqlServer.OK"));
            bnOK.addActionListener(new OKAction());
            bnOK.setMnemonic(79);
            bottomPanel.add(bnOK);
            JButton bnApply = new JButton(Messages.getString("UserAndRolePermissionsDialogSqlServer.Apply"));
            bnApply.addActionListener(new ApplyAction());
            bnApply.setMnemonic(65);
            bottomPanel.add(bnApply);
            bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        this.bnCancel = new JButton(this.isEditable() ? Messages.getString("UserAndRolePermissionsDialogSqlServer.Cancel") : Messages.getString("UserAndRolePermissionsDialogSqlServer.Close"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(this.bnCancel);
        this.jpanel.add((Component)bottomPanel, "South");
        CommonUtil.centerOnScreen(this.getDialog());
        this.addTabs();
        this.initProperties();
        this.add(this.jpanel);
    }

    @Override
    protected boolean isEditable() {
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    protected void addTabs() {
        this.initTables();
        this.initViews();
    }

    private JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane();
            this.tpane.setPreferredSize(new Dimension(820, 320));
            this.tpane.setTabPlacement(3);
        }
        return this.tpane;
    }

    private void initTables() {
        this.tablesSet = (TableProxySetSqlServer)this.storageDesign.getTableProxySet();
        this.tablesTable = new TableTable();
        JScrollPane scrollpane = new JScrollPane(this.tablesTable);
        scrollpane.setPreferredSize(new Dimension(800, 320));
        scrollpane.setHorizontalScrollBar(new JScrollBar());
        scrollpane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(scrollpane);
        this.getTabbedPane().addTab(Messages.getString("UserAndRolePermissionsDialogSqlServer.Tables"), this.objectsPanel);
        this.tablesTable.updateUI();
        TablesModel tableModel = (TablesModel)this.tablesTable.getModel();
        Iterator it = this.tablesSet.iterator();
        while (it.hasNext()) {
            TableProxySqlServer t = (TableProxySqlServer)it.next();
            String[] list = PermissionsSqlServer.getTablePrivilegesValues();
            Vector<Object> vect = new Vector<Object>();
            vect.addElement(t);
            for (int j = 0; j < list.length; ++j) {
                JButton button = new JButton();
                vect.addElement(button);
            }
            Object[] objects = vect.toArray();
            tableModel.addRow(objects);
        }
    }

    private void initViews() {
        this.viewSet = (TableViewProxySetSqlServer)this.storageDesign.getTableViewProxySet();
        this.viewsTable = new ViewsTable();
        this.viewsTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.viewsTable);
        scrollpane.setPreferredSize(new Dimension(800, 320));
        scrollpane.setHorizontalScrollBar(new JScrollBar());
        scrollpane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(scrollpane);
        this.getTabbedPane().addTab(Messages.getString("UserAndRolePermissionsDialogSqlServer.Views"), this.objectsPanel);
        this.viewsTable.updateUI();
        ViewsModel tableModel = (ViewsModel)this.viewsTable.getModel();
        Iterator it = this.viewSet.iterator();
        while (it.hasNext()) {
            TableViewProxySqlServer view = (TableViewProxySqlServer)it.next();
            String[] list = PermissionsSqlServer.getViewPrivilegesValues();
            Vector<Object> vect = new Vector<Object>();
            vect.addElement(view);
            for (int j = 0; j < list.length; ++j) {
                JButton button = new JButton();
                vect.addElement(button);
            }
            Object[] objects = vect.toArray();
            tableModel.addRow(objects);
        }
    }

    private boolean hasSelectedTablePrivileges(int row) {
        for (int k = 1; k < this.tablesTable.getColumnCount(); ++k) {
            if (!(this.tablesTable.getValueAt(row, k) instanceof JButton)) continue;
            JButton button = (JButton)this.tablesTable.getValueAt(row, k);
            if (button.getText().equals(CHECKED)) {
                return true;
            }
            if (!button.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSelectedViewPrivileges(int row) {
        for (int k = 1; k < this.viewsTable.getColumnCount(); ++k) {
            if (!(this.viewsTable.getValueAt(row, k) instanceof JButton)) continue;
            JButton button = (JButton)this.viewsTable.getValueAt(row, k);
            if (button.getText().equals(CHECKED)) {
                return true;
            }
            if (!button.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
            return true;
        }
        return false;
    }

    private PermissionsSqlServer getPermission(StorageObject user, StorageObject proxy) {
        for (PermissionsSqlServer perm : this.storageDesign.getPermissionsSet()) {
            if (perm.getUser() != user && perm.getRole() != user || perm.getTable() != proxy && perm.getView() != proxy) continue;
            return perm;
        }
        return null;
    }

    public void initProperties() {
        int k;
        PermissionsSqlServer perm;
        int i;
        for (i = 0; i < this.tablesTable.getRowCount(); ++i) {
            TableProxySqlServer t = (TableProxySqlServer)this.tablesTable.getValueAt(i, 0);
            perm = this.getPermission(this.storageObject, t);
            for (k = 0; k < this.tablesTable.getColumnCount(); ++k) {
                if (this.tablesTable.getValueAt(i, k) instanceof JButton) {
                    JButton button = (JButton)this.tablesTable.getValueAt(i, k);
                    if (perm != null) {
                        if (perm.getPrivileges().indexOf(this.tablesTable.getColumnName(k)) > -1) {
                            button.setText(CHECKED);
                            button.updateUI();
                            continue;
                        }
                        if (perm.getPrivilegesWithGrantOption().indexOf(this.tablesTable.getColumnName(k)) > -1) {
                            button.setText(CHECKED_WITH_GRANT_OPTION);
                            button.updateUI();
                            continue;
                        }
                        button.setText(EMPTY_VALUE);
                        button.updateUI();
                        continue;
                    }
                    button.setText(EMPTY_VALUE);
                    button.updateUI();
                    continue;
                }
                if (k != this.tablesTable.getColumnCount() - 1 || perm == null) continue;
                if (perm.getAsRole() != null) {
                    this.tablesTable.setValueAt(perm.getAsRole(), i, k);
                    continue;
                }
                this.tablesTable.setValueAt("", i, k);
            }
        }
        for (i = 0; i < this.viewsTable.getRowCount(); ++i) {
            TableViewProxySqlServer view = (TableViewProxySqlServer)this.viewsTable.getValueAt(i, 0);
            perm = this.getPermission(this.storageObject, view);
            for (k = 0; k < this.viewsTable.getColumnCount(); ++k) {
                if (this.viewsTable.getValueAt(i, k) instanceof JButton) {
                    JButton btn = (JButton)this.viewsTable.getValueAt(i, k);
                    if (perm != null) {
                        if (perm.getPrivileges().indexOf(this.viewsTable.getColumnName(k)) > -1) {
                            btn.setText(CHECKED);
                            btn.updateUI();
                            continue;
                        }
                        if (perm.getPrivilegesWithGrantOption().indexOf(this.viewsTable.getColumnName(k)) > -1) {
                            btn.setText(CHECKED_WITH_GRANT_OPTION);
                            btn.updateUI();
                            continue;
                        }
                        btn.setText(EMPTY_VALUE);
                        btn.updateUI();
                        continue;
                    }
                    btn.setText(EMPTY_VALUE);
                    btn.updateUI();
                    continue;
                }
                if (k != this.viewsTable.getColumnCount() - 1 || perm == null) continue;
                if (perm.getAsRole() != null) {
                    this.viewsTable.setValueAt(perm.getAsRole(), i, k);
                    continue;
                }
                this.viewsTable.setValueAt("", i, k);
            }
        }
    }

    protected void setProperties() {
        RoleSqlServer selectedRole;
        JButton button;
        int k;
        PermissionsSqlServer perm;
        int i;
        for (i = 0; i < this.tablesTable.getRowCount(); ++i) {
            TableProxySqlServer t = (TableProxySqlServer)this.tablesTable.getValueAt(i, 0);
            perm = this.getPermission(this.storageObject, t);
            if (this.hasSelectedTablePrivileges(i)) {
                if (perm == null) {
                    perm = this.storageDesign.getPermissionsSet().createPermissions();
                    perm.setTable(t);
                    if (this.storageObject instanceof UserSqlServer) {
                        perm.setUser((UserSqlServer)this.storageObject);
                    } else if (this.storageObject instanceof RoleSqlServer) {
                        perm.setRole((RoleSqlServer)this.storageObject);
                    }
                }
                perm.clear();
                for (k = 0; k < this.tablesTable.getColumnCount(); ++k) {
                    if (this.tablesTable.getValueAt(i, k) instanceof JButton) {
                        button = (JButton)this.tablesTable.getValueAt(i, k);
                        if (button.getText().equals(CHECKED)) {
                            perm.setPrivileges(this.tablesTable.getColumnName(k));
                            continue;
                        }
                        if (!button.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                        perm.setPrivilegesWithGrantOption(this.tablesTable.getColumnName(k));
                        continue;
                    }
                    if (!(this.tablesTable.getValueAt(i, k) instanceof RoleSqlServer) || perm == null) continue;
                    selectedRole = (RoleSqlServer)this.tablesTable.getValueAt(i, k);
                    perm.setAsRole(selectedRole);
                }
                continue;
            }
            if (perm == null) continue;
            this.storageDesign.getPermissionsSet().remove(perm);
        }
        for (i = 0; i < this.viewsTable.getRowCount(); ++i) {
            TableViewProxySqlServer view = (TableViewProxySqlServer)this.viewsTable.getValueAt(i, 0);
            perm = this.getPermission(this.storageObject, view);
            if (this.hasSelectedViewPrivileges(i)) {
                if (perm == null) {
                    perm = this.storageDesign.getPermissionsSet().createPermissions();
                    perm.setView(view);
                    if (this.storageObject instanceof UserSqlServer) {
                        perm.setUser((UserSqlServer)this.storageObject);
                    } else if (this.storageObject instanceof RoleSqlServer) {
                        perm.setRole((RoleSqlServer)this.storageObject);
                    }
                }
                perm.clear();
                for (k = 0; k < this.viewsTable.getColumnCount(); ++k) {
                    if (this.viewsTable.getValueAt(i, k) instanceof JButton) {
                        button = (JButton)this.viewsTable.getValueAt(i, k);
                        if (button.getText().equals(CHECKED)) {
                            perm.setPrivileges(this.viewsTable.getColumnName(k));
                            continue;
                        }
                        if (!button.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                        perm.setPrivilegesWithGrantOption(this.viewsTable.getColumnName(k));
                        continue;
                    }
                    if (!(this.viewsTable.getValueAt(i, k) instanceof RoleSqlServer) || perm == null) continue;
                    selectedRole = (RoleSqlServer)this.viewsTable.getValueAt(i, k);
                    perm.setAsRole(selectedRole);
                }
                continue;
            }
            if (perm == null) continue;
            this.storageDesign.getPermissionsSet().remove(perm);
        }
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("UserAndRolePermissionsDialogSqlServer.Permissions"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            this.dialog.setMinimumSize(new Dimension(850, 400));
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    class ButtonRoleTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonRoleTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                JButton currentButton = (JButton)e.getSource();
                if (currentButton.getText() == null) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(CHECKED)) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(EMPTY_VALUE)) {
                    currentButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.button = (JButton)value;
            this.button.setOpaque(true);
            this.button.setBackground(table.getBackground());
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            return this.button;
        }
    }

    class ButtonUserTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonUserTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                JButton currentButton = (JButton)e.getSource();
                if (currentButton.getText() == null) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(CHECKED)) {
                    currentButton.setText(CHECKED_WITH_GRANT_OPTION);
                } else if (currentButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(EMPTY_VALUE)) {
                    currentButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.button = (JButton)value;
            this.button.setOpaque(true);
            this.button.setBackground(table.getBackground());
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            return this.button;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setText((String)(value == null ? "" : "  " + ((JButton)value).getText()));
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setHorizontalAlignment(2);
            this.setText((String)(value == null ? "" : "  " + value.toString()));
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserAndRolePermissionsDialogSqlServer.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserAndRolePermissionsDialogSqlServer.this.setProperties();
            UserAndRolePermissionsDialogSqlServer.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserAndRolePermissionsDialogSqlServer.this.setProperties();
            UserAndRolePermissionsDialogSqlServer.this.storageObject.setDirty(true);
            UserAndRolePermissionsDialogSqlServer.this.close();
        }
    }

    public class ViewsModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return PermissionsSqlServer.getViewPrivilegesValues().length + 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            String[] perms = PermissionsSqlServer.getViewPrivilegesValues();
            if (column == 0) {
                return Messages.getString("UserAndRolePermissionsDialogSqlServer.View");
            }
            if (column == this.getColumnCount() - 1) {
                return Messages.getString("UserAndRolePermissionsDialogSqlServer.AsRole");
            }
            for (int i = 1; i < this.getColumnCount(); ++i) {
                if (column != i) continue;
                return perms[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!UserAndRolePermissionsDialogSqlServer.this.isEditable()) {
                return false;
            }
            return columnIndex > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class ViewsTable
    extends JTable {
        ViewsModel dataModel;

        public ViewsTable() {
            this.dataModel = new ViewsModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0 || col == this.getColumnCount() - 1) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            if (col == this.getColumnCount() - 1) {
                TableViewProxySqlServer view;
                RoleSetSqlServer roles = UserAndRolePermissionsDialogSqlServer.this.storageDesign.getRoleSet();
                Vector<Object> vect = new Vector<Object>();
                vect.addElement("");
                String vdb = "";
                Object obj = this.getValueAt(row, 0);
                if (obj instanceof TableViewProxySqlServer && (view = (TableViewProxySqlServer)obj).getDataBase() != null) {
                    vdb = view.getDataBase().getName();
                }
                for (int i = 0; i < roles.size(); ++i) {
                    String rdb;
                    RoleSqlServer role = (RoleSqlServer)roles.getElement(i);
                    String string = rdb = role.getDatabase() != null ? role.getDatabase().getName() : "";
                    if (!"".equals(vdb) && !rdb.equalsIgnoreCase(vdb)) continue;
                    vect.addElement(role);
                }
                JComboBox combo = new JComboBox();
                combo.setModel(new DefaultComboBoxModel(vect));
                return new DefaultCellEditor(combo);
            }
            if (UserAndRolePermissionsDialogSqlServer.this.storageObject instanceof UserSqlServer) {
                return new ButtonUserTableCellEditor();
            }
            return new ButtonRoleTableCellEditor();
        }
    }

    class TableTable
    extends JTable {
        TablesModel dataModel;

        public TableTable() {
            this.dataModel = new TablesModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0 || col == this.getColumnCount() - 1) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            if (col == this.getColumnCount() - 1) {
                TableProxySqlServer tab;
                RoleSetSqlServer roles = UserAndRolePermissionsDialogSqlServer.this.storageDesign.getRoleSet();
                Vector<Object> vect = new Vector<Object>();
                vect.addElement("");
                String tdb = "";
                Object obj = this.getValueAt(row, 0);
                if (obj instanceof TableProxySqlServer && (tab = (TableProxySqlServer)obj).getDatabase() != null) {
                    tdb = tab.getDatabase().getName();
                }
                for (int i = 0; i < roles.size(); ++i) {
                    String rdb;
                    RoleSqlServer role = (RoleSqlServer)roles.getElement(i);
                    String string = rdb = role.getDatabase() != null ? role.getDatabase().getName() : "";
                    if (!"".equals(tdb) && !rdb.equalsIgnoreCase(tdb)) continue;
                    vect.addElement(role);
                }
                JComboBox combo = new JComboBox();
                combo.setModel(new DefaultComboBoxModel(vect));
                return new DefaultCellEditor(combo);
            }
            if (UserAndRolePermissionsDialogSqlServer.this.storageObject instanceof UserSqlServer) {
                return new ButtonUserTableCellEditor();
            }
            return new ButtonRoleTableCellEditor();
        }
    }

    public class TablesModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return PermissionsSqlServer.getTablePrivilegesValues().length + 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            String[] perms = PermissionsSqlServer.getTablePrivilegesValues();
            if (column == 0) {
                return Messages.getString("UserAndRolePermissionsDialogSqlServer.Table");
            }
            if (column == this.getColumnCount() - 1) {
                return Messages.getString("UserAndRolePermissionsDialogSqlServer.AsRole");
            }
            for (int i = 1; i < this.getColumnCount(); ++i) {
                if (column != i) continue;
                return perms[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!UserAndRolePermissionsDialogSqlServer.this.isEditable()) {
                return false;
            }
            return columnIndex > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

