/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.UserAndRolePermissionsDialogSqlServer;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UserPropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private UserSqlServer user;
    private JTextField tfDatabase;
    private JTextField tfLogin;
    private JPanel panelPrivileges;
    private JList allPrivilegesList;
    private JList selectedPrivilegesList;
    private DefaultListModel allPrivilegesModel;
    private DefaultListModel selectedPrivilegesModel;
    private JButton bnAddPrivileges;
    private JButton bnRemovePrivileges;
    private JButton bnPermissions;
    private UserAndRolePermissionsDialogSqlServer dialog;
    private JComboBox cbSchemaObject;

    public UserPropertyDialogSqlServer(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.user = (UserSqlServer)object;
        this.setHeight(190);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("UserPropertyDialogSqlServer.UserProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDatabase();
        this.initLogin();
        this.initSchemaObject();
        this.initPermissionsButton();
    }

    private void initDatabase() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogSqlServer.Database"));
        this.general.add(label);
        this.tfDatabase = new JTextField();
        this.setBG(this.tfDatabase);
        this.tfDatabase.setPreferredSize(this.tfName.getPreferredSize());
        this.tfDatabase.setEnabled(false);
        this.general.add(this.tfDatabase);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfDatabase, 50);
    }

    private void initLogin() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogSqlServer.Login"));
        this.general.add(label);
        this.tfLogin = new JTextField();
        this.setBG(this.tfLogin);
        this.tfLogin.setEnabled(false);
        this.tfLogin.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfLogin);
        this.setLabelConstraints(label, 75);
        this.setObjectConstraints(this.tfLogin, 75);
    }

    private void initSchemaObject() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogSqlServer.ImplementsSchema"));
        this.general.add(label);
        this.cbSchemaObject = new JComboBox();
        this.setBG(this.cbSchemaObject);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getPhysicalDesign().getSchemaObjectSet().toArray(), this.cbSchemaObject);
        }
        this.cbSchemaObject.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSchemaObject);
        this.setLabelConstraints(label, 100);
        this.setObjectConstraints(this.cbSchemaObject, 100);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("UserPropertyDialogSqlServer.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 130);
    }

    @Override
    protected void addTabs() {
        this.initPrivilegesView();
    }

    private void initPrivilegesView() {
        this.panelPrivileges = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UserPropertyDialogSqlServer.Privileges"), this.panelPrivileges);
        this.initPrivileges();
    }

    private void initPrivileges() {
        this.initAllPrivilegesList();
        this.initSelectedPrivilegesList();
        this.initPrivilegesButtons();
    }

    private void initPrivilegesButtons() {
        this.bnAddPrivileges = new JButton(Messages.getString("UserPropertyDialogSqlServer.Add"));
        this.bnAddPrivileges.addActionListener(new AddPrivilegesActionListener());
        this.bnAddPrivileges.setEnabled(false);
        this.panelPrivileges.add(this.bnAddPrivileges);
        this.setObjectConstraints(this.getPrivilegesLayout(), this.bnAddPrivileges, 175, 60);
        this.bnRemovePrivileges = new JButton(Messages.getString("UserPropertyDialogSqlServer.Remove"));
        this.bnRemovePrivileges.setEnabled(false);
        this.bnRemovePrivileges.addActionListener(new RemovePrivilegesActionListener());
        this.panelPrivileges.add(this.bnRemovePrivileges);
        this.setObjectConstraints(this.getPrivilegesLayout(), this.bnRemovePrivileges, 175, 90);
        UserPropertyDialogSqlServer.equalizeButtonSizes(this.bnAddPrivileges, this.bnRemovePrivileges);
    }

    private void initAllPrivilegesList() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogSqlServer.AllPrivileges"));
        this.panelPrivileges.add(label);
        this.allPrivilegesModel = new DefaultListModel();
        this.allPrivilegesList = new JList(this.allPrivilegesModel);
        ListSelectionModel listSelectionModel = this.allPrivilegesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllPrivilegesListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allPrivilegesList);
        sp.setPreferredSize(new Dimension(144, 130));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelPrivileges.add(sp);
        this.setLabelConstraints(this.getPrivilegesLayout(), label, 12, 4);
        this.setObjectConstraints(this.getPrivilegesLayout(), sp, 10, 22);
    }

    private void initSelectedPrivilegesList() {
        JLabel label = new JLabel(Messages.getString("UserPropertyDialogSqlServer.SelectedPrivileges"));
        this.panelPrivileges.add(label);
        this.selectedPrivilegesModel = new DefaultListModel();
        this.selectedPrivilegesList = new JList(this.selectedPrivilegesModel);
        ListSelectionModel listSelectionModel = this.selectedPrivilegesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedPrivilegesListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedPrivilegesList);
        sp.setPreferredSize(new Dimension(145, 130));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelPrivileges.add(sp);
        this.setLabelConstraints(this.getPrivilegesLayout(), label, 292, 4);
        this.setObjectConstraints(this.getPrivilegesLayout(), sp, 290, 22);
    }

    protected SpringLayout getPrivilegesLayout() {
        return (SpringLayout)this.panelPrivileges.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.user.getName());
        this.tfName.setText(this.user.getName());
        this.tfDatabase.setText(this.user.getDatabase().getName());
        if (this.user.getLogin() != null) {
            this.tfLogin.setText(this.user.getLogin().getName());
        }
        String[] privilegesSet = (String[])UserSqlServer.getPrivilegesValues().toArray();
        for (int i = 0; i < privilegesSet.length; ++i) {
            String privilege = privilegesSet[i];
            if (this.user.getPrivilegesSet().contains(privilege)) {
                this.addElementToSortedListModel(this.selectedPrivilegesModel, privilege);
                continue;
            }
            this.addElementToSortedListModel(this.allPrivilegesModel, privilege);
        }
        if (this.user.isNullInstance()) {
            this.selectedPrivilegesList.setEnabled(false);
            this.allPrivilegesList.setEnabled(false);
        }
        this.getCommentsList().insert(this.user.getComment(), 0);
        this.cbSchemaObject.setSelectedItem(this.user.getSchemaObject());
    }

    @Override
    protected void setProperties() {
        if (this.user != null) {
            this.user.setSchemaObject((SchemaObject)this.cbSchemaObject.getSelectedItem());
            String oldName = this.user.getName();
            this.user.setName(this.tfName.getText());
            Object[] privSet = this.selectedPrivilegesModel.toArray();
            this.user.clear();
            for (int i = 0; i < privSet.length; ++i) {
                Object pr = privSet[i];
                if (!(pr instanceof String)) continue;
                this.user.setSystemPrivileges((String)pr);
            }
            this.user.setComment(this.getCommentsList().getText());
        }
    }

    private class SelectedPrivilegesListSelectionHandler
    implements ListSelectionListener {
        private SelectedPrivilegesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (UserPropertyDialogSqlServer.this.isEditable() && !e.getValueIsAdjusting()) {
                if (UserPropertyDialogSqlServer.this.selectedPrivilegesList.getSelectedIndex() == -1) {
                    UserPropertyDialogSqlServer.this.bnRemovePrivileges.setEnabled(false);
                } else {
                    UserPropertyDialogSqlServer.this.bnRemovePrivileges.setEnabled(true);
                }
            }
        }
    }

    private class AllPrivilegesListSelectionHandler
    implements ListSelectionListener {
        private AllPrivilegesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (UserPropertyDialogSqlServer.this.isEditable() && !e.getValueIsAdjusting()) {
                if (UserPropertyDialogSqlServer.this.allPrivilegesList.getSelectedIndex() == -1) {
                    UserPropertyDialogSqlServer.this.bnAddPrivileges.setEnabled(false);
                } else {
                    UserPropertyDialogSqlServer.this.bnAddPrivileges.setEnabled(true);
                }
            }
        }
    }

    private class RemovePrivilegesActionListener
    implements ActionListener {
        private RemovePrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!UserPropertyDialogSqlServer.this.selectedPrivilegesModel.isEmpty()) {
                Object[] selectedObjects = UserPropertyDialogSqlServer.this.selectedPrivilegesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (UserPropertyDialogSqlServer.this.allPrivilegesModel.contains(ob)) continue;
                    UserPropertyDialogSqlServer.this.addElementToSortedListModel(UserPropertyDialogSqlServer.this.allPrivilegesModel, ob);
                    UserPropertyDialogSqlServer.this.selectedPrivilegesModel.removeElement(ob);
                }
            }
        }
    }

    private class AddPrivilegesActionListener
    implements ActionListener {
        private AddPrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!UserPropertyDialogSqlServer.this.allPrivilegesModel.isEmpty()) {
                Object[] selectedObjects = UserPropertyDialogSqlServer.this.allPrivilegesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (UserPropertyDialogSqlServer.this.selectedPrivilegesModel.contains(ob)) continue;
                    UserPropertyDialogSqlServer.this.addElementToSortedListModel(UserPropertyDialogSqlServer.this.selectedPrivilegesModel, ob);
                    UserPropertyDialogSqlServer.this.allPrivilegesModel.removeElement(ob);
                }
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UserPropertyDialogSqlServer.this.dialog == null) {
                UserPropertyDialogSqlServer.this.dialog = new UserAndRolePermissionsDialogSqlServer(UserPropertyDialogSqlServer.this.getAppView(), UserPropertyDialogSqlServer.this.getStorageDesign(), UserPropertyDialogSqlServer.this.user);
            }
            UserPropertyDialogSqlServer.this.dialog.showDialog();
        }
    }
}

