/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.ColumnsPermissionsDialogSqlServerv2k5;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class PermissionsPropertiesDialogSqlServerv2k5
extends JDialog
implements AbstractEditorConstants {
    private static String EMPTY_VALUE = "";
    private static String CHECKED = "v";
    private static String CHECKED_WITH_GRANT_OPTION = "v->";
    protected static final String EDIT = Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Edit");
    private static String COLUMN_CHECKED = "c";
    private StorageObject storageObject;
    private JPanel objectsPanel;
    private UserSetSqlServer usersSet;
    private RoleSetSqlServer rolesSet;
    private ApplicationView appView;
    private StorageDesignSqlServer storageDesign;
    private JButton bnCancel;
    private JTabbedPane tpane;
    private JPanel jpanel;
    private ColumnsPermissionsDialogSqlServerv2k5 dialog;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertiesDialogSqlServerv2k5.this.bnCancel.doClick();
        }
    };
    private UsersTable usersTable;
    private RolesTable rolesTable;

    public PermissionsPropertiesDialogSqlServerv2k5(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view.getFrame());
        this.appView = view;
        this.storageDesign = (StorageDesignSqlServer)storageDesign;
        this.storageObject = object;
        this.storageObject.setDialogVisible(true, this);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                PermissionsPropertiesDialogSqlServerv2k5.this.storageObject.setDialogVisible(false, null);
            }
        });
        this.jpanel = new JPanel(new BorderLayout());
        this.jpanel.add((Component)this.getTabbedPane(), "Center");
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        JPanel bottomPanel = new JPanel();
        if (this.storageObject instanceof TableProxySqlServer) {
            JButton bnColumns = new JButton(Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Columns"));
            bnColumns.addActionListener(new ColumnsPermissionsListener(this));
            bnColumns.setCursor(Cursor.getPredefinedCursor(12));
            bnColumns.setMnemonic(79);
            bottomPanel.add((Component)bnColumns, "Before");
        }
        JButton bnOK = new JButton(Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.OK"));
        bnOK.addActionListener(new OKAction());
        bnOK.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setMnemonic(79);
        bottomPanel.add(bnOK);
        this.getRootPane().setDefaultButton(bnOK);
        JButton bnApply = new JButton(Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Apply"));
        bnApply.addActionListener(new ApplyAction());
        bnApply.setCursor(Cursor.getPredefinedCursor(12));
        bnApply.setMnemonic(65);
        bottomPanel.add(bnApply);
        this.bnCancel = new JButton(Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        AbstractPropertyDialog.equalizeButtonSizes(bnApply, this.bnCancel);
        AbstractPropertyDialog.equalizeButtonSizes(bnOK, this.bnCancel);
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escape);
        bottomPanel.add(this.bnCancel);
        this.jpanel.add((Component)bottomPanel, "South");
        this.getContentPane().add(this.jpanel);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.addTabs();
        this.initProperties();
        this.setModal(true);
    }

    public void initProperties() {
        int k;
        int i;
        for (i = 0; i < this.usersTable.getRowCount(); ++i) {
            UserSqlServer user = (UserSqlServer)this.usersTable.getValueAt(i, 0);
            for (k = 0; k < this.usersTable.getColumnCount(); ++k) {
                if (this.usersTable.getValueAt(i, k) instanceof JButton) {
                    JButton button = (JButton)this.usersTable.getValueAt(i, k);
                    if (this.getPermission(user, this.storageObject) != null) {
                        if (this.getPermission(user, this.storageObject).getPrivileges().indexOf(this.usersTable.getColumnName(k)) > -1) {
                            button.setText(CHECKED);
                            button.updateUI();
                            continue;
                        }
                        if (this.getPermission(user, this.storageObject).getPrivilegesWithGrantOption().indexOf(this.usersTable.getColumnName(k)) > -1) {
                            button.setText(CHECKED_WITH_GRANT_OPTION);
                            button.updateUI();
                            continue;
                        }
                        if (this.getPermission(user, this.storageObject).hasColPrivilege(this.usersTable.getColumnName(k))) {
                            button.setText(COLUMN_CHECKED);
                            button.updateUI();
                            continue;
                        }
                        button.setText(EMPTY_VALUE);
                        button.updateUI();
                        continue;
                    }
                    button.setText(EMPTY_VALUE);
                    button.updateUI();
                    continue;
                }
                if (k != this.usersTable.getColumnCount() - 1 || this.getPermission(user, this.storageObject) == null) continue;
                if (this.getPermission(user, this.storageObject).getAsRole() != null) {
                    this.usersTable.setValueAt(this.getPermission(user, this.storageObject).getAsRole(), i, k);
                    continue;
                }
                this.usersTable.setValueAt("", i, k);
            }
        }
        for (i = 0; i < this.rolesTable.getRowCount(); ++i) {
            RoleSqlServer role = (RoleSqlServer)this.rolesTable.getValueAt(i, 0);
            for (k = 0; k < this.rolesTable.getColumnCount(); ++k) {
                if (this.rolesTable.getValueAt(i, k) instanceof JButton) {
                    JButton btn = (JButton)this.rolesTable.getValueAt(i, k);
                    if (this.getPermission(role, this.storageObject) != null) {
                        if (this.getPermission(role, this.storageObject).getPrivileges().indexOf(this.rolesTable.getColumnName(k)) > -1) {
                            btn.setText(CHECKED);
                            btn.updateUI();
                            continue;
                        }
                        if (this.getPermission(role, this.storageObject).hasColPrivilege(this.rolesTable.getColumnName(k))) {
                            btn.setText(COLUMN_CHECKED);
                            btn.updateUI();
                            continue;
                        }
                        btn.setText(EMPTY_VALUE);
                        btn.updateUI();
                        continue;
                    }
                    btn.setText(EMPTY_VALUE);
                    btn.updateUI();
                    continue;
                }
                if (k != this.rolesTable.getColumnCount() - 1 || this.getPermission(role, this.storageObject) == null) continue;
                if (this.getPermission(role, this.storageObject).getAsRole() != null) {
                    this.rolesTable.setValueAt(this.getPermission(role, this.storageObject).getAsRole(), i, k);
                    continue;
                }
                this.rolesTable.setValueAt("", i, k);
            }
        }
    }

    protected void addTabs() {
        this.initUsersTable();
        this.initRolesTable();
    }

    private void initRolesTable() {
        this.rolesSet = this.storageDesign.getRoleSet();
        this.rolesTable = new RolesTable();
        this.rolesTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.rolesTable);
        scrollpane.setPreferredSize(new Dimension(800, 280));
        scrollpane.setHorizontalScrollBar(new JScrollBar());
        scrollpane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(scrollpane);
        this.getTabbedPane().addTab(Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Roles"), this.objectsPanel);
        this.rolesTable.updateUI();
        RolesModel tableModel = (RolesModel)this.rolesTable.getModel();
        for (int i = 0; i < this.rolesSet.size(); ++i) {
            RoleSqlServer role = (RoleSqlServer)this.rolesSet.getElement(i);
            String[] list = this.storageObject instanceof TableProxySqlServer ? (String[])PermissionsSqlServer.getTablePermissionsValues().toArray() : (String[])PermissionsSqlServer.getViewPermissionsValues().toArray();
            Vector<Object> vect = new Vector<Object>();
            vect.addElement(role);
            for (int j = 0; j < list.length; ++j) {
                JButton button = new JButton();
                vect.addElement(button);
            }
            Object[] objects = vect.toArray();
            tableModel.addRow(objects);
        }
    }

    private JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane();
            this.tpane.setPreferredSize(new Dimension(820, 320));
            this.tpane.setTabPlacement(3);
        }
        return this.tpane;
    }

    private void initUsersTable() {
        this.usersSet = this.storageDesign.getUserSet();
        if (this.storageObject instanceof TableProxySqlServer) {
            if (((TableProxySqlServer)this.storageObject).getUser() != null) {
                this.usersSet.remove(((TableProxySqlServer)this.storageObject).getUser());
            }
        } else if (this.storageObject instanceof TableViewProxySqlServer && ((TableViewProxySqlServer)this.storageObject).getUser() != null) {
            this.usersSet.remove(((TableViewProxySqlServer)this.storageObject).getUser());
        }
        this.usersTable = new UsersTable();
        this.usersTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.usersTable);
        scrollpane.setPreferredSize(new Dimension(800, 280));
        scrollpane.setHorizontalScrollBar(new JScrollBar());
        scrollpane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(scrollpane);
        this.getTabbedPane().addTab(Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Users"), this.objectsPanel);
        this.usersTable.updateUI();
        UsersModel tableModel = (UsersModel)this.usersTable.getModel();
        for (int i = 0; i < this.usersSet.size(); ++i) {
            UserSqlServer user = (UserSqlServer)this.usersSet.getElement(i);
            String[] list = this.storageObject instanceof TableProxySqlServer ? (String[])PermissionsSqlServer.getTablePermissionsValues().toArray() : (String[])PermissionsSqlServer.getViewPermissionsValues().toArray();
            Vector<Object> vect = new Vector<Object>();
            vect.addElement(user);
            for (int j = 0; j < list.length; ++j) {
                JButton button = new JButton();
                vect.addElement(button);
            }
            Object[] objects = vect.toArray();
            tableModel.addRow(objects);
        }
    }

    protected void setProperties() {
        RoleSqlServer selectedRole;
        JButton button;
        int k;
        PermissionsSqlServer perm;
        int i;
        for (i = 0; i < this.usersTable.getRowCount(); ++i) {
            UserSqlServer user = (UserSqlServer)this.usersTable.getValueAt(i, 0);
            perm = this.getPermission(user, this.storageObject);
            if (this.hasSelectedUserPrivileges(i)) {
                if (perm == null) {
                    perm = this.storageDesign.getPermissionsSet().createPermissions();
                    perm.setUser(user);
                    if (this.storageObject instanceof TableProxySqlServer) {
                        perm.setTable((TableProxySqlServer)this.storageObject);
                    } else if (this.storageObject instanceof TableViewProxySqlServer) {
                        perm.setView((TableViewProxySqlServer)this.storageObject);
                    }
                }
                perm.clear();
                for (k = 0; k < this.usersTable.getColumnCount(); ++k) {
                    if (this.usersTable.getValueAt(i, k) instanceof JButton) {
                        button = (JButton)this.usersTable.getValueAt(i, k);
                        if (button.getText().equals(CHECKED)) {
                            perm.setPrivileges(this.usersTable.getColumnName(k));
                            continue;
                        }
                        if (!button.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                        perm.setPrivilegesWithGrantOption(this.usersTable.getColumnName(k));
                        continue;
                    }
                    if (!(this.usersTable.getValueAt(i, k) instanceof RoleSqlServer) || this.getPermission(user, this.storageObject) == null) continue;
                    selectedRole = (RoleSqlServer)this.usersTable.getValueAt(i, k);
                    this.getPermission(user, this.storageObject).setAsRole(selectedRole);
                }
                continue;
            }
            if (perm == null) continue;
            this.storageDesign.getPermissionsSet().remove(perm);
        }
        for (i = 0; i < this.rolesTable.getRowCount(); ++i) {
            RoleSqlServer role = (RoleSqlServer)this.rolesTable.getValueAt(i, 0);
            perm = this.getPermission(role, this.storageObject);
            if (this.hasSelectedRolePrivileges(i)) {
                if (perm == null) {
                    perm = this.storageDesign.getPermissionsSet().createPermissions();
                    perm.setRole(role);
                    if (this.storageObject instanceof TableProxySqlServer) {
                        perm.setTable((TableProxySqlServer)this.storageObject);
                    } else if (this.storageObject instanceof TableViewProxySqlServer) {
                        perm.setView((TableViewProxySqlServer)this.storageObject);
                    }
                }
                perm.clear();
                for (k = 0; k < this.rolesTable.getColumnCount(); ++k) {
                    if (this.rolesTable.getValueAt(i, k) instanceof JButton) {
                        button = (JButton)this.rolesTable.getValueAt(i, k);
                        if (button.getText().equals(CHECKED)) {
                            perm.setPrivileges(this.rolesTable.getColumnName(k));
                            continue;
                        }
                        if (!button.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                        perm.setPrivilegesWithGrantOption(this.rolesTable.getColumnName(k));
                        continue;
                    }
                    if (!(this.rolesTable.getValueAt(i, k) instanceof RoleSqlServer) || this.getPermission(role, this.storageObject) == null) continue;
                    selectedRole = (RoleSqlServer)this.rolesTable.getValueAt(i, k);
                    this.getPermission(role, this.storageObject).setAsRole(selectedRole);
                }
                continue;
            }
            if (perm == null) continue;
            this.storageDesign.getPermissionsSet().remove(perm);
        }
    }

    public String getCaption() {
        return Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Permissions");
    }

    public UserSetSqlServer getUsersSet() {
        return this.usersSet;
    }

    private PermissionsSqlServer getPermission(StorageObject user, StorageObject proxy) {
        for (PermissionsSqlServer perm : this.storageDesign.getPermissionsSet()) {
            if (perm.getUser() != user && perm.getRole() != user || perm.getTable() != proxy && perm.getView() != proxy) continue;
            return perm;
        }
        return null;
    }

    private boolean hasSelectedUserPrivileges(int row) {
        for (int k = 1; k < this.usersTable.getColumnCount(); ++k) {
            if (!(this.usersTable.getValueAt(row, k) instanceof JButton)) continue;
            JButton button = (JButton)this.usersTable.getValueAt(row, k);
            if (button.getText().equals(CHECKED)) {
                return true;
            }
            if (button.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                return true;
            }
            if (!button.getText().equals(COLUMN_CHECKED)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSelectedRolePrivileges(int row) {
        for (int k = 1; k < this.rolesTable.getColumnCount(); ++k) {
            if (!(this.rolesTable.getValueAt(row, k) instanceof JButton)) continue;
            JButton button = (JButton)this.rolesTable.getValueAt(row, k);
            if (button.getText().equals(CHECKED)) {
                return true;
            }
            if (button.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                return true;
            }
            if (!button.getText().equals(COLUMN_CHECKED)) continue;
            return true;
        }
        return false;
    }

    public void setColumnPermissions(StorageObject user, String priv) {
        block5: {
            int row;
            block4: {
                row = 0;
                if (!(user instanceof UserSqlServer)) break block4;
                for (int i = 0; i < this.usersTable.getRowCount(); ++i) {
                    if (this.usersTable.getValueAt(i, 0) != user) continue;
                    row = i;
                    break;
                }
                for (int k = 1; k < this.usersTable.getColumnCount(); ++k) {
                    if (!((UsersModel)this.usersTable.getModel()).getColumnName(k).equalsIgnoreCase(priv)) continue;
                    JButton button = (JButton)this.usersTable.getValueAt(row, k);
                    button.setText(COLUMN_CHECKED);
                    this.usersTable.updateUI();
                }
                break block5;
            }
            if (!(user instanceof RoleSqlServer)) break block5;
            for (int i = 0; i < this.rolesTable.getRowCount(); ++i) {
                if (this.rolesTable.getValueAt(i, 0) != user) continue;
                row = i;
                break;
            }
            for (int k = 1; k < this.rolesTable.getColumnCount(); ++k) {
                if (!((RolesModel)this.rolesTable.getModel()).getColumnName(k).equalsIgnoreCase(priv)) continue;
                JButton button = (JButton)this.rolesTable.getValueAt(row, k);
                button.setText(COLUMN_CHECKED);
                this.rolesTable.updateUI();
            }
        }
    }

    public void clearColumnPermissions(StorageObject user, String priv) {
        block5: {
            int row;
            block4: {
                row = 0;
                if (!(user instanceof UserSqlServer)) break block4;
                for (int i = 0; i < this.usersTable.getRowCount(); ++i) {
                    if (this.usersTable.getValueAt(i, 0) != user) continue;
                    row = i;
                    break;
                }
                for (int k = 1; k < this.usersTable.getColumnCount(); ++k) {
                    JButton button;
                    if (!((UsersModel)this.usersTable.getModel()).getColumnName(k).equalsIgnoreCase(priv) || !(button = (JButton)this.usersTable.getValueAt(row, k)).getText().equalsIgnoreCase(COLUMN_CHECKED)) continue;
                    button.setText(EMPTY_VALUE);
                }
                break block5;
            }
            if (!(user instanceof RoleSqlServer)) break block5;
            for (int i = 0; i < this.rolesTable.getRowCount(); ++i) {
                if (this.rolesTable.getValueAt(i, 0) != user) continue;
                row = i;
                break;
            }
            for (int k = 1; k < this.rolesTable.getColumnCount(); ++k) {
                JButton button;
                if (!((RolesModel)this.rolesTable.getModel()).getColumnName(k).equalsIgnoreCase(priv) || !(button = (JButton)this.rolesTable.getValueAt(row, k)).getText().equalsIgnoreCase(COLUMN_CHECKED)) continue;
                button.setText(EMPTY_VALUE);
            }
        }
    }

    class ButtonRoleTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonRoleTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                JButton currentButton = (JButton)e.getSource();
                if (currentButton.getText() == null) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(CHECKED)) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(EMPTY_VALUE)) {
                    currentButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.button = (JButton)value;
            if (this.button != null) {
                this.button.setOpaque(true);
                this.button.setBackground(table.getBackground());
                this.button.setActionCommand(EDIT);
                this.button.addActionListener(this);
                this.button.setBorderPainted(true);
                return this.button;
            }
            return null;
        }
    }

    class ButtonUserTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonUserTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                JButton currentButton = (JButton)e.getSource();
                if (currentButton.getText() == null) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(CHECKED)) {
                    currentButton.setText(CHECKED_WITH_GRANT_OPTION);
                } else if (currentButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(EMPTY_VALUE)) {
                    currentButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.button = (JButton)value;
            if (this.button != null) {
                this.button.setOpaque(true);
                this.button.setBackground(table.getBackground());
                this.button.setActionCommand(EDIT);
                this.button.addActionListener(this);
                this.button.setBorderPainted(true);
                return this.button;
            }
            return null;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setText((String)(value == null ? "" : "  " + ((JButton)value).getText()));
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(2);
            this.setText((String)(value == null ? "" : "  " + value.toString()));
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertiesDialogSqlServerv2k5.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertiesDialogSqlServerv2k5.this.setProperties();
            PermissionsPropertiesDialogSqlServerv2k5.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertiesDialogSqlServerv2k5.this.setProperties();
            PermissionsPropertiesDialogSqlServerv2k5.this.storageObject.setDirty(true);
            PermissionsPropertiesDialogSqlServerv2k5.this.dispose();
        }
    }

    private class ColumnsPermissionsListener
    implements ActionListener {
        PermissionsPropertiesDialogSqlServerv2k5 permDialog;

        public ColumnsPermissionsListener(PermissionsPropertiesDialogSqlServerv2k5 permDialog) {
            this.permDialog = permDialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StorageObject selectedUser = null;
            if (PermissionsPropertiesDialogSqlServerv2k5.this.tpane.getSelectedIndex() == 0) {
                if (PermissionsPropertiesDialogSqlServerv2k5.this.usersTable.getSelectedRow() > -1) {
                    selectedUser = (StorageObject)PermissionsPropertiesDialogSqlServerv2k5.this.usersTable.getValueAt(PermissionsPropertiesDialogSqlServerv2k5.this.usersTable.getSelectedRow(), 0);
                }
            } else if (PermissionsPropertiesDialogSqlServerv2k5.this.rolesTable.getSelectedRow() > -1) {
                selectedUser = (StorageObject)PermissionsPropertiesDialogSqlServerv2k5.this.rolesTable.getValueAt(PermissionsPropertiesDialogSqlServerv2k5.this.rolesTable.getSelectedRow(), 0);
            }
            if (selectedUser != null && (PermissionsPropertiesDialogSqlServerv2k5.this.dialog == null || PermissionsPropertiesDialogSqlServerv2k5.this.dialog.getUser() != selectedUser)) {
                PermissionsPropertiesDialogSqlServerv2k5.this.dialog = new ColumnsPermissionsDialogSqlServerv2k5(PermissionsPropertiesDialogSqlServerv2k5.this.appView, PermissionsPropertiesDialogSqlServerv2k5.this.storageDesign, PermissionsPropertiesDialogSqlServerv2k5.this.storageObject, selectedUser, this.permDialog);
            }
            if (PermissionsPropertiesDialogSqlServerv2k5.this.dialog != null) {
                PermissionsPropertiesDialogSqlServerv2k5.this.dialog.show();
            }
        }
    }

    public class RolesModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            String[] perms = PermissionsPropertiesDialogSqlServerv2k5.this.storageObject instanceof TableProxySqlServer ? PermissionsSqlServer.getTablePrivilegesValues() : PermissionsSqlServer.getViewPrivilegesValues();
            return perms.length + 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            Object[] perms = PermissionsPropertiesDialogSqlServerv2k5.this.storageObject instanceof TableProxySqlServer ? PermissionsSqlServer.getTablePermissionsValues().toArray() : PermissionsSqlServer.getViewPermissionsValues().toArray();
            if (column == 0) {
                return Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Role");
            }
            if (column == this.getColumnCount() - 1) {
                return Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.AsRole");
            }
            for (int i = 1; i < this.getColumnCount() - 1; ++i) {
                if (column != i) continue;
                return perms[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class RolesTable
    extends JTable {
        RolesModel dataModel;

        public RolesTable() {
            this.dataModel = new RolesModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0 || col == this.getColumnCount() - 1) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            if (col == this.getColumnCount() - 1) {
                RoleSetSqlServer roles = PermissionsPropertiesDialogSqlServerv2k5.this.storageDesign.getRoleSet();
                Vector<Object> vect = new Vector<Object>();
                vect.addElement("");
                for (int i = 0; i < roles.size(); ++i) {
                    if (((RoleSqlServer)roles.getElement(i)).getName().equalsIgnoreCase("PUBLIC")) continue;
                    vect.addElement(roles.getElement(i));
                }
                JComboBox combo = new JComboBox();
                combo.setModel(new DefaultComboBoxModel(vect));
                return new DefaultCellEditor(combo);
            }
            return new ButtonRoleTableCellEditor();
        }
    }

    class UsersTable
    extends JTable {
        UsersModel dataModel;

        public UsersTable() {
            this.dataModel = new UsersModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0 || col == this.getColumnCount() - 1) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            if (col == this.getColumnCount() - 1) {
                RoleSetSqlServer roles = PermissionsPropertiesDialogSqlServerv2k5.this.storageDesign.getRoleSet();
                Vector<Object> vect = new Vector<Object>();
                vect.addElement("");
                for (int i = 0; i < roles.size(); ++i) {
                    if (((RoleSqlServer)roles.getElement(i)).getName().equalsIgnoreCase("PUBLIC")) continue;
                    vect.addElement(roles.getElement(i));
                }
                JComboBox combo = new JComboBox();
                combo.setModel(new DefaultComboBoxModel(vect));
                return new DefaultCellEditor(combo);
            }
            return new ButtonUserTableCellEditor();
        }
    }

    public class UsersModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            Object[] perms = PermissionsPropertiesDialogSqlServerv2k5.this.storageObject instanceof TableProxySqlServer ? PermissionsSqlServer.getTablePermissionsValues().toArray() : PermissionsSqlServer.getViewPermissionsValues().toArray();
            return perms.length + 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            Object[] perms = PermissionsPropertiesDialogSqlServerv2k5.this.storageObject instanceof TableProxySqlServer ? PermissionsSqlServer.getTablePermissionsValues().toArray() : PermissionsSqlServer.getViewPermissionsValues().toArray();
            if (column == 0) {
                return Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.User");
            }
            if (column == this.getColumnCount() - 1) {
                return Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.AsRole");
            }
            for (int i = 1; i < this.getColumnCount() - 1; ++i) {
                if (column != i) continue;
                return perms[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

