/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class TriggerPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private TriggerUDB trigger;
    private JComboBox cbScheme;
    private JComboBox cbAction;
    private JComboBox cbTriggeringTime;
    private JComboBox cbScope;
    private JTextField tfOwner;
    private JTextField tfTable;
    private JTextField tfCondition;
    private JTextField tfRef_OLD_AS;
    private JTextField tfRef_NEW_AS;
    private JTextField tfOLD_TABLE_AS;
    private JTextField tfNEW_TABLE_AS;
    private JIntegerField ifOrder;
    private JPanel panelColumns;
    private JPanel panelBody = new JPanel(new SpringLayout());
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAddColumns;
    private JButton bnRemoveColumns;
    private JTextArea bodyArea;

    public TriggerPropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.trigger = (TriggerUDB)object;
        this.setHeight(440);
        this.initCommentsView(170);
        this.initCommentsInRDBMS(170);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TriggerPropertyDialogUDB.TriggerProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initOwner();
        this.initScheme();
        this.initAction();
        this.initTriggeringTime();
        this.initScope();
        this.initRef_OLD_AS();
        this.initRef_NEW_AS();
        this.initOLD_TABLE_AS();
        this.initNEW_TABLE_AS();
        this.initCondition();
        this.initOrder();
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initBodyView();
    }

    private void initColumnsView() {
        this.panelColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TriggerPropertyDialogUDB.UpdateColumns"), this.panelColumns);
        this.initColumns();
    }

    private void initColumns() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initColumnsButtons();
    }

    private void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDB.AllColumns"));
        this.panelColumns.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(144, 330));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelColumns.add(sp);
        this.setLabelConstraints(this.getColumnsLayout(), label, 12, 20);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 38);
    }

    private void initSelectedColumnsList() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDB.SelectedColumns"));
        this.panelColumns.add(label);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsList);
        sp.setPreferredSize(new Dimension(145, 330));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelColumns.add(sp);
        this.setLabelConstraints(this.getColumnsLayout(), label, 292, 20);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 290, 38);
    }

    private void initColumnsButtons() {
        this.bnAddColumns = new JButton(Messages.getString("TriggerPropertyDialogUDB.Add"));
        this.bnAddColumns.addActionListener(new AddColumnsActionListener());
        this.bnAddColumns.setEnabled(false);
        this.panelColumns.add(this.bnAddColumns);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnAddColumns, 175, 155);
        this.bnRemoveColumns = new JButton(Messages.getString("TriggerPropertyDialogUDB.Remove"));
        this.bnRemoveColumns.setEnabled(false);
        this.bnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.panelColumns.add(this.bnRemoveColumns);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnRemoveColumns, 175, 185);
        TriggerPropertyDialogUDB.equalizeButtonSizes(this.bnAddColumns, this.bnRemoveColumns);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.panelColumns.getLayout();
    }

    protected SpringLayout getBodyLayout() {
        return (SpringLayout)this.panelBody.getLayout();
    }

    private void initBodyView() {
        this.panelBody = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TriggerPropertyDialogUDB.TriggerBody"), this.panelBody);
        this.initBody();
    }

    private void initBody() {
        this.bodyArea = new JTextArea();
        JScrollPane sp = new JScrollPane(this.bodyArea);
        sp.setPreferredSize(new Dimension(395, 360));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.bodyArea.setLineWrap(true);
        this.panelBody.add(sp);
        this.setObjectConstraints(this.getBodyLayout(), sp, 10, 12);
    }

    private void initTable() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDB.Table"));
        this.general.add(label);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEnabled(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDB.Owner"));
        this.general.add(label);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setEditable(false);
        this.tfOwner.setEnabled(false);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOwner);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfOwner, 110);
    }

    private void initScheme() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDB.Scheme"));
        this.general.add(label);
        this.cbScheme = new JComboBox();
        this.setBG(this.cbScheme);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.addActionListener(new SchemeListener());
        this.cbScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScheme);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbScheme, 80);
    }

    private void initAction() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDB.Action"));
        this.general.add(label);
        this.cbAction = new JComboBox<String>(Trigger.ACTION_TYPES);
        this.setBG(this.cbAction);
        this.cbAction.setPreferredSize(this.tfName.getPreferredSize());
        this.cbAction.addActionListener(new ActivationListener());
        this.cbAction.addActionListener(new TriggeringTimeListener());
        this.cbAction.addActionListener(new ScopeListener());
        this.general.add(this.cbAction);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbAction, 140);
    }

    private void initTriggeringTime() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDB.TriggeringTime"));
        this.general.add(label);
        this.cbTriggeringTime = new JComboBox<String>(TriggerUDB.TRIGGER_TIMES);
        this.setBG(this.cbTriggeringTime);
        this.cbTriggeringTime.setPreferredSize(this.tfName.getPreferredSize());
        this.cbTriggeringTime.addActionListener(new TriggeringTimeListener());
        this.cbTriggeringTime.addActionListener(new ScopeListener());
        this.cbTriggeringTime.addActionListener(new ActivationListener());
        this.general.add(this.cbTriggeringTime);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbTriggeringTime, 170);
    }

    private void initScope() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDB.Scope"));
        this.general.add(label);
        this.cbScope = new JComboBox<String>(TriggerUDB.SCOPE_TYPES);
        this.setBG(this.cbScope);
        this.cbScope.setPreferredSize(this.tfName.getPreferredSize());
        this.cbScope.addActionListener(new ScopeListener());
        this.cbScope.addActionListener(new TriggeringTimeListener());
        this.cbScope.addActionListener(new ActivationListener());
        this.general.add(this.cbScope);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbScope, 200);
    }

    private void initRef_OLD_AS() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDB.RefOLDAS"));
        this.general.add(label);
        this.tfRef_OLD_AS = new JTextField("", 26);
        this.general.add(this.tfRef_OLD_AS);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.tfRef_OLD_AS, 230);
    }

    private void initRef_NEW_AS() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDB.RefNEWAS"));
        this.general.add(label);
        this.tfRef_NEW_AS = new JTextField("", 26);
        this.general.add(this.tfRef_NEW_AS);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.tfRef_NEW_AS, 260);
    }

    private void initOLD_TABLE_AS() {
        JLabel label = new JLabel("OLD TABLE AS:");
        this.general.add(label);
        this.tfOLD_TABLE_AS = new JTextField("", 26);
        this.general.add(this.tfOLD_TABLE_AS);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.tfOLD_TABLE_AS, 290);
    }

    private void initNEW_TABLE_AS() {
        JLabel label = new JLabel("NEW TABLE AS:");
        this.general.add(label);
        this.tfNEW_TABLE_AS = new JTextField("", 26);
        this.general.add(this.tfNEW_TABLE_AS);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.tfNEW_TABLE_AS, 320);
    }

    private void initCondition() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDB.Condition"));
        this.general.add(label);
        this.tfCondition = new JTextField("", 26);
        this.general.add(this.tfCondition);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.tfCondition, 350);
    }

    private void initOrder() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDB.DefinitionOrder"));
        this.general.add(label);
        this.ifOrder = new JIntegerField(0, 26);
        this.general.add(this.ifOrder);
        this.setLabelConstraints(label, 380);
        this.setObjectConstraints(this.ifOrder, 380);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.trigger.getName());
        this.tfName.setText(this.trigger.getName());
        this.tfTable.setText(this.trigger.getTable() != null ? this.trigger.getTable().getName() : "");
        this.selectObject(this.cbScheme, this.trigger.getSchema());
        this.cbAction.setSelectedItem(this.trigger.getActions());
        this.cbTriggeringTime.setSelectedItem(this.trigger.getTriggerTime());
        this.cbScope.setSelectedItem(this.trigger.getScope());
        this.tfRef_OLD_AS.setText(this.trigger.getRef_OLD_AS());
        this.tfRef_NEW_AS.setText(this.trigger.getRef_NEW_AS());
        this.tfOLD_TABLE_AS.setText(this.trigger.getOLD_TABLE_AS());
        this.tfNEW_TABLE_AS.setText(this.trigger.getNEW_TABLE_AS());
        this.tfCondition.setText(this.trigger.getCondition());
        this.ifOrder.setValue((long)this.trigger.getOrder());
        this.bodyArea.setText(this.trigger.getBody());
        if (this.trigger.getTable() != null) {
            ColumnProxy[] columnSet = this.trigger.getTable().getColumnProxies();
            for (int i = 0; i < columnSet.length; ++i) {
                ColumnProxy column = columnSet[i];
                if (this.trigger.getColumnSet().contains(column.getName())) {
                    this.selectedColumnsModel.addElement(column);
                    continue;
                }
                this.allColumnsModel.addElement(column);
            }
        }
        this.getCommentsList().insert(this.trigger.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.trigger.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.trigger != null) {
            Object selected = this.cbScheme.getSelectedItem();
            if (selected instanceof SchemaUDB) {
                this.trigger.setSchema((SchemaUDB)selected);
                this.trigger.setOwner(((SchemaUDB)selected).getOwner());
            } else {
                this.trigger.setSchema(null);
                this.trigger.setOwner(null);
            }
            this.trigger.setName(this.tfName.getText());
            this.trigger.setActions((String)this.cbAction.getSelectedItem());
            this.trigger.setTriggerTime((String)this.cbTriggeringTime.getSelectedItem());
            this.trigger.setScope((String)this.cbScope.getSelectedItem());
            this.trigger.setRef_OLD_AS(this.tfRef_OLD_AS.getText());
            this.trigger.setRef_NEW_AS(this.tfRef_NEW_AS.getText());
            this.trigger.setOLD_TABLE_AS(this.tfOLD_TABLE_AS.getText());
            this.trigger.setNEW_TABLE_AS(this.tfNEW_TABLE_AS.getText());
            this.trigger.setCondition(this.tfCondition.getText());
            try {
                this.trigger.setOrder(this.ifOrder.getIntValue());
            }
            catch (NumberFormatException e) {
                this.trigger.setOrder(0);
            }
            this.trigger.setBody(this.bodyArea.getText());
            Object[] columnSet = this.selectedColumnsModel.toArray();
            this.trigger.clear();
            for (int i = 0; i < columnSet.length; ++i) {
                Object ob = columnSet[i];
                if (!(ob instanceof ColumnProxyUDB)) continue;
                this.trigger.setColumns(((ColumnProxyUDB)ob).getName());
            }
            this.trigger.setComment(this.getCommentsList().getText());
            this.trigger.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedSchema = this.cbScheme.getSelectedItem();
        if (selectedSchema instanceof SchemaUDB) {
            newName = ((SchemaUDB)selectedSchema).getName() + "." + (String)newName;
        }
        return this.getStorageObject().allowName((String)newName, true);
    }

    public class SchemeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            SchemaUDB schema = (SchemaUDB)TriggerPropertyDialogUDB.this.cbScheme.getSelectedItem();
            try {
                if (schema != null) {
                    TriggerPropertyDialogUDB.this.tfOwner.setText(schema.getOwner().toString());
                }
            }
            catch (NullPointerException e1) {
                TriggerPropertyDialogUDB.this.tfOwner.setText("");
            }
        }
    }

    public class TriggeringTimeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String trTime = (String)TriggerPropertyDialogUDB.this.cbTriggeringTime.getSelectedItem();
            if (trTime.equalsIgnoreCase(TriggerUDB.TRIGGER_TIMES[1])) {
                TriggerPropertyDialogUDB.this.tfOLD_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfOLD_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.cbScope.setEnabled(true);
            } else {
                TriggerPropertyDialogUDB.this.tfRef_NEW_AS.setEnabled(false);
                TriggerPropertyDialogUDB.this.tfRef_OLD_AS.setEnabled(false);
                TriggerPropertyDialogUDB.this.cbScope.setSelectedItem(TriggerUDB.SCOPE_TYPES[0]);
                TriggerPropertyDialogUDB.this.cbScope.setEnabled(false);
            }
        }
    }

    public class ScopeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String scope = (String)TriggerPropertyDialogUDB.this.cbScope.getSelectedItem();
            if (scope.equalsIgnoreCase(TriggerUDB.SCOPE_TYPES[1])) {
                TriggerPropertyDialogUDB.this.tfRef_NEW_AS.setEnabled(false);
                TriggerPropertyDialogUDB.this.tfRef_OLD_AS.setEnabled(false);
            } else {
                TriggerPropertyDialogUDB.this.tfRef_NEW_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfRef_OLD_AS.setEnabled(true);
            }
        }
    }

    public class ActivationListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String action = (String)TriggerPropertyDialogUDB.this.cbAction.getSelectedItem();
            boolean isUpdate = false;
            if (action.equalsIgnoreCase(Trigger.ACTION_TYPES[1])) {
                isUpdate = true;
            }
            TriggerPropertyDialogUDB.this.allColumnsList.setEnabled(isUpdate);
            TriggerPropertyDialogUDB.this.selectedColumnsList.setEnabled(isUpdate);
            if (!isUpdate) {
                TriggerPropertyDialogUDB.this.allColumnsList.setSelectedIndices(new int[0]);
                TriggerPropertyDialogUDB.this.selectedColumnsList.setSelectedIndices(new int[0]);
            }
            if (action.equalsIgnoreCase(Trigger.ACTION_TYPES[0])) {
                TriggerPropertyDialogUDB.this.tfOLD_TABLE_AS.setEnabled(false);
                TriggerPropertyDialogUDB.this.tfRef_OLD_AS.setEnabled(false);
                TriggerPropertyDialogUDB.this.tfNEW_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfRef_NEW_AS.setEnabled(true);
            } else if (action.equalsIgnoreCase(Trigger.ACTION_TYPES[1])) {
                TriggerPropertyDialogUDB.this.tfOLD_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfRef_OLD_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfNEW_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfRef_NEW_AS.setEnabled(true);
            } else {
                TriggerPropertyDialogUDB.this.tfOLD_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfRef_OLD_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfNEW_TABLE_AS.setEnabled(false);
                TriggerPropertyDialogUDB.this.tfRef_NEW_AS.setEnabled(false);
            }
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TriggerPropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TriggerPropertyDialogUDB.this.selectedColumnsList.getSelectedIndex() == -1) {
                    TriggerPropertyDialogUDB.this.bnRemoveColumns.setEnabled(false);
                } else {
                    TriggerPropertyDialogUDB.this.bnRemoveColumns.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TriggerPropertyDialogUDB.this.selectedColumnsModel.isEmpty()) {
                Object[] selectedObjects = TriggerPropertyDialogUDB.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TriggerPropertyDialogUDB.this.allColumnsModel.contains(ob)) continue;
                    TriggerPropertyDialogUDB.this.allColumnsModel.addElement(ob);
                    TriggerPropertyDialogUDB.this.selectedColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TriggerPropertyDialogUDB.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TriggerPropertyDialogUDB.this.allColumnsList.getSelectedIndex() == -1) {
                    TriggerPropertyDialogUDB.this.bnAddColumns.setEnabled(false);
                } else {
                    TriggerPropertyDialogUDB.this.bnAddColumns.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TriggerPropertyDialogUDB.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = TriggerPropertyDialogUDB.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TriggerPropertyDialogUDB.this.selectedColumnsModel.contains(ob)) continue;
                    TriggerPropertyDialogUDB.this.selectedColumnsModel.addElement(ob);
                    TriggerPropertyDialogUDB.this.allColumnsModel.removeElement(ob);
                }
            }
        }
    }
}

